/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.MX4JRemoteUtils;

public abstract class AbstractJMXConnectorServer
extends JMXConnectorServer {
    private JMXServiceURL url;
    private final Map environment;
    private volatile boolean active;
    private volatile boolean stopped;

    public AbstractJMXConnectorServer(JMXServiceURL url, Map environment, MBeanServer server) {
        super(server);
        this.url = url;
        this.environment = environment;
    }

    @Override
    public synchronized JMXServiceURL getAddress() {
        return this.url;
    }

    protected synchronized void setAddress(JMXServiceURL url) {
        this.url = url;
    }

    public synchronized Map getAttributes() {
        Map env = MX4JRemoteUtils.removeNonSerializableEntries(this.getEnvironment());
        return Collections.unmodifiableMap(env);
    }

    protected synchronized Map getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    @Override
    public synchronized void start() throws IOException, IllegalStateException {
        Logger logger = this.getLogger();
        if (this.isActive()) {
            if (logger.isEnabledFor(0)) {
                logger.trace("This JMXConnectorServer has already been started");
            }
            return;
        }
        if (this.isStopped()) {
            if (logger.isEnabledFor(0)) {
                logger.trace("This JMXConnectorServer has already been stopped");
            }
            throw new IOException("This RMIConnectorServer has already been stopped");
        }
        this.doStart();
        this.active = true;
        if (logger.isEnabledFor(20)) {
            logger.info("JMXConnectorServer started at: " + this.getAddress());
        }
    }

    protected abstract void doStart() throws IOException, IllegalStateException;

    @Override
    public synchronized void stop() throws IOException {
        if (!this.isActive() || this.isStopped()) {
            return;
        }
        this.stopped = true;
        this.active = false;
        this.doStop();
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("JMXConnectorServer stopped at: " + this.getAddress());
        }
    }

    protected abstract void doStop() throws IOException;

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    @Override
    public void connectionOpened(String connectionId, String message, Object userData) {
        super.connectionOpened(connectionId, message, userData);
    }

    @Override
    public void connectionClosed(String connectionId, String message, Object userData) {
        super.connectionClosed(connectionId, message, userData);
    }

    @Override
    public void connectionFailed(String connectionId, String message, Object userData) {
        super.connectionFailed(connectionId, message, userData);
    }
}

