/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.stats;

import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.stats.PointTime;
import mx4j.tools.stats.StatisticsRecorderMBean;

public abstract class AbstractStatisticsRecorder
implements StatisticsRecorderMBean,
MBeanRegistration {
    protected boolean isActive = false;
    protected MBeanServer server;
    protected int maxEntries = 256;
    protected SortedMap entries = new TreeMap();
    protected Date recordingStart;
    protected boolean isDouble = false;
    protected double minimumValue;
    protected double maximumValue;
    protected double averageValue;
    protected long count = 0L;

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    @Override
    public void start() {
        Logger logger = this.getLogger();
        if (!this.isActive) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Starting statistics recorder " + this);
            }
            this.isActive = true;
            this.recordingStart = new Date();
            this.entries.clear();
            this.averageValue = 0.0;
            this.maximumValue = 0.0;
            this.minimumValue = 0.0;
            this.count = 0L;
            this.isDouble = false;
            try {
                this.doStart();
            }
            catch (Exception e) {
                logger.error("Exception while starting recorder " + this, e);
            }
        }
    }

    @Override
    public void stop() {
        Logger logger = this.getLogger();
        if (this.isActive) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Starting statistics recorder " + this);
            }
            this.isActive = false;
            try {
                this.doStop();
            }
            catch (Exception e) {
                logger.error("Exception starting recorder " + this, e);
            }
        }
    }

    @Override
    public Number getAverage() {
        return this.createValue(this.averageValue);
    }

    @Override
    public Number getMin() {
        return this.createValue(this.minimumValue);
    }

    @Override
    public Number getMax() {
        return this.createValue(this.maximumValue);
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    @Override
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public void setMaxEntries(int maxEntries) {
        if (maxEntries <= 0) {
            throw new IllegalArgumentException("Max entries has to be bigger than 0");
        }
        this.maxEntries = maxEntries;
    }

    @Override
    public SortedMap getEntries() {
        return (SortedMap)((TreeMap)this.entries).clone();
    }

    @Override
    public Date getRecordingStart() {
        return this.recordingStart;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected synchronized void addEntry(Date key, Number value) {
        if (this.isActive) {
            this.entries.put(new PointTime(key, this.count++), value);
            if (this.entries.size() > this.maxEntries) {
                while (this.entries.size() > this.maxEntries) {
                    this.entries.remove(this.entries.firstKey());
                }
            }
            this.calculateStats(value);
        }
    }

    private void calculateStats(Number value) {
        if (!this.isDouble && (value instanceof Double || value instanceof Float)) {
            this.isDouble = true;
        }
        double newValue = value.doubleValue();
        if (this.count == 1L) {
            this.minimumValue = this.averageValue = newValue;
            this.maximumValue = this.averageValue;
            return;
        }
        if (newValue > this.maximumValue) {
            this.maximumValue = newValue;
        }
        if (newValue < this.minimumValue) {
            this.minimumValue = newValue;
        }
        this.averageValue = (1.0 - 1.0 / (double)this.count) * this.averageValue + 1.0 / (double)this.count * newValue;
    }

    private Number createValue(double targetValue) {
        if (this.isDouble) {
            return new Double(targetValue);
        }
        return new Long((long)targetValue);
    }
}

