/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertyHelper;

public class NestedPropertyTag
extends BodyTagSupport
implements NestedNameSupport {
    private String property = null;
    private String originalNest = null;
    private String originalName = null;
    private String originalProperty = null;

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String newNamed) {
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(String newProperty) {
        this.property = newProperty;
    }

    public int doStartTag() throws JspException {
        this.originalProperty = this.property;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.originalNest = NestedPropertyHelper.getCurrentProperty(request);
        this.originalName = NestedPropertyHelper.getCurrentName(request, this);
        String nested = NestedPropertyHelper.getAdjustedProperty(request, this.originalProperty);
        NestedPropertyHelper.setProperty(request, nested);
        NestedPropertyHelper.setName(request, this.originalName);
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            TagUtils.getInstance().writePrevious(this.pageContext, this.bodyContent.getString());
            this.bodyContent.clearBody();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.originalNest == null && this.originalName == null) {
            NestedPropertyHelper.deleteReference(request);
        } else {
            NestedPropertyHelper.setName(request, this.originalName);
            NestedPropertyHelper.setProperty(request, this.originalNest);
        }
        this.property = this.originalProperty;
        return 6;
    }

    public void release() {
        super.release();
        this.property = null;
        this.originalNest = null;
        this.originalName = null;
        this.originalProperty = null;
    }
}

