/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.definition;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.xmlDefinition.I18nFactorySet;
import org.apache.struts.util.RequestUtils;

public class ReloadableDefinitionsFactory
implements ComponentDefinitionsFactory {
    protected ComponentDefinitionsFactory factory = null;
    protected Map properties = null;
    public static final String DEFINITIONS_FACTORY_CLASSNAME = "definitions-factory-class";

    public ReloadableDefinitionsFactory(ServletContext servletContext, ServletConfig servletConfig) throws DefinitionsFactoryException {
        this.properties = new ServletPropertiesMap(servletConfig);
        this.factory = this.createFactory(servletContext, this.properties);
    }

    public ReloadableDefinitionsFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        this.properties = properties;
        this.factory = this.createFactory(servletContext, properties);
    }

    public ComponentDefinitionsFactory createFactoryFromClassname(ServletContext servletContext, Map properties, String classname) throws DefinitionsFactoryException {
        if (classname == null) {
            return this.createFactory(servletContext, properties);
        }
        try {
            Class factoryClass = RequestUtils.applicationClass(classname);
            ComponentDefinitionsFactory factory = (ComponentDefinitionsFactory)factoryClass.newInstance();
            factory.initFactory(servletContext, properties);
            return factory;
        }
        catch (ClassCastException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + classname + " must implements 'ComponentDefinitionsFactory'.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + classname + "'.", ex);
        }
        catch (InstantiationException ex) {
            throw new DefinitionsFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new DefinitionsFactoryException(ex);
        }
    }

    public ComponentDefinitionsFactory createDefaultFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        I18nFactorySet factory = new I18nFactorySet(servletContext, properties);
        return factory;
    }

    public ComponentDefinitionsFactory createFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        String classname = (String)properties.get(DEFINITIONS_FACTORY_CLASSNAME);
        if (classname != null) {
            return this.createFactoryFromClassname(servletContext, properties, classname);
        }
        return new I18nFactorySet(servletContext, properties);
    }

    @Override
    public ComponentDefinition getDefinition(String definitionName, ServletRequest request, ServletContext servletContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        return this.factory.getDefinition(definitionName, (ServletRequest)((HttpServletRequest)request), servletContext);
    }

    public void reload(ServletContext servletContext) throws DefinitionsFactoryException {
        ComponentDefinitionsFactory newInstance;
        this.factory = newInstance = this.createFactory(servletContext, this.properties);
    }

    public ComponentDefinitionsFactory getFactory() {
        return this.factory;
    }

    @Override
    public void initFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
    }

    public String toString() {
        return this.factory.toString();
    }

    class ServletPropertiesMap
    extends HashMap {
        ServletPropertiesMap(ServletConfig config) {
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.put(key, config.getInitParameter(key));
            }
        }
    }
}

