/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MultipartBoundaryInputStream
extends InputStream {
    private static final byte NEWLINE_BYTE = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String DOUBLE_DASH_STRING = "--";
    private static final int DEFAULT_LINE_SIZE = 4096;
    private static final String TOKEN_EQUALS = "=";
    private static final char TOKEN_QUOTE = '\"';
    private static final char TOKEN_COLON = ':';
    private static final char TOKEN_SEMI_COLON = ';';
    private static final char TOKEN_SPACE = ' ';
    private static final String DEFAULT_CONTENT_DISPOSITION = "form-data";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_FILENAME = "filename";
    private static final String PARAMETER_CHARSET = "charset";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String MESSAGE_INVALID_START = "Multipart data doesn't start with boundary";
    protected InputStream inputStream;
    protected String boundary;
    protected boolean boundaryEncountered;
    protected boolean finalBoundaryEncountered;
    protected boolean endOfStream;
    protected String elementContentDisposition;
    protected String elementName;
    protected String elementContentType;
    protected String elementFileName;
    protected String elementCharset;
    protected long maxLength = -1L;
    protected boolean maxLengthMet;
    protected long bytesRead;
    private byte[] boundaryBytes;
    private byte[] finalBoundaryBytes;
    private byte[] line;
    private int lineSize = 4096;
    private int lineLength;
    private boolean lineHasNewline;
    private boolean lineHasCarriage;
    private int lineIndex;

    public MultipartBoundaryInputStream() {
        this.resetStream();
    }

    public void setBoundary(String boundary) {
        this.boundary = DOUBLE_DASH_STRING + boundary;
        this.boundaryBytes = this.boundary.getBytes();
        this.finalBoundaryBytes = (this.boundary + DOUBLE_DASH_STRING).getBytes();
    }

    public void resetForNextBoundary() throws IOException {
        if (!this.finalBoundaryEncountered) {
            this.boundaryEncountered = false;
            this.resetCrlf();
            this.fillLine();
            this.readElementHeaders();
        }
    }

    public void setInputStream(InputStream stream) throws IOException {
        this.inputStream = stream;
        this.resetStream();
        this.readFirstElement();
    }

    @Override
    public int read() throws IOException {
        if (!this.maxLengthMet && !this.boundaryEncountered) {
            return this.readFromLine();
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length > 0) {
            int bytesRead;
            int read = this.read();
            if (read == -1 && (this.endOfStream || this.boundaryEncountered)) {
                return -1;
            }
            buffer[offset++] = (byte)read;
            for (bytesRead = 1; bytesRead < length && ((read = this.read()) != -1 || read == -1 && !this.boundaryEncountered) && !this.maxLengthMet; ++bytesRead) {
                buffer[offset++] = (byte)read;
            }
            return bytesRead;
        }
        return -1;
    }

    @Override
    public synchronized void mark(int i) {
        this.inputStream.mark(i);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public boolean isMaxLengthMet() {
        return this.maxLengthMet;
    }

    public String getElementContentDisposition() {
        return this.elementContentDisposition;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementCharset() {
        return this.elementCharset;
    }

    public String getElementContentType() {
        return this.elementContentType;
    }

    public String getElementFileName() {
        return this.elementFileName;
    }

    public boolean isElementFile() {
        return this.elementFileName != null;
    }

    public boolean isBoundaryEncountered() {
        return this.boundaryEncountered;
    }

    public boolean isFinalBoundaryEncountered() {
        return this.finalBoundaryEncountered;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public void setLineSize(int size) {
        this.lineSize = size;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    private final void readFirstElement() throws IOException {
        this.fillLine();
        if (!this.boundaryEncountered) {
            throw new IOException(MESSAGE_INVALID_START);
        }
        this.fillLine();
        this.readElementHeaders();
    }

    private final void readElementHeaders() throws IOException {
        this.readContentDisposition();
        this.resetCrlf();
        boolean hadContentType = this.readContentType();
        this.resetCrlf();
        if (hadContentType) {
            this.skipCurrentLineIfBlank();
        }
    }

    private final void readContentDisposition() throws IOException {
        String line = this.readLine();
        if (line != null) {
            int colonIndex = line.indexOf(58);
            if (colonIndex != -1) {
                int firstSemiColonIndex = line.indexOf(59);
                if (firstSemiColonIndex != -1) {
                    this.elementContentDisposition = line.substring(colonIndex + 1, firstSemiColonIndex).trim();
                }
            } else {
                this.elementContentDisposition = DEFAULT_CONTENT_DISPOSITION;
            }
            this.elementName = this.parseForParameter(PARAMETER_NAME, line);
            this.elementFileName = this.parseForParameter(PARAMETER_FILENAME, line);
            if (this.elementFileName != null) {
                this.elementFileName = this.checkAndFixFilename(this.elementFileName);
            }
        }
    }

    private final String checkAndFixFilename(String filename) {
        int colonIndex = (filename = new File(filename).getName()).indexOf(":");
        if (colonIndex == -1) {
            colonIndex = filename.indexOf("\\\\");
        }
        int slashIndex = filename.lastIndexOf("\\");
        if (colonIndex > -1 && slashIndex > -1) {
            filename = filename.substring(slashIndex + 1, filename.length());
        }
        return filename;
    }

    private final String parseForParameter(String parameter, String parseString) {
        int nameIndex = parseString.indexOf(parameter + TOKEN_EQUALS);
        if (nameIndex != -1) {
            int startIndex = -1;
            int endIndex = -1;
            if (parseString.charAt(nameIndex += parameter.length() + 1) == '\"') {
                startIndex = nameIndex + 1;
                int endQuoteIndex = parseString.indexOf(34, startIndex);
                if (endQuoteIndex != -1) {
                    endIndex = endQuoteIndex;
                }
            } else {
                int carriageIndex;
                startIndex = nameIndex;
                int spaceIndex = parseString.indexOf(32, startIndex);
                endIndex = spaceIndex != -1 ? spaceIndex : ((carriageIndex = parseString.indexOf(13, startIndex)) != -1 ? carriageIndex : parseString.length());
            }
            if (startIndex != -1 && endIndex != -1) {
                return parseString.substring(startIndex, endIndex);
            }
        }
        return null;
    }

    private final boolean readContentType() throws IOException {
        String line = this.readLine();
        if (line != null) {
            if (line.length() > 2) {
                this.elementContentType = this.parseHeaderValue(line);
                if (this.elementContentType == null) {
                    this.elementContentType = CONTENT_TYPE_APPLICATION_OCTET_STREAM;
                }
                this.elementCharset = this.parseForParameter(PARAMETER_CHARSET, line);
                return true;
            }
            this.elementContentType = CONTENT_TYPE_TEXT_PLAIN;
        }
        return false;
    }

    private final String parseHeaderValue(String headerLine) {
        int colonIndex = headerLine.indexOf(58);
        if (colonIndex != -1) {
            int semiColonIndex = headerLine.indexOf(59, colonIndex);
            int endLineIndex = semiColonIndex != -1 ? semiColonIndex : headerLine.indexOf(13, colonIndex);
            if (endLineIndex == -1) {
                endLineIndex = headerLine.length();
            }
            return headerLine.substring(colonIndex + 1, endLineIndex).trim();
        }
        return null;
    }

    private final void skipCurrentLineIfBlank() throws IOException {
        boolean fill = false;
        if (this.lineLength == 1) {
            if (this.line[0] == 10) {
                fill = true;
            }
        } else if (this.lineLength == 2 && this.equals(this.line, 0, 2, CRLF)) {
            fill = true;
        }
        if (fill && !this.endOfStream) {
            this.fillLine();
        }
    }

    private final void resetCrlf() {
        this.lineHasCarriage = false;
        this.lineHasNewline = false;
    }

    private final void resetStream() {
        this.line = new byte[this.lineSize];
        this.lineIndex = 0;
        this.lineLength = 0;
        this.lineHasCarriage = false;
        this.lineHasNewline = false;
        this.boundaryEncountered = false;
        this.finalBoundaryEncountered = false;
        this.endOfStream = false;
        this.maxLengthMet = false;
        this.bytesRead = 0L;
    }

    private final String readLine() throws IOException {
        String line = null;
        if (this.availableInLine() > 0) {
            line = new String(this.line, 0, this.lineLength);
            if (!this.endOfStream) {
                this.fillLine();
            }
        } else if (!this.endOfStream) {
            this.fillLine();
            line = this.readLine();
        }
        return line;
    }

    private final int readFromLine() throws IOException {
        if (!this.boundaryEncountered) {
            if (this.availableInLine() > 0) {
                return this.line[this.lineIndex++];
            }
            if (!this.endOfStream) {
                this.fillLine();
                return this.readFromLine();
            }
        }
        return -1;
    }

    private final int availableInLine() {
        return this.lineLength - this.lineIndex;
    }

    private final void fillLine() throws IOException {
        this.resetLine();
        if (!this.finalBoundaryEncountered && !this.endOfStream) {
            this.fillLineBuffer();
            this.checkForBoundary();
        }
    }

    private final void resetLine() {
        this.lineIndex = 0;
    }

    private final void fillLineBuffer() throws IOException {
        int read = 0;
        int index = 0;
        if (this.lineHasCarriage) {
            this.line[index++] = 13;
            this.lineHasCarriage = false;
        }
        if (this.lineHasNewline) {
            this.line[index++] = 10;
            this.lineHasNewline = false;
        }
        while (index < this.line.length && !this.maxLengthMet) {
            read = this.inputStream.read();
            this.byteRead();
            if (read != -1 || read == -1 && this.inputStream.available() > 0 && !this.maxLengthMet) {
                this.line[index++] = (byte)read;
                if (read != 10) continue;
                this.lineHasNewline = true;
                if (--index <= 0 || this.line[index - 1] != 13) break;
                this.lineHasCarriage = true;
                --index;
                break;
            }
            this.endOfStream = true;
            break;
        }
        this.lineLength = index;
    }

    private final void byteRead() {
        ++this.bytesRead;
        if (this.maxLength > -1L && this.bytesRead >= this.maxLength) {
            this.maxLengthMet = true;
            this.endOfStream = true;
        }
    }

    private final void checkForBoundary() {
        this.boundaryEncountered = false;
        int actualLength = this.lineLength;
        if (this.line[0] == 13 || this.line[0] == 10) {
            --actualLength;
        }
        if (this.line[1] == 10) {
            --actualLength;
        }
        int startIndex = this.lineLength - actualLength;
        if (actualLength == this.boundaryBytes.length) {
            if (this.equals(this.line, startIndex, this.boundaryBytes.length, this.boundaryBytes)) {
                this.boundaryEncountered = true;
            }
        } else if (actualLength == this.boundaryBytes.length + 2 && this.equals(this.line, startIndex, this.finalBoundaryBytes.length, this.finalBoundaryBytes)) {
            this.boundaryEncountered = true;
            this.finalBoundaryEncountered = true;
            this.endOfStream = true;
        }
    }

    private final boolean equals(byte[] comp, int offset, int length, byte[] source) {
        if (length != source.length || comp.length - offset < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comp[offset + i] == source[i]) continue;
            return false;
        }
        return true;
    }
}

