/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.SQLNestedException;
import org.apache.tomcat.dbcp.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool _pool = null;

    public PoolableConnection(Connection conn, ObjectPool pool) {
        super(conn);
        this._pool = pool;
    }

    public PoolableConnection(Connection conn, ObjectPool pool, AbandonedConfig config) {
        super(conn, config);
        this._pool = pool;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean isClosed = false;
        try {
            isClosed = this.isClosed();
        }
        catch (SQLException e) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLNestedException("Cannot close connection (isClosed check failed)", e);
        }
        if (isClosed) {
            throw new SQLException("Already closed.");
        }
        try {
            this._pool.returnObject(this);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot close connection (return to pool failed)", e);
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

