/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.cpdsadapter;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.dbcp.dbcp.cpdsadapter.PooledConnectionImpl;

class ConnectionImpl
implements Connection {
    private static final String CLOSED = "Attempted to use Connection after closed() was called.";
    private Connection connection;
    private PooledConnectionImpl pooledConnection;
    boolean isClosed;

    ConnectionImpl(PooledConnectionImpl pooledConnection, Connection connection) {
        this.pooledConnection = pooledConnection;
        this.connection = connection;
        this.isClosed = false;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            throw new SQLException("A ConnectionImpl was finalized without being closed which will cause leakage of  PooledConnections from the ConnectionPool.");
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertOpen();
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.assertOpen();
        this.isClosed = true;
        this.pooledConnection.notifyListeners();
    }

    @Override
    public void commit() throws SQLException {
        this.assertOpen();
        this.connection.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertOpen();
        return this.connection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertOpen();
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertOpen();
        return this.connection.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertOpen();
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpen();
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertOpen();
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertOpen();
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertOpen();
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        return this.pooledConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void rollback() throws SQLException {
        this.assertOpen();
        this.connection.rollback();
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.assertOpen();
        this.connection.setAutoCommit(b);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.assertOpen();
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpen();
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpen();
        this.connection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpen();
        this.connection.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertOpen();
        return this.connection.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.assertOpen();
        this.connection.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpen();
        return this.connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpen();
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpen();
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

