/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ValueExp;

class QualifiedAttributeValueExp
extends AttributeValueExp {
    private static final long serialVersionUID = 8832517277410933254L;
    private String className;
    private transient MBeanServer server;

    QualifiedAttributeValueExp(String className, String attr) {
        super(attr);
        this.className = className;
    }

    @Override
    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        this.server = server;
    }

    @Override
    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            String cls = this.server.getObjectInstance(name).getClassName();
            if (cls.equals(this.className)) {
                return super.apply(name);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        throw new InvalidApplicationException((Object)this.className);
    }
}

