/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanNotificationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanInfoSupport;

public class ModelMBeanNotificationInfo
extends MBeanNotificationInfo
implements DescriptorAccess,
Cloneable {
    private static final long serialVersionUID = -7445681389570207141L;
    private Descriptor notificationDescriptor;

    public ModelMBeanNotificationInfo(String[] types, String name, String description) {
        this(types, name, description, null);
    }

    public ModelMBeanNotificationInfo(String[] types, String name, String description, Descriptor descriptor) {
        super(types, name, description);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanNotificationInfo(ModelMBeanNotificationInfo copy) {
        super(copy.getNotifTypes(), copy.getName(), copy.getDescription());
        this.checkAndSetDescriptor(copy.getDescriptor());
    }

    @Override
    public Object clone() {
        return new ModelMBeanNotificationInfo(this);
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)this.notificationDescriptor.clone();
    }

    @Override
    public void setDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.notificationDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.notificationDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.notificationDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.notificationDescriptor = (Descriptor)descriptor.clone();
            if (this.notificationDescriptor.getFieldValue("displayname") == null) {
                this.notificationDescriptor.setField("displayname", this.getName());
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        String[] names = descriptor.getFieldNames();
        if (!(ModelMBeanInfoSupport.containsIgnoreCase(names, "name") && ModelMBeanInfoSupport.containsIgnoreCase(names, "descriptortype") && ModelMBeanInfoSupport.containsIgnoreCase(names, "severity"))) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.equals(descriptor.getFieldValue("name"))) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        if (desctype.compareToIgnoreCase("notification") != 0) {
            return false;
        }
        int severity = this.objectToInt(descriptor.getFieldValue("severity"));
        return severity >= 0 && severity <= 6;
    }

    private Descriptor createDefaultDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "severity", "displayName"};
        Object[] values = new Object[]{this.getName(), "notification", "5", this.getName()};
        return new DescriptorSupport(names, values);
    }

    private int objectToInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }
}

