/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnresolvedReferenceBinding
extends ReferenceBinding {
    ReferenceBinding resolvedType;
    TypeBinding[] wrappers;

    UnresolvedReferenceBinding(char[][] cArray, PackageBinding packageBinding) {
        this.compoundName = cArray;
        this.sourceName = cArray[cArray.length - 1];
        this.fPackage = packageBinding;
        this.wrappers = null;
    }

    void addWrapper(TypeBinding typeBinding, LookupEnvironment lookupEnvironment) {
        if (this.resolvedType != null) {
            typeBinding.swapUnresolved(this, this.resolvedType, lookupEnvironment);
            return;
        }
        if (this.wrappers == null) {
            this.wrappers = new TypeBinding[]{typeBinding};
        } else {
            int n = this.wrappers.length;
            this.wrappers = new TypeBinding[n + 1];
            System.arraycopy(this.wrappers, 0, this.wrappers, 0, n);
            this.wrappers[n] = typeBinding;
        }
    }

    public String debugName() {
        return this.toString();
    }

    ReferenceBinding resolve(LookupEnvironment lookupEnvironment, boolean bl) {
        ReferenceBinding referenceBinding = this.resolvedType;
        if (referenceBinding == null) {
            referenceBinding = this.fPackage.getType0(this.compoundName[this.compoundName.length - 1]);
            if (referenceBinding == this) {
                referenceBinding = lookupEnvironment.askForType(this.compoundName);
            }
            if (referenceBinding == null || referenceBinding == this) {
                if ((this.tagBits & 0x80L) == 0L) {
                    lookupEnvironment.problemReporter.isClassPathCorrect(this.compoundName, lookupEnvironment.unitBeingCompleted, lookupEnvironment.missingClassFileLocation);
                }
                referenceBinding = lookupEnvironment.createMissingType(null, this.compoundName);
            }
            this.setResolvedType(referenceBinding, lookupEnvironment);
        }
        if (bl) {
            referenceBinding = (ReferenceBinding)lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    void setResolvedType(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.resolvedType == referenceBinding) {
            return;
        }
        this.resolvedType = referenceBinding;
        if (this.wrappers != null) {
            int n = this.wrappers.length;
            for (int i = 0; i < n; ++i) {
                this.wrappers[i].swapUnresolved(this, referenceBinding, lookupEnvironment);
            }
        }
        lookupEnvironment.updateCaches(this, referenceBinding);
    }

    public String toString() {
        return "Unresolved type " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }
}

