/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);
    public ASTNode associatedNode;
    public FlowContext parent;
    public NullInfoRegistry initsOnFinally;
    public int tagBits;
    public static final int DEFER_NULL_DIAGNOSTIC = 1;
    public static final int PREEMPT_NULL_DIAGNOSTIC = 2;
    public static final int HIDE_NULL_COMPARISON_WARNING = 4;
    public static final int CAN_ONLY_NULL_NON_NULL = 0;
    public static final int CAN_ONLY_NULL = 1;
    public static final int CAN_ONLY_NON_NULL = 2;
    public static final int MAY_NULL = 3;
    public static final int CHECK_MASK = 255;
    public static final int IN_COMPARISON_NULL = 256;
    public static final int IN_COMPARISON_NON_NULL = 512;
    public static final int IN_ASSIGNMENT = 768;
    public static final int IN_INSTANCEOF = 1024;
    public static final int CONTEXT_MASK = -256;

    public FlowContext(FlowContext flowContext, ASTNode aSTNode) {
        this.parent = flowContext;
        this.associatedNode = aSTNode;
        if (flowContext != null) {
            if ((flowContext.tagBits & 3) != 0) {
                this.tagBits |= 1;
            }
            this.initsOnFinally = flowContext.initsOnFinally;
        }
    }

    public BranchLabel breakLabel() {
        return null;
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        this.checkExceptionHandlers(typeBinding, aSTNode, flowInfo, blockScope, false);
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope, boolean bl) {
        Object object;
        Statement statement;
        FlowContext flowContext = this;
        ArrayList<FlowContext> arrayList = null;
        if (blockScope.compilerOptions().sourceLevel >= 0x330000L && aSTNode instanceof ThrowStatement) {
            statement = ((ThrowStatement)aSTNode).exception;
            object = ((Expression)statement).localVariableBinding();
            if (statement instanceof SingleNameReference && object instanceof CatchParameterBinding && ((VariableBinding)object).isEffectivelyFinal()) {
                CatchParameterBinding catchParameterBinding = (CatchParameterBinding)object;
                this.checkExceptionHandlers(catchParameterBinding.getPreciseTypes(), aSTNode, flowInfo, blockScope);
                return;
            }
        }
        while (flowContext != null) {
            Object object2;
            statement = flowContext.subroutine();
            if (statement != null && ((SubRoutineStatement)statement).isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                object = (ExceptionHandlingFlowContext)flowContext;
                object2 = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    boolean bl2 = false;
                    int n = ((ReferenceBinding[])object2).length;
                    block5: for (int i = 0; i < n; ++i) {
                        int n2;
                        ReferenceBinding referenceBinding = object2[i];
                        int n3 = n2 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                        if (arrayList != null && referenceBinding != null && n2 != 0) {
                            int n4 = arrayList.size();
                            for (int j = 0; j < n4; ++j) {
                                LoopingFlowContext loopingFlowContext = (LoopingFlowContext)arrayList.get(j);
                                loopingFlowContext.recordCatchContextOfEscapingException((ExceptionHandlingFlowContext)object, referenceBinding);
                            }
                        }
                        switch (n2) {
                            case -1: {
                                ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, typeBinding, aSTNode, bl2);
                                bl2 = true;
                                continue block5;
                            }
                            case 1: {
                                ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, referenceBinding, aSTNode, false);
                            }
                        }
                    }
                    if (bl2) {
                        return;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).isMethodContext) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    if (typeBinding.isUncheckedException(false)) {
                        return;
                    }
                    if (!(((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode).isConstructor() || !abstractMethodDeclaration.binding.declaringClass.isAnonymousType()) break;
                    ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                    return;
                }
            } else if (flowContext instanceof LoopingFlowContext) {
                if (arrayList == null) {
                    arrayList = new ArrayList<FlowContext>(5);
                }
                arrayList.add(flowContext);
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (!bl && flowContext instanceof InsideSubRoutineFlowContext && (object = flowContext.associatedNode) instanceof TryStatement) {
                object2 = (TryStatement)object;
                flowInfo.addInitializationsFrom(object2.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
        if (bl) {
            blockScope.problemReporter().unhandledExceptionFromAutoClose(typeBinding, aSTNode);
        } else {
            blockScope.problemReporter().unhandledException(typeBinding, aSTNode);
        }
    }

    public void checkExceptionHandlers(TypeBinding[] typeBindingArray, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n;
        if (typeBindingArray == null || (n = typeBindingArray.length) == 0) {
            return;
        }
        int n2 = n;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        typeBindingArray = new TypeBinding[n];
        System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
        FlowContext flowContext = this;
        ArrayList<FlowContext> arrayList = null;
        while (flowContext != null) {
            Object object2;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                Object object3;
                int n3;
                object = (ExceptionHandlingFlowContext)flowContext;
                object2 = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    int n4;
                    n3 = ((ReferenceBinding[])object2).length;
                    object3 = new boolean[n];
                    for (n4 = 0; n4 < n3; ++n4) {
                        ReferenceBinding referenceBinding = object2[n4];
                        block6: for (int i = 0; i < n; ++i) {
                            int n5;
                            TypeBinding typeBinding = typeBindingArray[i];
                            if (typeBinding == null) continue;
                            int n6 = n5 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                            if (arrayList != null && referenceBinding != null && n5 != 0) {
                                int n7 = arrayList.size();
                                for (int j = 0; j < n7; ++j) {
                                    LoopingFlowContext loopingFlowContext = (LoopingFlowContext)arrayList.get(j);
                                    loopingFlowContext.recordCatchContextOfEscapingException((ExceptionHandlingFlowContext)object, referenceBinding);
                                }
                            }
                            switch (n5) {
                                case -1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, typeBinding, aSTNode, (boolean)object3[i]);
                                    if (object3[i] != false) continue block6;
                                    object3[i] = true;
                                    --n2;
                                    continue block6;
                                }
                                case 1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo.unconditionalInits(), typeBinding, referenceBinding, aSTNode, false);
                                }
                            }
                        }
                    }
                    for (n4 = 0; n4 < n; ++n4) {
                        if (object3[n4] == false) continue;
                        typeBindingArray[n4] = null;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).isMethodContext) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    for (n3 = 0; n3 < n; ++n3) {
                        TypeBinding typeBinding = typeBindingArray[n3];
                        object3 = typeBinding;
                        if (typeBinding == null || !((TypeBinding)object3).isUncheckedException(false)) continue;
                        --n2;
                        typeBindingArray[n3] = null;
                    }
                    if (!(((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration) || !(abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode).isConstructor() || !abstractMethodDeclaration.binding.declaringClass.isAnonymousType()) break;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding = typeBindingArray[i];
                        if (typeBinding == null) continue;
                        ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                    }
                    return;
                }
            } else if (flowContext instanceof LoopingFlowContext) {
                if (arrayList == null) {
                    arrayList = new ArrayList<FlowContext>(5);
                }
                arrayList.add(flowContext);
            }
            if (n2 == 0) {
                return;
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext instanceof InsideSubRoutineFlowContext && (object = flowContext.associatedNode) instanceof TryStatement) {
                object2 = (TryStatement)object;
                flowInfo.addInitializationsFrom(object2.subRoutineInits);
            }
            flowContext = flowContext.parent;
        }
        block11: for (int i = 0; i < n; ++i) {
            object = typeBindingArray[i];
            if (object == null) continue;
            for (int j = 0; j < i; ++j) {
                if (typeBindingArray[j] == object) continue block11;
            }
            blockScope.problemReporter().unhandledException((TypeBinding)object, aSTNode);
        }
    }

    public BranchLabel continueLabel() {
        return null;
    }

    public FlowInfo getInitsForFinalBlankInitializationCheck(TypeBinding typeBinding, FlowInfo flowInfo) {
        FlowContext flowContext = this;
        FlowInfo flowInfo2 = flowInfo;
        do {
            ExceptionHandlingFlowContext exceptionHandlingFlowContext;
            if (flowContext instanceof InitializationFlowContext) {
                exceptionHandlingFlowContext = (InitializationFlowContext)flowContext;
                if (((TypeDeclaration)exceptionHandlingFlowContext.associatedNode).binding == typeBinding) {
                    return flowInfo2;
                }
                flowInfo2 = exceptionHandlingFlowContext.initsBeforeContext;
                flowContext = exceptionHandlingFlowContext.initializationParent;
                continue;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                exceptionHandlingFlowContext = (ExceptionHandlingFlowContext)flowContext;
                flowContext = exceptionHandlingFlowContext.initializationParent == null ? exceptionHandlingFlowContext.parent : exceptionHandlingFlowContext.initializationParent;
                continue;
            }
            flowContext = flowContext.parent;
        } while (flowContext != null);
        return null;
    }

    public FlowContext getTargetContextForBreakLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            char[] cArray2;
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if ((cArray2 = flowContext.labelName()) != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] cArray) {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        FlowContext flowContext3 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext3 = flowContext;
            } else if (flowContext.isContinuable()) {
                flowContext2 = flowContext;
            }
            char[] cArray2 = flowContext.labelName();
            if (cArray2 != null && CharOperation.equals(cArray2, cArray)) {
                ((LabeledStatement)flowContext.associatedNode).bits |= 0x40;
                if (flowContext2 != null && flowContext.associatedNode.concreteStatement() == flowContext2.associatedNode) {
                    if (flowContext3 == null) {
                        return flowContext2;
                    }
                    return flowContext3;
                }
                return NotContinuableContext;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isBreakable() && flowContext.labelName() == null) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext flowContext = this;
        FlowContext flowContext2 = null;
        while (flowContext != null) {
            if (flowContext.isNonReturningContext()) {
                flowContext2 = flowContext;
            }
            if (flowContext.isContinuable()) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            flowContext = flowContext.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordBreakTo(FlowContext flowContext) {
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
    }

    public void recordSettingFinal(VariableBinding variableBinding, Reference reference, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            FlowContext flowContext = this;
            while (flowContext != null && flowContext.recordFinalAssignment(variableBinding, reference)) {
                flowContext = flowContext.parent;
            }
        }
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n) {
            case 256: 
            case 512: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n == 512) {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenFalse().setReachMode(2);
                        }
                    } else {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenTrue().setReachMode(2);
                        }
                    }
                    return;
                }
                if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                    return;
                }
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n & 0xFFFFFF00) {
                        case 256: {
                            if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            }
                            if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                flowInfo.initsWhenFalse().setReachMode(2);
                            }
                            return;
                        }
                        case 512: {
                            if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            }
                            if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                flowInfo.initsWhenTrue().setReachMode(2);
                            }
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                    break;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    switch (n & 0xFFFFFF00) {
                        case 256: {
                            if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                    }
                    break;
                }
                if (!flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) break;
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                    return;
                }
                if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                return;
            }
        }
        if (this.parent != null) {
            this.parent.recordUsingNullReference(scope, localVariableBinding, expression, n, flowInfo);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subroutine() {
        return null;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FlowContext flowContext = this;
        int n2 = 0;
        while ((flowContext = flowContext.parent) != null) {
            ++n2;
        }
        FlowContext[] flowContextArray = new FlowContext[n2 + 1];
        flowContext = this;
        int n3 = n2;
        while (n3 >= 0) {
            flowContextArray[n3--] = flowContext;
            flowContext = flowContext.parent;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(flowContextArray[n].individualToString()).append('\n');
        }
        stringBuffer.append('*');
        for (n = 0; n < n2 + 1; ++n) {
            stringBuffer.append('\t');
        }
        stringBuffer.append(this.individualToString()).append('\n');
        return stringBuffer.toString();
    }
}

