/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        methodBinding2 = (methodBinding = methodBinding.original()).findOriginalInheritedMethod(methodBinding2);
        if (methodBinding2 == null) {
            return false;
        }
        return this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        int n;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n2 = typeBindingArray.length;
        if (n2 != typeBindingArray2.length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) continue;
            if (typeBindingArray[n].leafComponentType().isRawType() && typeBindingArray[n].dimensions() == typeBindingArray2[n].dimensions() && typeBindingArray[n].leafComponentType().isEquivalentTo(typeBindingArray2[n].leafComponentType())) {
                if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (!typeBindingArray[i].leafComponentType().isParameterizedTypeWithActualArguments()) continue;
                    return false;
                }
                break;
            }
            return false;
        }
        ++n;
        while (n < n2) {
            if (!this.areTypesEqual(typeBindingArray[n], typeBindingArray2[n])) {
                if (!typeBindingArray[n].leafComponentType().isRawType() || typeBindingArray[n].dimensions() != typeBindingArray2[n].dimensions() || !typeBindingArray[n].leafComponentType().isEquivalentTo(typeBindingArray2[n].leafComponentType())) {
                    return false;
                }
            } else if (typeBindingArray[n].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType) {
            return true;
        }
        if (this.type.scope.compilerOptions().sourceLevel >= 0x310000L) {
            return this.areReturnTypesCompatible0(methodBinding, methodBinding2);
        }
        return this.areTypesEqual(methodBinding.returnType.erasure(), methodBinding2.returnType.erasure());
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == typeBinding2) {
            return true;
        }
        block0 : switch (typeBinding.kind()) {
            case 4: {
                switch (typeBinding2.kind()) {
                    case 260: 
                    case 1028: {
                        if (typeBinding == typeBinding2.erasure()) {
                            return true;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (typeBinding2.kind()) {
                    case 4: {
                        if (typeBinding.erasure() != typeBinding2) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (!typeBinding.isParameterizedType()) return false;
        if (!typeBinding2.isParameterizedType()) return false;
        if (!typeBinding.isEquivalentTo(typeBinding2)) return false;
        if (!typeBinding2.isEquivalentTo(typeBinding)) return false;
        return true;
    }

    protected boolean canOverridingMethodDifferInErasure(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        return !methodBinding.declaringClass.isRawType();
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || methodBinding.declaringClass == methodBinding2.declaringClass && !methodBinding.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        super.checkConcreteInheritedMethod(methodBinding, methodBindingArray);
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding2 = methodBindingArray[i];
            if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
                this.problemReporter().varargsConflict(methodBinding, methodBinding2, this.type);
            }
            MethodBinding methodBinding3 = methodBinding2.original();
            if (methodBinding3.returnType != methodBinding.returnType && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
                this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
            }
            if (!methodBinding3.declaringClass.isInterface() || (methodBinding.declaringClass != this.type.superclass || !this.type.superclass.isParameterizedType() || this.areMethodsCompatible(methodBinding, methodBinding3)) && this.type.superclass.erasure().findSuperTypeOriginatingFrom(methodBinding3.declaringClass) != null) continue;
            this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original());
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
        SyntheticMethodBinding syntheticMethodBinding;
        if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
            this.problemReporter(methodBinding).varargsConflict(methodBinding, methodBinding2, this.type);
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        if (methodBinding3.returnType != methodBinding.returnType && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
        }
        if ((syntheticMethodBinding = this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original())) != null) {
            int n;
            int n2 = n = methodBindingArray == null ? 0 : methodBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (methodBindingArray[i] == null || !this.detectInheritedNameClash(methodBinding3, methodBindingArray[i].original())) continue;
                return;
            }
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(syntheticMethodBinding.selector);
            for (n = methodBindingArray2.length - 1; n >= 0; --n) {
                MethodBinding methodBinding4 = methodBindingArray2[n];
                if (!methodBinding4.areParameterErasuresEqual(syntheticMethodBinding) || methodBinding4.returnType.erasure() != syntheticMethodBinding.returnType.erasure()) continue;
                this.problemReporter(methodBinding4).methodNameClash(methodBinding4, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding2.original(), 1);
                return;
            }
        }
    }

    void checkForNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.isStatic()) {
            return;
        }
        if (!this.detectNameClash(methodBinding, methodBinding2, false)) {
            int n;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            int n2 = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            if (n2 != typeBindingArray2.length) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                if (typeBindingArray[i] == typeBindingArray2[i] || typeBindingArray[i].isBaseType() == typeBindingArray2[i].isBaseType() && typeBindingArray2[i].isCompatibleWith(typeBindingArray[i])) continue;
                return;
            }
            ReferenceBinding[] referenceBindingArray = null;
            int n3 = 0;
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n3 = referenceBindingArray2.length;
                referenceBindingArray = referenceBindingArray2;
            }
            for (referenceBinding = referenceBinding.superclass(); referenceBinding != null && referenceBinding.isValidBinding(); referenceBinding = referenceBinding.superclass()) {
                Binding binding;
                int n4;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                n = methodBindingArray.length;
                for (n4 = 0; n4 < n; ++n4) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n4], methodBinding);
                    if (binding == null || this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding, true)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                if (referenceBindingArray == null) {
                    referenceBindingArray = referenceBindingArray2;
                    n3 = referenceBindingArray.length;
                    continue;
                }
                n4 = referenceBindingArray2.length;
                if (n3 + n4 >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n4 + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
                }
                block3: for (n = 0; n < n4; ++n) {
                    binding = referenceBindingArray2[n];
                    for (int i = 0; i < n3; ++i) {
                        if (binding == referenceBindingArray[i]) continue block3;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
            for (int i = 0; i < n3; ++i) {
                Binding binding;
                referenceBinding = referenceBindingArray[i];
                if (!referenceBinding.isValidBinding()) continue;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                int n5 = methodBindingArray.length;
                for (n = 0; n < n5; ++n) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n], methodBinding);
                    if (binding == null || this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding, true)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                n = referenceBindingArray2.length;
                if (n3 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray4 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray4, 0, referenceBindingArray, 0, n3);
                }
                block7: for (n5 = 0; n5 < n; ++n5) {
                    binding = referenceBindingArray2[n5];
                    for (int j = 0; j < n3; ++j) {
                        if (binding == referenceBindingArray[j]) continue block7;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
        }
    }

    void checkInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.declaringClass.isInterface() || methodBinding.isStatic()) {
            return;
        }
        this.detectInheritedNameClash(methodBinding.original(), methodBinding2.original());
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        boolean bl = true;
        MethodBinding methodBinding = null;
        for (int i = 0; i < n; ++i) {
            if (methodBindingArray[i].isAbstract()) continue;
            if (methodBinding != null) {
                this.problemReporter().duplicateInheritedMethods(this.type, methodBinding, methodBindingArray[i]);
                bl = false;
            }
            methodBinding = methodBindingArray[i];
        }
        if (bl) {
            super.checkInheritedMethods(methodBindingArray, n);
        }
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            if (!methodBinding.declaringClass.implementsInterface(methodBinding2.declaringClass, false)) {
                this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            }
            return true;
        }
        return false;
    }

    void reportRawReferences() {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        Object[] objectArray = this.currentMethods.valueTable;
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            MethodBinding[] methodBindingArray = (MethodBinding[])objectArray[n];
            int n2 = methodBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                MethodBinding methodBinding = methodBindingArray[i];
                if ((methodBinding.modifiers & 0x30000000) != 0) continue;
                AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
                if (abstractMethodDeclaration == null) {
                    return;
                }
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                Argument[] argumentArray = abstractMethodDeclaration.arguments;
                int n3 = methodBinding.parameters.length;
                for (int j = 0; j < n3; ++j) {
                    TypeBinding typeBinding = typeBindingArray[j];
                    Argument argument = argumentArray[j];
                    if (!typeBinding.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (argument.type.bits & 0x40000000) != 0) continue;
                    abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
                }
                if (abstractMethodDeclaration.isConstructor() || !(abstractMethodDeclaration instanceof MethodDeclaration)) continue;
                TypeReference typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType;
                TypeBinding typeBinding = methodBinding.returnType;
                if (typeReference == null || !typeBinding.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (typeReference.bits & 0x40000000) != 0) continue;
                abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
            }
        }
    }

    public void reportRawReferences(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding typeBinding;
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
        if (abstractMethodDeclaration == null) {
            return;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        int n = methodBinding.parameters.length;
        for (int i = 0; i < n; ++i) {
            typeBinding = typeBindingArray[i];
            TypeBinding typeBinding2 = typeBindingArray2[i];
            Argument argument = argumentArray[i];
            if (!typeBinding.leafComponentType().isRawType()) continue;
            if (typeBinding2.leafComponentType().isRawType()) {
                argument.binding.tagBits |= 0x200L;
                continue;
            }
            if (compilerOptions.getSeverity(0x20010000) == 256 || (argument.type.bits & 0x40000000) != 0) continue;
            abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
        }
        TypeReference typeReference = null;
        if (!abstractMethodDeclaration.isConstructor() && abstractMethodDeclaration instanceof MethodDeclaration && (typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType) != null) {
            TypeBinding typeBinding3 = methodBinding2.returnType;
            typeBinding = methodBinding.returnType;
            if (typeBinding.leafComponentType().isRawType() && !typeBinding3.leafComponentType().isRawType() && (typeReference.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
            }
        }
    }

    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        boolean bl3 = this.type.isOrEnclosedByPrivateType();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            MethodBinding methodBinding;
            int n2;
            MethodBinding[] methodBindingArray;
            MethodBinding methodBinding2;
            int n3;
            Object object;
            int n4;
            int n5;
            if (cArray[n] == null) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(cArray[n]);
            MethodBinding[] methodBindingArray3 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            if (methodBindingArray2 == null && !bl3) {
                n5 = methodBindingArray3.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    methodBindingArray3[n4].original().modifiers |= 0x8000000;
                }
            }
            if (methodBindingArray2 == null && this.type.isPublic()) {
                n5 = methodBindingArray3.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    object = methodBindingArray3[n4];
                    if (!((MethodBinding)object).isPublic() || ((MethodBinding)object).declaringClass.isPublic()) continue;
                    this.type.addSyntheticBridgeMethod(((MethodBinding)object).original());
                }
            }
            if (methodBindingArray2 == null && bl2) continue;
            if (methodBindingArray3.length == 1 && methodBindingArray2 == null) {
                if (!bl || !methodBindingArray3[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray3[0]);
                continue;
            }
            n5 = -1;
            n4 = methodBindingArray3.length;
            object = new MethodBinding[n4];
            MethodBinding[] methodBindingArray4 = new MethodBinding[n4];
            if (methodBindingArray2 != null) {
                n3 = methodBindingArray2.length;
                for (int i = 0; i < n3; ++i) {
                    methodBinding2 = methodBindingArray2[i];
                    methodBindingArray = null;
                    for (n2 = 0; n2 < n4; ++n2) {
                        methodBinding = this.computeSubstituteMethod(methodBindingArray3[n2], methodBinding2);
                        if (methodBinding == null) continue;
                        if (methodBindingArray4[n2] == null && this.isSubstituteParameterSubsignature(methodBinding2, methodBinding)) {
                            object[++n5] = methodBinding;
                            methodBindingArray4[n2] = methodBinding2;
                            continue;
                        }
                        this.checkForNameClash(methodBinding2, methodBinding);
                        if (n4 <= 1) continue;
                        if (methodBindingArray == null) {
                            methodBindingArray = new MethodBinding[n4];
                        }
                        methodBindingArray[n2] = methodBinding;
                    }
                    if (n5 < 0) continue;
                    this.checkAgainstInheritedMethods(methodBinding2, (MethodBinding[])object, n5 + 1, methodBindingArray);
                    while (n5 >= 0) {
                        object[n5--] = null;
                    }
                }
            }
            boolean[] blArray = new boolean[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                methodBinding2 = methodBindingArray4[n3];
                if (methodBinding2 == null && methodBindingArray2 != null && this.type.isPublic() && (methodBindingArray = methodBindingArray3[n3]).isPublic() && !methodBindingArray.declaringClass.isPublic()) {
                    this.type.addSyntheticBridgeMethod(methodBindingArray.original());
                }
                if (!bl3 && methodBinding2 == null && methodBindingArray2 != null) {
                    methodBindingArray3[n3].original().modifiers |= 0x8000000;
                }
                if (blArray[n3]) continue;
                methodBindingArray = methodBindingArray3[n3];
                if (methodBinding2 == null) {
                    object[++n5] = methodBindingArray;
                }
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    methodBinding = methodBindingArray3[n2];
                    if (methodBinding2 == methodBindingArray4[n2] && methodBinding2 != null || this.canSkipInheritedMethods((MethodBinding)methodBindingArray, methodBinding)) continue;
                    if (methodBindingArray.declaringClass != methodBinding.declaringClass) {
                        if (methodBinding.declaringClass.isInterface()) {
                            if (this.isInterfaceMethodImplemented(methodBinding, (MethodBinding)methodBindingArray, methodBinding.declaringClass)) {
                                blArray[n2] = true;
                                continue;
                            }
                        } else if (this.areMethodsCompatible((MethodBinding)methodBindingArray, methodBinding)) {
                            blArray[n2] = true;
                            continue;
                        }
                    }
                    if ((methodBinding = this.computeSubstituteMethod(methodBinding, (MethodBinding)methodBindingArray)) == null) continue;
                    if (this.isSubstituteParameterSubsignature((MethodBinding)methodBindingArray, methodBinding)) {
                        if (n5 == -1) {
                            object[++n5] = methodBindingArray;
                        }
                        if (methodBindingArray4[n2] == null) {
                            object[++n5] = methodBinding;
                        }
                        blArray[n2] = true;
                        continue;
                    }
                    if (methodBinding2 != null || methodBindingArray4[n2] != null) continue;
                    this.checkInheritedMethods((MethodBinding)methodBindingArray, methodBinding);
                }
                if (n5 == -1) continue;
                if (n5 > 0) {
                    this.checkInheritedMethods((MethodBinding[])object, n5 + 1);
                } else if (bl && ((MethodBinding)object[0]).isAbstract() && methodBinding2 == null) {
                    this.checkAbstractMethod((MethodBinding)object[0]);
                }
                while (n5 >= 0) {
                    object[n5--] = null;
                }
            }
        }
    }

    void checkTypeVariableMethods(TypeParameter typeParameter) {
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        block0: while (--n >= 0) {
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.inheritedMethods.valueTable[n]).length == 1) continue;
            int n2 = -1;
            MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
            int n3 = methodBindingArray.length;
            for (int i = 0; i < n3; ++i) {
                while (n2 >= 0) {
                    methodBindingArray2[n2--] = null;
                }
                MethodBinding methodBinding = methodBindingArray[i];
                if (methodBinding != null) {
                    methodBindingArray2[++n2] = methodBinding;
                    for (int j = i + 1; j < n3; ++j) {
                        MethodBinding methodBinding2 = methodBindingArray[j];
                        if (this.canSkipInheritedMethods(methodBinding, methodBinding2) || (methodBinding2 = this.computeSubstituteMethod(methodBinding2, methodBinding)) == null || !this.isSubstituteParameterSubsignature(methodBinding, methodBinding2)) continue;
                        methodBindingArray2[++n2] = methodBinding2;
                        methodBindingArray[j] = null;
                    }
                }
                if (n2 <= 0) continue;
                MethodBinding methodBinding3 = methodBindingArray2[0];
                int n4 = n2 + 1;
                while (--n4 > 0) {
                    MethodBinding methodBinding4 = methodBindingArray2[n4];
                    MethodBinding methodBinding5 = null;
                    MethodBinding methodBinding6 = null;
                    if (methodBinding3.declaringClass.isInterface()) {
                        methodBinding5 = methodBinding3;
                    } else if (methodBinding3.declaringClass.isClass()) {
                        methodBinding6 = methodBinding3;
                    }
                    if (methodBinding4.declaringClass.isInterface()) {
                        methodBinding5 = methodBinding4;
                    } else if (methodBinding4.declaringClass.isClass()) {
                        methodBinding6 = methodBinding4;
                    }
                    if (methodBinding5 != null && methodBinding6 != null && !this.isAsVisible(methodBinding6, methodBinding5)) {
                        this.problemReporter().inheritedMethodReducesVisibility(typeParameter, methodBinding6, new MethodBinding[]{methodBinding5});
                    }
                    if (this.areReturnTypesCompatible(methodBinding3, methodBinding4) || methodBinding3.declaringClass.isInterface() && methodBinding4.declaringClass.isInterface() && this.areReturnTypesCompatible(methodBinding4, methodBinding3)) continue;
                }
                if (n4 <= 0) continue;
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(typeParameter, methodBindingArray2, n2 + 1);
                continue block0;
            }
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeVariableBinding[] typeVariableBindingArray;
        int n;
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        if (methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding2.declaringClass).resolveTypesFor(methodBinding2);
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
        }
        if ((n = (typeVariableBindingArray = methodBinding.typeVariables).length) == 0) {
            return methodBinding;
        }
        TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
        int n2 = typeVariableBindingArray2.length;
        if (n2 == 0) {
            return methodBinding.asRawMethod(this.environment);
        }
        if (n2 != n) {
            return methodBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n2);
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = this.environment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
        for (int i = 0; i < n; ++i) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[i];
            TypeBinding typeBinding = typeBindingArray[i];
            if (typeBinding instanceof TypeVariableBinding) {
                TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)typeBinding;
                if (typeVariableBinding2.firstBound == typeVariableBinding.firstBound) {
                    if (typeVariableBinding2.firstBound == null) {
                        continue;
                    }
                } else if (typeVariableBinding2.firstBound != null && typeVariableBinding.firstBound != null && typeVariableBinding2.firstBound.isClass() != typeVariableBinding.firstBound.isClass()) {
                    return methodBinding;
                }
                if (Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superclass) != typeVariableBinding2.superclass) {
                    return methodBinding;
                }
                int n3 = typeVariableBinding.superInterfaces.length;
                ReferenceBinding[] referenceBindingArray = typeVariableBinding2.superInterfaces;
                if (n3 != referenceBindingArray.length) {
                    return methodBinding;
                }
                block1: for (int j = 0; j < n3; ++j) {
                    TypeBinding typeBinding2 = Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding.superInterfaces[j]);
                    for (int k = 0; k < n3; ++k) {
                        if (typeBinding2 == referenceBindingArray[k]) continue block1;
                    }
                    return methodBinding;
                }
                continue;
            }
            if (typeVariableBinding.boundCheck(parameterizedGenericMethodBinding, typeBinding) == 0) continue;
            return methodBinding;
        }
        return parameterizedGenericMethodBinding;
    }

    boolean detectInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        if (methodBinding.returnType.erasure() != methodBinding2.returnType.erasure()) {
            return false;
        }
        if (methodBinding.declaringClass.erasure() != methodBinding2.declaringClass.erasure()) {
            if (methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass) != null) {
                return false;
            }
            if (methodBinding2.declaringClass.findSuperTypeOriginatingFrom(methodBinding.declaringClass) != null) {
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, methodBinding, methodBinding2);
        return true;
    }

    boolean detectNameClash(MethodBinding methodBinding, MethodBinding methodBinding2, boolean bl) {
        MethodBinding[] methodBindingArray;
        MethodBinding methodBinding3 = methodBinding2;
        MethodBinding methodBinding4 = methodBinding3.original();
        if (!methodBinding.areParameterErasuresEqual(methodBinding4)) {
            return false;
        }
        int n = 1;
        if (this.environment.globalOptions.complianceLevel == 0x320000L && methodBinding.returnType.erasure() != methodBinding4.returnType.erasure()) {
            n = 0;
        }
        if (!bl && (methodBindingArray = (MethodBinding[])this.currentMethods.get(methodBinding2.selector)).length > 1) {
            int n2 = methodBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                MethodBinding methodBinding5 = methodBindingArray[i];
                if (methodBinding5 == methodBinding || !this.doesMethodOverride(methodBinding5, methodBinding2)) continue;
                methodBinding3 = methodBinding5;
                break;
            }
        }
        if (!methodBinding.areParameterErasuresEqual(methodBinding4 = methodBinding3.original())) {
            return false;
        }
        methodBinding4 = methodBinding2.original();
        this.problemReporter(methodBinding).methodNameClash(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding4, n);
        return n != 0;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return this.couldMethodOverride(methodBinding, methodBinding2) && this.areMethodsCompatible(methodBinding, methodBinding2);
    }

    boolean doTypeVariablesClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && !(methodBinding2 instanceof ParameterizedGenericMethodBinding);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        int n3;
        ReferenceBinding referenceBinding2;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        boolean bl = this.type.isHierarchyInconsistent();
        for (referenceBinding2 = referenceBinding; referenceBinding2 != null && referenceBinding2.isValidBinding(); referenceBinding2 = referenceBinding2.superclass()) {
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n4 = referenceBindingArray2.length;
                continue;
            }
            n3 = referenceBindingArray3.length;
            if (n4 + n3 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n3 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
            }
            block1: for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding3 = referenceBindingArray3[n2];
                for (int i = 0; i < n4; ++i) {
                    if (referenceBinding3 == referenceBindingArray2[i]) continue block1;
                }
                referenceBindingArray2[n4++] = referenceBinding3;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            referenceBinding2 = referenceBindingArray2[n3];
            if (!referenceBinding2.isValidBinding()) continue;
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            n2 = referenceBindingArray3.length;
            if (n4 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n2 + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
            }
            block4: for (int i = 0; i < n2; ++i) {
                ReferenceBinding referenceBinding4 = referenceBindingArray3[i];
                for (n = 0; n < n4; ++n) {
                    if (referenceBinding4 == referenceBindingArray2[n]) continue block4;
                }
                referenceBindingArray2[n4++] = referenceBinding4;
            }
        }
        if (!bl) {
            return null;
        }
        SimpleSet simpleSet = null;
        for (n2 = 0; n2 < n4; ++n2) {
            ReferenceBinding referenceBinding5 = referenceBindingArray2[n2];
            if (!referenceBinding5.isValidBinding()) continue;
            TypeBinding typeBinding = referenceBinding5.erasure();
            for (n = n2 + 1; n < n4; ++n) {
                ReferenceBinding referenceBinding6 = referenceBindingArray2[n];
                if (!referenceBinding6.isValidBinding() || referenceBinding6.erasure() != typeBinding) continue;
                if (simpleSet == null) {
                    simpleSet = new SimpleSet(n4);
                }
                simpleSet.add(referenceBindingArray2[n2]);
                simpleSet.add(referenceBindingArray2[n]);
            }
        }
        return simpleSet;
    }

    boolean hasGenericParameter(MethodBinding methodBinding) {
        if (methodBinding.genericSignature() == null) {
            return false;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            TypeBinding typeBinding = typeBindingArray[i].leafComponentType();
            if (!(typeBinding instanceof ReferenceBinding) || ((n2 = ((ReferenceBinding)typeBinding).modifiers) & 0x40000000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding3.returnType.leafComponentType();
        if (typeBinding.isParameterizedTypeWithActualArguments()) {
            return !methodBinding.returnType.leafComponentType().isRawType();
        }
        TypeBinding typeBinding2 = methodBinding.returnType.leafComponentType();
        switch (typeBinding2.kind()) {
            case 4100: {
                if (typeBinding2 != methodBinding2.returnType.leafComponentType()) break;
                return true;
            }
        }
        return !typeBinding.isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding3;
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        if (methodBinding.original() != methodBinding && methodBinding2.declaringClass.isInterface()) {
            return false;
        }
        return (methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) != null && methodBinding.returnType == methodBinding2.returnType && this.doesMethodOverride(methodBinding2, methodBinding);
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3;
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding.declaringClass.isParameterizedType()) {
            methodBinding = methodBinding.original();
        }
        return this.isParameterSubsignature(methodBinding, (methodBinding3 = methodBinding.findOriginalInheritedMethod(methodBinding2)) == null ? methodBinding2 : methodBinding3);
    }

    boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        return methodBinding3 != null && this.isSubstituteParameterSubsignature(methodBinding, methodBinding3);
    }

    boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!this.areParametersEqual(methodBinding, methodBinding2)) {
            if (methodBinding2.hasSubstitutedParameters() && methodBinding.areParameterErasuresEqual(methodBinding2)) {
                return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !this.hasGenericParameter(methodBinding);
            }
            if (methodBinding.declaringClass.isRawType() && methodBinding2.declaringClass.isRawType() && methodBinding.hasSubstitutedParameters() && methodBinding2.hasSubstitutedParameters()) {
                return this.areMethodsCompatible(methodBinding, methodBinding2);
            }
            return false;
        }
        if (methodBinding2 instanceof ParameterizedGenericMethodBinding) {
            if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                return !((ParameterizedGenericMethodBinding)methodBinding2).isRaw;
            }
            return !this.hasGenericParameter(methodBinding);
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES;
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.returnType == methodBinding2.returnType.erasure()) {
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.areTypesEqual(typeBindingArray[i], typeBindingArray2[i])) continue;
                return true;
            }
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding2.original().typeVariables != Binding.NO_TYPE_VARIABLES && methodBinding.returnType.erasure().findSuperTypeOriginatingFrom(methodBinding2.returnType.erasure()) != null;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(methodBinding, methodBinding2);
    }

    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        this.reportRawReferences();
        int n = this.type.typeVariables.length;
        while (--n >= 0) {
            TypeVariableBinding typeVariableBinding = this.type.typeVariables[n];
            if (typeVariableBinding.superInterfaces == Binding.NO_SUPERINTERFACES || typeVariableBinding.superInterfaces.length == 1 && typeVariableBinding.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            if (referenceBinding.kind() == 4100) {
                referenceBinding = (ReferenceBinding)referenceBinding.erasure();
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[referenceBindingArray.length];
            int n2 = referenceBindingArray.length;
            while (--n2 >= 0) {
                referenceBindingArray2[n2] = referenceBindingArray[n2].kind() == 4100 ? (ReferenceBinding)referenceBindingArray[n2].erasure() : referenceBindingArray[n2];
            }
            this.computeInheritedMethods(referenceBinding, referenceBindingArray2);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[n]);
        }
    }
}

