/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    public ReferenceBinding genericType;
    public int rank;
    public TypeBinding bound;
    public TypeBinding[] otherBounds;
    char[] genericSignature;
    public int boundKind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;

    public WildcardBinding(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, LookupEnvironment lookupEnvironment) {
        this.rank = n;
        this.boundKind = n2;
        this.modifiers = 0x40000001;
        this.environment = lookupEnvironment;
        this.initialize(referenceBinding, typeBinding, typeBindingArray);
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)referenceBinding).addWrapper(this, lookupEnvironment);
        }
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        }
        this.tagBits |= 0x1000000L;
    }

    public int kind() {
        return this.otherBounds == null ? 516 : 8196;
    }

    public boolean boundCheck(TypeBinding typeBinding) {
        switch (this.boundKind) {
            case 0: {
                return true;
            }
            case 1: {
                int n;
                if (!typeBinding.isCompatibleWith(this.bound)) {
                    return false;
                }
                int n2 = n = this.otherBounds == null ? 0 : this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    if (typeBinding.isCompatibleWith(this.otherBounds[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return typeBinding.isCompatibleWith(this.bound);
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.bound.collectMissingTypes(list);
        }
        return list;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        block82: {
            ReferenceBinding referenceBinding;
            if ((this.tagBits & 0x20000000L) == 0L) {
                return;
            }
            if (typeBinding == TypeBinding.NULL) {
                return;
            }
            if (typeBinding.isCapture()) {
                referenceBinding = (CaptureBinding)typeBinding;
                typeBinding = referenceBinding.wildcard;
            }
            block0 : switch (n) {
                case 1: {
                    block5 : switch (this.boundKind) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            block10 : switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block10;
                                        }
                                        case 1: {
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 1);
                                            break block10;
                                        }
                                    }
                                    break;
                                }
                                case 8196: {
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 1);
                                    int n2 = wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n2; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 1);
                                    }
                                    break block0;
                                }
                                default: {
                                    this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 1);
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block5;
                                        }
                                        case 1: {
                                            break block5;
                                        }
                                        case 2: {
                                            int n3;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n4 = n3 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n3; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break;
                                        }
                                    }
                                    break block5;
                                }
                                case 8196: {
                                    break block5;
                                }
                            }
                            this.bound.collectSubstitutes(scope, typeBinding, inferenceContext, 2);
                        }
                    }
                    break;
                }
                case 0: {
                    block27 : switch (this.boundKind) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            int n5;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 0);
                                            int n6 = n5 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n5; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 0);
                                            }
                                            break block0;
                                        }
                                    }
                                    break block0;
                                }
                                case 8196: {
                                    int n7;
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 0);
                                    int n8 = n7 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n7; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 0);
                                    }
                                    break block0;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block27;
                                        }
                                        case 1: {
                                            break block27;
                                        }
                                        case 2: {
                                            int n9;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 0);
                                            int n10 = n9 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n9; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 0);
                                            }
                                            break;
                                        }
                                    }
                                    break block27;
                                }
                                case 8196: {
                                    break block27;
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.boundKind) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            int n11;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n12 = n11 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n11; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break block82;
                                        }
                                    }
                                    break block82;
                                }
                                case 8196: {
                                    int n13;
                                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                                    this.bound.collectSubstitutes(scope, wildcardBinding.bound, inferenceContext, 2);
                                    int n14 = n13 = wildcardBinding.otherBounds == null ? 0 : wildcardBinding.otherBounds.length;
                                    for (int i = 0; i < n13; ++i) {
                                        this.bound.collectSubstitutes(scope, wildcardBinding.otherBounds[i], inferenceContext, 2);
                                    }
                                    break block82;
                                }
                            }
                            break block82;
                        }
                        case 2: {
                            switch (typeBinding.kind()) {
                                case 516: {
                                    referenceBinding = (WildcardBinding)typeBinding;
                                    switch (((WildcardBinding)referenceBinding).boundKind) {
                                        case 0: {
                                            break block0;
                                        }
                                        case 1: {
                                            break block0;
                                        }
                                        case 2: {
                                            int n15;
                                            this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).bound, inferenceContext, 2);
                                            int n16 = n15 = ((WildcardBinding)referenceBinding).otherBounds == null ? 0 : ((WildcardBinding)referenceBinding).otherBounds.length;
                                            for (int i = 0; i < n15; ++i) {
                                                this.bound.collectSubstitutes(scope, ((WildcardBinding)referenceBinding).otherBounds[i], inferenceContext, 2);
                                            }
                                            break;
                                        }
                                    }
                                    break block0;
                                }
                                case 8196: {
                                    break block0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        char[] cArray2 = this.genericType.computeUniqueKey(false);
        char[] cArray3 = ('{' + String.valueOf(this.rank) + '}').toCharArray();
        switch (this.boundKind) {
            case 0: {
                cArray = TypeConstants.WILDCARD_STAR;
                break;
            }
            case 1: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.computeUniqueKey(false));
                break;
            }
            default: {
                cArray = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.computeUniqueKey(false));
            }
        }
        return CharOperation.concat(cArray2, cArray3, cArray);
    }

    public char[] constantPoolName() {
        return this.erasure().constantPoolName();
    }

    public String debugName() {
        return this.toString();
    }

    public TypeBinding erasure() {
        if (this.otherBounds == null) {
            if (this.boundKind == 1) {
                return this.bound.erasure();
            }
            TypeVariableBinding typeVariableBinding = this.typeVariable();
            if (typeVariableBinding != null) {
                return typeVariableBinding.erasure();
            }
            return this.genericType;
        }
        return this.bound.id == 1 ? this.otherBounds[0].erasure() : this.bound.erasure();
    }

    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.boundKind) {
                case 0: {
                    this.genericSignature = TypeConstants.WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    void initialize(ReferenceBinding referenceBinding, TypeBinding typeBinding, TypeBinding[] typeBindingArray) {
        this.genericType = referenceBinding;
        this.bound = typeBinding;
        this.otherBounds = typeBindingArray;
        if (referenceBinding != null) {
            this.fPackage = referenceBinding.getPackage();
        }
        if (typeBinding != null) {
            this.tagBits |= typeBinding.tagBits & 0x20000880L;
        }
        if (typeBindingArray != null) {
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding2 = typeBindingArray[i];
                this.tagBits |= typeBinding2.tagBits & 0x800L;
            }
        }
    }

    public boolean isSuperclassOf(ReferenceBinding referenceBinding) {
        if (this.boundKind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(referenceBinding);
            }
            return referenceBinding.id == 1;
        }
        return false;
    }

    public boolean isIntersectionType() {
        return this.otherBounds != null;
    }

    public boolean isHierarchyConnected() {
        return this.superclass != null && this.superInterfaces != null;
    }

    public boolean isUnboundWildcard() {
        return this.boundKind == 0;
    }

    public boolean isWildcard() {
        return true;
    }

    public char[] readableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.readableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.readableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('&').append(this.otherBounds[n].readableName());
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.readableName());
    }

    ReferenceBinding resolve() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this;
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        BinaryTypeBinding.resolveType(this.genericType, this.environment, false);
        switch (this.boundKind) {
            case 1: {
                int n;
                TypeBinding typeBinding;
                this.bound = typeBinding = BinaryTypeBinding.resolveType(this.bound, this.environment, true);
                this.tagBits |= typeBinding.tagBits & 0x800L;
                int n2 = n = this.otherBounds == null ? 0 : this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    this.otherBounds[i] = typeBinding = BinaryTypeBinding.resolveType(this.otherBounds[i], this.environment, true);
                    this.tagBits |= typeBinding.tagBits & 0x800L;
                }
                break;
            }
            case 2: {
                TypeBinding typeBinding;
                this.bound = typeBinding = BinaryTypeBinding.resolveType(this.bound, this.environment, true);
                this.tagBits |= typeBinding.tagBits & 0x800L;
                break;
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                int n;
                if (this.otherBounds == null) {
                    return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.shortReadableName());
                }
                StringBuffer stringBuffer = new StringBuffer(10);
                stringBuffer.append(this.bound.shortReadableName());
                int n2 = this.otherBounds.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('&').append(this.otherBounds[n].shortReadableName());
                }
                n = stringBuffer.length();
                char[] cArray = new char[n];
                stringBuffer.getChars(0, n, cArray, 0);
                return cArray;
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.shortReadableName());
    }

    public char[] signature() {
        if (this.signature == null) {
            switch (this.boundKind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    public char[] sourceName() {
        switch (this.boundKind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.sourceName());
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding typeBinding = null;
            if (this.boundKind == 1 && !this.bound.isInterface()) {
                typeBinding = this.bound;
            } else {
                TypeVariableBinding typeVariableBinding = this.typeVariable();
                if (typeVariableBinding != null) {
                    typeBinding = typeVariableBinding.firstBound;
                }
            }
            this.superclass = typeBinding instanceof ReferenceBinding && !typeBinding.isInterface() ? (ReferenceBinding)typeBinding : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : Binding.NO_SUPERINTERFACES;
            if (this.boundKind == 1) {
                int n;
                if (this.bound.isInterface()) {
                    n = this.superInterfaces.length;
                    this.superInterfaces = new ReferenceBinding[n + 1];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, n);
                    this.superInterfaces[0] = (ReferenceBinding)this.bound;
                }
                if (this.otherBounds != null) {
                    n = this.superInterfaces.length;
                    int n2 = this.otherBounds.length;
                    this.superInterfaces = new ReferenceBinding[n + n2];
                    System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, n);
                    for (int i = 0; i < n2; ++i) {
                        this.superInterfaces[n + i] = (ReferenceBinding)this.otherBounds[i];
                    }
                }
            }
        }
        return this.superInterfaces;
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        boolean bl = false;
        if (this.genericType == unresolvedReferenceBinding) {
            this.genericType = referenceBinding;
            bl = true;
        }
        if (this.bound == unresolvedReferenceBinding) {
            this.bound = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            bl = true;
        }
        if (this.otherBounds != null) {
            int n = this.otherBounds.length;
            for (int i = 0; i < n; ++i) {
                if (this.otherBounds[i] != unresolvedReferenceBinding) continue;
                this.otherBounds[i] = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
                bl = true;
            }
        }
        if (bl) {
            this.initialize(this.genericType, this.bound, this.otherBounds);
        }
    }

    public String toString() {
        switch (this.boundKind) {
            case 0: {
                return new String(TypeConstants.WILDCARD_NAME);
            }
            case 1: {
                if (this.otherBounds == null) {
                    return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
                }
                StringBuffer stringBuffer = new StringBuffer(this.bound.debugName());
                int n = this.otherBounds.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append('&').append(this.otherBounds[i].debugName());
                }
                return stringBuffer.toString();
            }
        }
        return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariableBindingArray;
        if (this.typeVariable == null && this.rank < (typeVariableBindingArray = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariableBindingArray[this.rank];
        }
        return this.typeVariable;
    }
}

