/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public CategorizedProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, CategorizedProblem categorizedProblem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = categorizedProblem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable throwable) {
        this();
        this.compilationResult = compilationResult;
        this.exception = throwable;
    }

    public AbortCompilation(boolean bl, RuntimeException runtimeException) {
        this();
        this.isSilent = bl;
        this.silentException = runtimeException;
    }

    public String getMessage() {
        String string = super.getMessage();
        StringBuffer stringBuffer = new StringBuffer(string == null ? Util.EMPTY_STRING : string);
        if (this.problem != null) {
            stringBuffer.append(this.problem);
        } else if (this.exception != null) {
            string = this.exception.getMessage();
            stringBuffer.append(string == null ? Util.EMPTY_STRING : string);
        } else if (this.silentException != null) {
            string = this.silentException.getMessage();
            stringBuffer.append(string == null ? Util.EMPTY_STRING : string);
        }
        return String.valueOf(stringBuffer);
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        int[] nArray = compilationResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(invocationSite.sourceStart(), nArray, 0, nArray.length - 1));
        this.compilationResult = compilationResult;
    }

    public void updateContext(ASTNode aSTNode, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(aSTNode.sourceStart());
        this.problem.setSourceEnd(aSTNode.sourceEnd());
        int[] nArray = compilationResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(aSTNode.sourceStart(), nArray, 0, nArray.length - 1));
        this.compilationResult = compilationResult;
    }

    public String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.problem != null) {
            stringBuffer.append(this.problem);
        }
        return String.valueOf(stringBuffer);
    }
}

