/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, long[] lArray) {
        super(cArray, n, lArray);
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding referenceBinding, Scope scope, int n) {
        ParameterizedTypeBinding parameterizedTypeBinding;
        ReferenceBinding referenceBinding2;
        TypeVariableBinding[] typeVariableBindingArray;
        if (n > 0 && referenceBinding.enclosingType() != null) {
            this.checkBounds(referenceBinding.enclosingType(), scope, n - 1);
        }
        if (referenceBinding.isParameterizedTypeWithActualArguments() && (typeVariableBindingArray = (referenceBinding2 = (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding).genericType()).typeVariables()) != null) {
            parameterizedTypeBinding.boundCheck(scope, this.typeArguments[n]);
        }
    }

    public TypeReference copyDims(int n) {
        return new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, n, this.sourcePositions);
    }

    public char[][] getParameterizedTypeName() {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = this.tokens.length;
        char[][] cArrayArray = new char[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = this.typeArguments[n2];
            if (objectArray == null) {
                cArrayArray[n2] = this.tokens[n2];
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append(this.tokens[n2]);
            stringBuffer.append('<');
            int n4 = objectArray.length;
            for (n = 0; n < n4; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CharOperation.concatWith(objectArray[n].getParameterizedTypeName(), '.'));
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArrayArray[n2] = new char[n];
            stringBuffer.getChars(0, n, cArrayArray[n2], 0);
        }
        n2 = this.dimensions;
        if (n2 > 0) {
            objectArray = new char[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                n = i * 2;
                objectArray[n] = (TypeReference)91;
                objectArray[n + 1] = (TypeReference)93;
            }
            cArrayArray[n3 - 1] = CharOperation.concat(cArrayArray[n3 - 1], (char[])objectArray);
        }
        return cArrayArray;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, bl);
        this.createArrayType(scope);
        return typeBinding == null ? typeBinding : this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, boolean bl) {
        boolean bl2 = scope.kind == 3;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            int n = this.tokens.length;
            for (int i = 0; i < n; ++i) {
                TypeReference[] typeReferenceArray = this.typeArguments[i];
                if (typeReferenceArray == null) continue;
                int n2 = typeReferenceArray.length;
                for (int j = 0; j < n2; ++j) {
                    TypeReference typeReference = typeReferenceArray[j];
                    if (bl2) {
                        typeReference.resolveType((ClassScope)scope);
                        continue;
                    }
                    typeReference.resolveType((BlockScope)scope, bl);
                }
            }
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl3 = true;
        Object object = null;
        int n = this.tokens.length;
        for (int i = packageBinding == null ? 0 : packageBinding.compoundName.length; i < n; ++i) {
            Object object2;
            int n3;
            TypeReference[] typeReferenceArray;
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                for (int j = i; j < n; ++j) {
                    typeReferenceArray = this.typeArguments[j];
                    if (typeReferenceArray == null) continue;
                    int n4 = typeReferenceArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        TypeReference typeReference = typeReferenceArray[n3];
                        if (bl2) {
                            typeReference.resolveType((ClassScope)scope);
                            continue;
                        }
                        typeReference.resolveType((BlockScope)scope);
                    }
                }
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (object == null) {
                object = referenceBinding.enclosingType();
                if (object != null) {
                    object = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType((TypeBinding)object, false) : scope.environment().convertToParameterizedType((ReferenceBinding)object);
                }
            } else {
                if (bl3 && referenceBinding.isStatic() && (((TypeBinding)object).isParameterizedTypeWithActualArguments() || ((TypeBinding)object).isGenericType())) {
                    scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)object), i);
                    bl3 = false;
                }
                if ((typeReferenceArray = referenceBinding.enclosingType()) != null && typeReferenceArray.erasure() != ((TypeBinding)object).erasure()) {
                    object = typeReferenceArray;
                }
            }
            if ((typeReferenceArray = this.typeArguments[i]) != null) {
                TypeVariableBinding[] typeVariableBindingArray;
                Object object3;
                object2 = null;
                if (bl2) {
                    object2 = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                boolean bl4 = (n3 = typeReferenceArray.length) == 0 && i == n - 1 && (this.bits & 0x80000) != 0;
                TypeBinding[] typeBindingArray = new TypeBinding[n3];
                boolean bl5 = false;
                ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
                for (int j = 0; j < n3; ++j) {
                    TypeBinding typeBinding;
                    object3 = typeReferenceArray[j];
                    TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object3).resolveTypeArgument((ClassScope)scope, referenceBinding2, j) : ((TypeReference)object3).resolveTypeArgument((BlockScope)scope, referenceBinding2, j);
                    if (typeBinding == null) {
                        bl5 = true;
                        continue;
                    }
                    typeBindingArray[j] = typeBinding;
                }
                if (bl5) {
                    return null;
                }
                if (bl2) {
                    ((ClassScope)scope).superTypeReference = object2;
                    if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                        return null;
                    }
                }
                if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    if (scope.compilerOptions().originalSourceLevel >= 0x310000L) {
                        scope.problemReporter().nonGenericTypeCannotBeParameterized(i, this, referenceBinding, typeBindingArray);
                        return null;
                    }
                    this.resolvedType = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType(referenceBinding2, null, (ReferenceBinding)object) : referenceBinding;
                    return this.resolvedType;
                }
                if (n3 != typeVariableBindingArray.length && !bl4) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray, i);
                    return null;
                }
                if (bl3 && !referenceBinding.isStatic() && (object3 = referenceBinding.enclosingType()) != null && ((TypeBinding)object3).isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object3), typeBindingArray);
                    bl3 = false;
                }
                object3 = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)object);
                if (!bl4) {
                    if (bl) {
                        ((ParameterizedTypeBinding)object3).boundCheck(scope, typeReferenceArray);
                    } else {
                        scope.deferBoundCheck(this);
                    }
                }
                object = object3;
            } else {
                object2 = (ReferenceBinding)referenceBinding.original();
                if (bl2 && ((ClassScope)scope).detectHierarchyCycle((TypeBinding)object2, this)) {
                    return null;
                }
                if (((TypeBinding)object2).isGenericType()) {
                    if (bl3 && object != null && ((TypeBinding)object).isParameterizedType()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object), i);
                        bl3 = false;
                    }
                    object = scope.environment().createRawType((ReferenceBinding)object2, (ReferenceBinding)object);
                } else {
                    Object object4 = object = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object) : referenceBinding;
                }
            }
            if (this.isTypeUseDeprecated((TypeBinding)object, scope)) {
                this.reportDeprecatedType((TypeBinding)object, scope, i);
            }
            this.resolvedType = object;
        }
        return this.resolvedType;
    }

    private void createArrayType(Scope scope) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        int n4 = this.tokens.length;
        for (int i = 0; i < n4 - 1; ++i) {
            stringBuffer.append(this.tokens[i]);
            TypeReference[] typeReferenceArray = this.typeArguments[i];
            if (typeReferenceArray != null) {
                stringBuffer.append('<');
                n3 = typeReferenceArray.length;
                if (n3 > 0) {
                    n2 = n3 - 1;
                    for (int j = 0; j < n2; ++j) {
                        typeReferenceArray[j].print(0, stringBuffer);
                        stringBuffer.append(", ");
                    }
                    typeReferenceArray[n2].print(0, stringBuffer);
                }
                stringBuffer.append('>');
            }
            stringBuffer.append('.');
        }
        stringBuffer.append(this.tokens[n4 - 1]);
        TypeReference[] typeReferenceArray = this.typeArguments[n4 - 1];
        if (typeReferenceArray != null) {
            stringBuffer.append('<');
            int n5 = typeReferenceArray.length;
            if (n5 > 0) {
                n3 = n5 - 1;
                for (n2 = 0; n2 < n3; ++n2) {
                    typeReferenceArray[n2].print(0, stringBuffer);
                    stringBuffer.append(", ");
                }
                typeReferenceArray[n3].print(0, stringBuffer);
            }
            stringBuffer.append('>');
        }
        if ((this.bits & 0x4000) != 0) {
            for (int i = 0; i < this.dimensions - 1; ++i) {
                stringBuffer.append("[]");
            }
            stringBuffer.append("...");
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, bl);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, false);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.typeArguments[i] == null) continue;
                int n2 = this.typeArguments[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.typeArguments[i][j].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                if (this.typeArguments[i] == null) continue;
                int n2 = this.typeArguments[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.typeArguments[i][j].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

