/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n, long l) {
        super(cArray, n, l);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int n) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n2 = this.typeArguments.length;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n].getParameterizedTypeName(), '.'));
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        int n3 = this.dimensions;
        if (n3 > 0) {
            char[] cArray2 = new char[n3 * 2];
            for (int i = 0; i < n3; ++i) {
                int n4 = i * 2;
                cArray2[n4] = 91;
                cArray2[n4 + 1] = 93;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, referenceBinding, bl);
        if (typeBinding == null) {
            this.resolvedType = this.createArrayType(scope, this.resolvedType);
            return null;
        }
        typeBinding = this.createArrayType(scope, typeBinding);
        if (!this.resolvedType.isValidBinding()) {
            return typeBinding;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, ReferenceBinding typeBinding, boolean bl) {
        TypeBinding typeBinding2;
        TypeVariableBinding[] typeVariableBindingArray;
        int n;
        TypeBinding typeBinding3;
        ReferenceBinding referenceBinding;
        if (typeBinding == null) {
            this.resolvedType = scope.getType(this.token);
            if (this.resolvedType.isValidBinding()) {
                referenceBinding = (ReferenceBinding)this.resolvedType;
            } else {
                this.reportInvalidType(scope);
                switch (this.resolvedType.problemId()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        typeBinding3 = this.resolvedType.closestMatch();
                        if (typeBinding3 instanceof ReferenceBinding) {
                            referenceBinding = (ReferenceBinding)typeBinding3;
                            break;
                        }
                    }
                    default: {
                        boolean bl2 = scope.kind == 3;
                        int n2 = this.typeArguments.length;
                        for (int i = 0; i < n2; ++i) {
                            TypeReference typeReference = this.typeArguments[i];
                            if (bl2) {
                                typeReference.resolveType((ClassScope)scope);
                                continue;
                            }
                            typeReference.resolveType((BlockScope)scope, bl);
                        }
                        return null;
                    }
                }
            }
            typeBinding = referenceBinding.enclosingType();
            if (typeBinding != null) {
                typeBinding = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(typeBinding, false) : scope.environment().convertToParameterizedType((ReferenceBinding)typeBinding);
                referenceBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding);
            }
        } else {
            referenceBinding = scope.getMemberType(this.token, (ReferenceBinding)typeBinding);
            this.resolvedType = referenceBinding;
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, referenceBinding, (ReferenceBinding)typeBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(referenceBinding, scope)) {
                scope.problemReporter().deprecatedType(referenceBinding, this);
            }
            if ((typeBinding3 = referenceBinding.enclosingType()) != null && typeBinding3.erasure() != typeBinding.erasure()) {
                typeBinding = typeBinding3;
            }
        }
        boolean bl3 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl3) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        int n3 = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n3];
        boolean bl4 = false;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
        for (n = 0; n < n3; ++n) {
            typeVariableBindingArray = this.typeArguments[n];
            TypeBinding typeBinding4 = typeBinding2 = bl3 ? typeVariableBindingArray.resolveTypeArgument((ClassScope)scope, referenceBinding2, n) : typeVariableBindingArray.resolveTypeArgument((BlockScope)scope, referenceBinding2, n);
            if (typeBinding2 == null) {
                bl4 = true;
                continue;
            }
            typeBindingArray[n] = typeBinding2;
        }
        if (bl4) {
            return null;
        }
        if (bl3) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                return null;
            }
        }
        n = (this.bits & 0x80000) != 0 ? 1 : 0;
        typeVariableBindingArray = referenceBinding2.typeVariables();
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            boolean bl5;
            boolean bl6 = bl5 = scope.compilerOptions().originalSourceLevel >= 0x310000L;
            if ((referenceBinding2.tagBits & 0x80L) == 0L && bl5) {
                this.resolvedType = referenceBinding;
                scope.problemReporter().nonGenericTypeCannotBeParameterized(0, this, referenceBinding, typeBindingArray);
                return null;
            }
            if (!bl5) {
                if (!this.resolvedType.isValidBinding()) {
                    return referenceBinding;
                }
                this.resolvedType = referenceBinding;
                return this.resolvedType;
            }
        } else if (n3 != typeVariableBindingArray.length) {
            if (n == 0) {
                scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                return null;
            }
        } else if (!referenceBinding.isStatic() && (typeBinding2 = referenceBinding.enclosingType()) != null && typeBinding2.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)typeBinding2), typeBindingArray);
            return null;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)typeBinding);
        if (n == 0) {
            if (bl) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            } else {
                scope.deferBoundCheck(this);
            }
        }
        if (this.isTypeUseDeprecated(parameterizedTypeBinding, scope)) {
            this.reportDeprecatedType(parameterizedTypeBinding, scope);
        }
        if (!this.resolvedType.isValidBinding()) {
            return parameterizedTypeBinding;
        }
        this.resolvedType = parameterizedTypeBinding;
        return this.resolvedType;
    }

    private TypeBinding createArrayType(Scope scope, TypeBinding typeBinding) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            return scope.createArrayType(typeBinding, this.dimensions);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n3 = this.typeArguments.length;
        if (n3 > 0) {
            n2 = n3 - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
        }
        stringBuffer.append(">");
        if ((this.bits & 0x4000) != 0) {
            for (n2 = 0; n2 < this.dimensions - 1; ++n2) {
                stringBuffer.append("[]");
            }
            stringBuffer.append("...");
        } else {
            for (n2 = 0; n2 < this.dimensions; ++n2) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        return this.internalResolveType(blockScope, null, bl);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                this.typeArguments[i].traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                this.typeArguments[i].traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

