/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces;
    private FieldBinding[] fields;
    private MethodBinding[] methods;
    public ReferenceBinding[] memberTypes;
    public TypeVariableBinding[] typeVariables;
    public ClassScope scope;
    private static final int METHOD_EMUL = 0;
    private static final int FIELD_EMUL = 1;
    private static final int CLASS_LITERAL_EMUL = 2;
    private static final int MAX_SYNTHETICS = 3;
    HashMap[] synthetics;
    char[] genericReferenceTypeSignature;
    private SimpleLookupTable storedAnnotations = null;

    public SourceTypeBinding(char[][] cArray, PackageBinding packageBinding, ClassScope classScope) {
        this.compoundName = cArray;
        this.fPackage = packageBinding;
        this.fileName = classScope.referenceCompilationUnit().getFileName();
        this.modifiers = classScope.referenceContext.modifiers;
        this.sourceName = classScope.referenceContext.name;
        this.scope = classScope;
        this.fields = Binding.UNINITIALIZED_FIELDS;
        this.methods = Binding.UNINITIALIZED_METHODS;
        this.computeId();
    }

    private void addDefaultAbstractMethods() {
        if ((this.tagBits & 0x400L) != 0L) {
            return;
        }
        this.tagBits |= 0x400L;
        if (this.isClass() && this.isAbstract()) {
            if (this.scope.compilerOptions().targetJDK >= 0x2E0000L) {
                return;
            }
            ReferenceBinding[] referenceBindingArray = this.superInterfaces();
            if (referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                int n;
                MethodBinding[] methodBindingArray = null;
                int n2 = 0;
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                int n3 = referenceBindingArray2.length;
                for (n = 0; n < n3; ++n) {
                    ReferenceBinding referenceBinding = referenceBindingArray2[n];
                    if (!referenceBinding.isValidBinding()) continue;
                    MethodBinding[] methodBindingArray2 = referenceBinding.methods();
                    int n4 = methodBindingArray2.length;
                    block1: while (--n4 >= 0) {
                        MethodBinding methodBinding = methodBindingArray2[n4];
                        if (this.implementsMethod(methodBinding)) continue;
                        if (n2 == 0) {
                            methodBindingArray = new MethodBinding[5];
                        } else {
                            for (int i = 0; i < n2; ++i) {
                                MethodBinding methodBinding2 = methodBindingArray[i];
                                if (CharOperation.equals(methodBinding2.selector, methodBinding.selector) && methodBinding2.areParametersEqual(methodBinding)) continue block1;
                            }
                        }
                        MethodBinding methodBinding3 = new MethodBinding(methodBinding.modifiers | 0x80000 | 0x1000, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, this);
                        if (n2 == methodBindingArray.length) {
                            MethodBinding[] methodBindingArray3 = methodBindingArray;
                            methodBindingArray = new MethodBinding[2 * n2];
                            System.arraycopy(methodBindingArray3, 0, methodBindingArray, 0, n2);
                        }
                        methodBindingArray[n2++] = methodBinding3;
                    }
                    referenceBindingArray = referenceBinding.superInterfaces();
                    if (referenceBindingArray == Binding.NO_SUPERINTERFACES) continue;
                    n4 = referenceBindingArray.length;
                    if (n3 + n4 >= referenceBindingArray2.length) {
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n3 + n4 + 5];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n3);
                    }
                    block3: for (int i = 0; i < n4; ++i) {
                        ReferenceBinding referenceBinding2 = referenceBindingArray[i];
                        for (int j = 0; j < n3; ++j) {
                            if (referenceBinding2 == referenceBindingArray2[j]) continue block3;
                        }
                        referenceBindingArray2[n3++] = referenceBinding2;
                    }
                }
                if (n2 > 0) {
                    n = this.methods.length;
                    this.methods = new MethodBinding[n + n2];
                    System.arraycopy(this.methods, 0, this.methods, 0, n);
                    System.arraycopy(methodBindingArray, 0, this.methods, n, n2);
                    if ((n += n2) > 1) {
                        ReferenceBinding.sortMethods(this.methods, 0, n);
                    }
                }
            }
        }
    }

    public FieldBinding addSyntheticFieldForInnerclass(LocalVariableBinding localVariableBinding) {
        boolean bl;
        FieldBinding fieldBinding;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((fieldBinding = (FieldBinding)this.synthetics[1].get(localVariableBinding)) == null) {
            fieldBinding = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, localVariableBinding.name), localVariableBinding.type, 4114, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(localVariableBinding, fieldBinding);
        }
        int n = 1;
        block0: do {
            bl = false;
            FieldBinding fieldBinding2 = this.getField(fieldBinding.name, true);
            if (fieldBinding2 == null) continue;
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
            int n2 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
            for (int i = 0; i < n2; ++i) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
                if (fieldDeclaration.binding != fieldBinding2) continue;
                fieldBinding.name = CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, localVariableBinding.name, ("$" + String.valueOf(n++)).toCharArray());
                bl = true;
                continue block0;
            }
        } while (bl);
        return fieldBinding;
    }

    public FieldBinding addSyntheticFieldForInnerclass(ReferenceBinding referenceBinding) {
        boolean bl;
        FieldBinding fieldBinding;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((fieldBinding = (FieldBinding)this.synthetics[1].get(referenceBinding)) == null) {
            fieldBinding = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(referenceBinding.depth()).toCharArray()), referenceBinding, 4112, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(referenceBinding, fieldBinding);
        }
        block0: do {
            bl = false;
            FieldBinding fieldBinding2 = this.getField(fieldBinding.name, true);
            if (fieldBinding2 == null) continue;
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
            int n = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
            for (int i = 0; i < n; ++i) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
                if (fieldDeclaration.binding != fieldBinding2) continue;
                if (this.scope.compilerOptions().complianceLevel >= 0x310000L) {
                    fieldBinding.name = CharOperation.concat(fieldBinding.name, "$".toCharArray());
                    bl = true;
                    continue block0;
                }
                this.scope.problemReporter().duplicateFieldInType(this, fieldDeclaration);
                continue block0;
            }
        } while (bl);
        return fieldBinding;
    }

    public FieldBinding addSyntheticFieldForClassLiteral(TypeBinding typeBinding, BlockScope blockScope) {
        FieldBinding fieldBinding;
        FieldBinding fieldBinding2;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[2] == null) {
            this.synthetics[2] = new HashMap(5);
        }
        if ((fieldBinding2 = (FieldBinding)this.synthetics[2].get(typeBinding)) == null) {
            fieldBinding2 = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_CLASS, String.valueOf(this.synthetics[2].size()).toCharArray()), blockScope.getJavaLangClass(), 4104, this, Constant.NotAConstant, this.synthetics[2].size());
            this.synthetics[2].put(typeBinding, fieldBinding2);
        }
        if ((fieldBinding = this.getField(fieldBinding2.name, true)) != null) {
            TypeDeclaration typeDeclaration = blockScope.referenceType();
            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
            int n = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
            for (int i = 0; i < n; ++i) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
                if (fieldDeclaration.binding != fieldBinding) continue;
                blockScope.problemReporter().duplicateFieldInType(this, fieldDeclaration);
                break;
            }
        }
        return fieldBinding2;
    }

    public FieldBinding addSyntheticFieldForAssert(BlockScope blockScope) {
        boolean bl;
        FieldBinding fieldBinding;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((fieldBinding = (FieldBinding)this.synthetics[1].get("assertionEmulation")) == null) {
            fieldBinding = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ASSERT_DISABLED, TypeBinding.BOOLEAN, 4120, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("assertionEmulation", fieldBinding);
        }
        int n = 0;
        block0: do {
            bl = false;
            FieldBinding fieldBinding2 = this.getField(fieldBinding.name, true);
            if (fieldBinding2 == null) continue;
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            int n2 = typeDeclaration.fields == null ? 0 : typeDeclaration.fields.length;
            for (int i = 0; i < n2; ++i) {
                FieldDeclaration fieldDeclaration = typeDeclaration.fields[i];
                if (fieldDeclaration.binding != fieldBinding2) continue;
                fieldBinding.name = CharOperation.concat(TypeConstants.SYNTHETIC_ASSERT_DISABLED, ("_" + String.valueOf(n++)).toCharArray());
                bl = true;
                continue block0;
            }
        } while (bl);
        return fieldBinding;
    }

    public FieldBinding addSyntheticFieldForEnumValues() {
        boolean bl;
        FieldBinding fieldBinding;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((fieldBinding = (FieldBinding)this.synthetics[1].get("enumConstantValues")) == null) {
            fieldBinding = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ENUM_VALUES, this.scope.createArrayType(this, 1), 4122, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("enumConstantValues", fieldBinding);
        }
        int n = 0;
        block0: do {
            bl = false;
            FieldBinding fieldBinding2 = this.getField(fieldBinding.name, true);
            if (fieldBinding2 == null) continue;
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
            int n2 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
            for (int i = 0; i < n2; ++i) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
                if (fieldDeclaration.binding != fieldBinding2) continue;
                fieldBinding.name = CharOperation.concat(TypeConstants.SYNTHETIC_ENUM_VALUES, ("_" + String.valueOf(n++)).toCharArray());
                bl = true;
                continue block0;
            }
        } while (bl);
        return fieldBinding;
    }

    public SyntheticMethodBinding addSyntheticMethod(FieldBinding fieldBinding, boolean bl, boolean bl2) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding syntheticMethodBinding = null;
        SyntheticMethodBinding[] syntheticMethodBindingArray = (SyntheticMethodBinding[])this.synthetics[0].get(fieldBinding);
        if (syntheticMethodBindingArray == null) {
            syntheticMethodBinding = new SyntheticMethodBinding(fieldBinding, bl, bl2, (ReferenceBinding)this);
            syntheticMethodBindingArray = new SyntheticMethodBinding[2];
            this.synthetics[0].put(fieldBinding, syntheticMethodBindingArray);
            syntheticMethodBindingArray[bl ? 0 : 1] = syntheticMethodBinding;
        } else {
            syntheticMethodBinding = syntheticMethodBindingArray[bl ? 0 : 1];
            if (syntheticMethodBinding == null) {
                syntheticMethodBinding = new SyntheticMethodBinding(fieldBinding, bl, bl2, (ReferenceBinding)this);
                syntheticMethodBindingArray[bl ? 0 : 1] = syntheticMethodBinding;
            }
        }
        return syntheticMethodBinding;
    }

    public SyntheticMethodBinding addSyntheticEnumMethod(char[] cArray) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding syntheticMethodBinding = null;
        SyntheticMethodBinding[] syntheticMethodBindingArray = (SyntheticMethodBinding[])this.synthetics[0].get(cArray);
        if (syntheticMethodBindingArray == null) {
            syntheticMethodBinding = new SyntheticMethodBinding(this, cArray);
            syntheticMethodBindingArray = new SyntheticMethodBinding[2];
            this.synthetics[0].put(cArray, syntheticMethodBindingArray);
            syntheticMethodBindingArray[0] = syntheticMethodBinding;
        } else {
            syntheticMethodBinding = syntheticMethodBindingArray[0];
            if (syntheticMethodBinding == null) {
                syntheticMethodBindingArray[0] = syntheticMethodBinding = new SyntheticMethodBinding(this, cArray);
            }
        }
        return syntheticMethodBinding;
    }

    public SyntheticFieldBinding addSyntheticFieldForSwitchEnum(char[] cArray, String string) {
        boolean bl;
        SyntheticFieldBinding syntheticFieldBinding;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((syntheticFieldBinding = (SyntheticFieldBinding)this.synthetics[1].get(string)) == null) {
            syntheticFieldBinding = new SyntheticFieldBinding(cArray, this.scope.createArrayType(TypeBinding.INT, 1), 4106, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(string, syntheticFieldBinding);
        }
        int n = 0;
        block0: do {
            bl = false;
            FieldBinding fieldBinding = this.getField(syntheticFieldBinding.name, true);
            if (fieldBinding == null) continue;
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
            int n2 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
            for (int i = 0; i < n2; ++i) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
                if (fieldDeclaration.binding != fieldBinding) continue;
                syntheticFieldBinding.name = CharOperation.concat(cArray, ("_" + String.valueOf(n++)).toCharArray());
                bl = true;
                continue block0;
            }
        } while (bl);
        return syntheticFieldBinding;
    }

    public SyntheticMethodBinding addSyntheticMethodForSwitchEnum(TypeBinding typeBinding) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding syntheticMethodBinding = null;
        char[] cArray = CharOperation.concat(TypeConstants.SYNTHETIC_SWITCH_ENUM_TABLE, typeBinding.constantPoolName());
        CharOperation.replace(cArray, '/', '$');
        String string = new String(cArray);
        SyntheticMethodBinding[] syntheticMethodBindingArray = (SyntheticMethodBinding[])this.synthetics[0].get(string);
        if (syntheticMethodBindingArray == null) {
            SyntheticFieldBinding syntheticFieldBinding = this.addSyntheticFieldForSwitchEnum(cArray, string);
            syntheticMethodBinding = new SyntheticMethodBinding((FieldBinding)syntheticFieldBinding, this, typeBinding, cArray);
            syntheticMethodBindingArray = new SyntheticMethodBinding[2];
            this.synthetics[0].put(string, syntheticMethodBindingArray);
            syntheticMethodBindingArray[0] = syntheticMethodBinding;
        } else {
            syntheticMethodBinding = syntheticMethodBindingArray[0];
            if (syntheticMethodBinding == null) {
                SyntheticFieldBinding syntheticFieldBinding = this.addSyntheticFieldForSwitchEnum(cArray, string);
                syntheticMethodBindingArray[0] = syntheticMethodBinding = new SyntheticMethodBinding((FieldBinding)syntheticFieldBinding, this, typeBinding, cArray);
            }
        }
        return syntheticMethodBinding;
    }

    public SyntheticMethodBinding addSyntheticMethodForEnumInitialization(int n, int n2) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding syntheticMethodBinding = new SyntheticMethodBinding(this, n, n2);
        SyntheticMethodBinding[] syntheticMethodBindingArray = new SyntheticMethodBinding[2];
        this.synthetics[0].put(syntheticMethodBinding.selector, syntheticMethodBindingArray);
        syntheticMethodBindingArray[0] = syntheticMethodBinding;
        return syntheticMethodBinding;
    }

    public SyntheticMethodBinding addSyntheticMethod(MethodBinding methodBinding, boolean bl) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding syntheticMethodBinding = null;
        SyntheticMethodBinding[] syntheticMethodBindingArray = (SyntheticMethodBinding[])this.synthetics[0].get(methodBinding);
        if (syntheticMethodBindingArray == null) {
            syntheticMethodBinding = new SyntheticMethodBinding(methodBinding, bl, (ReferenceBinding)this);
            syntheticMethodBindingArray = new SyntheticMethodBinding[2];
            this.synthetics[0].put(methodBinding, syntheticMethodBindingArray);
            syntheticMethodBindingArray[bl ? 0 : 1] = syntheticMethodBinding;
        } else {
            syntheticMethodBinding = syntheticMethodBindingArray[bl ? 0 : 1];
            if (syntheticMethodBinding == null) {
                syntheticMethodBinding = new SyntheticMethodBinding(methodBinding, bl, (ReferenceBinding)this);
                syntheticMethodBindingArray[bl ? 0 : 1] = syntheticMethodBinding;
            }
        }
        if (methodBinding.declaringClass.isStatic()) {
            if (methodBinding.isConstructor() && methodBinding.parameters.length >= 254 || methodBinding.parameters.length >= 255) {
                this.scope.problemReporter().tooManyParametersForSyntheticMethod(methodBinding.sourceMethod());
            }
        } else if (methodBinding.isConstructor() && methodBinding.parameters.length >= 253 || methodBinding.parameters.length >= 254) {
            this.scope.problemReporter().tooManyParametersForSyntheticMethod(methodBinding.sourceMethod());
        }
        return syntheticMethodBinding;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        Object object;
        Object object2;
        if (this.isInterface()) {
            return null;
        }
        if (methodBinding.returnType.erasure() == methodBinding2.returnType.erasure() && methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            object2 = this.synthetics[0].keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof MethodBinding)) continue;
                MethodBinding methodBinding3 = (MethodBinding)object;
                if (!CharOperation.equals(methodBinding.selector, methodBinding3.selector) || methodBinding.returnType.erasure() != methodBinding3.returnType.erasure() || !methodBinding.areParameterErasuresEqual(methodBinding3)) continue;
                return null;
            }
        }
        object2 = null;
        object = (SyntheticMethodBinding[])this.synthetics[0].get(methodBinding);
        if (object == null) {
            object2 = new SyntheticMethodBinding(methodBinding, methodBinding2, this);
            object = new SyntheticMethodBinding[2];
            this.synthetics[0].put(methodBinding, object);
            object[1] = object2;
        } else {
            object2 = object[1];
            if (object2 == null) {
                object2 = new SyntheticMethodBinding(methodBinding, methodBinding2, this);
                object[1] = object2;
            }
        }
        return object2;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding methodBinding) {
        Object object;
        Object object2;
        if (this.scope.compilerOptions().complianceLevel <= 0x310000L) {
            return null;
        }
        if (this.isInterface()) {
            return null;
        }
        if (methodBinding.isAbstract() || methodBinding.isFinal() || methodBinding.isStatic()) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[3];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            object2 = this.synthetics[0].keySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof MethodBinding)) continue;
                MethodBinding methodBinding2 = (MethodBinding)object;
                if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector) || methodBinding.returnType.erasure() != methodBinding2.returnType.erasure() || !methodBinding.areParameterErasuresEqual(methodBinding2)) continue;
                return null;
            }
        }
        object2 = null;
        object = (SyntheticMethodBinding[])this.synthetics[0].get(methodBinding);
        if (object == null) {
            object2 = new SyntheticMethodBinding(methodBinding, this);
            object = new SyntheticMethodBinding[2];
            this.synthetics[0].put(methodBinding, object);
            object[0] = object2;
        } else {
            object2 = object[0];
            if (object2 == null) {
                object2 = new SyntheticMethodBinding(methodBinding, this);
                object[0] = object2;
            }
        }
        return object2;
    }

    boolean areFieldsInitialized() {
        return this.fields != Binding.UNINITIALIZED_FIELDS;
    }

    boolean areMethodsInitialized() {
        return this.methods != Binding.UNINITIALIZED_METHODS;
    }

    public int kind() {
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = super.computeUniqueKey(bl);
        if (cArray.length == 2) {
            return cArray;
        }
        if (Util.isClassFileName(this.fileName)) {
            return cArray;
        }
        int n = CharOperation.lastIndexOf('.', this.fileName);
        if (n != -1) {
            char[] cArray2;
            int n2 = CharOperation.lastIndexOf('/', this.fileName) + 1;
            char[] cArray3 = CharOperation.subarray(this.fileName, n2, n);
            n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0) {
                n2 = 1;
            }
            if ((n = this.isMemberType() ? CharOperation.indexOf('$', cArray, n2) : -1) == -1) {
                n = CharOperation.indexOf('<', cArray, n2);
            }
            if (n == -1) {
                n = CharOperation.indexOf(';', cArray, n2);
            }
            if (!CharOperation.equals(cArray2 = CharOperation.subarray(cArray, n2, n), cArray3)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray, 0, n2);
                stringBuffer.append(cArray3);
                stringBuffer.append('~');
                stringBuffer.append(cArray2);
                stringBuffer.append(cArray, n, cArray.length - n);
                int n3 = stringBuffer.length();
                cArray = new char[n3];
                stringBuffer.getChars(0, n3, cArray, 0);
                return cArray;
            }
        }
        return cArray;
    }

    void faultInTypesForFieldsAndMethods() {
        this.getAnnotationTagBits();
        ReferenceBinding referenceBinding = this.enclosingType();
        if (referenceBinding != null && referenceBinding.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
        this.fields();
        this.methods();
        int n = this.memberTypes.length;
        for (int i = 0; i < n; ++i) {
            ((SourceTypeBinding)this.memberTypes[i]).faultInTypesForFieldsAndMethods();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldBinding[] fields() {
        block12: {
            if ((this.tagBits & 0x2000L) != 0L) {
                return this.fields;
            }
            int n = 0;
            FieldBinding[] fieldBindingArray = this.fields;
            try {
                int n2;
                if ((this.tagBits & 0x1000L) == 0L) {
                    n2 = this.fields.length;
                    if (n2 > 1) {
                        ReferenceBinding.sortFields(this.fields, 0, n2);
                    }
                    this.tagBits |= 0x1000L;
                }
                int n3 = this.fields.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.resolveTypeFor(this.fields[n2]) != null) continue;
                    if (fieldBindingArray == this.fields) {
                        fieldBindingArray = new FieldBinding[n3];
                        System.arraycopy(this.fields, 0, fieldBindingArray, 0, n3);
                    }
                    fieldBindingArray[n2] = null;
                    ++n;
                }
                Object var6_5 = null;
                if (n <= 0) break block12;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (n > 0) {
                    int n4 = fieldBindingArray.length - n;
                    if (n4 == 0) {
                        this.fields = Binding.NO_FIELDS;
                        return Binding.NO_FIELDS;
                    }
                    FieldBinding[] fieldBindingArray2 = new FieldBinding[n4];
                    int n5 = 0;
                    int n6 = fieldBindingArray.length;
                    for (int i = 0; i < n6; ++i) {
                        if (fieldBindingArray[i] == null) continue;
                        fieldBindingArray2[n5++] = fieldBindingArray[i];
                    }
                    this.fields = fieldBindingArray2;
                }
                throw throwable;
            }
            int n7 = fieldBindingArray.length - n;
            if (n7 == 0) {
                this.fields = Binding.NO_FIELDS;
                return Binding.NO_FIELDS;
            }
            FieldBinding[] fieldBindingArray3 = new FieldBinding[n7];
            int n8 = 0;
            int n9 = fieldBindingArray.length;
            for (int i = 0; i < n9; ++i) {
                if (fieldBindingArray[i] == null) continue;
                fieldBindingArray3[n8++] = fieldBindingArray[i];
            }
            this.fields = fieldBindingArray3;
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    public char[] genericTypeSignature() {
        if (this.genericReferenceTypeSignature == null) {
            this.genericReferenceTypeSignature = this.computeGenericTypeSignature(this.typeVariables);
        }
        return this.genericReferenceTypeSignature;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        StringBuffer stringBuffer = null;
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer = new StringBuffer(10);
            stringBuffer.append('<');
            n2 = this.typeVariables.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.typeVariables[n].genericSignature());
            }
            stringBuffer.append('>');
        } else {
            block9: {
                if (this.superclass == null || !this.superclass.isParameterizedType()) {
                    n2 = this.superInterfaces.length;
                    for (n = 0; n < n2; ++n) {
                        if (!this.superInterfaces[n].isParameterizedType()) {
                            continue;
                        }
                        break block9;
                    }
                    return null;
                }
            }
            stringBuffer = new StringBuffer(10);
        }
        if (this.superclass != null) {
            stringBuffer.append(this.superclass.genericTypeSignature());
        } else {
            stringBuffer.append(this.scope.getJavaLangObject().genericTypeSignature());
        }
        n2 = this.superInterfaces.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.superInterfaces[n].genericTypeSignature());
        }
        return stringBuffer.toString().toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAnnotationTagBits() {
        if ((this.tagBits & 0x200000000L) == 0L && this.scope != null) {
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            boolean bl = typeDeclaration.staticInitializerScope.insideTypeAnnotation;
            try {
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = true;
                ASTNode.resolveAnnotations(typeDeclaration.staticInitializerScope, typeDeclaration.annotations, this);
                Object var4_3 = null;
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = bl;
                throw throwable;
            }
            if ((this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
            }
        }
        return this.tagBits;
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        int n = 0;
        int n2 = this.methods.length;
        while (--n2 >= 0) {
            if (!this.methods[n2].isDefaultAbstract()) continue;
            ++n;
        }
        if (n == 0) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] methodBindingArray = new MethodBinding[n];
        n = 0;
        int n3 = this.methods.length;
        while (--n3 >= 0) {
            if (!this.methods[n3].isDefaultAbstract()) continue;
            methodBindingArray[n++] = this.methods[n3];
        }
        return methodBindingArray;
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        block9: {
            long l;
            int n;
            block8: {
                n = typeBindingArray.length;
                if ((this.tagBits & 0x8000L) == 0L) break block8;
                long l2 = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
                if (l2 < 0L) break block9;
                int n2 = (int)(l2 >> 32);
                block0: for (int i = (int)l2; i <= n2; ++i) {
                    MethodBinding methodBinding = this.methods[i];
                    if (methodBinding.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    return methodBinding;
                }
                break block9;
            }
            if ((this.tagBits & 0x4000L) == 0L) {
                int n3 = this.methods.length;
                if (n3 > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, n3);
                }
                this.tagBits |= 0x4000L;
            }
            if ((l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods)) >= 0L) {
                int n4 = (int)(l >> 32);
                block2: for (int i = (int)l; i <= n4; ++i) {
                    MethodBinding methodBinding = this.methods[i];
                    if (this.resolveTypesFor(methodBinding) == null || methodBinding.returnType == null) {
                        this.methods();
                        return this.getExactConstructor(typeBindingArray);
                    }
                    if (methodBinding.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray3 = methodBinding.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray3[j] != typeBindingArray[j]) continue block2;
                    }
                    return methodBinding;
                }
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n = typeBindingArray.length;
        boolean bl = true;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l >= 0L) {
                int n2 = (int)(l >> 32);
                block0: for (int i = (int)l; i <= n2; ++i) {
                    MethodBinding methodBinding = this.methods[i];
                    bl = false;
                    if (methodBinding.parameters.length != n) continue;
                    TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                    for (int j = 0; j < n; ++j) {
                        if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                    }
                    return methodBinding;
                }
            }
        } else {
            long l;
            if ((this.tagBits & 0x4000L) == 0L) {
                int n3 = this.methods.length;
                if (n3 > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, n3);
                }
                this.tagBits |= 0x4000L;
            }
            if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
                MethodBinding methodBinding;
                int n4;
                int n5;
                int n6 = (int)l;
                int n7 = (int)(l >> 32);
                for (n5 = n6; n5 <= n7; ++n5) {
                    MethodBinding methodBinding2 = this.methods[n5];
                    if (this.resolveTypesFor(methodBinding2) != null && methodBinding2.returnType != null) continue;
                    this.methods();
                    return this.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
                n5 = this.scope.compilerOptions().sourceLevel >= 0x310000L ? 1 : 0;
                for (n4 = n6; n4 <= n7; ++n4) {
                    methodBinding = this.methods[n4];
                    for (int i = n7; i > n4; --i) {
                        boolean bl2;
                        MethodBinding methodBinding3 = this.methods[i];
                        boolean bl3 = bl2 = n5 != 0 ? methodBinding.areParameterErasuresEqual(methodBinding3) : methodBinding.areParametersEqual(methodBinding3);
                        if (!bl2) continue;
                        this.methods();
                        return this.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                    }
                }
                block5: for (n4 = n6; n4 <= n7; ++n4) {
                    methodBinding = this.methods[n4];
                    TypeBinding[] typeBindingArray3 = methodBinding.parameters;
                    if (typeBindingArray3.length != n) continue;
                    for (int i = 0; i < n; ++i) {
                        if (typeBindingArray3[i] != typeBindingArray[i]) continue block5;
                    }
                    return methodBinding;
                }
            }
        }
        if (bl) {
            if (this.isInterface()) {
                if (this.superInterfaces.length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldBinding getField(char[] cArray, boolean bl) {
        FieldBinding fieldBinding;
        if ((this.tagBits & 0x2000L) != 0L) {
            return ReferenceBinding.binarySearch(cArray, this.fields);
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        if ((fieldBinding = ReferenceBinding.binarySearch(cArray, this.fields)) != null) {
            FieldBinding fieldBinding2;
            block13: {
                FieldBinding fieldBinding3 = null;
                try {
                    fieldBinding2 = fieldBinding3 = this.resolveTypeFor(fieldBinding);
                    Object var7_7 = null;
                    if (fieldBinding3 != null) break block13;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (fieldBinding3 == null) {
                        int n = this.fields.length - 1;
                        if (n == 0) {
                            this.fields = Binding.NO_FIELDS;
                        } else {
                            FieldBinding[] fieldBindingArray = new FieldBinding[n];
                            int n2 = 0;
                            int n3 = this.fields.length;
                            for (int i = 0; i < n3; ++i) {
                                FieldBinding fieldBinding4 = this.fields[i];
                                if (fieldBinding4 == fieldBinding) continue;
                                fieldBindingArray[n2++] = fieldBinding4;
                            }
                            this.fields = fieldBindingArray;
                        }
                    }
                    throw throwable;
                }
                int n = this.fields.length - 1;
                if (n == 0) {
                    this.fields = Binding.NO_FIELDS;
                } else {
                    FieldBinding[] fieldBindingArray = new FieldBinding[n];
                    int n4 = 0;
                    int n5 = this.fields.length;
                    for (int i = 0; i < n5; ++i) {
                        FieldBinding fieldBinding5 = this.fields[i];
                        if (fieldBinding5 == fieldBinding) continue;
                        fieldBindingArray[n4++] = fieldBinding5;
                    }
                    this.fields = fieldBindingArray;
                }
            }
            return fieldBinding2;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        MethodBinding methodBinding;
        int n;
        int n2;
        int n3;
        long l;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l2 = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l2 >= 0L) {
                int n4 = (int)l2;
                int n5 = (int)(l2 >> 32);
                int n6 = n5 - n4 + 1;
                MethodBinding[] methodBindingArray = new MethodBinding[n6];
                System.arraycopy(this.methods, n4, methodBindingArray, 0, n6);
                return methodBindingArray;
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n7 = this.methods.length;
            if (n7 > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n7);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            n3 = (int)l;
            n2 = (int)(l >> 32);
            for (n = n3; n <= n2; ++n) {
                methodBinding = this.methods[n];
                if (this.resolveTypesFor(methodBinding) != null && methodBinding.returnType != null) continue;
                this.methods();
                return this.getMethods(cArray);
            }
        } else {
            return Binding.NO_METHODS;
        }
        n = n2 - n3 + 1;
        MethodBinding[] methodBindingArray = new MethodBinding[n];
        System.arraycopy(this.methods, n3, methodBindingArray, 0, n);
        n3 = this.scope.compilerOptions().sourceLevel >= 0x310000L ? 1 : 0;
        n = methodBindingArray.length - 1;
        for (n2 = 0; n2 < n; ++n2) {
            methodBinding = methodBindingArray[n2];
            for (int i = n; i > n2; --i) {
                boolean bl;
                boolean bl2 = bl = n3 != 0 ? methodBinding.areParameterErasuresEqual(methodBindingArray[i]) : methodBinding.areParametersEqual(methodBindingArray[i]);
                if (!bl) continue;
                this.methods();
                return this.getMethods(cArray);
            }
        }
        return methodBindingArray;
    }

    public FieldBinding getSyntheticField(LocalVariableBinding localVariableBinding) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        return (FieldBinding)this.synthetics[1].get(localVariableBinding);
    }

    public FieldBinding getSyntheticField(ReferenceBinding referenceBinding, boolean bl) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        FieldBinding fieldBinding = (FieldBinding)this.synthetics[1].get(referenceBinding);
        if (fieldBinding != null) {
            return fieldBinding;
        }
        if (!bl) {
            Iterator iterator = this.synthetics[1].values().iterator();
            while (iterator.hasNext()) {
                fieldBinding = (FieldBinding)iterator.next();
                if (!CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, fieldBinding.name) || fieldBinding.type.findSuperTypeOriginatingFrom(referenceBinding) == null) continue;
                return fieldBinding;
            }
        }
        return null;
    }

    public SyntheticMethodBinding getSyntheticBridgeMethod(MethodBinding methodBinding) {
        if (this.synthetics == null) {
            return null;
        }
        if (this.synthetics[0] == null) {
            return null;
        }
        SyntheticMethodBinding[] syntheticMethodBindingArray = (SyntheticMethodBinding[])this.synthetics[0].get(methodBinding);
        if (syntheticMethodBindingArray == null) {
            return null;
        }
        return syntheticMethodBindingArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDeprecatedAnnotationTagBits() {
        if ((this.tagBits & 0x400000000L) == 0L) {
            TypeDeclaration typeDeclaration = this.scope.referenceContext;
            boolean bl = typeDeclaration.staticInitializerScope.insideTypeAnnotation;
            try {
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = true;
                ASTNode.resolveDeprecatedAnnotations(typeDeclaration.staticInitializerScope, typeDeclaration.annotations, this);
                this.tagBits |= 0x400000000L;
                Object var4_3 = null;
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                typeDeclaration.staticInitializerScope.insideTypeAnnotation = bl;
                throw throwable;
            }
            if ((this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
            }
        }
    }

    void initializeForStaticImports() {
        if (this.scope == null) {
            return;
        }
        if (this.superInterfaces == null) {
            this.scope.connectTypeHierarchy();
        }
        this.scope.buildFields();
        this.scope.buildMethods();
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: {
                int n;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                if (!((typeBinding.tagBits & 0x40000000L) != 0L || this.isMemberType() && typeBinding.isMemberType())) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                if (this != parameterizedTypeBinding.genericType()) {
                    return false;
                }
                if (!this.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding.enclosingType())) {
                        return false;
                    }
                }
                int n2 = this.typeVariables == null ? 0 : this.typeVariables.length;
                typeBindingArray = parameterizedTypeBinding.arguments;
                int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n != n2) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    if (this.typeVariables[i].isTypeArgumentContainedBy(typeBindingArray[i])) continue;
                    return false;
                }
                return true;
            }
            case 1028: {
                return typeBinding.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    public boolean isHierarchyConnected() {
        return (this.tagBits & 0x200L) != 0L;
    }

    public ReferenceBinding[] memberTypes() {
        return this.memberTypes;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodBinding[] methods() {
        block40: {
            int n;
            if ((this.tagBits & 0x8000L) != 0L) {
                return this.methods;
            }
            if ((this.tagBits & 0x4000L) == 0L) {
                n = this.methods.length;
                if (n > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, n);
                }
                this.tagBits |= 0x4000L;
            }
            n = 0;
            MethodBinding[] methodBindingArray = this.methods;
            try {
                int n2;
                int n3 = this.methods.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.resolveTypesFor(this.methods[n2]) != null) continue;
                    if (methodBindingArray == this.methods) {
                        methodBindingArray = new MethodBinding[n3];
                        System.arraycopy(this.methods, 0, methodBindingArray, 0, n3);
                    }
                    methodBindingArray[n2] = null;
                    ++n;
                }
                n2 = this.scope.compilerOptions().sourceLevel >= 0x310000L ? 1 : 0;
                n3 = this.scope.compilerOptions().complianceLevel == 0x320000L ? 1 : 0;
                int n4 = this.methods.length;
                for (int i = 0; i < n4; ++i) {
                    int n5 = 1;
                    MethodBinding methodBinding = methodBindingArray[i];
                    if (methodBinding == null) continue;
                    char[] cArray = methodBinding.selector;
                    AbstractMethodDeclaration abstractMethodDeclaration = null;
                    for (int j = i + 1; j < n4; ++j) {
                        AbstractMethodDeclaration abstractMethodDeclaration2;
                        boolean bl;
                        int n6;
                        MethodBinding methodBinding2 = methodBindingArray[j];
                        if (methodBinding2 == null) continue;
                        if (!CharOperation.equals(cArray, methodBinding2.selector)) break;
                        if (n2 != 0) {
                            if (!methodBinding.areParameterErasuresEqual(methodBinding2)) continue;
                            if (n3 != 0 && methodBinding.returnType != null && methodBinding2.returnType != null && methodBinding.returnType.erasure() != methodBinding2.returnType.erasure()) {
                                boolean bl2;
                                MethodBinding methodBinding3;
                                TypeBinding[] typeBindingArray = methodBinding.parameters;
                                TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
                                n6 = typeBindingArray.length;
                                TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
                                TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
                                boolean bl3 = typeVariableBindingArray == typeVariableBindingArray2;
                                MethodBinding methodBinding4 = methodBinding2;
                                if (!bl3 && (methodBinding3 = methodBinding.computeSubstitutedMethod(methodBinding2, this.scope.environment())) != null) {
                                    bl3 = true;
                                    methodBinding4 = methodBinding3;
                                }
                                if (!(bl2 = methodBinding.areParametersEqual(methodBinding4)) || !bl3) {
                                    if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES && typeVariableBindingArray2 != Binding.NO_TYPE_VARIABLES) {
                                        n5 = 0;
                                    } else if (n6 > 0) {
                                        int n7 = n6;
                                        while (--n7 >= 0 && typeBindingArray[n7] == typeBindingArray2[n7].erasure()) {
                                            TypeBinding typeBinding;
                                            if (typeBindingArray[n7] != typeBindingArray2[n7] || !((typeBinding = typeBindingArray[n7].leafComponentType()) instanceof SourceTypeBinding) || typeBinding.typeVariables() == Binding.NO_TYPE_VARIABLES) continue;
                                            n7 = n6;
                                            break;
                                        }
                                        if (n7 >= 0 && n7 < n6) {
                                            n7 = n6;
                                            while (--n7 >= 0 && typeBindingArray[n7].erasure() == typeBindingArray2[n7]) {
                                            }
                                        }
                                        if (n7 >= 0) {
                                            n5 = 0;
                                        }
                                    } else if (n6 != 0) {
                                        n5 = 0;
                                    }
                                }
                            }
                        } else if (!methodBinding.areParametersEqual(methodBinding2)) continue;
                        boolean bl4 = this.isEnum() && (CharOperation.equals(cArray, TypeConstants.VALUEOF) || CharOperation.equals(cArray, TypeConstants.VALUES));
                        boolean bl5 = bl = n5 == 1;
                        if (abstractMethodDeclaration == null && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null && abstractMethodDeclaration.binding != null) {
                            int n8 = n6 = methodBinding.returnType == null && methodBinding2.returnType != null ? 1 : 0;
                            if (bl4) {
                                this.scope.problemReporter().duplicateEnumSpecialMethod(this, abstractMethodDeclaration);
                                n6 = 1;
                            } else {
                                this.scope.problemReporter().duplicateMethodInType(this, abstractMethodDeclaration, methodBinding.areParametersEqual(methodBinding2), n5);
                            }
                            if (n6 != 0) {
                                bl = false;
                                abstractMethodDeclaration.binding = null;
                                if (methodBindingArray == this.methods) {
                                    methodBindingArray = new MethodBinding[n4];
                                    System.arraycopy(this.methods, 0, methodBindingArray, 0, n4);
                                }
                                methodBindingArray[i] = null;
                                ++n;
                            }
                        }
                        if ((abstractMethodDeclaration2 = methodBinding2.sourceMethod()) == null || abstractMethodDeclaration2.binding == null) continue;
                        if (bl4) {
                            this.scope.problemReporter().duplicateEnumSpecialMethod(this, abstractMethodDeclaration2);
                            bl = true;
                        } else {
                            this.scope.problemReporter().duplicateMethodInType(this, abstractMethodDeclaration2, methodBinding.areParametersEqual(methodBinding2), n5);
                        }
                        if (!bl) continue;
                        abstractMethodDeclaration2.binding = null;
                        if (methodBindingArray == this.methods) {
                            methodBindingArray = new MethodBinding[n4];
                            System.arraycopy(this.methods, 0, methodBindingArray, 0, n4);
                        }
                        methodBindingArray[j] = null;
                        ++n;
                    }
                    if (methodBinding.returnType != null || methodBindingArray[i] == null) continue;
                    abstractMethodDeclaration = methodBinding.sourceMethod();
                    if (abstractMethodDeclaration != null) {
                        abstractMethodDeclaration.binding = null;
                    }
                    if (methodBindingArray == this.methods) {
                        methodBindingArray = new MethodBinding[n4];
                        System.arraycopy(this.methods, 0, methodBindingArray, 0, n4);
                    }
                    methodBindingArray[i] = null;
                    ++n;
                }
                Object var24_27 = null;
                if (n <= 0) break block40;
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                if (n > 0) {
                    int n9 = methodBindingArray.length - n;
                    if (n9 == 0) {
                        this.methods = Binding.NO_METHODS;
                    } else {
                        MethodBinding[] methodBindingArray2 = new MethodBinding[n9];
                        int n10 = 0;
                        int n11 = methodBindingArray.length;
                        for (int i = 0; i < n11; ++i) {
                            if (methodBindingArray[i] == null) continue;
                            methodBindingArray2[n10++] = methodBindingArray[i];
                        }
                        this.methods = methodBindingArray2;
                    }
                }
                this.addDefaultAbstractMethods();
                this.tagBits |= 0x8000L;
                throw throwable;
            }
            int n12 = methodBindingArray.length - n;
            if (n12 == 0) {
                this.methods = Binding.NO_METHODS;
            } else {
                MethodBinding[] methodBindingArray3 = new MethodBinding[n12];
                int n13 = 0;
                int n14 = methodBindingArray.length;
                for (int i = 0; i < n14; ++i) {
                    if (methodBindingArray[i] == null) continue;
                    methodBindingArray3[n13++] = methodBindingArray[i];
                }
                this.methods = methodBindingArray3;
            }
        }
        this.addDefaultAbstractMethods();
        this.tagBits |= 0x8000L;
        {
        }
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldBinding resolveTypeFor(FieldBinding fieldBinding) {
        FieldDeclaration[] fieldDeclarationArray;
        if ((fieldBinding.modifiers & 0x2000000) == 0) {
            return fieldBinding;
        }
        if (this.scope.compilerOptions().sourceLevel >= 0x310000L && (fieldBinding.getAnnotationTagBits() & 0x400000000000L) != 0L) {
            fieldBinding.modifiers |= 0x100000;
        }
        if (this.isViewedAsDeprecated() && !fieldBinding.isDeprecated()) {
            fieldBinding.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            fieldBinding.modifiers |= 0x40000;
        }
        int n = (fieldDeclarationArray = this.scope.referenceContext.fields) == null ? 0 : fieldDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding;
            TypeBinding typeBinding2;
            FieldBinding fieldBinding2;
            block14: {
                FieldDeclaration fieldDeclaration;
                block13: {
                    block12: {
                        if (fieldDeclarationArray[i].binding != fieldBinding) continue;
                        MethodScope methodScope = fieldBinding.isStatic() ? this.scope.referenceContext.staticInitializerScope : this.scope.referenceContext.initializerScope;
                        fieldBinding2 = methodScope.initializedField;
                        try {
                            methodScope.initializedField = fieldBinding;
                            fieldDeclaration = fieldDeclarationArray[i];
                            fieldBinding.type = typeBinding2 = fieldDeclaration.getKind() == 3 ? methodScope.environment().convertToRawType(this, false) : fieldDeclaration.type.resolveType(methodScope, true);
                            fieldBinding.modifiers &= 0xFDFFFFFF;
                            if (typeBinding2 != null) break block12;
                            fieldDeclaration.binding = null;
                            FieldBinding fieldBinding3 = null;
                            Object var11_13 = null;
                            methodScope.initializedField = fieldBinding2;
                            return fieldBinding3;
                        }
                        catch (Throwable throwable) {
                            Object var11_17 = null;
                            methodScope.initializedField = fieldBinding2;
                            throw throwable;
                        }
                    }
                    if (typeBinding2 != TypeBinding.VOID) break block13;
                    this.scope.problemReporter().variableTypeCannotBeVoid(fieldDeclaration);
                    fieldDeclaration.binding = null;
                    FieldBinding fieldBinding4 = null;
                    Object var11_14 = null;
                    methodScope.initializedField = fieldBinding2;
                    return fieldBinding4;
                }
                if (!typeBinding2.isArrayType() || ((ArrayBinding)typeBinding2).leafComponentType != TypeBinding.VOID) break block14;
                this.scope.problemReporter().variableTypeCannotBeVoidArray(fieldDeclaration);
                fieldDeclaration.binding = null;
                FieldBinding fieldBinding5 = null;
                Object var11_15 = null;
                methodScope.initializedField = fieldBinding2;
                return fieldBinding5;
            }
            if ((typeBinding2.tagBits & 0x80L) != 0L) {
                fieldBinding.tagBits |= 0x80L;
            }
            if ((typeBinding = typeBinding2.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding).modifiers & 0x40000000) != 0) {
                fieldBinding.modifiers |= 0x40000000;
            }
            Object var11_16 = null;
            methodScope.initializedField = fieldBinding2;
            return fieldBinding;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodBinding resolveTypesFor(MethodBinding methodBinding) {
        Object object;
        int n;
        TypeBinding[] typeBindingArray;
        Object object2;
        int n2;
        int n3;
        TypeReference[] typeReferenceArray;
        int n4;
        AbstractMethodDeclaration abstractMethodDeclaration;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return methodBinding;
        }
        if (this.scope.compilerOptions().sourceLevel >= 0x310000L && (methodBinding.getAnnotationTagBits() & 0x400000000000L) != 0L) {
            methodBinding.modifiers |= 0x100000;
        }
        if (this.isViewedAsDeprecated() && !methodBinding.isDeprecated()) {
            methodBinding.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            methodBinding.modifiers |= 0x40000;
        }
        if ((abstractMethodDeclaration = methodBinding.sourceMethod()) == null) {
            return null;
        }
        TypeParameter[] typeParameterArray = abstractMethodDeclaration.typeParameters();
        if (typeParameterArray != null) {
            abstractMethodDeclaration.scope.connectTypeVariables(typeParameterArray, true);
            n4 = typeParameterArray.length;
            for (int i = 0; i < n4; ++i) {
                typeParameterArray[i].checkBounds(abstractMethodDeclaration.scope);
            }
        }
        if ((typeReferenceArray = abstractMethodDeclaration.thrownExceptions) != null) {
            n4 = typeReferenceArray.length;
            methodBinding.thrownExceptions = new ReferenceBinding[n4];
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                object2 = (ReferenceBinding)typeReferenceArray[n2].resolveType(abstractMethodDeclaration.scope, true);
                if (object2 == null) continue;
                if (((TypeBinding)object2).isBoundParameterizedType()) {
                    abstractMethodDeclaration.scope.problemReporter().invalidParameterizedExceptionType((TypeBinding)object2, typeReferenceArray[n2]);
                    continue;
                }
                if (((TypeBinding)object2).findSuperTypeOriginatingFrom(21, true) == null && ((Binding)object2).isValidBinding()) {
                    abstractMethodDeclaration.scope.problemReporter().cannotThrowType(typeReferenceArray[n2], (TypeBinding)object2);
                    continue;
                }
                if ((((ReferenceBinding)object2).tagBits & 0x80L) != 0L) {
                    methodBinding.tagBits |= 0x80L;
                }
                methodBinding.modifiers |= ((ReferenceBinding)object2).modifiers & 0x40000000;
                methodBinding.thrownExceptions[n3++] = object2;
            }
            if (n3 < n4) {
                methodBinding.thrownExceptions = new ReferenceBinding[n3];
                System.arraycopy(methodBinding.thrownExceptions, 0, methodBinding.thrownExceptions, 0, n3);
            }
        }
        n4 = this.scope.compilerOptions().reportUnavoidableGenericTypeProblems ? 1 : 0;
        n3 = 0;
        object2 = abstractMethodDeclaration.arguments;
        if (object2 != null) {
            n2 = ((Argument[])object2).length;
            methodBinding.parameters = Binding.NO_PARAMETERS;
            typeBindingArray = new TypeBinding[n2];
            for (n = 0; n < n2; ++n) {
                TypeBinding typeBinding;
                Object var15_19;
                TypeBinding typeBinding2;
                boolean bl;
                object = object2[n];
                if (((Argument)object).annotations != null) {
                    methodBinding.tagBits |= 0x400L;
                }
                boolean bl2 = bl = n4 == 0 && !methodBinding.isConstructor() && (((Argument)object).type.bits & 0x40000000) == 0;
                if (bl) {
                    ((Argument)object).type.bits |= 0x40000000;
                }
                try {
                    typeBinding2 = ((Argument)object).type.resolveType(abstractMethodDeclaration.scope, true);
                    var15_19 = null;
                    if (bl) {
                        ((Argument)object).type.bits &= 0xBFFFFFFF;
                    }
                }
                catch (Throwable throwable) {
                    var15_19 = null;
                    if (bl) {
                        ((Argument)object).type.bits &= 0xBFFFFFFF;
                    }
                    throw throwable;
                }
                if (typeBinding2 == null) {
                    n3 = 1;
                    continue;
                }
                if (typeBinding2 == TypeBinding.VOID) {
                    abstractMethodDeclaration.scope.problemReporter().argumentTypeCannotBeVoid(this, abstractMethodDeclaration, (Argument)object);
                    n3 = 1;
                    continue;
                }
                if ((typeBinding2.tagBits & 0x80L) != 0L) {
                    methodBinding.tagBits |= 0x80L;
                }
                if ((typeBinding = typeBinding2.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding).modifiers & 0x40000000) != 0) {
                    methodBinding.modifiers |= 0x40000000;
                }
                typeBindingArray[n] = typeBinding2;
                ((Argument)object).binding = new LocalVariableBinding((LocalDeclaration)object, typeBinding2, ((Argument)object).modifiers, true);
            }
            if (n3 == 0) {
                methodBinding.parameters = typeBindingArray;
            }
        }
        if (this.scope.compilerOptions().sourceLevel >= 0x330000L) {
            if ((methodBinding.tagBits & 0x8000000000000L) != 0L) {
                if (!methodBinding.isVarargs()) {
                    abstractMethodDeclaration.scope.problemReporter().safeVarargsOnFixedArityMethod(methodBinding);
                } else if (!(methodBinding.isStatic() || methodBinding.isFinal() || methodBinding.isConstructor())) {
                    abstractMethodDeclaration.scope.problemReporter().safeVarargsOnNonFinalInstanceMethod(methodBinding);
                }
            } else if (methodBinding.parameters != null && methodBinding.parameters.length > 0 && methodBinding.isVarargs() && !methodBinding.parameters[methodBinding.parameters.length - 1].isReifiable()) {
                abstractMethodDeclaration.scope.problemReporter().possibleHeapPollutionFromVararg(abstractMethodDeclaration.arguments[abstractMethodDeclaration.arguments.length - 1]);
            }
        }
        n2 = 0;
        if (!methodBinding.isConstructor()) {
            TypeBinding[] typeBindingArray2 = typeBindingArray = abstractMethodDeclaration instanceof MethodDeclaration ? ((MethodDeclaration)abstractMethodDeclaration).returnType : null;
            if (typeBindingArray == null) {
                abstractMethodDeclaration.scope.problemReporter().missingReturnType(abstractMethodDeclaration);
                methodBinding.returnType = null;
                n2 = 1;
            } else {
                int n5 = n = n4 == 0 && (typeBindingArray.bits & 0x40000000) == 0 ? 1 : 0;
                if (n != 0) {
                    typeBindingArray.bits |= 0x40000000;
                }
                try {
                    object = typeBindingArray.resolveType(abstractMethodDeclaration.scope, true);
                    Object var17_20 = null;
                    if (n != 0) {
                        typeBindingArray.bits &= 0xBFFFFFFF;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    if (n != 0) {
                        typeBindingArray.bits &= 0xBFFFFFFF;
                    }
                    throw throwable;
                }
                if (object == null) {
                    n2 = 1;
                } else if (((TypeBinding)object).isArrayType() && ((ArrayBinding)object).leafComponentType == TypeBinding.VOID) {
                    abstractMethodDeclaration.scope.problemReporter().returnTypeCannotBeVoidArray((MethodDeclaration)abstractMethodDeclaration);
                    n2 = 1;
                } else {
                    if ((((TypeBinding)object).tagBits & 0x80L) != 0L) {
                        methodBinding.tagBits |= 0x80L;
                    }
                    methodBinding.returnType = object;
                    TypeBinding typeBinding = ((TypeBinding)object).leafComponentType();
                    if (typeBinding instanceof ReferenceBinding && (((ReferenceBinding)typeBinding).modifiers & 0x40000000) != 0) {
                        methodBinding.modifiers |= 0x40000000;
                    }
                }
            }
        }
        if (n3 != 0) {
            abstractMethodDeclaration.binding = null;
            methodBinding.parameters = Binding.NO_PARAMETERS;
            if (typeParameterArray != null) {
                n = typeParameterArray.length;
                for (int i = 0; i < n; ++i) {
                    typeParameterArray[i].binding = null;
                }
            }
            return null;
        }
        if (n2 != 0) {
            return methodBinding;
        }
        methodBinding.modifiers &= 0xFDFFFFFF;
        return methodBinding;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean bl) {
        if (bl) {
            binding.getAnnotationTagBits();
        }
        return super.retrieveAnnotationHolder(binding, false);
    }

    public void setFields(FieldBinding[] fieldBindingArray) {
        this.fields = fieldBindingArray;
    }

    public void setMethods(MethodBinding[] methodBindingArray) {
        this.methods = methodBindingArray;
    }

    public final int sourceEnd() {
        return this.scope.referenceContext.sourceEnd;
    }

    public final int sourceStart() {
        return this.scope.referenceContext.sourceStart;
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        if (bl && this.storedAnnotations == null && this.scope != null) {
            this.scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            if (!this.scope.environment().globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public ReferenceBinding superclass() {
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public SyntheticMethodBinding[] syntheticMethods() {
        int n;
        if (this.synthetics == null || this.synthetics[0] == null || this.synthetics[0].size() == 0) {
            return null;
        }
        int n2 = 0;
        SyntheticMethodBinding[] syntheticMethodBindingArray = new SyntheticMethodBinding[1];
        Iterator iterator = this.synthetics[0].values().iterator();
        while (iterator.hasNext()) {
            SyntheticMethodBinding[] syntheticMethodBindingArray2 = (SyntheticMethodBinding[])iterator.next();
            n = syntheticMethodBindingArray2.length;
            for (int i = 0; i < n; ++i) {
                if (syntheticMethodBindingArray2[i] == null) continue;
                if (n2 + 1 > syntheticMethodBindingArray.length) {
                    SyntheticMethodBinding[] syntheticMethodBindingArray3 = syntheticMethodBindingArray;
                    syntheticMethodBindingArray = new SyntheticMethodBinding[n2 + 1];
                    System.arraycopy(syntheticMethodBindingArray3, 0, syntheticMethodBindingArray, 0, n2);
                }
                syntheticMethodBindingArray[n2++] = syntheticMethodBindingArray2[i];
            }
        }
        int n3 = syntheticMethodBindingArray.length;
        SyntheticMethodBinding[] syntheticMethodBindingArray4 = new SyntheticMethodBinding[n3];
        for (n = 0; n < n3; ++n) {
            SyntheticMethodBinding syntheticMethodBinding;
            syntheticMethodBindingArray4[syntheticMethodBinding.index] = syntheticMethodBinding = syntheticMethodBindingArray[n];
        }
        return syntheticMethodBindingArray4;
    }

    public FieldBinding[] syntheticFields() {
        SyntheticFieldBinding syntheticFieldBinding;
        int n;
        Iterator iterator;
        int n2;
        if (this.synthetics == null) {
            return null;
        }
        int n3 = this.synthetics[1] == null ? 0 : this.synthetics[1].size();
        int n4 = n3 + (n2 = this.synthetics[2] == null ? 0 : this.synthetics[2].size());
        if (n4 == 0) {
            return null;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n4];
        if (this.synthetics[1] != null) {
            iterator = this.synthetics[1].values().iterator();
            for (n = 0; n < n3; ++n) {
                syntheticFieldBinding = (SyntheticFieldBinding)iterator.next();
                fieldBindingArray[syntheticFieldBinding.index] = syntheticFieldBinding;
            }
        }
        if (this.synthetics[2] != null) {
            iterator = this.synthetics[2].values().iterator();
            for (n = 0; n < n2; ++n) {
                syntheticFieldBinding = (SyntheticFieldBinding)iterator.next();
                fieldBindingArray[n3 + syntheticFieldBinding.index] = syntheticFieldBinding;
            }
        }
        return fieldBindingArray;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            stringBuffer.append("NoId");
        } else {
            stringBuffer.append(this.id);
        }
        stringBuffer.append(")\n");
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            stringBuffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append("<");
            n2 = this.typeVariables.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (this.typeVariables[n] == null) {
                    stringBuffer.append("NULL TYPE VARIABLE");
                    continue;
                }
                char[] cArray = this.typeVariables[n].toString().toCharArray();
                stringBuffer.append(cArray, 1, cArray.length - 2);
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                stringBuffer.append("\n\timplements : ");
                n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n] != null ? this.superInterfaces[n].debugName() : "NULL TYPE");
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType() != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                stringBuffer.append("\n/*   fields   */");
                n2 = this.fields.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('\n').append(this.fields[n] != null ? this.fields[n].toString() : "NULL FIELD");
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                stringBuffer.append("\n/*   methods   */");
                n2 = this.methods.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('\n').append(this.methods[n] != null ? this.methods[n].toString() : "NULL METHOD");
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                stringBuffer.append("\n/*   members   */");
                n2 = this.memberTypes.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append('\n').append(this.memberTypes[n] != null ? this.memberTypes[n].toString() : "NULL TYPE");
                }
            }
        } else {
            stringBuffer.append("NULL MEMBER TYPES");
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables != null ? this.typeVariables : Binding.NO_TYPE_VARIABLES;
    }

    void verifyMethods(MethodVerifier methodVerifier) {
        methodVerifier.verify(this);
        int n = this.memberTypes.length;
        while (--n >= 0) {
            ((SourceTypeBinding)this.memberTypes[n]).verifyMethods(methodVerifier);
        }
    }

    public FieldBinding[] unResolvedFields() {
        return this.fields;
    }

    public void tagIndirectlyAccessibleMembers() {
        int n;
        for (n = 0; n < this.fields.length; ++n) {
            if (this.fields[n].isPrivate()) continue;
            this.fields[n].modifiers |= 0x8000000;
        }
        for (n = 0; n < this.memberTypes.length; ++n) {
            if (this.memberTypes[n].isPrivate()) continue;
            this.memberTypes[n].modifiers |= 0x8000000;
        }
        if (this.superclass.isPrivate() && this.superclass instanceof SourceTypeBinding) {
            ((SourceTypeBinding)this.superclass).tagIndirectlyAccessibleMembers();
        }
    }
}

