/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.IElementInfo;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public abstract class ElementImpl
implements Element,
IElementInfo {
    public final BaseProcessingEnvImpl _env;
    public final Binding _binding;

    protected ElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, Binding binding) {
        this._env = baseProcessingEnvImpl;
        this._binding = binding;
    }

    @Override
    public TypeMirror asType() {
        return this._env.getFactory().newTypeMirror(this._binding);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        AnnotationBinding[] annotationBindingArray = this.getAnnotationBindings();
        if (annotationBindingArray == null || annotationBindingArray.length == 0 || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        if (string == null) {
            return null;
        }
        string = string.replace('$', '.');
        for (AnnotationBinding annotationBinding : annotationBindingArray) {
            char[] cArray;
            ReferenceBinding referenceBinding;
            if (annotationBinding == null || (referenceBinding = annotationBinding.getAnnotationType()) == null || !referenceBinding.isAnnotationType()) continue;
            if (referenceBinding.isMemberType()) {
                cArray = CharOperation.concatWith(referenceBinding.enclosingType().compoundName, referenceBinding.sourceName, '.');
                CharOperation.replace(cArray, '$', '.');
            } else {
                cArray = CharOperation.concatWith(referenceBinding.compoundName, '.');
            }
            if (!string.equals(new String(cArray))) continue;
            AnnotationMirrorImpl annotationMirrorImpl = (AnnotationMirrorImpl)this._env.getFactory().newAnnotationMirror(annotationBinding);
            return (A)((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)annotationMirrorImpl));
        }
        return null;
    }

    protected abstract AnnotationBinding[] getAnnotationBindings();

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return this._env.getFactory().getAnnotationMirrors(this.getAnnotationBindings());
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public Name getSimpleName() {
        return new NameImpl(this._binding.shortReadableName());
    }

    @Override
    public int hashCode() {
        return this._binding.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ElementImpl elementImpl = (ElementImpl)object;
        return !(this._binding == null ? elementImpl._binding != null : this._binding != elementImpl._binding);
    }

    public String toString() {
        return this._binding.toString();
    }

    @Override
    public String getFileName() {
        return null;
    }

    abstract PackageElement getPackage();

    public boolean hides(Element element) {
        return false;
    }
}

