/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.DeclaredTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.NoTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PrimitiveTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.WildcardTypeImpl;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypesImpl
implements Types {
    private final BaseProcessingEnvImpl _env;

    public TypesImpl(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
    }

    @Override
    public Element asElement(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: 
            case TYPEVAR: {
                return this._env.getFactory().newElement(((TypeMirrorImpl)typeMirror).binding());
            }
        }
        return null;
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        ElementImpl elementImpl = (ElementImpl)element;
        DeclaredTypeImpl declaredTypeImpl = (DeclaredTypeImpl)declaredType;
        ReferenceBinding referenceBinding = (ReferenceBinding)declaredTypeImpl._binding;
        switch (element.getKind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                MethodBinding methodBinding = (MethodBinding)elementImpl._binding;
                if (methodBinding.declaringClass != referenceBinding) {
                    throw new IllegalArgumentException("element is not valid for the containing declared type");
                }
                for (MethodBinding methodBinding2 : referenceBinding.methods()) {
                    if (!CharOperation.equals(methodBinding2.selector, methodBinding.selector) || !methodBinding2.areParameterErasuresEqual(methodBinding)) continue;
                    return this._env.getFactory().newTypeMirror(methodBinding2);
                }
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                FieldBinding fieldBinding = (FieldBinding)elementImpl._binding;
                if (fieldBinding.declaringClass != referenceBinding) {
                    throw new IllegalArgumentException("element is not valid for the containing declared type");
                }
                for (FieldBinding fieldBinding2 : referenceBinding.fields()) {
                    if (!CharOperation.equals(fieldBinding2.name, fieldBinding.name)) continue;
                    return this._env.getFactory().newTypeMirror(fieldBinding2);
                }
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: {
                ReferenceBinding referenceBinding2 = (ReferenceBinding)elementImpl._binding;
                if (referenceBinding2.enclosingType() != referenceBinding) {
                    throw new IllegalArgumentException("element is not valid for the containing declared type");
                }
                for (ReferenceBinding referenceBinding3 : referenceBinding.memberTypes()) {
                    if (!CharOperation.equals(referenceBinding3.compoundName, referenceBinding3.compoundName)) continue;
                    return this._env.getFactory().newTypeMirror(referenceBinding3);
                }
                break;
            }
        }
        throw new IllegalArgumentException("element is not valid for the containing declared type: element kind " + (Object)((Object)element.getKind()));
    }

    @Override
    public TypeElement boxedClass(PrimitiveType primitiveType) {
        PrimitiveTypeImpl primitiveTypeImpl = (PrimitiveTypeImpl)primitiveType;
        BaseTypeBinding baseTypeBinding = (BaseTypeBinding)primitiveTypeImpl._binding;
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType(baseTypeBinding);
        return (TypeElement)this._env.getFactory().newElement(typeBinding);
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        throw new UnsupportedOperationException("NYI: TypesImpl.capture(...)");
    }

    @Override
    public boolean contains(TypeMirror typeMirror, TypeMirror typeMirror2) {
        switch (typeMirror.getKind()) {
            case EXECUTABLE: 
            case PACKAGE: {
                throw new IllegalArgumentException("Executable and package are illegal argument for Types.contains(..)");
            }
        }
        switch (typeMirror2.getKind()) {
            case EXECUTABLE: 
            case PACKAGE: {
                throw new IllegalArgumentException("Executable and package are illegal argument for Types.contains(..)");
            }
        }
        throw new UnsupportedOperationException("NYI: TypesImpl.contains(" + typeMirror + ", " + typeMirror2 + ")");
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case EXECUTABLE: 
            case PACKAGE: {
                throw new IllegalArgumentException("Invalid type mirror for directSypertypes");
            }
        }
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        Binding binding = typeMirrorImpl._binding;
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                arrayList.add(this._env.getFactory().newTypeMirror(referenceBinding2));
            }
            for (ReferenceBinding referenceBinding3 : referenceBinding.superInterfaces()) {
                arrayList.add(this._env.getFactory().newTypeMirror(referenceBinding3));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        Binding binding = typeMirrorImpl._binding;
        if (binding instanceof ReferenceBinding) {
            return this._env.getFactory().newTypeMirror(((ReferenceBinding)binding).erasure());
        }
        if (binding instanceof ArrayBinding) {
            TypeBinding typeBinding = (TypeBinding)binding;
            return this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createArrayType(typeBinding.leafComponentType().erasure(), typeBinding.dimensions()));
        }
        return typeMirror;
    }

    @Override
    public ArrayType getArrayType(TypeMirror typeMirror) {
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
        return (ArrayType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createArrayType(typeBinding.leafComponentType(), typeBinding.dimensions() + 1));
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        int n = typeMirrorArray.length;
        TypeElementImpl typeElementImpl = (TypeElementImpl)typeElement;
        ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n2 = typeVariableBindingArray.length;
        if (n == 0) {
            if (referenceBinding.isGenericType()) {
                return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createRawType(referenceBinding, null));
            }
            return (DeclaredType)typeElement.asType();
        }
        if (n != n2) {
            throw new IllegalArgumentException("Number of typeArguments doesn't match the number of formal parameters of typeElem");
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirrorArray[i];
            Binding binding = typeMirrorImpl._binding;
            if (!(binding instanceof TypeBinding)) {
                throw new IllegalArgumentException("Invalid type argument: " + typeMirrorImpl);
            }
            typeBindingArray[i] = (TypeBinding)binding;
        }
        return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createParameterizedType(referenceBinding, typeBindingArray, null));
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType declaredType, TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        int n = typeMirrorArray.length;
        TypeElementImpl typeElementImpl = (TypeElementImpl)typeElement;
        ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n2 = typeVariableBindingArray.length;
        DeclaredTypeImpl declaredTypeImpl = (DeclaredTypeImpl)declaredType;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)declaredTypeImpl._binding;
        if (n == 0) {
            if (referenceBinding.isGenericType()) {
                return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createRawType(referenceBinding, referenceBinding2));
            }
            throw new UnsupportedOperationException("NYI: TypesImpl.getDeclaredType(...) for member types");
        }
        if (n != n2) {
            throw new IllegalArgumentException("Number of typeArguments doesn't match the number of formal parameters of typeElem");
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirrorArray[i];
            Binding binding = typeMirrorImpl._binding;
            if (!(binding instanceof TypeBinding)) {
                throw new IllegalArgumentException("Invalid type for a type arguments : " + typeMirrorImpl);
            }
            typeBindingArray[i] = (TypeBinding)binding;
        }
        return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createParameterizedType(referenceBinding, typeBindingArray, referenceBinding2));
    }

    @Override
    public NoType getNoType(TypeKind typeKind) {
        return this._env.getFactory().getNoType(typeKind);
    }

    @Override
    public NullType getNullType() {
        return this._env.getFactory().getNullType();
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind typeKind) {
        return this._env.getFactory().getPrimitiveType(typeKind);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror != null && typeMirror2 != null) {
            throw new IllegalArgumentException("Extends and super bounds cannot be set at the same time");
        }
        if (typeMirror != null) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
            TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
            return (WildcardType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createWildcard(null, 0, typeBinding, null, 1));
        }
        if (typeMirror2 != null) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror2;
            TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
            return new WildcardTypeImpl(this._env, this._env.getLookupEnvironment().createWildcard(null, 0, typeBinding, null, 2));
        }
        return new WildcardTypeImpl(this._env, this._env.getLookupEnvironment().createWildcard(null, 0, null, null, 0));
    }

    @Override
    public boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            return false;
        }
        Binding binding = ((TypeMirrorImpl)typeMirror).binding();
        Binding binding2 = ((TypeMirrorImpl)typeMirror2).binding();
        if (!(binding instanceof TypeBinding) || !(binding2 instanceof TypeBinding)) {
            throw new IllegalArgumentException();
        }
        if (((TypeBinding)binding).isCompatibleWith((TypeBinding)binding2)) {
            return true;
        }
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType((TypeBinding)binding);
        return null != typeBinding && typeBinding.isCompatibleWith((TypeBinding)binding2);
    }

    @Override
    public boolean isSameType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Binding binding;
        if (typeMirror.getKind() == TypeKind.WILDCARD || typeMirror2.getKind() == TypeKind.WILDCARD) {
            return false;
        }
        if (typeMirror == typeMirror2) {
            return true;
        }
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            return false;
        }
        Binding binding2 = ((TypeMirrorImpl)typeMirror).binding();
        return binding2 == (binding = ((TypeMirrorImpl)typeMirror2).binding());
    }

    @Override
    public boolean isSubsignature(ExecutableType executableType, ExecutableType executableType2) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableTypeImpl)executableType)._binding;
        MethodBinding methodBinding2 = (MethodBinding)((ExecutableTypeImpl)executableType2)._binding;
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        return methodBinding.areParameterErasuresEqual(methodBinding2) && methodBinding.areTypeVariableErasuresEqual(methodBinding2);
    }

    @Override
    public boolean isSubtype(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Binding binding;
        if (typeMirror instanceof NoTypeImpl) {
            if (typeMirror2 instanceof NoTypeImpl) {
                return ((NoTypeImpl)typeMirror).getKind() == ((NoTypeImpl)typeMirror2).getKind();
            }
            return false;
        }
        if (typeMirror2 instanceof NoTypeImpl) {
            return false;
        }
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            return false;
        }
        if (typeMirror == typeMirror2) {
            return true;
        }
        Binding binding2 = ((TypeMirrorImpl)typeMirror).binding();
        if (binding2 == (binding = ((TypeMirrorImpl)typeMirror2).binding())) {
            return true;
        }
        if (!(binding2 instanceof TypeBinding) || !(binding instanceof TypeBinding)) {
            return false;
        }
        if (binding2.kind() == 132 || binding.kind() == 132) {
            if (binding2.kind() != binding.kind()) {
                return false;
            }
            return ((TypeBinding)binding2).isCompatibleWith((TypeBinding)binding);
        }
        return ((TypeBinding)binding2).isCompatibleWith((TypeBinding)binding);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        if (!(((TypeMirrorImpl)typeMirror)._binding instanceof ReferenceBinding)) {
            throw new IllegalArgumentException("Given type mirror cannot be unboxed");
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)((TypeMirrorImpl)typeMirror)._binding;
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType(referenceBinding);
        if (typeBinding.kind() != 132) {
            throw new IllegalArgumentException();
        }
        return (PrimitiveType)this._env.getFactory().newTypeMirror((BaseTypeBinding)typeBinding);
    }
}

