/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public SubRoutineStatement[] subroutines;
    public LocalVariableBinding saveValueVariable;
    public int initStateIndex = -1;

    public ReturnStatement(Expression expression, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.expression = expression;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
            if ((this.expression.implicitConversion & 0x400) != 0) {
                this.expression.checkNPE(blockScope, flowContext, flowInfo);
            }
        }
        this.initStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        FlowContext flowContext2 = flowContext;
        int n = 0;
        boolean bl = false;
        boolean bl2 = this.needValueStore();
        boolean bl3 = true;
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext2.subroutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new SubRoutineStatement[5];
                }
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    bl = false;
                    this.bits |= 0x20000000;
                    break;
                }
                if (subRoutineStatement instanceof TryStatement && ((TryStatement)subRoutineStatement).resources.length > 0) {
                    bl3 = false;
                }
            }
            flowContext2.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext2 instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = flowContext2.associatedNode;
                if (aSTNode instanceof SynchronizedStatement) {
                    this.bits |= 0x40000000;
                    continue;
                }
                if (!(aSTNode instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!bl2) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                bl = true;
                this.initStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
                continue;
            }
            if (!(flowContext2 instanceof InitializationFlowContext)) continue;
            blockScope.problemReporter().cannotReturnInInitializer(this);
            return FlowInfo.DEAD_END;
        } while ((flowContext2 = flowContext2.parent) != null);
        if (this.subroutines != null && n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        if (bl) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if ((this.bits & 0x40000000) == 0 && this.expression != null && this.expression.resolvedType == TypeBinding.BOOLEAN && bl3) {
                this.expression.bits |= 0x10;
            }
        }
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        boolean bl = false;
        if (this.needValueStore()) {
            bl = true;
            this.expression.generateCode(blockScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        if (this.subroutines != null) {
            BaseTypeBinding baseTypeBinding = this.expression == null ? TypeBinding.VOID : this.expression.reusableJSRTarget();
            int n2 = this.subroutines.length;
            for (int i = 0; i < n2; ++i) {
                SubRoutineStatement subRoutineStatement = this.subroutines[i];
                boolean bl2 = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, baseTypeBinding, this.initStateIndex, this.saveValueVariable);
                if (!bl2) continue;
                codeStream.recordPositionsFrom(n, this.sourceStart);
                SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, i, codeStream);
                return;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && !bl) {
            this.expression.generateCode(blockScope, codeStream, true);
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        this.generateReturnBytecode(codeStream);
        if (this.saveValueVariable != null) {
            codeStream.removeVariable(this.saveValueVariable);
        }
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        codeStream.generateReturnBytecode(this.expression);
    }

    public void generateStoreSaveValueIfNecessary(CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
            codeStream.addVariable(this.saveValueVariable);
        }
    }

    private boolean needValueStore() {
        return this.expression != null && (this.expression.constant == Constant.NotAConstant || (this.expression.implicitConversion & 0x200) != 0) && !(this.expression instanceof NullLiteral);
    }

    public boolean needValue() {
        return this.saveValueVariable != null || (this.bits & 0x40000000) != 0 || (this.bits & 0x20000000) == 0;
    }

    public void prepareSaveValueLocation(TryStatement tryStatement) {
        this.saveValueVariable = tryStatement.secretReturnValue;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ReturnStatement.printIndent(n, stringBuffer).append("return ");
        if (this.expression != null) {
            this.expression.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        BaseTypeBinding baseTypeBinding;
        MethodBinding methodBinding;
        MethodScope methodScope = blockScope.methodScope();
        Object object = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (baseTypeBinding = TypeBinding.VOID);
        if (baseTypeBinding == TypeBinding.VOID) {
            if (this.expression == null) {
                return;
            }
            TypeBinding typeBinding = this.expression.resolveType(blockScope);
            if (typeBinding != null) {
                blockScope.problemReporter().attemptToReturnNonVoidExpression(this, typeBinding);
            }
            return;
        }
        if (this.expression == null) {
            if (baseTypeBinding != null) {
                blockScope.problemReporter().shouldReturn(baseTypeBinding, this);
            }
            return;
        }
        this.expression.setExpectedType(baseTypeBinding);
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            return;
        }
        if (typeBinding == TypeBinding.VOID) {
            blockScope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (baseTypeBinding == null) {
            return;
        }
        if (baseTypeBinding != typeBinding) {
            blockScope.compilationUnitScope().recordTypeConversion(baseTypeBinding, typeBinding);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding, baseTypeBinding) || typeBinding.isCompatibleWith(baseTypeBinding)) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            if (typeBinding.needsUncheckedConversion(baseTypeBinding)) {
                blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding, baseTypeBinding);
            }
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, baseTypeBinding, (CastExpression)this.expression);
            }
            return;
        }
        if (this.isBoxingCompatible(typeBinding, baseTypeBinding, this.expression, blockScope)) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, baseTypeBinding, (CastExpression)this.expression);
            }
            return;
        }
        if ((baseTypeBinding.tagBits & 0x80L) == 0L) {
            blockScope.problemReporter().typeMismatchError(typeBinding, baseTypeBinding, this.expression, null);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expression != null) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

