/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;

    public FinallyFlowContext(FlowContext flowContext, ASTNode aSTNode) {
        super(flowContext, aSTNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n;
        for (n = 0; n < this.assignCount; ++n) {
            object = this.finalVariables[n];
            if (object == null) continue;
            boolean bl = false;
            if (object instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)object)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)object, this.finalAssignments[n]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)object)) {
                bl = true;
                blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)object, this.finalAssignments[n]);
            }
            if (!bl) continue;
            FlowContext flowContext = this.parent;
            while (flowContext != null) {
                flowContext.removeFinalAssignmentIfAny(this.finalAssignments[n]);
                flowContext = flowContext.parent;
            }
        }
        if ((this.tagBits & 1) != 0) {
            for (n = 0; n < this.nullCount; ++n) {
                this.parent.recordUsingNullReference(blockScope, this.nullLocals[n], this.nullReferences[n], this.nullCheckTypes[n], flowInfo);
            }
        } else {
            block18: for (n = 0; n < this.nullCount; ++n) {
                object = this.nullReferences[n];
                LocalVariableBinding localVariableBinding = this.nullLocals[n];
                switch (this.nullCheckTypes[n]) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (this.nullCheckTypes[n] == 512) {
                                if ((this.tagBits & 4) != 0) continue block18;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, (ASTNode)object);
                                continue block18;
                            }
                            if ((this.tagBits & 4) != 0) continue block18;
                            blockScope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, (ASTNode)object);
                            continue block18;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                                        continue block18;
                                    }
                                    if ((this.tagBits & 4) != 0) continue block18;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, (ASTNode)object);
                                    continue block18;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                                        continue block18;
                                    }
                                    if ((this.tagBits & 4) != 0) continue block18;
                                    blockScope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, (ASTNode)object);
                                    continue block18;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, (ASTNode)object);
                                    continue block18;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof(localVariableBinding, (ASTNode)object);
                                    continue block18;
                                }
                            }
                            continue block18;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block18;
                        switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                            case 256: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) != 1 || (((Expression)object).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                                break;
                            }
                            case 512: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) != 1 || (((Expression)object).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                                break;
                            }
                        }
                        continue block18;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                            continue block18;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block18;
                        blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                        continue block18;
                    }
                }
            }
        }
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Finally flow context");
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        block64: {
            block66: {
                block65: {
                    if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) break block64;
                    if ((this.tagBits & 1) == 0) break block65;
                    switch (n) {
                        case 256: 
                        case 257: 
                        case 512: 
                        case 513: 
                        case 769: 
                        case 1025: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                if (n == 512) {
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                                    }
                                    if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                        flowInfo.initsWhenFalse().setReachMode(2);
                                    }
                                } else if (n == 256) {
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                                    }
                                    if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                        flowInfo.initsWhenTrue().setReachMode(2);
                                    }
                                }
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                switch (n & 0xFFFFFF00) {
                                    case 256: {
                                        if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        if ((this.tagBits & 4) == 0) {
                                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                        }
                                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                            flowInfo.initsWhenFalse().setReachMode(2);
                                        }
                                        return;
                                    }
                                    case 512: {
                                        if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        if ((this.tagBits & 4) == 0) {
                                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                        }
                                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                            flowInfo.initsWhenTrue().setReachMode(2);
                                        }
                                        return;
                                    }
                                    case 768: {
                                        scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                        return;
                                    }
                                    case 1024: {
                                        scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                                switch (n & 0xFFFFFF00) {
                                    case 256: {
                                        if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    case 512: {
                                        if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            break block66;
                        }
                        case 3: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            break block66;
                        }
                    }
                    break block66;
                }
                switch (n) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (n == 512) {
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                                }
                                if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                }
                            } else {
                                if ((this.tagBits & 4) == 0) {
                                    scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                                }
                                if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                }
                            }
                            return;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (n & 0xFFFFFF00) {
                                case 256: {
                                    if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                    }
                                    if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                        flowInfo.initsWhenFalse().setReachMode(2);
                                    }
                                    return;
                                }
                                case 512: {
                                    if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    if ((this.tagBits & 4) == 0) {
                                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                    }
                                    if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                        flowInfo.initsWhenTrue().setReachMode(2);
                                    }
                                    return;
                                }
                                case 768: {
                                    scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                    return;
                                }
                                case 1024: {
                                    scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                    return;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        switch (n & 0xFFFFFF00) {
                            case 256: {
                                if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                            case 512: {
                                if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        return;
                    }
                }
            }
            if ((this.tagBits & 4) == 0 || n == 3 || (n & 0xFFFFFF00) == 768 || (n & 0xFFFFFF00) == 1024) {
                this.recordNullReference(localVariableBinding, expression, n);
            }
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int n2 = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[n2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[n2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[n2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }
}

