/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    private MethodBinding tiebreakMethod;

    public static MethodBinding computeCompatibleMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, Scope scope, InvocationSite invocationSite) {
        int n;
        Object object;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        TypeBinding[] typeBindingArray2 = invocationSite.genericTypeArguments();
        InferenceContext inferenceContext = null;
        TypeBinding[] typeBindingArray3 = null;
        if (typeBindingArray2 != null) {
            if (typeBindingArray2.length != typeVariableBindingArray.length) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 11);
            }
            parameterizedGenericMethodBinding = scope.environment().createParameterizedGenericMethod(methodBinding, typeBindingArray2);
        } else {
            object = methodBinding.parameters;
            inferenceContext = new InferenceContext(methodBinding);
            parameterizedGenericMethodBinding = ParameterizedGenericMethodBinding.inferFromArgumentTypes(scope, methodBinding, typeBindingArray, object, inferenceContext);
            if (parameterizedGenericMethodBinding == null) {
                return null;
            }
            if (inferenceContext.hasUnresolvedTypeArgument()) {
                if (inferenceContext.isUnchecked) {
                    n = inferenceContext.substitutes.length;
                    typeBindingArray3 = new TypeBinding[n];
                    System.arraycopy(inferenceContext.substitutes, 0, typeBindingArray3, 0, n);
                }
                if (parameterizedGenericMethodBinding.returnType != TypeBinding.VOID) {
                    TypeBinding typeBinding = invocationSite.expectedType();
                    if (typeBinding != null) {
                        inferenceContext.hasExplicitExpectedType = true;
                    } else {
                        typeBinding = scope.getJavaLangObject();
                    }
                    inferenceContext.expectedType = typeBinding;
                }
                if ((parameterizedGenericMethodBinding = parameterizedGenericMethodBinding.inferFromExpectedType(scope, inferenceContext)) == null) {
                    return null;
                }
            }
        }
        object = null;
        object = inferenceContext != null ? new LingeringTypeVariableEliminator(typeVariableBindingArray, inferenceContext.substitutes, scope) : parameterizedGenericMethodBinding;
        int n2 = typeVariableBindingArray.length;
        for (n = 0; n < n2; ++n) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[n];
            TypeBinding typeBinding = parameterizedGenericMethodBinding.typeArguments[n];
            TypeBinding typeBinding2 = Scope.substitute((Substitution)new LingeringTypeVariableEliminator(typeVariableBindingArray, null, scope), typeBinding);
            if (typeBindingArray3 != null && typeBindingArray3[n] == null) continue;
            switch (typeVariableBinding.boundCheck((Substitution)object, typeBinding2)) {
                case 2: {
                    int n3 = typeBindingArray.length;
                    TypeBinding[] typeBindingArray4 = new TypeBinding[n3 + 2];
                    System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, n3);
                    typeBindingArray4[n3] = typeBinding;
                    typeBindingArray4[n3 + 1] = typeVariableBinding;
                    return new ProblemMethodBinding(parameterizedGenericMethodBinding, methodBinding.selector, typeBindingArray4, 10);
                }
                case 1: {
                    parameterizedGenericMethodBinding.tagBits |= 0x100L;
                }
            }
        }
        return parameterizedGenericMethodBinding;
    }

    /*
     * Unable to fully structure code
     */
    private static ParameterizedGenericMethodBinding inferFromArgumentTypes(Scope var0, MethodBinding var1_1, TypeBinding[] var2_2, TypeBinding[] var3_3, InferenceContext var4_4) {
        block12: {
            block11: {
                block14: {
                    block13: {
                        if (!var1_1.isVarargs()) break block11;
                        var5_5 = var3_3.length;
                        var6_7 = var5_5 - 1;
                        var7_9 = var2_2.length;
                        for (var8_11 = 0; var8_11 < var6_7; ++var8_11) {
                            var3_3[var8_11].collectSubstitutes(var0, var2_2[var8_11], var4_4, 1);
                            if (var4_4.status != 1) continue;
                            return null;
                        }
                        if (var6_7 >= var7_9) break block12;
                        var8_12 = var3_3[var6_7];
                        var9_14 = var2_2[var6_7];
                        if (var5_5 != var7_9) break block13;
                        if (var9_14 == TypeBinding.NULL) break block14;
                        switch (var9_14.dimensions()) {
                            case 0: {
                                ** break;
                            }
                            case 1: {
                                if (var9_14.leafComponentType().isBaseType()) ** break;
                                break block14;
                            }
                            default: {
                                break block14;
                            }
                        }
                    }
                    var8_12 = ((ArrayBinding)var8_12).elementsType();
                }
                for (var10_16 = var6_7; var10_16 < var7_9; ++var10_16) {
                    var8_12.collectSubstitutes(var0, var2_2[var10_16], var4_4, 1);
                    if (var4_4.status != 1) continue;
                    return null;
                }
                break block12;
            }
            var5_5 = var3_3.length;
            for (var6_7 = 0; var6_7 < var5_5; ++var6_7) {
                var3_3[var6_7].collectSubstitutes(var0, var2_2[var6_7], var4_4, 1);
                if (var4_4.status != 1) continue;
                return null;
            }
        }
        if (!ParameterizedGenericMethodBinding.resolveSubstituteConstraints(var0, var5_6 = var1_1.typeVariables, var4_4, false)) {
            return null;
        }
        var7_10 = var6_8 = var4_4.substitutes;
        var9_15 = var5_6.length;
        for (var8_11 = 0; var8_11 < var9_15; ++var8_11) {
            if (var6_8[var8_11] == null) {
                if (var7_10 == var6_8) {
                    var7_10 = new TypeBinding[var9_15];
                    System.arraycopy(var6_8, 0, var7_10, 0, var8_11);
                }
                var7_10[var8_11] = var5_6[var8_11];
                continue;
            }
            if (var7_10 == var6_8) continue;
            var7_10[var8_11] = var6_8[var8_11];
        }
        var8_13 = var0.environment().createParameterizedGenericMethod(var1_1, var7_10);
        return var8_13;
    }

    private static boolean resolveSubstituteConstraints(Scope scope, TypeVariableBinding[] typeVariableBindingArray, InferenceContext inferenceContext, boolean bl) {
        Object object;
        TypeBinding[] typeBindingArray;
        TypeBinding typeBinding;
        TypeVariableBinding typeVariableBinding;
        int n;
        TypeBinding[] typeBindingArray2 = inferenceContext.substitutes;
        int n2 = typeVariableBindingArray.length;
        block0: for (n = 0; n < n2; ++n) {
            typeVariableBinding = typeVariableBindingArray[n];
            typeBinding = typeBindingArray2[n];
            if (typeBinding != null || (typeBindingArray = inferenceContext.getSubstitutes(typeVariableBinding, 0)) == null) continue;
            int n3 = typeBindingArray.length;
            for (int i = 0; i < n3; ++i) {
                object = typeBindingArray[i];
                if (object == null) continue;
                if (object == typeVariableBinding) {
                    for (int j = i + 1; j < n3; ++j) {
                        object = typeBindingArray[j];
                        if (object == typeVariableBinding || object == null) continue;
                        typeBindingArray2[n] = object;
                        continue block0;
                    }
                    typeBindingArray2[n] = typeVariableBinding;
                    continue block0;
                }
                typeBindingArray2[n] = object;
                continue block0;
            }
        }
        if (inferenceContext.hasUnresolvedTypeArgument()) {
            for (n = 0; n < n2; ++n) {
                typeVariableBinding = typeVariableBindingArray[n];
                typeBinding = typeBindingArray2[n];
                if (typeBinding != null || (typeBindingArray = inferenceContext.getSubstitutes(typeVariableBinding, 2)) == null) continue;
                TypeBinding typeBinding2 = scope.lowerUpperBound(typeBindingArray);
                if (typeBinding2 == null) {
                    return false;
                }
                if (typeBinding2 == TypeBinding.VOID) continue;
                typeBindingArray2[n] = typeBinding2;
            }
        }
        if (bl && inferenceContext.hasUnresolvedTypeArgument()) {
            for (n = 0; n < n2; ++n) {
                typeVariableBinding = typeVariableBindingArray[n];
                typeBinding = typeBindingArray2[n];
                if (typeBinding != null || (typeBindingArray = inferenceContext.getSubstitutes(typeVariableBinding, 1)) == null) continue;
                TypeBinding[] typeBindingArray3 = Scope.greaterLowerBound(typeBindingArray);
                TypeBinding typeBinding3 = null;
                if (typeBindingArray3 != null) {
                    if (typeBindingArray3.length == 1) {
                        typeBinding3 = typeBindingArray3[0];
                    } else {
                        object = new TypeBinding[typeBindingArray3.length - 1];
                        System.arraycopy(typeBindingArray3, 1, object, 0, typeBindingArray3.length - 1);
                        typeBinding3 = scope.environment().createWildcard(null, 0, typeBindingArray3[0], (TypeBinding[])object, 1);
                    }
                }
                if (typeBinding3 == null) continue;
                typeBindingArray2[n] = typeBinding3;
            }
        }
        return true;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, RawTypeBinding rawTypeBinding, LookupEnvironment lookupEnvironment) {
        int n;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        int n2 = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        for (n = 0; n < n2; ++n) {
            typeBindingArray[n] = lookupEnvironment.convertToRawType(typeVariableBindingArray[n].erasure(), false);
        }
        this.isRaw = true;
        this.tagBits = methodBinding.tagBits;
        this.environment = lookupEnvironment;
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.declaringClass = rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = typeBindingArray;
        this.originalMethod = methodBinding;
        n = rawTypeBinding == null || methodBinding.isStatic() ? 1 : 0;
        this.parameters = Scope.substitute((Substitution)this, n != 0 ? methodBinding.parameters : Scope.substitute((Substitution)rawTypeBinding, methodBinding.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, n != 0 ? methodBinding.thrownExceptions : Scope.substitute((Substitution)rawTypeBinding, methodBinding.thrownExceptions));
        if (this.thrownExceptions == null) {
            this.thrownExceptions = Binding.NO_EXCEPTIONS;
        }
        this.returnType = Scope.substitute((Substitution)this, n != 0 ? methodBinding.returnType : Scope.substitute((Substitution)rawTypeBinding, methodBinding.returnType));
        this.wasInferred = false;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, TypeBinding[] typeBindingArray, LookupEnvironment lookupEnvironment) {
        block6: {
            this.environment = lookupEnvironment;
            this.modifiers = methodBinding.modifiers;
            this.selector = methodBinding.selector;
            this.declaringClass = methodBinding.declaringClass;
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            this.typeArguments = typeBindingArray;
            this.isRaw = false;
            this.tagBits = methodBinding.tagBits;
            this.originalMethod = methodBinding;
            this.parameters = Scope.substitute((Substitution)this, methodBinding.parameters);
            this.returnType = Scope.substitute((Substitution)this, methodBinding.returnType);
            this.thrownExceptions = Scope.substitute((Substitution)this, methodBinding.thrownExceptions);
            if (this.thrownExceptions == null) {
                this.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n;
                    int n2 = this.parameters.length;
                    for (n = 0; n < n2; ++n) {
                        if ((this.parameters[n].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break block6;
                    }
                    n2 = this.thrownExceptions.length;
                    for (n = 0; n < n2; ++n) {
                        if ((this.thrownExceptions[n].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break;
                    }
                }
            }
        }
        this.wasInferred = true;
    }

    public char[] computeUniqueKey(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.originalMethod.computeUniqueKey(false));
        stringBuffer.append('%');
        stringBuffer.append('<');
        if (!this.isRaw) {
            n = this.typeArguments.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding = this.typeArguments[i];
                stringBuffer.append(typeBinding.computeUniqueKey(false));
            }
        }
        stringBuffer.append('>');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    private ParameterizedGenericMethodBinding inferFromExpectedType(Scope scope, InferenceContext inferenceContext) {
        block17: {
            TypeBinding typeBinding;
            int n;
            TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
            int n2 = typeVariableBindingArray.length;
            if (inferenceContext.expectedType != null) {
                this.returnType.collectSubstitutes(scope, inferenceContext.expectedType, inferenceContext, 2);
                if (inferenceContext.status == 1) {
                    return null;
                }
            }
            for (n = 0; n < n2; ++n) {
                boolean bl;
                TypeBinding typeBinding2 = this.typeArguments[n];
                typeBinding = typeVariableBindingArray[n];
                boolean bl2 = bl = typeBinding2 != typeBinding;
                if (typeBinding.firstBound == typeBinding.superclass) {
                    TypeBinding typeBinding3 = Scope.substitute((Substitution)this, typeBinding.superclass);
                    typeBinding2.collectSubstitutes(scope, typeBinding3, inferenceContext, 2);
                    if (inferenceContext.status == 1) {
                        return null;
                    }
                    if (bl) {
                        typeBinding3.collectSubstitutes(scope, typeBinding2, inferenceContext, 1);
                        if (inferenceContext.status == 1) {
                            return null;
                        }
                    }
                }
                int n3 = typeBinding.superInterfaces.length;
                for (int i = 0; i < n3; ++i) {
                    TypeBinding typeBinding4 = Scope.substitute((Substitution)this, typeBinding.superInterfaces[i]);
                    typeBinding2.collectSubstitutes(scope, typeBinding4, inferenceContext, 2);
                    if (inferenceContext.status == 1) {
                        return null;
                    }
                    if (!bl) continue;
                    typeBinding4.collectSubstitutes(scope, typeBinding2, inferenceContext, 1);
                    if (inferenceContext.status != 1) continue;
                    return null;
                }
            }
            if (!ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, typeVariableBindingArray, inferenceContext, true)) {
                return null;
            }
            for (n = 0; n < n2; ++n) {
                typeBinding = inferenceContext.substitutes[n];
                this.typeArguments[n] = typeBinding != null ? typeBinding : (inferenceContext.substitutes[n] = typeVariableBindingArray[n].upperBound());
            }
            this.typeArguments = Scope.substitute((Substitution)this, this.typeArguments);
            TypeBinding typeBinding5 = this.returnType;
            this.returnType = Scope.substitute((Substitution)this, this.returnType);
            this.inferredReturnType = inferenceContext.hasExplicitExpectedType && this.returnType != typeBinding5;
            this.parameters = Scope.substitute((Substitution)this, this.parameters);
            this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
            if (this.thrownExceptions == null) {
                this.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
            if ((this.tagBits & 0x80L) == 0L) {
                if ((this.returnType.tagBits & 0x80L) != 0L) {
                    this.tagBits |= 0x80L;
                } else {
                    int n4;
                    int n5 = this.parameters.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        if ((this.parameters[n4].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break block17;
                    }
                    n5 = this.thrownExceptions.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        if ((this.thrownExceptions[n4].tagBits & 0x80L) == 0L) continue;
                        this.tagBits |= 0x80L;
                        break;
                    }
                }
            }
        }
        return this;
    }

    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
        int n = typeVariableBindingArray.length;
        if (typeVariableBinding.rank < n && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
            return this.typeArguments[typeVariableBinding.rank];
        }
        return typeVariableBinding;
    }

    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            this.tiebreakMethod = this.originalMethod.asRawMethod(this.environment);
        }
        return this.tiebreakMethod;
    }

    private static class LingeringTypeVariableEliminator
    implements Substitution {
        private final TypeVariableBinding[] variables;
        private final TypeBinding[] substitutes;
        private final Scope scope;

        public LingeringTypeVariableEliminator(TypeVariableBinding[] typeVariableBindingArray, TypeBinding[] typeBindingArray, Scope scope) {
            this.variables = typeVariableBindingArray;
            this.substitutes = typeBindingArray;
            this.scope = scope;
        }

        public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
            if (typeVariableBinding.rank >= this.variables.length || this.variables[typeVariableBinding.rank] != typeVariableBinding) {
                return typeVariableBinding;
            }
            if (this.substitutes != null) {
                return Scope.substitute((Substitution)new LingeringTypeVariableEliminator(this.variables, null, this.scope), this.substitutes[typeVariableBinding.rank]);
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)(typeVariableBinding.declaringElement instanceof ReferenceBinding ? typeVariableBinding.declaringElement : null);
            return this.scope.environment().createWildcard(referenceBinding, typeVariableBinding.rank, null, null, 0);
        }

        public LookupEnvironment environment() {
            return this.scope.environment();
        }

        public boolean isRawSubstitution() {
            return false;
        }
    }
}

