/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AptSourceLocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class AnnotationDiscoveryVisitor
extends ASTVisitor {
    final BaseProcessingEnvImpl _env;
    final Factory _factory;
    final ManyToMany<TypeElement, Element> _annoToElement;

    public AnnotationDiscoveryVisitor(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
        this._factory = baseProcessingEnvImpl.getFactory();
        this._annoToElement = new ManyToMany();
    }

    @Override
    public boolean visit(Argument argument, BlockScope blockScope) {
        Annotation[] annotationArray = argument.annotations;
        ReferenceContext referenceContext = blockScope.referenceContext();
        if (referenceContext instanceof AbstractMethodDeclaration) {
            MethodBinding methodBinding = ((AbstractMethodDeclaration)referenceContext).binding;
            if (methodBinding != null) {
                TypeDeclaration typeDeclaration = blockScope.referenceType();
                typeDeclaration.binding.resolveTypesFor(methodBinding);
                if (argument.binding != null) {
                    argument.binding = new AptSourceLocalVariableBinding(argument.binding, methodBinding);
                }
            }
            if (annotationArray != null) {
                this.resolveAnnotations(blockScope, annotationArray, argument.binding);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
        Argument[] argumentArray;
        Annotation[] annotationArray = constructorDeclaration.annotations;
        if (annotationArray != null) {
            argumentArray = constructorDeclaration.binding;
            if (argumentArray == null) {
                return false;
            }
            ((SourceTypeBinding)argumentArray.declaringClass).resolveTypesFor((MethodBinding)argumentArray);
            this.resolveAnnotations(constructorDeclaration.scope, annotationArray, (Binding)argumentArray);
        }
        if ((argumentArray = constructorDeclaration.arguments) != null) {
            int n = argumentArray.length;
            for (int i = 0; i < n; ++i) {
                argumentArray[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        Annotation[] annotationArray = fieldDeclaration.annotations;
        if (annotationArray != null) {
            FieldBinding fieldBinding = fieldDeclaration.binding;
            if (fieldBinding == null) {
                return false;
            }
            ((SourceTypeBinding)fieldBinding.declaringClass).resolveTypeFor(fieldBinding);
            this.resolveAnnotations(methodScope, annotationArray, fieldBinding);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope classScope) {
        Argument[] argumentArray;
        Annotation[] annotationArray = methodDeclaration.annotations;
        if (annotationArray != null) {
            argumentArray = methodDeclaration.binding;
            if (argumentArray == null) {
                return false;
            }
            ((SourceTypeBinding)argumentArray.declaringClass).resolveTypesFor((MethodBinding)argumentArray);
            this.resolveAnnotations(methodDeclaration.scope, annotationArray, methodDeclaration.binding);
        }
        if ((argumentArray = methodDeclaration.arguments) != null) {
            int n = argumentArray.length;
            for (int i = 0; i < n; ++i) {
                argumentArray[i].traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        if (sourceTypeBinding == null) {
            return false;
        }
        Annotation[] annotationArray = typeDeclaration.annotations;
        if (annotationArray != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotationArray, sourceTypeBinding);
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        if (sourceTypeBinding == null) {
            return false;
        }
        Annotation[] annotationArray = typeDeclaration.annotations;
        if (annotationArray != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotationArray, sourceTypeBinding);
        }
        return true;
    }

    private void resolveAnnotations(BlockScope blockScope, Annotation[] annotationArray, Binding binding) {
        ASTNode.resolveAnnotations(blockScope, annotationArray, binding);
        for (Annotation annotation : annotationArray) {
            AnnotationBinding annotationBinding = annotation.getCompilerAnnotation();
            if (annotationBinding == null) continue;
            TypeElement typeElement = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
            Element element = this._factory.newElement(binding);
            this._annoToElement.put(typeElement, element);
        }
    }
}

