/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredLocalVariable
extends RecoveredStatement {
    public RecoveredAnnotation[] annotations;
    public int annotationCount;
    public int modifiers;
    public int modifiersStart;
    public LocalDeclaration localDeclaration;
    boolean alreadyCompletedLocalInitialization;

    public RecoveredLocalVariable(LocalDeclaration localDeclaration, RecoveredElement recoveredElement, int n) {
        super(localDeclaration, recoveredElement, n);
        this.localDeclaration = localDeclaration;
        this.alreadyCompletedLocalInitialization = localDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.alreadyCompletedLocalInitialization || !(statement instanceof Expression)) {
            return super.add(statement, n);
        }
        this.alreadyCompletedLocalInitialization = true;
        this.localDeclaration.initialization = (Expression)statement;
        this.localDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.localDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public void attach(RecoveredAnnotation[] recoveredAnnotationArray, int n, int n2, int n3) {
        if (n > 0) {
            Annotation[] annotationArray = this.localDeclaration.annotations;
            if (annotationArray != null) {
                this.annotations = new RecoveredAnnotation[n];
                this.annotationCount = 0;
                block0: for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < annotationArray.length; ++j) {
                        if (recoveredAnnotationArray[i].annotation == annotationArray[j]) continue block0;
                    }
                    this.annotations[this.annotationCount++] = recoveredAnnotationArray[i];
                }
            } else {
                this.annotations = recoveredAnnotationArray;
                this.annotationCount = n;
            }
        }
        if (n2 != 0) {
            this.modifiers = n2;
            this.modifiersStart = n3;
        }
    }

    public ASTNode parseTree() {
        return this.localDeclaration;
    }

    public int sourceEnd() {
        return this.localDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        return this.tabString(n) + "Recovered local variable:\n" + this.localDeclaration.print(n + 1, new StringBuffer(10));
    }

    public Statement updatedStatement(int n, Set set) {
        if (this.modifiers != 0) {
            this.localDeclaration.modifiers |= this.modifiers;
            if (this.modifiersStart < this.localDeclaration.declarationSourceStart) {
                this.localDeclaration.declarationSourceStart = this.modifiersStart;
            }
        }
        if (this.annotationCount > 0) {
            int n2;
            int n3 = this.localDeclaration.annotations == null ? 0 : this.localDeclaration.annotations.length;
            Annotation[] annotationArray = new Annotation[n3 + this.annotationCount];
            if (n3 > 0) {
                System.arraycopy(this.localDeclaration.annotations, 0, annotationArray, this.annotationCount, n3);
            }
            for (n2 = 0; n2 < this.annotationCount; ++n2) {
                annotationArray[n2] = this.annotations[n2].updatedAnnotationReference();
            }
            this.localDeclaration.annotations = annotationArray;
            n2 = this.annotations[0].annotation.sourceStart;
            if (n2 < this.localDeclaration.declarationSourceStart) {
                this.localDeclaration.declarationSourceStart = n2;
            }
        }
        return this.localDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedLocalInitialization = true;
            }
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.localDeclaration.declarationSourceEnd == 0 && (this.localDeclaration.type instanceof ArrayTypeReference || this.localDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedLocalInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n - 1, n2 - 1);
        return this.parent.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedStatement(0, new HashSet());
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.localDeclaration.declarationSourceEnd == 0) {
            this.localDeclaration.declarationSourceEnd = n2;
            this.localDeclaration.declarationEnd = n2;
        }
    }
}

