/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.InnerInferenceHelper;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MostSpecificExceptionMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFactoryMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public abstract class Scope {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public static final int APPLICABILITY = 1;
    public static final int INVOCATION_TYPE = 2;
    public static final int FULL_INFERENCE = 3;
    public int kind;
    public Scope parent;
    private static Substitutor defaultSubstitutor = new Substitutor();

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding convertEliminatingTypeVariables(TypeBinding originalType, ReferenceBinding genericType, int rank, Set eliminatedVariables) {
        if ((originalType.tagBits & 0x20000000L) != 0L) {
            switch (originalType.kind()) {
                case 68: {
                    ArrayBinding originalArrayType = (ArrayBinding)originalType;
                    TypeBinding originalLeafComponentType = originalArrayType.leafComponentType;
                    TypeBinding substitute = Scope.convertEliminatingTypeVariables(originalLeafComponentType, genericType, rank, eliminatedVariables);
                    if (!TypeBinding.notEquals(substitute, originalLeafComponentType)) break;
                    return originalArrayType.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalArrayType.dimensions());
                }
                case 260: {
                    int length;
                    TypeBinding[] originalArguments;
                    ReferenceBinding originalEnclosing;
                    ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)originalType;
                    ReferenceBinding substitutedEnclosing = originalEnclosing = paramType.enclosingType();
                    if (originalEnclosing != null) {
                        substitutedEnclosing = (ReferenceBinding)Scope.convertEliminatingTypeVariables(originalEnclosing, genericType, rank, eliminatedVariables);
                    }
                    TypeBinding[] substitutedArguments = originalArguments = paramType.arguments;
                    int n = length = originalArguments == null ? 0 : originalArguments.length;
                    for (int i = 0; i < length; ++i) {
                        TypeBinding originalArgument = originalArguments[i];
                        TypeBinding substitutedArgument = Scope.convertEliminatingTypeVariables(originalArgument, paramType.genericType(), i, eliminatedVariables);
                        if (TypeBinding.notEquals(substitutedArgument, originalArgument)) {
                            if (substitutedArguments == originalArguments) {
                                substitutedArguments = new TypeBinding[length];
                                System.arraycopy(originalArguments, 0, substitutedArguments, 0, i);
                            }
                            substitutedArguments[i] = substitutedArgument;
                            continue;
                        }
                        if (substitutedArguments == originalArguments) continue;
                        substitutedArguments[i] = originalArgument;
                    }
                    if (!TypeBinding.notEquals(originalEnclosing, substitutedEnclosing) && originalArguments == substitutedArguments) break;
                    return paramType.environment.createParameterizedType(paramType.genericType(), substitutedArguments, substitutedEnclosing);
                }
                case 4100: {
                    if (genericType == null) break;
                    TypeVariableBinding originalVariable = (TypeVariableBinding)originalType;
                    if (eliminatedVariables != null && eliminatedVariables.contains(originalType)) {
                        return originalVariable.environment.createWildcard(genericType, rank, null, null, 0);
                    }
                    TypeBinding originalUpperBound = originalVariable.upperBound();
                    if (eliminatedVariables == null) {
                        eliminatedVariables = new HashSet<TypeVariableBinding>(2);
                    }
                    eliminatedVariables.add(originalVariable);
                    TypeBinding substitutedUpperBound = Scope.convertEliminatingTypeVariables(originalUpperBound, genericType, rank, eliminatedVariables);
                    eliminatedVariables.remove(originalVariable);
                    return originalVariable.environment.createWildcard(genericType, rank, substitutedUpperBound, null, 1);
                }
                case 1028: {
                    break;
                }
                case 2052: {
                    int length;
                    TypeBinding[] originalArguments;
                    ReferenceBinding originalEnclosing;
                    ReferenceBinding currentType = (ReferenceBinding)originalType;
                    ReferenceBinding substitutedEnclosing = originalEnclosing = currentType.enclosingType();
                    if (originalEnclosing != null) {
                        substitutedEnclosing = (ReferenceBinding)Scope.convertEliminatingTypeVariables(originalEnclosing, genericType, rank, eliminatedVariables);
                    }
                    TypeBinding[] substitutedArguments = originalArguments = currentType.typeVariables();
                    int n = length = originalArguments == null ? 0 : originalArguments.length;
                    for (int i = 0; i < length; ++i) {
                        TypeVariableBinding originalArgument = originalArguments[i];
                        TypeBinding substitutedArgument = Scope.convertEliminatingTypeVariables(originalArgument, currentType, i, eliminatedVariables);
                        if (TypeBinding.notEquals(substitutedArgument, originalArgument)) {
                            if (substitutedArguments == originalArguments) {
                                substitutedArguments = new TypeBinding[length];
                                System.arraycopy(originalArguments, 0, substitutedArguments, 0, i);
                            }
                            substitutedArguments[i] = substitutedArgument;
                            continue;
                        }
                        if (substitutedArguments == originalArguments) continue;
                        substitutedArguments[i] = originalArgument;
                    }
                    if (!TypeBinding.notEquals(originalEnclosing, substitutedEnclosing) && originalArguments == substitutedArguments) break;
                    return originalArguments[0].environment.createParameterizedType(genericType, substitutedArguments, substitutedEnclosing);
                }
                case 516: {
                    TypeBinding originalBound;
                    WildcardBinding wildcard = (WildcardBinding)originalType;
                    TypeBinding substitutedBound = originalBound = wildcard.bound;
                    if (originalBound == null || !TypeBinding.notEquals(substitutedBound = Scope.convertEliminatingTypeVariables(originalBound, genericType, rank, eliminatedVariables), originalBound)) break;
                    return wildcard.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, null, wildcard.boundKind);
                }
                case 8196: {
                    int length;
                    TypeBinding[] originalOtherBounds;
                    TypeBinding originalBound;
                    WildcardBinding intersection = (WildcardBinding)originalType;
                    TypeBinding substitutedBound = originalBound = intersection.bound;
                    if (originalBound != null) {
                        substitutedBound = Scope.convertEliminatingTypeVariables(originalBound, genericType, rank, eliminatedVariables);
                    }
                    TypeBinding[] substitutedOtherBounds = originalOtherBounds = intersection.otherBounds;
                    int n = length = originalOtherBounds == null ? 0 : originalOtherBounds.length;
                    for (int i = 0; i < length; ++i) {
                        TypeBinding originalOtherBound = originalOtherBounds[i];
                        TypeBinding substitutedOtherBound = Scope.convertEliminatingTypeVariables(originalOtherBound, genericType, rank, eliminatedVariables);
                        if (TypeBinding.notEquals(substitutedOtherBound, originalOtherBound)) {
                            if (substitutedOtherBounds == originalOtherBounds) {
                                substitutedOtherBounds = new TypeBinding[length];
                                System.arraycopy(originalOtherBounds, 0, substitutedOtherBounds, 0, i);
                            }
                            substitutedOtherBounds[i] = substitutedOtherBound;
                            continue;
                        }
                        if (substitutedOtherBounds == originalOtherBounds) continue;
                        substitutedOtherBounds[i] = originalOtherBound;
                    }
                    if (!TypeBinding.notEquals(substitutedBound, originalBound) && substitutedOtherBounds == originalOtherBounds) break;
                    return intersection.environment.createWildcard(intersection.genericType, intersection.rank, substitutedBound, substitutedOtherBounds, intersection.boundKind);
                }
            }
        }
        return originalType;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n') {
                        return TypeBinding.BOOLEAN;
                    }
                    if (length != 4 || name[1] != 'y' || name[2] != 't' || name[3] != 'e') break;
                    return TypeBinding.BYTE;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    public static ReferenceBinding[] greaterLowerBound(ReferenceBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        ReferenceBinding[] result = types;
        int removed = 0;
        for (int i = 0; i < length; ++i) {
            ReferenceBinding iType = result[i];
            if (iType == null) continue;
            for (int j = 0; j < length; ++j) {
                ReferenceBinding jType;
                if (i == j || (jType = result[j]) == null || !iType.isCompatibleWith(jType)) continue;
                if (result == types) {
                    ReferenceBinding[] referenceBindingArray = result;
                    result = new ReferenceBinding[length];
                    System.arraycopy(referenceBindingArray, 0, result, 0, length);
                }
                result[j] = null;
                ++removed;
            }
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        ReferenceBinding[] trimmedResult = new ReferenceBinding[length - removed];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            ReferenceBinding iType = result[i];
            if (iType == null) continue;
            trimmedResult[index++] = iType;
        }
        return trimmedResult;
    }

    public static TypeBinding[] greaterLowerBound(TypeBinding[] types, Scope scope, LookupEnvironment environment) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        TypeBinding[] result = types;
        int removed = 0;
        for (int i = 0; i < length; ++i) {
            TypeBinding iType = result[i];
            if (iType == null) continue;
            for (int j = 0; j < length; ++j) {
                ParameterizedTypeBinding narrowType;
                ParameterizedTypeBinding wideType;
                TypeBinding jType;
                if (i == j || (jType = result[j]) == null) continue;
                if (iType.isCompatibleWith(jType, scope)) {
                    if (result == types) {
                        TypeBinding[] typeBindingArray = result;
                        result = new TypeBinding[length];
                        System.arraycopy(typeBindingArray, 0, result, 0, length);
                    }
                    result[j] = null;
                    ++removed;
                    continue;
                }
                if (jType.isCompatibleWith(iType, scope) || !iType.isParameterizedType() || !jType.isParameterizedType()) continue;
                if (iType.original().isCompatibleWith(jType.original(), scope)) {
                    wideType = (ParameterizedTypeBinding)jType;
                    narrowType = (ParameterizedTypeBinding)iType;
                } else {
                    if (!jType.original().isCompatibleWith(iType.original(), scope)) continue;
                    wideType = (ParameterizedTypeBinding)iType;
                    narrowType = (ParameterizedTypeBinding)jType;
                }
                if (wideType.arguments == null || !narrowType.isProperType(false) || !wideType.isProperType(false)) continue;
                int numTypeArgs = wideType.arguments.length;
                TypeBinding[] bounds = new TypeBinding[numTypeArgs];
                for (int k = 0; k < numTypeArgs; ++k) {
                    TypeBinding argument = wideType.arguments[k];
                    bounds[k] = argument.isTypeVariable() ? ((TypeVariableBinding)argument).upperBound() : argument;
                }
                ReferenceBinding wideOriginal = (ReferenceBinding)wideType.original();
                ParameterizedTypeBinding substitutedWideType = environment.createParameterizedType(wideOriginal, bounds, wideOriginal.enclosingType());
                if (narrowType.isCompatibleWith(substitutedWideType, scope)) continue;
                return null;
            }
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        TypeBinding[] trimmedResult = new TypeBinding[length - removed];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            TypeBinding iType = result[i];
            if (iType == null) continue;
            trimmedResult[index++] = iType;
        }
        return trimmedResult;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] originalTypes) {
        return defaultSubstitutor.substitute(substitution, originalTypes);
    }

    public static TypeBinding substitute(Substitution substitution, TypeBinding originalType) {
        return defaultSubstitutor.substitute(substitution, originalType);
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] originalTypes) {
        return defaultSubstitutor.substitute(substitution, originalTypes);
    }

    public TypeBinding boxing(TypeBinding type) {
        if (type.isBaseType() || type.kind() == 65540) {
            return this.environment().computeBoxingType(type);
        }
        return type;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public boolean isLambdaScope() {
        return false;
    }

    public boolean isLambdaSubscope() {
        Scope scope = this;
        while (scope != null) {
            switch (scope.kind) {
                case 1: {
                    break;
                }
                case 2: {
                    return scope.isLambdaScope();
                }
                default: {
                    return false;
                }
            }
            scope = scope.parent;
        }
        return false;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite, int inferenceLevel) {
        return this.computeCompatibleMethod(method, arguments, invocationSite, inferenceLevel, false);
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite, int inferenceLevel, boolean tiebreakingVarargsMethods) {
        TypeBinding[] genericTypeArguments = invocationSite.genericTypeArguments();
        TypeBinding[] parameters = method.parameters;
        TypeVariableBinding[] typeVariables = method.typeVariables;
        if (parameters == arguments && (method.returnType.tagBits & 0x20000000L) == 0L && genericTypeArguments == null && typeVariables == Binding.NO_TYPE_VARIABLES) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        CompilerOptions compilerOptions = this.compilerOptions();
        if (typeVariables != Binding.NO_TYPE_VARIABLES && compilerOptions.sourceLevel >= 0x310000L) {
            TypeBinding[] newArgs = null;
            for (int i = 0; i < argLength; ++i) {
                TypeBinding param;
                TypeBinding typeBinding = param = i < paramLength ? parameters[i] : parameters[paramLength - 1];
                if (arguments[i].isBaseType() == param.isBaseType()) continue;
                if (newArgs == null) {
                    newArgs = new TypeBinding[argLength];
                    System.arraycopy(arguments, 0, newArgs, 0, argLength);
                }
                newArgs[i] = this.environment().computeBoxingType(arguments[i]);
            }
            if (newArgs != null) {
                arguments = newArgs;
            } else {
                TypeBinding[] typeBindingArray = arguments;
                arguments = new TypeBinding[argLength];
                System.arraycopy(typeBindingArray, 0, arguments, 0, argLength);
            }
            method = ParameterizedGenericMethodBinding.computeCompatibleMethod(method, arguments, this, invocationSite, inferenceLevel);
            if (method == null) {
                return null;
            }
            if (!method.isValidBinding()) {
                return method;
            }
        } else if (genericTypeArguments != null && compilerOptions.complianceLevel < 0x330000L) {
            if (method instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)method).wasInferred) {
                    return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 13);
                }
            } else if (!method.isOverriding() || !this.isOverriddenMethodGeneric(method)) {
                return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 11);
            }
        }
        if (tiebreakingVarargsMethods && CompilerOptions.tolerateIllegalAmbiguousVarargsInvocation && compilerOptions.complianceLevel < 0x330000L) {
            tiebreakingVarargsMethods = false;
        }
        if (this.parameterCompatibilityLevel18(method, arguments, tiebreakingVarargsMethods, invocationSite) > -1) {
            if ((method.tagBits & 0x10000000000000L) != 0L) {
                return this.environment().createPolymorphicMethod(method, arguments);
            }
            return method;
        }
        if (genericTypeArguments != null && typeVariables != Binding.NO_TYPE_VARIABLES) {
            return new ProblemMethodBinding(method, method.selector, arguments, 12);
        }
        return null;
    }

    private int parameterCompatibilityLevel18(MethodBinding method, TypeBinding[] arguments, boolean tiebreakingVarargsMethods, InvocationSite site) {
        block7: {
            if (site instanceof Invocation && this.compilerOptions().complianceLevel >= 0x340000L) {
                InferenceContext18 infCtx;
                Invocation invocation = (Invocation)site;
                if (method instanceof ParameterizedGenericMethodBinding && (infCtx = invocation.getInferenceContext((ParameterizedGenericMethodBinding)method)) != null) {
                    if (infCtx.isVarArgs()) {
                        return 2;
                    }
                    return 0;
                }
                Expression[] invocationArguments = invocation.arguments();
                if (invocationArguments != null) {
                    InnerInferenceHelper innerInferenceHelper = invocation.innerInferenceHelper();
                    int argLen = invocationArguments.length;
                    boolean[] isVarArgs = new boolean[]{method.isVarargs() && argLen != method.parameters.length};
                    int level = 0;
                    for (int i = 0; i < argLen; ++i) {
                        TypeBinding argumentType = i < arguments.length ? arguments[i] : null;
                        int nextLevel = this.compatibilityLevel18FromInner(method, innerInferenceHelper, invocationArguments[i], argumentType, argLen, i, isVarArgs);
                        if (nextLevel == -1) {
                            return nextLevel;
                        }
                        if (nextLevel != -2) {
                            level = Math.max(level, nextLevel);
                            continue;
                        }
                        break block7;
                    }
                    return level;
                }
            }
        }
        boolean tolerateInferenceVariables = site instanceof ReferenceExpression && ((ReferenceExpression)site).trialResolution;
        return this.parameterCompatibilityLevel(method, arguments, tiebreakingVarargsMethods, tolerateInferenceVariables);
    }

    private int compatibilityLevel18FromInner(MethodBinding method, InnerInferenceHelper innerInferenceHelper, Expression invocArg, TypeBinding argType, int argLen, int i, boolean[] isVarArgs) {
        int compatible = isVarArgs[0] ? 2 : 0;
        TypeBinding resolvedType = invocArg.resolvedType;
        TypeBinding targetType = InferenceContext18.getParameter(method.parameters, i, isVarArgs[0]);
        if (!isVarArgs[0] && this.shouldTryVarargs(method, resolvedType, targetType)) {
            isVarArgs[0] = true;
            targetType = InferenceContext18.getParameter(method.parameters, i, true);
        }
        if (targetType == null) {
            return -1;
        }
        int level = -2;
        if (invocArg instanceof Invocation && resolvedType != null) {
            MethodBinding updatedMethod;
            Invocation innerPoly = (Invocation)((Object)invocArg);
            level = this.parameterCompatibilityLevel(resolvedType, targetType);
            if (level != -1) {
                if (TypeBinding.notEquals(argType, resolvedType) && innerInferenceHelper != null) {
                    innerInferenceHelper.registerInnerResult(method, resolvedType, argLen, i);
                }
                return Math.max(compatible, level);
            }
            MethodBinding innerBinding = innerPoly.binding(null, false, null);
            if (innerBinding instanceof ParameterizedGenericMethodBinding) {
                TypeBinding[] typeArguments;
                ParameterizedGenericMethodBinding innerParameterized = (ParameterizedGenericMethodBinding)innerBinding;
                InferenceContext18 infCtx18 = innerPoly.getInferenceContext(innerParameterized);
                if (infCtx18 != null && !infCtx18.hasResultFor(targetType)) {
                    invocArg.setExpectedType(targetType);
                    MethodBinding solution = infCtx18.inferInvocationType(innerPoly, innerParameterized);
                    if (solution != null && solution.isValidBinding()) {
                        if (innerPoly.updateBindings(solution, targetType) && innerInferenceHelper != null) {
                            innerInferenceHelper.registerInnerResult(method, invocArg.resolvedType, argLen, i);
                        }
                        if (solution.returnType != null && (level = this.parameterCompatibilityLevel(solution.returnType, targetType)) != -1) {
                            return Math.max(compatible, level);
                        }
                    }
                    invocArg.setExpectedType(null);
                    return -1;
                }
                if (innerPoly instanceof AllocationExpression && (typeArguments = resolvedType.typeArguments()) != null && typeArguments.length == 0) {
                    AllocationExpression alloc = (AllocationExpression)innerPoly;
                    if ((alloc.type.bits & 0x80000) != 0) {
                        if (resolvedType.isCompatibleWith(targetType.erasure(), this)) {
                            return compatible;
                        }
                        return -1;
                    }
                }
            } else if (innerPoly instanceof AllocationExpression && (updatedMethod = innerPoly.binding(targetType, false, null)) != innerBinding && updatedMethod != null) {
                if (updatedMethod.isValidBinding()) {
                    if (updatedMethod.declaringClass.isCompatibleWith(targetType)) {
                        return compatible;
                    }
                    return -1;
                }
                if (updatedMethod.problemId() == 3) {
                    level = -2;
                }
            }
        } else {
            if (invocArg.isPolyExpression()) {
                if (invocArg instanceof ConditionalExpression) {
                    ConditionalExpression ce = (ConditionalExpression)invocArg;
                    int level1 = this.compatibilityLevel18FromInner(method, innerInferenceHelper, ce.valueIfTrue, argType, argLen, i, isVarArgs);
                    if (level1 == -1) {
                        return -1;
                    }
                    int level2 = this.compatibilityLevel18FromInner(method, innerInferenceHelper, ce.valueIfFalse, argType, argLen, i, isVarArgs);
                    if (level2 == -1) {
                        return -1;
                    }
                    return Math.max(level1, level2);
                }
                if (invocArg.isCompatibleWith(targetType, this)) {
                    return 0;
                }
                if (!isVarArgs[0] && method.isVarargs()) {
                    isVarArgs[0] = true;
                    targetType = InferenceContext18.getParameter(method.parameters, i, true);
                    if (targetType != null && invocArg.isCompatibleWith(targetType, this)) {
                        return 2;
                    }
                }
                return -1;
            }
            if (resolvedType != null && resolvedType.isValidBinding()) {
                return this.parameterCompatibilityLevel(resolvedType, targetType);
            }
        }
        return level;
    }

    private boolean shouldTryVarargs(MethodBinding method, TypeBinding resolvedType, TypeBinding targetType) {
        if (!method.isVarargs()) {
            return false;
        }
        if (targetType == null) {
            return true;
        }
        return targetType.isArrayType() && resolvedType != null && !resolvedType.isCompatibleWith(targetType, this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected boolean connectTypeVariables(TypeParameter[] typeParameters, boolean checkForErasedCandidateCollisions) {
        TypeVariableBinding typeVariable;
        if (typeParameters == null || typeParameters.length == 0) {
            return true;
        }
        HashMap invocations = new HashMap(2);
        boolean noProblems = true;
        for (TypeParameter typeParameter : typeParameters) {
            typeVariable = typeParameter.binding;
            if (typeVariable == null) {
                return false;
            }
            typeVariable.setSuperClass(this.getJavaLangObject());
            typeVariable.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            typeVariable.setFirstBound(null);
        }
        int i = 0;
        while (true) {
            block26: {
                block28: {
                    int n;
                    TypeReference[] boundRefs;
                    TypeBinding superType;
                    boolean isFirstBoundTypeVariable;
                    TypeReference typeRef;
                    block29: {
                        int paramLength;
                        block25: {
                            TypeParameter typeParameter;
                            block24: {
                                block27: {
                                    if (i >= paramLength) break block25;
                                    typeParameter = typeParameters[i];
                                    typeVariable = typeParameter.binding;
                                    typeRef = typeParameter.type;
                                    if (typeRef == null) break block26;
                                    isFirstBoundTypeVariable = false;
                                    TypeBinding typeBinding = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false, 256) : typeRef.resolveType((ClassScope)this, 256);
                                    if (superType != null) break block27;
                                    typeVariable.tagBits |= 0x20000L;
                                    break block24;
                                }
                                typeRef.resolvedType = superType;
                                switch (superType.kind()) {
                                    case 68: {
                                        this.problemReporter().boundCannotBeArray(typeRef, superType);
                                        typeVariable.tagBits |= 0x20000L;
                                        break block24;
                                    }
                                    case 4100: {
                                        isFirstBoundTypeVariable = true;
                                        TypeVariableBinding varSuperType = (TypeVariableBinding)superType;
                                        if (varSuperType.rank >= typeVariable.rank && varSuperType.declaringElement == typeVariable.declaringElement && this.compilerOptions().complianceLevel <= 0x320000L) {
                                            this.problemReporter().forwardTypeVariableReference(typeParameter, varSuperType);
                                            typeVariable.tagBits |= 0x20000L;
                                            break block24;
                                        } else {
                                            void var14_16;
                                            if (this.compilerOptions().complianceLevel <= 0x320000L || typeVariable.rank < varSuperType.rank || varSuperType.declaringElement != typeVariable.declaringElement) break;
                                            SimpleSet set = new SimpleSet(typeParameters.length);
                                            set.add(typeVariable);
                                            TypeVariableBinding typeVariableBinding = varSuperType;
                                            while (var14_16 instanceof TypeVariableBinding) {
                                                if (set.includes(var14_16)) {
                                                    this.problemReporter().hierarchyCircularity(typeVariable, (ReferenceBinding)varSuperType, typeRef);
                                                    typeVariable.tagBits |= 0x20000L;
                                                    break block24;
                                                }
                                                set.add(var14_16);
                                                ReferenceBinding referenceBinding = ((TypeVariableBinding)var14_16).superclass;
                                            }
                                            break;
                                        }
                                    }
                                    default: {
                                        if (!((ReferenceBinding)superType).isFinal()) break;
                                        this.problemReporter().finalVariableBound(typeVariable, typeRef);
                                    }
                                }
                                ReferenceBinding superRefType = (ReferenceBinding)superType;
                                if (!superType.isInterface()) {
                                    typeVariable.setSuperClass(superRefType);
                                } else {
                                    typeVariable.setSuperInterfaces(new ReferenceBinding[]{superRefType});
                                }
                                typeVariable.tagBits |= superType.tagBits & 0x800L;
                                typeVariable.setFirstBound(superRefType);
                            }
                            boundRefs = typeParameter.bounds;
                            if (boundRefs == null) break block28;
                            n = boundRefs.length;
                            break block29;
                        }
                        i = 0;
                        while (true) {
                            if (i >= paramLength) {
                                return noProblems;
                            }
                            this.resolveTypeParameter(typeParameters[i]);
                            ++i;
                        }
                    }
                    block8: for (int j = 0; j < n; ++j) {
                        boolean didAlreadyComplain;
                        typeRef = boundRefs[j];
                        TypeBinding typeBinding = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false) : typeRef.resolveType((ClassScope)this);
                        if (superType == null) {
                            typeVariable.tagBits |= 0x20000L;
                            continue;
                        }
                        typeVariable.tagBits |= superType.tagBits & 0x800L;
                        boolean bl = didAlreadyComplain = !typeRef.resolvedType.isValidBinding();
                        if (isFirstBoundTypeVariable && j == 0) {
                            this.problemReporter().noAdditionalBoundAfterTypeVariable(typeRef);
                            typeVariable.tagBits |= 0x20000L;
                            didAlreadyComplain = true;
                        } else {
                            if (superType.isArrayType()) {
                                if (didAlreadyComplain) continue;
                                this.problemReporter().boundCannotBeArray(typeRef, superType);
                                typeVariable.tagBits |= 0x20000L;
                                continue;
                            }
                            if (!superType.isInterface()) {
                                if (didAlreadyComplain) continue;
                                this.problemReporter().boundMustBeAnInterface(typeRef, superType);
                                typeVariable.tagBits |= 0x20000L;
                                continue;
                            }
                        }
                        if (checkForErasedCandidateCollisions && TypeBinding.equalsEquals(typeVariable.firstBound, typeVariable.superclass) && this.hasErasedCandidatesCollisions(superType, typeVariable.superclass, invocations, typeVariable, typeRef)) continue;
                        ReferenceBinding superRefType = (ReferenceBinding)superType;
                        int index = typeVariable.superInterfaces.length;
                        while (--index >= 0) {
                            ReferenceBinding previousInterface = typeVariable.superInterfaces[index];
                            if (TypeBinding.equalsEquals(previousInterface, superRefType)) {
                                this.problemReporter().duplicateBounds(typeRef, superType);
                                typeVariable.tagBits |= 0x20000L;
                                continue block8;
                            }
                            if (!checkForErasedCandidateCollisions || !this.hasErasedCandidatesCollisions(superType, previousInterface, invocations, typeVariable, typeRef)) continue;
                            continue block8;
                        }
                        int size = typeVariable.superInterfaces.length;
                        System.arraycopy(typeVariable.superInterfaces, 0, typeVariable.setSuperInterfaces(new ReferenceBinding[size + 1]), 0, size);
                        typeVariable.superInterfaces[size] = superRefType;
                    }
                }
                noProblems &= (typeVariable.tagBits & 0x20000L) == 0L;
            }
            ++i;
        }
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension) {
        return this.createArrayType(type, dimension, Binding.NO_ANNOTATIONS);
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension, AnnotationBinding[] annotations) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension, annotations);
        }
        return new ArrayBinding(type, dimension, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameters, Binding declaringElement) {
        if (typeParameters == null || typeParameters.length == 0) {
            return Binding.NO_TYPE_VARIABLES;
        }
        PackageBinding unitPackage = this.compilationUnitScope().fPackage;
        int length = typeParameters.length;
        TypeVariableBinding[] typeVariableBindings = new TypeVariableBinding[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            TypeParameter typeParameter = typeParameters[i];
            TypeVariableBinding parameterBinding = new TypeVariableBinding(typeParameter.name, declaringElement, i, this.environment());
            parameterBinding.fPackage = unitPackage;
            typeParameter.binding = parameterBinding;
            if ((typeParameter.bits & 0x100000) != 0) {
                switch (declaringElement.kind()) {
                    case 8: {
                        MethodBinding methodBinding = (MethodBinding)declaringElement;
                        AbstractMethodDeclaration sourceMethod = methodBinding.sourceMethod();
                        if (sourceMethod == null) break;
                        sourceMethod.bits |= 0x100000;
                        break;
                    }
                    case 4: {
                        if (!(declaringElement instanceof SourceTypeBinding)) break;
                        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)declaringElement;
                        TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
                        if (typeDeclaration == null) break;
                        typeDeclaration.bits |= 0x100000;
                    }
                }
            }
            for (int j = 0; j < count; ++j) {
                TypeVariableBinding knownVar = typeVariableBindings[j];
                if (!CharOperation.equals(knownVar.sourceName, typeParameter.name)) continue;
                this.problemReporter().duplicateTypeParameterInType(typeParameter);
            }
            typeVariableBindings[count++] = parameterBinding;
        }
        if (count != length) {
            TypeVariableBinding[] typeVariableBindingArray = typeVariableBindings;
            typeVariableBindings = new TypeVariableBinding[count];
            System.arraycopy(typeVariableBindingArray, 0, typeVariableBindings, 0, count);
        }
        return typeVariableBindings;
    }

    void resolveTypeParameter(TypeParameter typeParameter) {
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingLambdaScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (!(methodScope.referenceContext instanceof LambdaExpression)) continue;
            return methodScope;
        }
        return null;
    }

    public final ReferenceBinding enclosingReceiverType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return this.environment().convertToParameterizedType(((ClassScope)scope).referenceContext.binding);
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope current = this;
        while ((current = current.parent) != null) {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    protected MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, ObjectVector found, MethodBinding[] concreteMatches) {
        int startFoundSize = found.size;
        boolean sourceLevel18 = this.compilerOptions().sourceLevel >= 0x340000L;
        ArrayList<TypeBinding> visitedTypes = new ArrayList<TypeBinding>();
        for (ReferenceBinding currentType = classHierarchyStart; currentType != null; currentType = currentType.superclass()) {
            this.findMethodInSuperInterfaces(currentType, selector, found, visitedTypes, invocationSite);
        }
        int candidatesCount = concreteMatches == null ? 0 : concreteMatches.length;
        int foundSize = found.size;
        MethodBinding[] candidates = new MethodBinding[foundSize - startFoundSize + candidatesCount];
        if (concreteMatches != null) {
            System.arraycopy(concreteMatches, 0, candidates, 0, candidatesCount);
        }
        MethodBinding problemMethod = null;
        if (foundSize > startFoundSize) {
            MethodVerifier methodVerifier = this.environment().methodVerifier();
            block1: for (int i = startFoundSize; i < foundSize; ++i) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite, 1);
                if (compatibleMethod == null) continue;
                if (compatibleMethod.isValidBinding()) {
                    int j;
                    if (concreteMatches != null) {
                        int length = concreteMatches.length;
                        for (j = 0; j < length; ++j) {
                            if (!methodVerifier.areMethodsCompatible(concreteMatches[j], compatibleMethod)) continue;
                        }
                    }
                    if (sourceLevel18 || !compatibleMethod.isVarargs() || !(compatibleMethod instanceof ParameterizedGenericMethodBinding)) {
                        for (j = 0; j < startFoundSize; ++j) {
                            MethodBinding classMethod = (MethodBinding)found.elementAt(j);
                            if (classMethod != null && methodVerifier.areMethodsCompatible(classMethod, compatibleMethod)) continue block1;
                        }
                    }
                    candidates[candidatesCount++] = compatibleMethod;
                    continue;
                }
                if (problemMethod != null) continue;
                problemMethod = compatibleMethod;
            }
        }
        MethodBinding concreteMatch = null;
        if (candidatesCount < 2) {
            if (concreteMatches == null && candidatesCount == 0) {
                return problemMethod;
            }
            concreteMatch = candidates[0];
            if ((concreteMatch = this.inferInvocationType(invocationSite, concreteMatch, argumentTypes)) != null) {
                this.compilationUnitScope().recordTypeReferences(concreteMatch.thrownExceptions);
            }
            return concreteMatch;
        }
        if (this.compilerOptions().complianceLevel >= 0x300000L) {
            return this.mostSpecificMethodBinding(candidates, candidatesCount, argumentTypes, invocationSite, receiverType);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, candidatesCount, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        ReferenceBinding enclosingReceiverType = this.enclosingReceiverType();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingReceiverType == null) {
                TypeDeclaration[] types;
                if (memberType.canBeSeenBy(this.getCurrentPackage())) {
                    return memberType;
                }
                if (this instanceof CompilationUnitScope && (types = ((CompilationUnitScope)this).referenceContext.types) != null) {
                    int max = types.length;
                    for (int i = 0; i < max; ++i) {
                        if (!memberType.canBeSeenBy(enclosingType, types[i].binding)) continue;
                        return memberType;
                    }
                }
            } else if (memberType.canBeSeenBy(enclosingType, enclosingReceiverType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(new char[][]{typeName}, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        MethodBinding exactMethod = receiverType.getExactMethod(selector, argumentTypes, unitScope);
        if (exactMethod != null && exactMethod.typeVariables == Binding.NO_TYPE_VARIABLES && !exactMethod.isBridge()) {
            if (this.compilerOptions().sourceLevel >= 0x310000L) {
                int i = argumentTypes.length;
                while (--i >= 0) {
                    if (!this.isPossibleSubtypeOfRawType(argumentTypes[i])) continue;
                    return null;
                }
            }
            unitScope.recordTypeReferences(exactMethod.thrownExceptions);
            if (exactMethod.isAbstract() && exactMethod.thrownExceptions != Binding.NO_EXCEPTIONS) {
                return null;
            }
            if (exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                if (argumentTypes == Binding.NO_PARAMETERS && CharOperation.equals(selector, TypeConstants.GETCLASS) && exactMethod.returnType.isParameterizedType()) {
                    return this.environment().createGetClassMethod(receiverType, exactMethod, this);
                }
                if (invocationSite.genericTypeArguments() != null) {
                    exactMethod = this.computeCompatibleMethod(exactMethod, argumentTypes, invocationSite, 3);
                } else if ((exactMethod.tagBits & 0x10000000000000L) != 0L) {
                    return this.environment().createPolymorphicMethod(exactMethod, argumentTypes);
                }
                return exactMethod;
            }
        }
        return null;
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        return this.findField(receiverType, fieldName, invocationSite, needResolve, false);
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve, boolean invisibleFieldsOk) {
        boolean insideTypeAnnotations;
        CompilationUnitScope unitScope;
        block34: {
            TypeBinding leafType;
            unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            switch (receiverType.kind()) {
                case 132: {
                    return null;
                }
                case 516: 
                case 4100: 
                case 8196: {
                    TypeBinding receiverErasure = receiverType.erasure();
                    if (receiverErasure.isArrayType()) {
                        leafType = receiverErasure.leafComponentType();
                        break;
                    }
                    break block34;
                }
                case 68: {
                    leafType = receiverType.leafComponentType();
                    break;
                }
                default: {
                    break block34;
                }
            }
            if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)leafType, fieldName, 8);
            }
            if (CharOperation.equals(fieldName, TypeConstants.LENGTH)) {
                if ((leafType.tagBits & 0x80L) != 0L) {
                    return new ProblemFieldBinding(ArrayBinding.ArrayLength, null, fieldName, 1);
                }
                return ArrayBinding.ArrayLength;
            }
            return null;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        currentType.initializeForStaticImports();
        FieldBinding field = currentType.getField(fieldName, needResolve);
        boolean bl = insideTypeAnnotations = this instanceof MethodScope && ((MethodScope)this).insideTypeAnnotation;
        if (field != null) {
            if (invisibleFieldsOk) {
                return field;
            }
            if (invocationSite == null || insideTypeAnnotations ? field.canBeSeenBy(this.getCurrentPackage()) : field.canBeSeenBy(currentType, invocationSite, this)) {
                return field;
            }
            return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
        }
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        FieldBinding notVisibleField = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    block6: for (int a = 0; a < itsLength; ++a) {
                        ReferenceBinding next = itsInterfaces[a];
                        for (int b = 0; b < nextPosition; ++b) {
                            if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block6;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                }
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordTypeReference(currentType);
            currentType.initializeForStaticImports();
            field = (currentType = (ReferenceBinding)currentType.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd())).getField(fieldName, needResolve);
            if (field == null) continue;
            if (invisibleFieldsOk) {
                return field;
            }
            keepLooking = false;
            if (field.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visibleField == null) {
                    visibleField = field;
                    continue;
                }
                return new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
            }
            if (notVisibleField != null) continue;
            notVisibleField = field;
        }
        if (interfacesToVisit != null) {
            ProblemFieldBinding ambiguous = null;
            for (int i = 0; i < nextPosition; ++i) {
                ReferenceBinding anInterface = interfacesToVisit[i];
                unitScope.recordTypeReference(anInterface);
                field = anInterface.getField(fieldName, true);
                if (field != null) {
                    if (invisibleFieldsOk) {
                        return field;
                    }
                    if (visibleField == null) {
                        visibleField = field;
                        continue;
                    }
                    ambiguous = new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
                    break;
                }
                ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block9: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block9;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (notVisibleField != null) {
            return new ProblemFieldBinding(notVisibleField, currentType, fieldName, 2);
        }
        return null;
    }

    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        PackageBinding currentPackage = this.getCurrentPackage();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null || this.parent == unitScope && (enclosingSourceType.tagBits & 0x40000L) == 0L ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(new char[][]{typeName}, memberType, 2);
        }
        ReferenceBinding currentType = enclosingType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                ReferenceBinding sourceType;
                ReferenceBinding referenceBinding = sourceType = currentType.isParameterizedType() ? ((ParameterizedTypeBinding)currentType).genericType() : currentType;
                if (sourceType.isHierarchyBeingConnected()) {
                    return null;
                }
                ((SourceTypeBinding)sourceType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                } else {
                    int itsLength = itsInterfaces.length;
                    if (nextPosition + itsLength >= interfacesToVisit.length) {
                        ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                    }
                    block1: for (int a = 0; a < itsLength; ++a) {
                        ReferenceBinding next = itsInterfaces[a];
                        for (int b = 0; b < nextPosition; ++b) {
                            if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block1;
                        }
                        interfacesToVisit[nextPosition++] = next;
                    }
                }
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordReference(currentType, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            unitScope.recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType == null) {
                    visibleMemberType = memberType;
                    continue;
                }
                return new ProblemReferenceBinding(new char[][]{typeName}, visibleMemberType, 3);
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            ProblemReferenceBinding ambiguous = null;
            for (int i = 0; i < nextPosition; ++i) {
                void anInterface = interfacesToVisit[i];
                unitScope.recordReference((ReferenceBinding)anInterface, typeName);
                memberType = anInterface.getMemberType(typeName);
                if (memberType != null) {
                    unitScope.recordTypeReference(memberType);
                    if (visibleMemberType == null) {
                        visibleMemberType = memberType;
                        continue;
                    }
                    ambiguous = new ProblemReferenceBinding(new char[][]{typeName}, visibleMemberType, 3);
                    break;
                }
                ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block4: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block4;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible != null) {
            return new ProblemReferenceBinding(new char[][]{typeName}, notVisible, 2);
        }
        return null;
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, boolean inStaticContext) {
        TypeBinding elementType;
        MethodBinding method = this.findMethod0(receiverType, selector, argumentTypes, invocationSite, inStaticContext);
        if (method != null && method.isValidBinding() && method.isVarargs() && (elementType = method.parameters[method.parameters.length - 1].leafComponentType()) instanceof ReferenceBinding && !((ReferenceBinding)elementType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(method, method.selector, invocationSite.genericTypeArguments(), 16);
        }
        return method;
    }

    public MethodBinding findMethod0(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, boolean inStaticContext) {
        MethodBinding candidate;
        int i;
        boolean searchForDefaultAbstractMethod;
        long complianceLevel;
        ReferenceBinding currentType = receiverType;
        boolean receiverTypeIsInterface = receiverType.isInterface();
        ObjectVector found = new ObjectVector(3);
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        if (receiverTypeIsInterface) {
            unitScope.recordTypeReference(receiverType);
            Object[] receiverMethods = receiverType.getMethods(selector, argumentTypes.length);
            if (receiverMethods.length > 0) {
                found.addAll(receiverMethods);
            }
            this.findMethodInSuperInterfaces(receiverType, selector, found, null, invocationSite);
            currentType = this.getJavaLangObject();
        }
        boolean isCompliant14 = (complianceLevel = this.compilerOptions().complianceLevel) >= 0x300000L;
        boolean isCompliant15 = complianceLevel >= 0x310000L;
        boolean soureLevel18 = this.compilerOptions().sourceLevel >= 0x340000L;
        ReferenceBinding classHierarchyStart = currentType;
        MethodVerifier verifier = this.environment().methodVerifier();
        while (currentType != null) {
            unitScope.recordTypeReference(currentType);
            currentType = (ReferenceBinding)currentType.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd());
            Object[] currentMethods = currentType.getMethods(selector, argumentTypes.length);
            int currentLength = currentMethods.length;
            if (currentLength > 0) {
                if (isCompliant14 && (receiverTypeIsInterface || found.size > 0)) {
                    int l = currentLength;
                    block8: for (int i2 = 0; i2 < l; ++i2) {
                        Object currentMethod = currentMethods[i2];
                        if (currentMethod == null) continue;
                        if (receiverTypeIsInterface && !((MethodBinding)currentMethod).isPublic()) {
                            --currentLength;
                            currentMethods[i2] = null;
                            continue;
                        }
                        int max = found.size;
                        for (int j = 0; j < max; ++j) {
                            MethodBinding matchingMethod = (MethodBinding)found.elementAt(j);
                            MethodBinding matchingOriginal = matchingMethod.original();
                            MethodBinding currentOriginal = matchingOriginal.findOriginalInheritedMethod((MethodBinding)currentMethod);
                            if (currentOriginal == null || !verifier.isParameterSubsignature(matchingOriginal, currentOriginal)) continue;
                            if (isCompliant15 && matchingMethod.isBridge() && !((MethodBinding)currentMethod).isBridge()) continue block8;
                            --currentLength;
                            currentMethods[i2] = null;
                            continue block8;
                        }
                    }
                }
                if (currentLength > 0) {
                    if (currentMethods.length == currentLength) {
                        found.addAll(currentMethods);
                    } else {
                        for (Object currentMethod : currentMethods) {
                            if (currentMethod == null) continue;
                            found.add(currentMethod);
                        }
                    }
                }
            }
            currentType = currentType.superclass();
        }
        int foundSize = found.size;
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        Binding problemMethod = null;
        boolean bl = searchForDefaultAbstractMethod = soureLevel18 || isCompliant14 && !receiverTypeIsInterface && (receiverType.isAbstract() || receiverType.isTypeVariable());
        if (foundSize > 0) {
            for (int i3 = 0; i3 < foundSize; ++i3) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i3);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite, 1);
                if (compatibleMethod == null) continue;
                if (compatibleMethod.isValidBinding()) {
                    if (foundSize == 1 && compatibleMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                        if (searchForDefaultAbstractMethod) {
                            return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, new MethodBinding[]{compatibleMethod});
                        }
                        MethodBinding improved = this.inferInvocationType(invocationSite, compatibleMethod, argumentTypes);
                        if (improved == null || !improved.isValidBinding()) {
                            problemMethod = improved;
                            continue;
                        }
                        compatibleMethod = improved;
                        unitScope.recordTypeReferences(compatibleMethod.thrownExceptions);
                        return compatibleMethod;
                    }
                    if (candidatesCount == 0) {
                        candidates = new MethodBinding[foundSize];
                    }
                    candidates[candidatesCount++] = compatibleMethod;
                    continue;
                }
                if (problemMethod != null) continue;
                problemMethod = compatibleMethod;
            }
        }
        if (candidatesCount == 0) {
            MethodBinding interfaceMethod;
            if (problemMethod != null) {
                switch (problemMethod.problemId()) {
                    case 11: 
                    case 13: {
                        return problemMethod;
                    }
                }
            }
            if ((interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null)) != null) {
                if (soureLevel18 && foundSize > 0 && interfaceMethod.isVarargs() && interfaceMethod instanceof ParameterizedGenericMethodBinding) {
                    MethodBinding original = interfaceMethod.original();
                    for (int i4 = 0; i4 < foundSize; ++i4) {
                        MethodBinding substitute;
                        MethodBinding classMethod = (MethodBinding)found.elementAt(i4);
                        if (classMethod.isAbstract() || (substitute = verifier.computeSubstituteMethod(original, classMethod)) == null || !verifier.isSubstituteParameterSubsignature(classMethod, substitute)) continue;
                        return new ProblemMethodBinding(interfaceMethod, selector, argumentTypes, 24);
                    }
                }
                return interfaceMethod;
            }
            if (found.size == 0) {
                return null;
            }
            if (problemMethod != null) {
                return problemMethod;
            }
            int bestArgMatches = -1;
            MethodBinding bestGuess = (MethodBinding)found.elementAt(0);
            int argLength = argumentTypes.length;
            foundSize = found.size;
            for (int i5 = 0; i5 < foundSize; ++i5) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i5);
                TypeBinding[] params = methodBinding.parameters;
                int paramLength = params.length;
                int argMatches = 0;
                block14: for (int a = 0; a < argLength; ++a) {
                    int p;
                    TypeBinding arg = argumentTypes[a];
                    int n = p = a == 0 ? 0 : a - 1;
                    while (p < paramLength && p < a + 1) {
                        if (TypeBinding.equalsEquals(params[p], arg)) {
                            ++argMatches;
                            continue block14;
                        }
                        ++p;
                    }
                }
                if (argMatches < bestArgMatches) continue;
                if (argMatches == bestArgMatches) {
                    int diff2;
                    int diff1 = paramLength < argLength ? 2 * (argLength - paramLength) : paramLength - argLength;
                    int bestLength = bestGuess.parameters.length;
                    int n = diff2 = bestLength < argLength ? 2 * (argLength - bestLength) : bestLength - argLength;
                    if (diff1 >= diff2) continue;
                }
                bestArgMatches = argMatches;
                bestGuess = methodBinding;
            }
            return new ProblemMethodBinding(bestGuess, bestGuess.selector, argumentTypes, 1);
        }
        int visiblesCount = 0;
        for (i = 0; i < candidatesCount; ++i) {
            void methodBinding = candidates[i];
            if (!methodBinding.canBeSeenBy(receiverType, invocationSite, this)) continue;
            if (visiblesCount != i) {
                candidates[i] = null;
                candidates[visiblesCount] = methodBinding;
            }
            ++visiblesCount;
        }
        switch (visiblesCount) {
            case 0: {
                MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null);
                if (interfaceMethod != null) {
                    return interfaceMethod;
                }
                candidate = candidates[0];
                return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, candidate.isStatic() && candidate.declaringClass.isInterface() ? 20 : 2);
            }
            case 1: {
                if (searchForDefaultAbstractMethod) {
                    return this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, new MethodBinding[]{candidates[0]});
                }
                candidate = this.inferInvocationType(invocationSite, (MethodBinding)candidates[0], argumentTypes);
                if (candidate != null) {
                    unitScope.recordTypeReferences(candidate.thrownExceptions);
                }
                return candidate;
            }
        }
        if (complianceLevel <= 0x2F0000L) {
            ReferenceBinding declaringClass = candidates[0].declaringClass;
            return !declaringClass.isInterface() ? this.mostSpecificClassMethodBinding(candidates, visiblesCount, invocationSite) : this.mostSpecificInterfaceMethodBinding(candidates, visiblesCount, invocationSite);
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            for (i = 0; i < visiblesCount; ++i) {
                candidate = candidates[i];
                if (candidate instanceof ParameterizedGenericMethodBinding) {
                    candidate = ((ParameterizedGenericMethodBinding)candidate).originalMethod;
                }
                if (!candidate.hasSubstitutedParameters()) continue;
                for (int j = i + 1; j < visiblesCount; ++j) {
                    MethodBinding otherCandidate = candidates[j];
                    if (!otherCandidate.hasSubstitutedParameters() || otherCandidate != candidate && (!TypeBinding.equalsEquals(candidate.declaringClass, otherCandidate.declaringClass) || !candidate.areParametersEqual(otherCandidate))) continue;
                    return new ProblemMethodBinding(candidates[i], candidates[i].selector, candidates[i].parameters, 3);
                }
            }
        }
        if (inStaticContext) {
            MethodBinding[] staticCandidates = new MethodBinding[visiblesCount];
            int staticCount = 0;
            for (int i6 = 0; i6 < visiblesCount; ++i6) {
                if (!candidates[i6].isStatic()) continue;
                staticCandidates[staticCount++] = candidates[i6];
            }
            if (staticCount == 1) {
                return staticCandidates[0];
            }
            if (staticCount > 1) {
                return this.mostSpecificMethodBinding(staticCandidates, staticCount, argumentTypes, invocationSite, receiverType);
            }
        }
        if (visiblesCount != candidates.length) {
            MethodBinding[] methodBindingArray = candidates;
            candidates = new MethodBinding[visiblesCount];
            System.arraycopy(methodBindingArray, 0, candidates, 0, visiblesCount);
        }
        return searchForDefaultAbstractMethod ? this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, candidates) : this.mostSpecificMethodBinding(candidates, visiblesCount, argumentTypes, invocationSite, receiverType);
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, Binding.NO_PARAMETERS, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes, null);
        if (methodBinding != null) {
            if (argumentTypes == Binding.NO_PARAMETERS) {
                switch (selector[0]) {
                    case 'c': {
                        if (!CharOperation.equals(selector, TypeConstants.CLONE)) break;
                        return this.environment().computeArrayClone(methodBinding);
                    }
                    case 'g': {
                        if (!CharOperation.equals(selector, TypeConstants.GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return this.environment().createGetClassMethod(receiverType, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite, false)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 26);
        }
        return methodBinding;
    }

    protected void findMethodInSuperInterfaces(ReferenceBinding receiverType, char[] selector, ObjectVector found, List<TypeBinding> visitedTypes, InvocationSite invocationSite) {
        ReferenceBinding currentType = receiverType;
        ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
        if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] interfacesToVisit = itsInterfaces;
            int nextPosition = interfacesToVisit.length;
            block0: for (int i = 0; i < nextPosition; ++i) {
                currentType = interfacesToVisit[i];
                if (visitedTypes != null) {
                    TypeBinding uncaptured = currentType.uncapture(this);
                    for (TypeBinding visited : visitedTypes) {
                        if (!uncaptured.isEquivalentTo(visited)) continue;
                        continue block0;
                    }
                    visitedTypes.add(uncaptured);
                }
                this.compilationUnitScope().recordTypeReference(currentType);
                currentType = (ReferenceBinding)currentType.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd());
                MethodBinding[] currentMethods = currentType.getMethods(selector);
                if (currentMethods.length > 0) {
                    int foundSize = found.size;
                    block2: for (MethodBinding current : currentMethods) {
                        if (!current.canBeSeenBy(receiverType, invocationSite, this)) continue;
                        if (foundSize > 0) {
                            for (int f = 0; f < foundSize; ++f) {
                                if (current == found.elementAt(f)) continue block2;
                            }
                        }
                        found.add(current);
                    }
                }
                if ((itsInterfaces = currentType.superInterfaces()) == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block4: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block4;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        ReferenceBinding typeBinding = declarationPackage.getType(typeName);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && !typeBinding.canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(new char[][]{typeName}, typeBinding, 2);
        }
        return typeBinding;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean bl = false;
                boolean insideConstructorCall = false;
                boolean insideTypeAnnotation = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                MethodScope methodScope = null;
                int depth = 0;
                int foundDepth = 0;
                boolean shouldTrackOuterLocals = false;
                ReferenceBinding foundActualReceiverType = null;
                block27: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            methodScope = (MethodScope)scope;
                            n |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                            insideTypeAnnotation = methodScope.insideTypeAnnotation;
                        }
                        case 1: {
                            Object variableDeclaration;
                            LocalVariableBinding localVariableBinding = scope.findVariable(name);
                            if (localVariableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                return problemFieldBinding;
                            }
                            if (depth > 0) {
                                invocationSite.setDepth(depth);
                            }
                            if (shouldTrackOuterLocals) {
                                if (invocationSite instanceof NameReference) {
                                    NameReference nameReference = (NameReference)invocationSite;
                                    nameReference.bits |= 0x80000;
                                } else if (invocationSite instanceof AbstractVariableDeclaration) {
                                    variableDeclaration = (AbstractVariableDeclaration)invocationSite;
                                    ((AbstractVariableDeclaration)variableDeclaration).bits |= 0x200000;
                                }
                            }
                            variableDeclaration = localVariableBinding;
                            return variableDeclaration;
                        }
                        case 3: {
                            FieldBinding fieldBinding;
                            ClassScope classScope = (ClassScope)scope;
                            ReferenceBinding receiverType = classScope.enclosingReceiverType();
                            if (!insideTypeAnnotation && (fieldBinding = classScope.findField(receiverType, name, invocationSite, needResolve)) != null) {
                                if (fieldBinding.problemId() == 3) {
                                    FieldBinding fieldBinding2;
                                    if (foundField != null && foundField.problemId() != 2) {
                                        fieldBinding2 = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        return fieldBinding2;
                                    }
                                    fieldBinding2 = fieldBinding;
                                    return fieldBinding2;
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    if (!fieldBinding.isStatic()) {
                                        int n;
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 6);
                                        } else if (n != 0) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 7);
                                        }
                                    }
                                    if (TypeBinding.equalsEquals(receiverType, fieldBinding.declaringClass) || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(receiverType);
                                            }
                                            FieldBinding fieldBinding3 = insideProblem == null ? fieldBinding : insideProblem;
                                            return fieldBinding3;
                                        }
                                        if (foundField.isValidBinding() && TypeBinding.notEquals(((FieldBinding)foundField).declaringClass, fieldBinding.declaringClass) && TypeBinding.notEquals(((FieldBinding)foundField).declaringClass, foundActualReceiverType)) {
                                            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                            return problemFieldBinding;
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = receiverType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            insideTypeAnnotation = false;
                            ++depth;
                            shouldTrackOuterLocals = true;
                            n |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block27;
                        }
                    }
                    if (scope.isLambdaScope()) {
                        shouldTrackOuterLocals = true;
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    ProblemFieldBinding problemFieldBinding = foundInsideProblem;
                    return problemFieldBinding;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth > 0) {
                            invocationSite.setDepth(foundDepth);
                            invocationSite.setActualReceiverType(foundActualReceiverType);
                        }
                        Binding binding2 = foundField;
                        return binding2;
                    }
                    problemField = foundField;
                    foundField = null;
                }
                if (this.compilerOptions().sourceLevel >= 0x310000L) {
                    unitScope.faultInImports();
                    ImportBinding[] importBindingArray = unitScope.imports;
                    if (importBindingArray != null) {
                        int length = importBindingArray.length;
                        for (int i = 0; i < length; ++i) {
                            ImportBinding importBinding = importBindingArray[i];
                            if (!importBinding.isStatic() || importBinding.onDemand || !CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) || unitScope.resolveSingleImport(importBinding, 13) == null || !(importBinding.resolvedImport instanceof FieldBinding)) continue;
                            foundField = (FieldBinding)importBinding.resolvedImport;
                            ImportReference importReference = importBinding.reference;
                            if (importReference != null && needResolve) {
                                importReference.bits |= 2;
                            }
                            invocationSite.setActualReceiverType(((FieldBinding)foundField).declaringClass);
                            if (foundField.isValidBinding()) {
                                Binding binding3 = foundField;
                                return binding3;
                            }
                            if (problemField != null) continue;
                            problemField = foundField;
                        }
                        boolean foundInImport = false;
                        for (ImportBinding importBinding : importBindingArray) {
                            FieldBinding temp;
                            Binding resolvedImport;
                            if (!importBinding.isStatic() || !importBinding.onDemand || !((resolvedImport = importBinding.resolvedImport) instanceof ReferenceBinding) || (temp = this.findField((ReferenceBinding)resolvedImport, name, invocationSite, needResolve)) == null) continue;
                            if (!temp.isValidBinding()) {
                                if (problemField != null) continue;
                                problemField = temp;
                                continue;
                            }
                            if (!temp.isStatic() || foundField == temp) continue;
                            ImportReference importReference = importBinding.reference;
                            if (importReference != null && needResolve) {
                                importReference.bits |= 2;
                            }
                            if (foundInImport) {
                                ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 3);
                                return problemFieldBinding;
                            }
                            foundField = temp;
                            foundInImport = true;
                        }
                        if (foundField != null) {
                            invocationSite.setActualReceiverType(((FieldBinding)foundField).declaringClass);
                            Binding binding4 = foundField;
                            return binding4;
                        }
                    }
                }
            }
            if ((mask & 4) != 0) {
                binding = Scope.getBaseType(name);
                if (binding != null) {
                    TypeBinding typeBinding = binding;
                    return typeBinding;
                }
                binding = this.getTypeOrPackage(name, (mask & 0x10) == 0 ? 4 : 20, needResolve);
                if (binding.isValidBinding() || mask == 4) {
                    Binding binding5 = binding;
                    return binding5;
                }
            } else if ((mask & 0x10) != 0) {
                unitScope.recordSimpleReference(name);
                binding = env.getTopLevelPackage(name);
                if (binding != null) {
                    Binding binding6 = binding;
                    return binding6;
                }
            }
            if (problemField != null) {
                Binding binding7 = problemField;
                return binding7;
            }
            if (binding != null && binding.problemId() != 1) {
                Binding binding8 = binding;
                return binding8;
            }
            ProblemBinding problemBinding = new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
            return problemBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    private MethodBinding getExactMethod(TypeBinding receiverType, TypeBinding type, char[] selector, InvocationSite invocationSite, MethodBinding candidate) {
        if (type == null) {
            return null;
        }
        ReferenceBinding[] superInterfaces = type.superInterfaces();
        TypeBinding[] typePlusSupertypes = new TypeBinding[2 + superInterfaces.length];
        typePlusSupertypes[0] = type;
        typePlusSupertypes[1] = type.superclass();
        if (superInterfaces.length != 0) {
            System.arraycopy(superInterfaces, 0, typePlusSupertypes, 2, superInterfaces.length);
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReference(type);
        type = type.capture(this, invocationSite.sourceEnd());
        int typesLength = typePlusSupertypes.length;
        for (int i = 0; i < typesLength; ++i) {
            MethodBinding[] methodBindingArray;
            if (i == 0) {
                methodBindingArray = type.getMethods(selector);
            } else {
                MethodBinding[] methodBindingArray2 = new MethodBinding[1];
                methodBindingArray = methodBindingArray2;
                methodBindingArray2[0] = this.getExactMethod(receiverType, typePlusSupertypes[i], selector, invocationSite, candidate);
            }
            for (MethodBinding currentMethod : methodBindingArray) {
                if (currentMethod == null || candidate == currentMethod || i == 0 && (!currentMethod.canBeSeenBy(receiverType, invocationSite, this) || currentMethod.isSynthetic() || currentMethod.isBridge())) continue;
                if (candidate != null) {
                    if (candidate.areParameterErasuresEqual(currentMethod)) continue;
                    throw new MethodClashException();
                }
                candidate = currentMethod;
            }
        }
        return candidate;
    }

    public MethodBinding getExactMethod(TypeBinding receiverType, char[] selector, InvocationSite invocationSite) {
        if (receiverType == null || !receiverType.isValidBinding() || receiverType.isBaseType()) {
            return null;
        }
        TypeBinding currentType = receiverType;
        if (currentType.isArrayType()) {
            if (!currentType.leafComponentType().canBeSeenBy(this)) {
                return null;
            }
            currentType = this.getJavaLangObject();
        }
        MethodBinding exactMethod = null;
        try {
            exactMethod = this.getExactMethod(receiverType, currentType, selector, invocationSite, null);
        }
        catch (MethodClashException e) {
            return null;
        }
        if (exactMethod == null || !exactMethod.canBeSeenBy(invocationSite, this)) {
            return null;
        }
        if (exactMethod.isVarargs() || exactMethod.typeVariables() != Binding.NO_TYPE_VARIABLES && invocationSite.genericTypeArguments() == null) {
            return null;
        }
        if (receiverType.isArrayType()) {
            if (CharOperation.equals(selector, TypeConstants.CLONE)) {
                return this.environment().computeArrayClone(exactMethod);
            }
            if (CharOperation.equals(selector, TypeConstants.GETCLASS)) {
                return this.environment().createGetClassMethod(receiverType, exactMethod, this);
            }
        }
        if (exactMethod.declaringClass.id == 1 && CharOperation.equals(selector, TypeConstants.GETCLASS) && exactMethod.returnType.isParameterizedType()) {
            return this.environment().createGetClassMethod(receiverType, exactMethod, this);
        }
        return exactMethod;
    }

    public MethodBinding getExactConstructor(TypeBinding receiverType, InvocationSite invocationSite) {
        if (receiverType == null || !receiverType.isValidBinding() || !receiverType.canBeInstantiated() || receiverType.isBaseType()) {
            return null;
        }
        if (receiverType.isArrayType()) {
            TypeBinding leafType = receiverType.leafComponentType();
            if (!leafType.canBeSeenBy(this) || !leafType.isReifiable()) {
                return null;
            }
            return new MethodBinding(4097, TypeConstants.INIT, receiverType, new TypeBinding[]{TypeBinding.INT}, Binding.NO_EXCEPTIONS, this.getJavaLangObject());
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        MethodBinding exactConstructor = null;
        unitScope.recordTypeReference(receiverType);
        for (MethodBinding constructor : receiverType.getMethods(TypeConstants.INIT)) {
            if (!constructor.canBeSeenBy(invocationSite, this)) continue;
            if (constructor.isVarargs()) {
                return null;
            }
            if (constructor.typeVariables() != Binding.NO_TYPE_VARIABLES && invocationSite.genericTypeArguments() == null) {
                return null;
            }
            if (exactConstructor == null) {
                exactConstructor = constructor;
                continue;
            }
            return null;
        }
        return exactConstructor;
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding elementType;
        MethodBinding method = this.getConstructor0(receiverType, argumentTypes, invocationSite);
        if (method != null && method.isValidBinding() && method.isVarargs() && (elementType = method.parameters[method.parameters.length - 1].leafComponentType()) instanceof ReferenceBinding && !((ReferenceBinding)elementType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(method, method.selector, invocationSite.genericTypeArguments(), 16);
        }
        return method;
    }

    public MethodBinding getConstructor0(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            unitScope.recordTypeReference(receiverType);
            unitScope.recordTypeReferences(argumentTypes);
            MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite, 3);
                }
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            MethodBinding[] methods = receiverType.getMethods(TypeConstants.INIT, argumentTypes.length);
            if (methods == Binding.NO_METHODS) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
                return problemMethodBinding;
            }
            MethodBinding[] compatible = new MethodBinding[methods.length];
            int compatibleIndex = 0;
            MethodBinding problemMethod = null;
            int length = methods.length;
            for (int i = 0; i < length; ++i) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methods[i], argumentTypes, invocationSite, 1);
                if (compatibleMethod == null) continue;
                if (compatibleMethod.isValidBinding()) {
                    compatible[compatibleIndex++] = compatibleMethod;
                    continue;
                }
                if (problemMethod != null) continue;
                problemMethod = compatibleMethod;
            }
            if (compatibleIndex == 0) {
                if (problemMethod == null) {
                    ProblemMethodBinding i = new ProblemMethodBinding(methods[0], TypeConstants.INIT, argumentTypes, 1);
                    return i;
                }
                MethodBinding i = problemMethod;
                return i;
            }
            MethodBinding[] visible = new MethodBinding[compatibleIndex];
            int visibleIndex = 0;
            for (int i = 0; i < compatibleIndex; ++i) {
                MethodBinding method = compatible[i];
                if (!method.canBeSeenBy(invocationSite, this)) continue;
                visible[visibleIndex++] = method;
            }
            if (visibleIndex == 1) {
                MethodBinding methodBinding3 = this.inferInvocationType(invocationSite, visible[0], argumentTypes);
                return methodBinding3;
            }
            if (visibleIndex == 0) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(compatible[0], TypeConstants.INIT, compatible[0].parameters, 2);
                return problemMethodBinding;
            }
            MethodBinding methodBinding4 = this.mostSpecificMethodBinding(visible, visibleIndex, argumentTypes, invocationSite, receiverType);
            return methodBinding4;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        LookupEnvironment env = this.environment();
        try {
            env.missingClassFileLocation = invocationSite;
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                FieldBinding fieldBinding = field;
                return fieldBinding;
            }
            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
            return problemFieldBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        insideStaticContext = false;
        insideConstructorCall = false;
        insideTypeAnnotation = false;
        foundMethod = null;
        foundProblem = null;
        foundProblemVisible = false;
        scope = this;
        methodScope = null;
        depth = 0;
        options = this.compilerOptions();
        inheritedHasPrecedence = options.complianceLevel >= 0x300000L;
        block5: while (true) {
            switch (scope.kind) {
                case 2: {
                    methodScope = (MethodScope)scope;
                    insideStaticContext |= methodScope.isStatic;
                    insideConstructorCall |= methodScope.isConstructorCall;
                    insideTypeAnnotation = methodScope.insideTypeAnnotation;
                    ** GOTO lbl71
                }
                case 3: {
                    classScope = (ClassScope)scope;
                    receiverType = classScope.enclosingReceiverType();
                    if (!insideTypeAnnotation) {
                        methodBinding = classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite);
                        if (methodBinding == null) {
                            methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite, false);
                        }
                        if (methodBinding != null) {
                            if (foundMethod == null) {
                                if (methodBinding.isValidBinding()) {
                                    if (!methodBinding.isStatic() && (insideConstructorCall || insideStaticContext)) {
                                        if (foundProblem != null && foundProblem.problemId() != 2) {
                                            return foundProblem;
                                        }
                                        return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, insideConstructorCall != false ? 6 : 7);
                                    }
                                    if (!methodBinding.isStatic() && methodScope != null) {
                                        this.tagAsAccessingEnclosingInstanceStateOf(receiverType, false);
                                    }
                                    if (inheritedHasPrecedence || TypeBinding.equalsEquals(receiverType, methodBinding.declaringClass) || receiverType.getMethods(selector) != Binding.NO_METHODS) {
                                        if (foundProblemVisible) {
                                            return foundProblem;
                                        }
                                        if (depth > 0) {
                                            invocationSite.setDepth(depth);
                                            invocationSite.setActualReceiverType(receiverType);
                                        }
                                        if (argumentTypes == Binding.NO_PARAMETERS && CharOperation.equals(selector, TypeConstants.GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                                            return this.environment().createGetClassMethod(receiverType, methodBinding, this);
                                        }
                                        return methodBinding;
                                    }
                                    if (foundProblem == null || foundProblem.problemId() == 2) {
                                        if (foundProblem != null) {
                                            foundProblem = null;
                                        }
                                        if (depth > 0) {
                                            invocationSite.setDepth(depth);
                                            invocationSite.setActualReceiverType(receiverType);
                                        }
                                        foundMethod = methodBinding;
                                    }
                                } else {
                                    if (methodBinding.problemId() != 2 && methodBinding.problemId() != 1) {
                                        return methodBinding;
                                    }
                                    if (foundProblem == null) {
                                        foundProblem = methodBinding;
                                    }
                                    if (!foundProblemVisible && methodBinding.problemId() == 1 && (closestMatch = ((ProblemMethodBinding)methodBinding).closestMatch) != null && closestMatch.canBeSeenBy(receiverType, invocationSite, this)) {
                                        foundProblem = methodBinding;
                                        foundProblemVisible = true;
                                    }
                                }
                            } else if (methodBinding.problemId() == 3 || TypeBinding.notEquals(foundMethod.declaringClass, methodBinding.declaringClass) && (TypeBinding.equalsEquals(receiverType, methodBinding.declaringClass) || receiverType.getMethods(selector) != Binding.NO_METHODS)) {
                                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                            }
                        }
                    }
                    insideTypeAnnotation = false;
                    ++depth;
                    insideStaticContext |= receiverType.isStatic();
                    enclosingMethodScope = scope.methodScope();
                    insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                    ** GOTO lbl71
                }
                case 4: {
                    break block5;
                }
lbl71:
                // 3 sources

                default: {
                    scope = scope.parent;
                    continue block5;
                }
            }
            break;
        }
        if (insideStaticContext && options.sourceLevel >= 0x310000L) {
            if (foundProblem != null) {
                if (foundProblem.declaringClass != null && foundProblem.declaringClass.id == 1) {
                    return foundProblem;
                }
                if (foundProblem.problemId() == 1 && foundProblemVisible) {
                    return foundProblem;
                }
            }
            unitScope = (CompilationUnitScope)scope;
            unitScope.faultInImports();
            imports = unitScope.imports;
            if (imports != null) {
                visible = null;
                skipOnDemand = false;
                for (ImportBinding importBinding : imports) {
                    if (!importBinding.isStatic()) continue;
                    resolvedImport = importBinding.resolvedImport;
                    possible = null;
                    if (importBinding.onDemand) {
                        if (!skipOnDemand && resolvedImport instanceof ReferenceBinding) {
                            possible = this.findMethod((ReferenceBinding)resolvedImport, selector, argumentTypes, invocationSite, true);
                        }
                    } else if (resolvedImport instanceof MethodBinding) {
                        staticMethod = (MethodBinding)resolvedImport;
                        if (CharOperation.equals(staticMethod.selector, selector)) {
                            possible = this.findMethod(staticMethod.declaringClass, selector, argumentTypes, invocationSite, true);
                        }
                    } else if (resolvedImport instanceof FieldBinding) {
                        staticField = (FieldBinding)resolvedImport;
                        if (CharOperation.equals(staticField.name, selector) && (referencedType = this.getType(importName = importBinding.reference.tokens, importName.length - 1)) != null) {
                            possible = this.findMethod((ReferenceBinding)referencedType, selector, argumentTypes, invocationSite, true);
                        }
                    }
                    if (possible == null || possible == foundProblem) continue;
                    if (!possible.isValidBinding()) {
                        if (foundProblem != null) continue;
                        foundProblem = possible;
                        continue;
                    }
                    if (!possible.isStatic()) continue;
                    compatibleMethod = this.computeCompatibleMethod((MethodBinding)possible, argumentTypes, invocationSite, 1);
                    if (compatibleMethod != null) {
                        if (compatibleMethod.isValidBinding()) {
                            if (compatibleMethod.canBeSeenBy(unitScope.fPackage)) {
                                if (visible != null && visible.contains(compatibleMethod)) continue;
                                importReference = importBinding.reference;
                                if (importReference != null) {
                                    importReference.bits |= 2;
                                }
                                if (!skipOnDemand && !importBinding.onDemand) {
                                    visible = null;
                                    skipOnDemand = true;
                                }
                                if (visible == null) {
                                    visible = new ObjectVector(3);
                                }
                                visible.add(compatibleMethod);
                                continue;
                            }
                            if (foundProblem != null) continue;
                            foundProblem = new ProblemMethodBinding(compatibleMethod, selector, compatibleMethod.parameters, 2);
                            continue;
                        }
                        if (foundProblem != null) continue;
                        foundProblem = compatibleMethod;
                        continue;
                    }
                    if (foundProblem != null) continue;
                    foundProblem = new ProblemMethodBinding((MethodBinding)possible, selector, argumentTypes, 1);
                }
                if (visible != null) {
                    if (visible.size == 1) {
                        foundMethod = (MethodBinding)visible.elementAt(0);
                    } else {
                        temp = new MethodBinding[visible.size];
                        visible.copyInto(temp);
                        foundMethod = this.mostSpecificMethodBinding((MethodBinding[])temp, temp.length, argumentTypes, invocationSite, null);
                    }
                }
            }
        }
        if (foundMethod != null) {
            invocationSite.setActualReceiverType(foundMethod.declaringClass);
            return foundMethod;
        }
        if (foundProblem != null) {
            return foundProblem;
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_IO_SERIALIZABLE);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_IO_SERIALIZABLE, this);
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION, this);
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ASSERTIONERROR, this);
    }

    public final ReferenceBinding getJavaLangClass() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_CLASS);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_CLASS, this);
    }

    public final ReferenceBinding getJavaLangCloneable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_CLONEABLE);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_CLONEABLE, this);
    }

    public final ReferenceBinding getJavaLangEnum() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ENUM);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ENUM, this);
    }

    public final ReferenceBinding getJavaLangInvokeLambdaMetafactory() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_INVOKE_LAMBDAMETAFACTORY, this);
    }

    public final ReferenceBinding getJavaLangInvokeSerializedLambda() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_INVOKE_SERIALIZEDLAMBDA);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_INVOKE_SERIALIZEDLAMBDA, this);
    }

    public final ReferenceBinding getJavaLangInvokeMethodHandlesLookup() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_INVOKE_METHODHANDLES);
        ReferenceBinding outerType = unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_INVOKE_METHODHANDLES, this);
        return this.findDirectMemberType("Lookup".toCharArray(), outerType);
    }

    public final ReferenceBinding getJavaLangIterable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ITERABLE);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ITERABLE, this);
    }

    public final ReferenceBinding getJavaLangObject() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_OBJECT);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangString() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_STRING);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_STRING, this);
    }

    public final ReferenceBinding getJavaLangThrowable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_THROWABLE);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_THROWABLE, this);
    }

    public final ReferenceBinding getJavaLangIllegalArgumentException() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ILLEGALARGUMENTEXCEPTION, this);
    }

    public final ReferenceBinding getJavaUtilIterator() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(TypeConstants.JAVA_UTIL_ITERATOR);
        return unitScope.environment.getResolvedType(TypeConstants.JAVA_UTIL_ITERATOR, this);
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        char[][] compoundName = new char[][]{typeName};
        return new ProblemReferenceBinding(compoundName, null, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            switch (receiverType.kind()) {
                case 132: {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                    return problemMethodBinding;
                }
                case 68: {
                    unitScope.recordTypeReference(receiverType);
                    MethodBinding methodBinding = this.findMethodForArray((ArrayBinding)receiverType, selector, argumentTypes, invocationSite);
                    return methodBinding;
                }
            }
            unitScope.recordTypeReference(receiverType);
            ReferenceBinding currentType = (ReferenceBinding)receiverType;
            if (!currentType.canBeSeenBy(this)) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 8);
                return problemMethodBinding;
            }
            MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding != null) {
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite, false);
            if (methodBinding == null) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                return problemMethodBinding;
            }
            if (!methodBinding.isValidBinding()) {
                MethodBinding methodBinding3 = methodBinding;
                return methodBinding3;
            }
            if (argumentTypes == Binding.NO_PARAMETERS && CharOperation.equals(selector, TypeConstants.GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                ParameterizedMethodBinding parameterizedMethodBinding = this.environment().createGetClassMethod(receiverType, methodBinding, this);
                return parameterizedMethodBinding;
            }
            MethodBinding methodBinding4 = methodBinding;
            return methodBinding4;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    public final Binding getPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 20, true);
        if (binding == null) {
            char[][] qName = new char[][]{compoundName[0]};
            return new ProblemReferenceBinding(qName, this.environment().createMissingType(null, compoundName), 1);
        }
        if (!binding.isValidBinding()) {
            if (binding instanceof PackageBinding) {
                char[][] qName = new char[][]{compoundName[0]};
                return new ProblemReferenceBinding(qName, null, 1);
            }
            return binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        int length = compoundName.length;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < length) {
            if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(compoundName, null, 1);
    }

    public final Binding getOnlyPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 16, true);
        if (binding == null || !binding.isValidBinding()) {
            char[][] qName = new char[][]{compoundName[0]};
            return new ProblemReferenceBinding(qName, null, 1);
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        int length = compoundName.length;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < length) {
            if ((binding = packageBinding.getPackage(compoundName[currentIndex++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
            }
            packageBinding = (PackageBinding)binding;
        }
        return packageBinding;
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = Scope.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4, true);
    }

    public final TypeBinding getType(char[] name, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(name);
        }
        Binding binding = packageBinding.getTypeOrPackage(name);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(binding instanceof ReferenceBinding ? ((ReferenceBinding)binding).compoundName : CharOperation.arrayConcat(packageBinding.compoundName, name), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        if (!typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(typeBinding.compoundName, typeBinding, 2);
        }
        return typeBinding;
    }

    public final TypeBinding getType(char[][] compoundName, int typeNameLength) {
        TypeBinding binding;
        if (typeNameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(compoundName);
        Binding binding2 = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 20, true);
        if (binding2 == null) {
            char[][] qName = new char[][]{compoundName[0]};
            return new ProblemReferenceBinding(qName, this.environment().createMissingType(this.compilationUnitScope().getCurrentPackage(), qName), 1);
        }
        if (!binding2.isValidBinding()) {
            if (binding2 instanceof PackageBinding) {
                char[][] qName = new char[][]{compoundName[0]};
                return new ProblemReferenceBinding(qName, this.environment().createMissingType(null, qName), 1);
            }
            return (ReferenceBinding)binding2;
        }
        int currentIndex = 1;
        boolean checkVisibility = false;
        if (binding2 instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding2;
            while (currentIndex < typeNameLength) {
                if ((binding2 = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    char[][] qName = CharOperation.subarray(compoundName, 0, currentIndex);
                    return new ProblemReferenceBinding(qName, this.environment().createMissingType(packageBinding, qName), 1);
                }
                if (!binding2.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding2 instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding2).closestMatch() : null, binding2.problemId());
                }
                if (!(binding2 instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding2;
            }
            if (binding2 instanceof PackageBinding) {
                char[][] qName = CharOperation.subarray(compoundName, 0, currentIndex);
                return new ProblemReferenceBinding(qName, this.environment().createMissingType(null, qName), 1);
            }
            checkVisibility = true;
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding2;
        unitScope.recordTypeReference(typeBinding);
        if (checkVisibility && !typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
        }
        while (currentIndex < typeNameLength) {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            if (typeBinding instanceof ProblemReferenceBinding) {
                ProblemReferenceBinding problemBinding = (ProblemReferenceBinding)typeBinding;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), problemBinding.closestReferenceMatch(), typeBinding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), typeBinding.problemId());
        }
        return typeBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask, boolean needResolve) {
        char[][] qName;
        PackageBinding packageBinding;
        Binding cachedBinding;
        Scope scope = this;
        MethodScope methodScope = null;
        Binding foundType = null;
        boolean insideStaticContext = false;
        boolean insideTypeAnnotation = false;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            boolean inheritedHasPrecedence = this.compilerOptions().complianceLevel >= 0x300000L;
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        methodScope = (MethodScope)scope;
                        AbstractMethodDeclaration methodDecl = methodScope.referenceMethod();
                        if (methodDecl != null) {
                            if (methodDecl.binding != null) {
                                TypeVariableBinding typeVariable = methodDecl.binding.getTypeVariable(name);
                                if (typeVariable != null) {
                                    return typeVariable;
                                }
                            } else {
                                int i;
                                TypeParameter[] params = methodDecl.typeParameters();
                                int n = i = params == null ? 0 : params.length;
                                while (--i >= 0) {
                                    if (!CharOperation.equals(params[i].name, name) || params[i].binding == null || !params[i].binding.isValidBinding()) continue;
                                    return params[i].binding;
                                }
                            }
                        }
                        insideStaticContext |= methodScope.isStatic;
                        insideTypeAnnotation = methodScope.insideTypeAnnotation;
                    }
                    case 1: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        if (foundType == null) return localType;
                        if (!TypeBinding.notEquals((TypeBinding)foundType, localType)) return localType;
                        return new ProblemReferenceBinding(new char[][]{name}, (ReferenceBinding)foundType, 5);
                    }
                    case 3: {
                        ReferenceBinding memberType;
                        TypeVariableBinding typeVariable;
                        SourceTypeBinding sourceType = ((ClassScope)scope).referenceContext.binding;
                        if (scope == this && (sourceType.tagBits & 0x40000L) == 0L) {
                            typeVariable = sourceType.getTypeVariable(name);
                            if (typeVariable != null) {
                                return typeVariable;
                            }
                            if (CharOperation.equals(name, sourceType.sourceName)) {
                                return sourceType;
                            }
                            insideStaticContext |= sourceType.isStatic();
                            break;
                        }
                        if (!insideTypeAnnotation && (memberType = this.findMemberType(name, sourceType)) != null) {
                            if (memberType.problemId() == 3) {
                                if (foundType == null) return memberType;
                                if (foundType.problemId() == 2) {
                                    return memberType;
                                }
                                return new ProblemReferenceBinding(new char[][]{name}, (ReferenceBinding)foundType, 5);
                            }
                            if (memberType.isValidBinding() && (TypeBinding.equalsEquals(sourceType, memberType.enclosingType()) || inheritedHasPrecedence)) {
                                if (insideStaticContext && !memberType.isStatic() && sourceType.isGenericType()) {
                                    return new ProblemReferenceBinding(new char[][]{name}, memberType, 7);
                                }
                                if (foundType == null) return memberType;
                                if (inheritedHasPrecedence && foundType.problemId() == 2) {
                                    return memberType;
                                }
                                if (foundType.isValidBinding() && TypeBinding.notEquals((TypeBinding)foundType, memberType)) {
                                    return new ProblemReferenceBinding(new char[][]{name}, (ReferenceBinding)foundType, 5);
                                }
                            }
                            if (foundType == null || foundType.problemId() == 2 && memberType.problemId() != 2) {
                                foundType = memberType;
                            }
                        }
                        if ((typeVariable = sourceType.getTypeVariable(name)) != null) {
                            if (!insideStaticContext) return typeVariable;
                            return new ProblemReferenceBinding(new char[][]{name}, typeVariable, 7);
                        }
                        insideStaticContext |= sourceType.isStatic();
                        insideTypeAnnotation = false;
                        if (!CharOperation.equals(sourceType.sourceName, name)) break;
                        if (foundType == null) return sourceType;
                        if (!TypeBinding.notEquals((TypeBinding)foundType, sourceType)) return sourceType;
                        if (foundType.problemId() == 2) return sourceType;
                        return new ProblemReferenceBinding(new char[][]{name}, (ReferenceBinding)foundType, 5);
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
            if (foundType != null && foundType.problemId() != 2) {
                return foundType;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        HashtableOfObject typeOrPackageCache = unitScope.typeOrPackageCache;
        if (typeOrPackageCache != null && (cachedBinding = (Binding)typeOrPackageCache.get(name)) != null) {
            if (cachedBinding instanceof ImportBinding) {
                ImportReference importReference = ((ImportBinding)cachedBinding).reference;
                if (importReference != null) {
                    importReference.bits |= 2;
                }
                if (cachedBinding instanceof ImportConflictBinding) {
                    cachedBinding = ((ImportConflictBinding)cachedBinding).conflictingTypeBinding;
                    typeOrPackageCache.put(name, cachedBinding);
                } else {
                    cachedBinding = ((ImportBinding)cachedBinding).resolvedImport;
                    typeOrPackageCache.put(name, cachedBinding);
                }
            }
            if ((mask & 4) != 0) {
                if (foundType != null && foundType.problemId() != 2 && cachedBinding.problemId() != 3) {
                    return foundType;
                }
                if (cachedBinding instanceof ReferenceBinding) {
                    return cachedBinding;
                }
            }
            if ((mask & 0x10) != 0 && cachedBinding instanceof PackageBinding) {
                return cachedBinding;
            }
        }
        if ((mask & 4) != 0) {
            ImportBinding[] imports = unitScope.imports;
            if (imports != null && typeOrPackageCache == null) {
                int length = imports.length;
                for (int i = 0; i < length; ++i) {
                    Binding resolvedImport;
                    ImportBinding importBinding = imports[i];
                    if (importBinding.onDemand || !CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) || (resolvedImport = unitScope.resolveSingleImport(importBinding, 4)) == null || !(resolvedImport instanceof TypeBinding)) continue;
                    ImportReference importReference = importBinding.reference;
                    if (importReference == null) return resolvedImport;
                    importReference.bits |= 2;
                    return resolvedImport;
                }
            }
            PackageBinding currentPackage = unitScope.fPackage;
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding = currentPackage.getTypeOrPackage(name);
            if (binding instanceof ReferenceBinding) {
                ReferenceBinding referenceType = (ReferenceBinding)binding;
                if ((referenceType.tagBits & 0x80L) == 0L) {
                    if (typeOrPackageCache == null) return referenceType;
                    typeOrPackageCache.put(name, referenceType);
                    return referenceType;
                }
            }
            if (imports != null) {
                boolean foundInImport = false;
                ReferenceBinding type = null;
                for (ImportBinding someImport : imports) {
                    if (!someImport.onDemand) continue;
                    Binding resolvedImport = someImport.resolvedImport;
                    ReferenceBinding temp = null;
                    if (resolvedImport instanceof PackageBinding) {
                        temp = this.findType(name, (PackageBinding)resolvedImport, currentPackage);
                    } else if (someImport.isStatic()) {
                        temp = this.findMemberType(name, (ReferenceBinding)resolvedImport);
                        if (temp != null && !temp.isStatic()) {
                            temp = null;
                        }
                    } else {
                        temp = this.findDirectMemberType(name, (ReferenceBinding)resolvedImport);
                    }
                    if (!TypeBinding.notEquals(temp, type) || temp == null) continue;
                    if (temp.isValidBinding()) {
                        ImportReference importReference = someImport.reference;
                        if (importReference != null) {
                            importReference.bits |= 2;
                        }
                        if (foundInImport) {
                            temp = new ProblemReferenceBinding(new char[][]{name}, type, 3);
                            if (typeOrPackageCache == null) return temp;
                            typeOrPackageCache.put(name, temp);
                            return temp;
                        }
                        type = temp;
                        foundInImport = true;
                        continue;
                    }
                    if (foundType != null) continue;
                    foundType = temp;
                }
                if (type != null) {
                    if (typeOrPackageCache == null) return type;
                    typeOrPackageCache.put(name, type);
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x10) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            if (typeOrPackageCache == null) return packageBinding;
            typeOrPackageCache.put(name, packageBinding);
            return packageBinding;
        }
        if (foundType != null) {
            if ((((ReferenceBinding)foundType).tagBits & 0x80L) == 0L) return foundType;
            qName = new char[][]{name};
            foundType = new ProblemReferenceBinding(qName, (ReferenceBinding)foundType, 1);
            if (typeOrPackageCache == null) return foundType;
            if ((mask & 0x10) == 0) return foundType;
            typeOrPackageCache.put(name, foundType);
            return foundType;
        }
        qName = new char[][]{name};
        MissingTypeBinding closestMatch = null;
        if ((mask & 0x10) != 0) {
            if (needResolve) {
                closestMatch = this.environment().createMissingType(unitScope.fPackage, qName);
            }
        } else {
            PackageBinding packageBinding2 = unitScope.environment.getTopLevelPackage(name);
            if ((packageBinding2 == null || !packageBinding2.isValidBinding()) && needResolve) {
                closestMatch = this.environment().createMissingType(unitScope.fPackage, qName);
            }
        }
        foundType = new ProblemReferenceBinding(qName, closestMatch, 1);
        if (typeOrPackageCache == null) return foundType;
        if ((mask & 0x10) == 0) return foundType;
        typeOrPackageCache.put(name, foundType);
        return foundType;
    }

    public final Binding getTypeOrPackage(char[][] compoundName) {
        Binding binding;
        int nameLength = compoundName.length;
        if (nameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 20, true);
        if (!binding.isValidBinding()) {
            return binding;
        }
        int currentIndex = 1;
        boolean checkVisibility = false;
        if (binding instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        ReferenceBinding qualifiedType = (ReferenceBinding)this.environment().convertToRawType(typeBinding, false);
        if (checkVisibility && !typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
        }
        while (currentIndex < nameLength) {
            if (!(typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)typeBinding.closestMatch(), typeBinding.problemId());
            }
            if (typeBinding.isGenericType()) {
                qualifiedType = this.environment().createRawType(typeBinding, qualifiedType);
                continue;
            }
            qualifiedType = qualifiedType != null && (qualifiedType.isRawType() || qualifiedType.isParameterizedType()) ? this.environment().createParameterizedType(typeBinding, null, qualifiedType) : typeBinding;
        }
        return qualifiedType;
    }

    public boolean hasErasedCandidatesCollisions(TypeBinding one, TypeBinding two, Map invocations, ReferenceBinding type, ASTNode typeRef) {
        invocations.clear();
        TypeBinding[] mecs = this.minimalErasedCandidates(new TypeBinding[]{one, two}, invocations);
        if (mecs != null) {
            for (TypeBinding mec : mecs) {
                Object value;
                if (mec == null || !((value = invocations.get(mec)) instanceof TypeBinding[])) continue;
                TypeBinding[] invalidInvocations = (TypeBinding[])value;
                this.problemReporter().superinterfacesCollide(invalidInvocations[0].erasure(), typeRef, invalidInvocations[0], invalidInvocations[1]);
                type.tagBits |= 0x20000L;
                return true;
            }
        }
        return false;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected boolean isAcceptableMethod(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneParams = one.parameters;
        int oneParamsLength = oneParams.length;
        TypeBinding[] twoParams = two.parameters;
        int twoParamsLength = twoParams.length;
        if (oneParamsLength != twoParamsLength) {
            if (!one.isVarargs()) return false;
            if (!two.isVarargs()) return false;
            if (CompilerOptions.tolerateIllegalAmbiguousVarargsInvocation && this.compilerOptions().complianceLevel < 0x330000L && oneParamsLength > twoParamsLength && ((ArrayBinding)twoParams[twoParamsLength - 1]).elementsType().id != 1) {
                return false;
            }
        } else {
            boolean applyErasure = this.environment().globalOptions.sourceLevel < 0x310000L;
            int i = 0;
            while (i < oneParamsLength) {
                TypeBinding twoParam;
                TypeBinding oneParam = applyErasure ? oneParams[i].erasure() : oneParams[i];
                TypeBinding typeBinding = twoParam = applyErasure ? twoParams[i].erasure() : twoParams[i];
                if (TypeBinding.equalsEquals(oneParam, twoParam) || oneParam.isCompatibleWith(twoParam)) {
                    if (!two.declaringClass.isRawType()) {
                        TypeBinding leafComponentType = two.original().parameters[i].leafComponentType();
                        TypeBinding originalTwoParam = applyErasure ? leafComponentType.erasure() : leafComponentType;
                        block0 : switch (originalTwoParam.kind()) {
                            case 4100: {
                                if (((TypeVariableBinding)originalTwoParam).hasOnlyRawBounds()) break;
                            }
                            case 260: 
                            case 516: 
                            case 8196: {
                                TypeBinding originalOneParam = one.original().parameters[i].leafComponentType();
                                switch (originalOneParam.kind()) {
                                    case 4: 
                                    case 2052: {
                                        TypeBinding inheritedTwoParam = oneParam.findSuperTypeOriginatingFrom(twoParam);
                                        if (inheritedTwoParam == null) break;
                                        if (inheritedTwoParam.leafComponentType().isRawType()) return false;
                                        break block0;
                                    }
                                    case 4100: {
                                        if (((TypeVariableBinding)originalOneParam).upperBound().isRawType()) return false;
                                        break block0;
                                    }
                                    case 1028: {
                                        return false;
                                    }
                                }
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    if (i != oneParamsLength - 1) return false;
                    if (!one.isVarargs()) return false;
                    if (!two.isVarargs()) return false;
                    TypeBinding oType = ((ArrayBinding)oneParam).elementsType();
                    TypeBinding eType = ((ArrayBinding)twoParam).elementsType();
                    if (CompilerOptions.tolerateIllegalAmbiguousVarargsInvocation && this.compilerOptions().complianceLevel < 0x330000L) {
                        if (TypeBinding.equalsEquals(oneParam, eType)) return true;
                        if (!oneParam.isCompatibleWith(eType)) return false;
                        return true;
                    }
                    if (TypeBinding.equalsEquals(oType, eType)) return true;
                    if (!oType.isCompatibleWith(eType)) return false;
                    return true;
                }
                ++i;
            }
            return true;
        }
        int i = (oneParamsLength > twoParamsLength ? twoParamsLength : oneParamsLength) - 2;
        while (true) {
            if (i < 0) {
                if (this.parameterCompatibilityLevel(one, twoParams, true, false) != -1) return false;
                if (this.parameterCompatibilityLevel(two, oneParams, true, false) != 2) return false;
                return true;
            }
            if (TypeBinding.notEquals(oneParams[i], twoParams[i]) && !oneParams[i].isCompatibleWith(twoParams[i])) {
                return false;
            }
            --i;
        }
    }

    public boolean isBoxingCompatibleWith(TypeBinding expressionType, TypeBinding targetType) {
        LookupEnvironment environment = this.environment();
        if (environment.globalOptions.sourceLevel < 0x310000L || expressionType.isBaseType() == targetType.isBaseType()) {
            return false;
        }
        TypeBinding convertedType = environment.computeBoxingType(expressionType);
        return TypeBinding.equalsEquals(convertedType, targetType) || convertedType.isCompatibleWith(targetType, this);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        method = method.original();
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).binding != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (!TypeBinding.equalsEquals(topLevelTypes[i], enclosingType.original())) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || !TypeBinding.equalsEquals(((ClassScope)scope).referenceContext.binding, type)) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                SourceTypeBinding declaringType;
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context;
                    ReferenceContext referenceContext = methodScope.referenceContext;
                    MethodBinding methodBinding = context = referenceContext instanceof AbstractMethodDeclaration ? ((AbstractMethodDeclaration)referenceContext).binding : ((LambdaExpression)referenceContext).binding;
                    if (context != null && context.isViewedAsDeprecated()) {
                        return true;
                    }
                } else if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if ((declaringType = ((BlockScope)this).referenceType().binding) == null) break;
                declaringType.initializeDeprecatedAnnotationTagBits();
                if (!declaringType.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                ((Binding)context).initializeDeprecatedAnnotationTagBits();
                if (!context.isViewedAsDeprecated()) break;
                return true;
            }
            case 4: {
                SourceTypeBinding type;
                CompilationUnitDeclaration unit = this.referenceCompilationUnit();
                if (unit.types == null || unit.types.length <= 0 || (type = unit.types[0].binding) == null) break;
                type.initializeDeprecatedAnnotationTagBits();
                if (!type.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private boolean isOverriddenMethodGeneric(MethodBinding method) {
        MethodVerifier verifier = this.environment().methodVerifier();
        for (ReferenceBinding currentType = method.declaringClass.superclass(); currentType != null; currentType = currentType.superclass()) {
            for (MethodBinding currentMethod : currentType.getMethods(method.selector)) {
                if (currentMethod == null || currentMethod.original().typeVariables == Binding.NO_TYPE_VARIABLES || !verifier.doesMethodOverride(method, currentMethod)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPossibleSubtypeOfRawType(TypeBinding paramType) {
        TypeBinding t = paramType.leafComponentType();
        if (t.isBaseType()) {
            return false;
        }
        ReferenceBinding currentType = (ReferenceBinding)t;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        do {
            if (currentType.isRawType()) {
                return true;
            }
            if (!currentType.isHierarchyConnected()) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block1: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block1;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        } while ((currentType = currentType.superclass()) != null);
        for (int i = 0; i < nextPosition; ++i) {
            currentType = interfacesToVisit[i];
            if (currentType.isRawType()) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block4: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (TypeBinding.equalsEquals(next, interfacesToVisit[b])) continue block4;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding mec, Object invocationData, ArrayList lubStack) {
        if (invocationData == null) {
            return mec;
        }
        if (invocationData instanceof TypeBinding) {
            return (TypeBinding)invocationData;
        }
        TypeBinding[] invocations = (TypeBinding[])invocationData;
        int dim = mec.dimensions();
        int argLength = (mec = mec.leafComponentType()).typeVariables().length;
        if (argLength == 0) {
            return mec;
        }
        TypeBinding[] bestArguments = new TypeBinding[argLength];
        int length = invocations.length;
        block5: for (int i = 0; i < length; ++i) {
            TypeBinding invocation = invocations[i].leafComponentType();
            switch (invocation.kind()) {
                case 2052: {
                    TypeVariableBinding[] invocationVariables = invocation.typeVariables();
                    for (int j = 0; j < argLength; ++j) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[j], invocationVariables[j], (ReferenceBinding)mec, j, (ArrayList)lubStack.clone());
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[j] = bestArgument;
                    }
                    continue block5;
                }
                case 260: {
                    ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)invocation;
                    for (int j = 0; j < argLength; ++j) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[j], parameterizedType.arguments[j], (ReferenceBinding)mec, j, (ArrayList)lubStack.clone());
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[j] = bestArgument;
                    }
                    continue block5;
                }
                case 1028: {
                    return dim == 0 ? invocation : this.environment().createArrayType(invocation, dim);
                }
            }
        }
        ParameterizedTypeBinding least = this.environment().createParameterizedType((ReferenceBinding)mec.erasure(), bestArguments, mec.enclosingType());
        return dim == 0 ? least : this.environment().createArrayType(least, dim);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding u, TypeBinding v, ReferenceBinding genericType, int rank, ArrayList lubStack) {
        if (u == null) {
            return v;
        }
        if (TypeBinding.equalsEquals(u, v)) {
            return u;
        }
        if (v.isWildcard()) {
            WildcardBinding wildV = (WildcardBinding)v;
            if (u.isWildcard()) {
                WildcardBinding wildU = (WildcardBinding)u;
                switch (wildU.boundKind) {
                    case 1: {
                        switch (wildV.boundKind) {
                            case 1: {
                                TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, wildV.bound}, lubStack);
                                if (lub == null) {
                                    return null;
                                }
                                if (TypeBinding.equalsEquals(lub, TypeBinding.INT)) {
                                    return this.environment().createWildcard(genericType, rank, null, null, 0);
                                }
                                return this.environment().createWildcard(genericType, rank, lub, null, 1);
                            }
                            case 2: {
                                if (TypeBinding.equalsEquals(wildU.bound, wildV.bound)) {
                                    return wildU.bound;
                                }
                                return this.environment().createWildcard(genericType, rank, null, null, 0);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (wildU.boundKind != 2) break;
                        TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, wildV.bound}, this, this.environment());
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                    }
                }
            } else {
                switch (wildV.boundKind) {
                    case 1: {
                        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, wildV.bound}, lubStack);
                        if (lub == null) {
                            return null;
                        }
                        if (TypeBinding.equalsEquals(lub, TypeBinding.INT)) {
                            return this.environment().createWildcard(genericType, rank, null, null, 0);
                        }
                        return this.environment().createWildcard(genericType, rank, lub, null, 1);
                    }
                    case 2: {
                        TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{u, wildV.bound}, this, this.environment());
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                    }
                }
            }
        } else if (u.isWildcard()) {
            WildcardBinding wildU = (WildcardBinding)u;
            switch (wildU.boundKind) {
                case 1: {
                    TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, v}, lubStack);
                    if (lub == null) {
                        return null;
                    }
                    if (TypeBinding.equalsEquals(lub, TypeBinding.INT)) {
                        return this.environment().createWildcard(genericType, rank, null, null, 0);
                    }
                    return this.environment().createWildcard(genericType, rank, lub, null, 1);
                }
                case 2: {
                    TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, v}, this, this.environment());
                    if (glb == null) {
                        return null;
                    }
                    return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                }
            }
        }
        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, v}, lubStack);
        if (lub == null) {
            return null;
        }
        if (TypeBinding.equalsEquals(lub, TypeBinding.INT)) {
            return this.environment().createWildcard(genericType, rank, null, null, 0);
        }
        return this.environment().createWildcard(genericType, rank, lub, null, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] types) {
        int typeLength = types.length;
        if (typeLength == 1) {
            TypeBinding type = types[0];
            return type == null ? TypeBinding.VOID : type;
        }
        return this.lowerUpperBound(types, new ArrayList(1));
    }

    private TypeBinding lowerUpperBound(TypeBinding[] types, ArrayList lubStack) {
        int typeLength = types.length;
        if (typeLength == 1) {
            TypeBinding type = types[0];
            return type == null ? TypeBinding.VOID : type;
        }
        int stackLength = lubStack.size();
        block5: for (int i = 0; i < stackLength; ++i) {
            TypeBinding[] lubTypes = (TypeBinding[])lubStack.get(i);
            int lubTypeLength = lubTypes.length;
            if (lubTypeLength < typeLength) continue;
            block6: for (int j = 0; j < typeLength; ++j) {
                TypeBinding type = types[j];
                if (type == null) continue;
                for (int k = 0; k < lubTypeLength; ++k) {
                    TypeBinding lubType = lubTypes[k];
                    if (lubType != null && (TypeBinding.equalsEquals(lubType, type) || lubType.isEquivalentTo(type))) continue block6;
                }
                continue block5;
            }
            return TypeBinding.INT;
        }
        lubStack.add(types);
        HashMap invocations = new HashMap(1);
        TypeBinding[] mecs = this.minimalErasedCandidates(types, invocations);
        if (mecs == null) {
            return null;
        }
        int length = mecs.length;
        if (length == 0) {
            return TypeBinding.VOID;
        }
        int count = 0;
        TypeBinding firstBound = null;
        int commonDim = -1;
        for (int i = 0; i < length; ++i) {
            TypeBinding mec = mecs[i];
            if (mec == null) continue;
            if ((mec = this.leastContainingInvocation(mec, invocations.get(mec), lubStack)) == null) {
                return null;
            }
            int dim = mec.dimensions();
            if (commonDim == -1) {
                commonDim = dim;
            } else if (dim != commonDim) {
                return null;
            }
            if (firstBound == null && !mec.leafComponentType().isInterface()) {
                firstBound = mec.leafComponentType();
            }
            mecs[count++] = mec;
        }
        switch (count) {
            case 0: {
                return TypeBinding.VOID;
            }
            case 1: {
                return mecs[0];
            }
            case 2: {
                if ((commonDim == 0 ? mecs[1].id : mecs[1].leafComponentType().id) == 1) {
                    return mecs[0];
                }
                if ((commonDim == 0 ? mecs[0].id : mecs[0].leafComponentType().id) != 1) break;
                return mecs[1];
            }
        }
        TypeBinding[] otherBounds = new TypeBinding[count - 1];
        int rank = 0;
        for (int i = 0; i < count; ++i) {
            TypeBinding mec;
            TypeBinding typeBinding = mec = commonDim == 0 ? mecs[i] : mecs[i].leafComponentType();
            if (!mec.isInterface()) continue;
            otherBounds[rank++] = mec;
        }
        WildcardBinding intersectionType = this.environment().createWildcard(null, 0, firstBound, otherBounds, 1);
        return commonDim == 0 ? intersectionType : this.environment().createArrayType(intersectionType, commonDim);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final MethodScope namedMethodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope) || scope.isLambdaScope()) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] types, Map allInvocations) {
        int i;
        TypeBinding firstErasure;
        int length = types.length;
        int indexOfFirst = -1;
        int actualLength = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            TypeBinding type = types[i2];
            if (type == TypeBinding.NULL) {
                type = null;
                types[i2] = null;
            }
            if (type == null) continue;
            if (type.isBaseType()) {
                return null;
            }
            if (indexOfFirst < 0) {
                indexOfFirst = i2;
            }
            ++actualLength;
        }
        switch (actualLength) {
            case 0: {
                return Binding.NO_TYPES;
            }
            case 1: {
                return types;
            }
        }
        TypeBinding firstType = types[indexOfFirst];
        if (firstType.isBaseType()) {
            return null;
        }
        ArrayList<TypeBinding> typesToVisit = new ArrayList<TypeBinding>(5);
        int dim = firstType.dimensions();
        TypeBinding leafType = firstType.leafComponentType();
        switch (leafType.kind()) {
            case 68: 
            case 260: 
            case 1028: {
                firstErasure = firstType.erasure();
                break;
            }
            default: {
                firstErasure = firstType;
            }
        }
        if (TypeBinding.notEquals(firstErasure, firstType)) {
            allInvocations.put(firstErasure, firstType);
        }
        typesToVisit.add(firstType);
        int max = 1;
        block12: for (int i3 = 0; i3 < max; ++i3) {
            ReferenceBinding superTypeErasure;
            ReferenceBinding superType;
            ReferenceBinding itsSuperclass;
            TypeBinding firstBound;
            ReferenceBinding currentType;
            TypeBinding typeToVisit = (TypeBinding)typesToVisit.get(i3);
            dim = typeToVisit.dimensions();
            if (dim > 0) {
                leafType = typeToVisit.leafComponentType();
                switch (leafType.id) {
                    case 1: {
                        if (dim > 1) {
                            TypeBinding elementType = ((ArrayBinding)typeToVisit).elementsType();
                            if (typesToVisit.contains(elementType)) continue block12;
                            typesToVisit.add(elementType);
                            ++max;
                            continue block12;
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        ReferenceBinding superType2 = this.getJavaIoSerializable();
                        if (!typesToVisit.contains(superType2)) {
                            typesToVisit.add(superType2);
                            ++max;
                        }
                        if (!typesToVisit.contains(superType2 = this.getJavaLangCloneable())) {
                            typesToVisit.add(superType2);
                            ++max;
                        }
                        if (typesToVisit.contains(superType2 = this.getJavaLangObject())) continue block12;
                        typesToVisit.add(superType2);
                        ++max;
                        continue block12;
                    }
                    default: {
                        typeToVisit = leafType;
                    }
                }
            }
            if ((currentType = (ReferenceBinding)typeToVisit).isCapture() && (firstBound = ((CaptureBinding)currentType).firstBound) != null && firstBound.isArrayType()) {
                TypeBinding superTypeErasure2;
                TypeBinding superType3;
                TypeBinding typeBinding = superType3 = dim == 0 ? firstBound : this.environment().createArrayType(firstBound, dim);
                if (typesToVisit.contains(superType3)) continue;
                typesToVisit.add(superType3);
                ++max;
                TypeBinding typeBinding2 = superTypeErasure2 = firstBound.isTypeVariable() || firstBound.isWildcard() ? superType3 : superType3.erasure();
                if (!TypeBinding.notEquals(superTypeErasure2, superType3)) continue;
                allInvocations.put(superTypeErasure2, superType3);
                continue;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces != null) {
                for (ReferenceBinding itsInterface : itsInterfaces) {
                    ReferenceBinding superTypeErasure3;
                    ReferenceBinding superType4;
                    TypeBinding typeBinding = superType4 = dim == 0 ? itsInterface : this.environment().createArrayType(itsInterface, dim);
                    if (typesToVisit.contains(superType4)) continue;
                    typesToVisit.add(superType4);
                    ++max;
                    TypeBinding typeBinding3 = superTypeErasure3 = itsInterface.isTypeVariable() || itsInterface.isWildcard() ? superType4 : superType4.erasure();
                    if (!TypeBinding.notEquals(superTypeErasure3, superType4)) continue;
                    allInvocations.put(superTypeErasure3, superType4);
                }
            }
            if ((itsSuperclass = currentType.superclass()) == null) continue;
            TypeBinding typeBinding = superType = dim == 0 ? itsSuperclass : this.environment().createArrayType(itsSuperclass, dim);
            if (typesToVisit.contains(superType)) continue;
            typesToVisit.add(superType);
            ++max;
            TypeBinding typeBinding4 = superTypeErasure = itsSuperclass.isTypeVariable() || itsSuperclass.isWildcard() ? superType : superType.erasure();
            if (!TypeBinding.notEquals(superTypeErasure, superType)) continue;
            allInvocations.put(superTypeErasure, superType);
        }
        int superLength = typesToVisit.size();
        TypeBinding[] erasedSuperTypes = new TypeBinding[superLength];
        int rank = 0;
        for (TypeBinding type : typesToVisit) {
            leafType = type.leafComponentType();
            erasedSuperTypes[rank++] = leafType.isTypeVariable() || leafType.isWildcard() ? type : type.erasure();
        }
        int remaining = superLength;
        for (i = indexOfFirst + 1; i < length; ++i) {
            int k;
            int invocLength;
            TypeBinding[] someInvocations;
            Object invocationData;
            TypeBinding match;
            TypeBinding erasedSuperType;
            int j;
            TypeBinding otherType = types[i];
            if (otherType == null) continue;
            if (otherType.isArrayType()) {
                block16: for (j = 0; j < superLength; ++j) {
                    erasedSuperType = erasedSuperTypes[j];
                    if (erasedSuperType == null || TypeBinding.equalsEquals(erasedSuperType, otherType)) continue;
                    match = otherType.findSuperTypeOriginatingFrom(erasedSuperType);
                    if (match == null) {
                        erasedSuperTypes[j] = null;
                        if (--remaining != 0) continue;
                        return null;
                    }
                    invocationData = allInvocations.get(erasedSuperType);
                    if (invocationData == null) {
                        allInvocations.put(erasedSuperType, match);
                        continue;
                    }
                    if (invocationData instanceof TypeBinding) {
                        if (!TypeBinding.notEquals(match, (TypeBinding)invocationData)) continue;
                        someInvocations = new TypeBinding[]{(TypeBinding)invocationData, match};
                        allInvocations.put(erasedSuperType, someInvocations);
                        continue;
                    }
                    someInvocations = (TypeBinding[])invocationData;
                    invocLength = someInvocations.length;
                    for (k = 0; k < invocLength; ++k) {
                        if (TypeBinding.equalsEquals(someInvocations[k], match)) continue block16;
                    }
                    TypeBinding[] typeBindingArray = someInvocations;
                    someInvocations = new TypeBinding[invocLength + 1];
                    System.arraycopy(typeBindingArray, 0, someInvocations, 0, invocLength);
                    allInvocations.put(erasedSuperType, someInvocations);
                    someInvocations[invocLength] = match;
                }
                continue;
            }
            block18: for (j = 0; j < superLength; ++j) {
                erasedSuperType = erasedSuperTypes[j];
                if (erasedSuperType == null) continue;
                if (TypeBinding.equalsEquals(erasedSuperType, otherType) || erasedSuperType.id == 1 && otherType.isInterface()) {
                    match = erasedSuperType;
                } else {
                    match = erasedSuperType.isArrayType() ? null : otherType.findSuperTypeOriginatingFrom(erasedSuperType);
                    if (match == null) {
                        erasedSuperTypes[j] = null;
                        if (--remaining != 0) continue;
                        return null;
                    }
                }
                invocationData = allInvocations.get(erasedSuperType);
                if (invocationData == null) {
                    allInvocations.put(erasedSuperType, match);
                    continue;
                }
                if (invocationData instanceof TypeBinding) {
                    if (!TypeBinding.notEquals(match, (TypeBinding)invocationData)) continue;
                    someInvocations = new TypeBinding[]{(TypeBinding)invocationData, match};
                    allInvocations.put(erasedSuperType, someInvocations);
                    continue;
                }
                someInvocations = (TypeBinding[])invocationData;
                invocLength = someInvocations.length;
                for (k = 0; k < invocLength; ++k) {
                    if (TypeBinding.equalsEquals(someInvocations[k], match)) continue block18;
                }
                TypeBinding[] typeBindingArray = someInvocations;
                someInvocations = new TypeBinding[invocLength + 1];
                System.arraycopy(typeBindingArray, 0, someInvocations, 0, invocLength);
                allInvocations.put(erasedSuperType, someInvocations);
                someInvocations[invocLength] = match;
            }
        }
        if (remaining > 1) {
            for (i = 0; i < superLength; ++i) {
                TypeBinding erasedSuperType = erasedSuperTypes[i];
                if (erasedSuperType == null) continue;
                for (int j = 0; j < superLength; ++j) {
                    TypeBinding otherType;
                    if (i == j || (otherType = erasedSuperTypes[j]) == null) continue;
                    if (erasedSuperType instanceof ReferenceBinding) {
                        if (otherType.id == 1 && erasedSuperType.isInterface() || erasedSuperType.findSuperTypeOriginatingFrom(otherType) == null) continue;
                        erasedSuperTypes[j] = null;
                        --remaining;
                        continue;
                    }
                    if (!erasedSuperType.isArrayType() || otherType.isArrayType() && otherType.leafComponentType().id == 1 && otherType.dimensions() == erasedSuperType.dimensions() && erasedSuperType.leafComponentType().isInterface() || erasedSuperType.findSuperTypeOriginatingFrom(otherType) == null) continue;
                    erasedSuperTypes[j] = null;
                    --remaining;
                }
            }
        }
        return erasedSuperTypes;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding previous = null;
        block0: for (int i = 0; i < visibleSize; ++i) {
            MethodBinding method = visible[i];
            if (previous != null && TypeBinding.notEquals(method.declaringClass, previous.declaringClass)) break;
            if (!method.isStatic()) {
                previous = method;
            }
            for (int j = 0; j < visibleSize; ++j) {
                if (i != j && !visible[j].areParametersCompatibleWith(method.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
            return method;
        }
        return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        block0: for (int i = 0; i < visibleSize; ++i) {
            MethodBinding method = visible[i];
            for (int j = 0; j < visibleSize; ++j) {
                if (i != j && !visible[j].areParametersCompatibleWith(method.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
            return method;
        }
        return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] visible, int visibleSize, TypeBinding[] argumentTypes, final InvocationSite invocationSite, ReferenceBinding receiverType) {
        boolean isJdk18 = this.compilerOptions().sourceLevel >= 0x340000L;
        int[] compatibilityLevels = new int[visibleSize];
        int compatibleCount = 0;
        for (int i = 0; i < visibleSize; ++i) {
            InnerInferenceHelper innerInferenceHelper;
            TypeBinding[] argTypes = argumentTypes;
            if (isJdk18 && invocationSite instanceof Invocation && (innerInferenceHelper = ((Invocation)invocationSite).innerInferenceHelper()) != null) {
                argTypes = innerInferenceHelper.getArgumentTypesForCandidate(visible[i], argumentTypes);
            }
            if ((compatibilityLevels[i] = this.parameterCompatibilityLevel(visible[i], argTypes)) == -1) continue;
            if (i != compatibleCount) {
                visible[compatibleCount] = visible[i];
                compatibilityLevels[compatibleCount] = compatibilityLevels[i];
            }
            ++compatibleCount;
        }
        if (compatibleCount == 0) {
            return new ProblemMethodBinding(visible[0].selector, argumentTypes, 1);
        }
        if (compatibleCount == 1) {
            MethodBinding candidate = this.inferInvocationType(invocationSite, visible[0], argumentTypes);
            if (candidate != null) {
                this.compilationUnitScope().recordTypeReferences(candidate.thrownExceptions);
            }
            return candidate;
        }
        if (compatibleCount != visibleSize) {
            MethodBinding[] methodBindingArray = visible;
            visibleSize = compatibleCount;
            visible = new MethodBinding[visibleSize];
            System.arraycopy(methodBindingArray, 0, visible, 0, compatibleCount);
            int[] nArray = compatibilityLevels;
            compatibilityLevels = new int[compatibleCount];
            System.arraycopy(nArray, 0, compatibilityLevels, 0, compatibleCount);
        }
        MethodBinding[] moreSpecific = new MethodBinding[visibleSize];
        if (isJdk18) {
            int count = 0;
            block1: for (int j = 0; j < visibleSize; ++j) {
                MethodBinding mbj = visible[j].genericMethod();
                TypeBinding[] mbjParameters = mbj.parameters;
                int levelj = compatibilityLevels[j];
                for (int k = 0; k < visibleSize; ++k) {
                    TypeBinding t;
                    TypeBinding s;
                    if (j == k) continue;
                    int levelk = compatibilityLevels[k];
                    if (levelj > -1 && levelk > -1 && levelj != levelk) {
                        if (levelj >= levelk) continue block1;
                        continue;
                    }
                    MethodBinding mbk = visible[k].genericMethod();
                    TypeBinding[] mbkParameters = mbk.parameters;
                    if ((invocationSite instanceof Invocation || invocationSite instanceof ReferenceExpression) && mbk.typeVariables() != Binding.NO_TYPE_VARIABLES) {
                        Expression[] expressions = null;
                        expressions = invocationSite instanceof Invocation ? ((Invocation)invocationSite).arguments() : ((ReferenceExpression)invocationSite).createPseudoExpressions(argumentTypes);
                        InferenceContext18 ic18 = new InferenceContext18(this, expressions, null);
                        if (ic18.isMoreSpecificThan(mbj, mbk, levelj == 2, levelk == 2)) continue;
                        continue block1;
                    }
                    int length = argumentTypes.length;
                    for (int i = 0; i < length; ++i) {
                        TypeBinding t2;
                        TypeBinding argumentType = argumentTypes[i];
                        TypeBinding s2 = InferenceContext18.getParameter(mbjParameters, i, levelj == 2);
                        if (!TypeBinding.equalsEquals(s2, t2 = InferenceContext18.getParameter(mbkParameters, i, levelk == 2)) && !argumentType.sIsMoreSpecific(s2, t2, this)) continue block1;
                    }
                    if (levelj == 2 && levelk == 2 && TypeBinding.notEquals(s = InferenceContext18.getParameter(mbjParameters, argumentTypes.length, true), t = InferenceContext18.getParameter(mbkParameters, argumentTypes.length, true)) && t.isSubtypeOf(s)) continue block1;
                }
                moreSpecific[count++] = visible[j];
            }
            if (count == 0) {
                return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
            }
            if (count == 1) {
                MethodBinding candidate = this.inferInvocationType(invocationSite, moreSpecific[0], argumentTypes);
                if (candidate != null) {
                    this.compilationUnitScope().recordTypeReferences(candidate.thrownExceptions);
                }
                return candidate;
            }
            visibleSize = count;
        } else {
            InvocationSite tieBreakInvocationSite = new InvocationSite(){

                @Override
                public TypeBinding[] genericTypeArguments() {
                    return null;
                }

                @Override
                public boolean isSuperAccess() {
                    return invocationSite.isSuperAccess();
                }

                @Override
                public boolean isTypeAccess() {
                    return invocationSite.isTypeAccess();
                }

                @Override
                public void setActualReceiverType(ReferenceBinding actualReceiverType) {
                }

                @Override
                public void setDepth(int depth) {
                }

                @Override
                public void setFieldIndex(int depth) {
                }

                @Override
                public int sourceStart() {
                    return invocationSite.sourceStart();
                }

                @Override
                public int sourceEnd() {
                    return invocationSite.sourceStart();
                }

                @Override
                public TypeBinding invocationTargetType() {
                    return invocationSite.invocationTargetType();
                }

                @Override
                public boolean receiverIsImplicitThis() {
                    return invocationSite.receiverIsImplicitThis();
                }

                @Override
                public InferenceContext18 freshInferenceContext(Scope scope) {
                    return null;
                }

                @Override
                public ExpressionContext getExpressionContext() {
                    return ExpressionContext.VANILLA_CONTEXT;
                }
            };
            int count = 0;
            int max = 2;
            for (int level = 0; level <= max; ++level) {
                block5: for (int i = 0; i < visibleSize; ++i) {
                    if (compatibilityLevels[i] != level) continue;
                    max = level;
                    MethodBinding current = visible[i];
                    MethodBinding original = current.original();
                    MethodBinding tiebreakMethod = current.tiebreakMethod();
                    for (int j = 0; j < visibleSize; ++j) {
                        MethodBinding acceptable;
                        if (i == j || compatibilityLevels[j] != level) continue;
                        MethodBinding next = visible[j];
                        if (original == next.original()) {
                            compatibilityLevels[j] = -1;
                            continue;
                        }
                        MethodBinding methodToTest = next;
                        if (next instanceof ParameterizedGenericMethodBinding) {
                            ParameterizedGenericMethodBinding pNext = (ParameterizedGenericMethodBinding)next;
                            if (!pNext.isRaw || pNext.isStatic()) {
                                methodToTest = pNext.originalMethod;
                            }
                        }
                        if ((acceptable = this.computeCompatibleMethod(methodToTest, tiebreakMethod.parameters, tieBreakInvocationSite, 2, level == 2)) == null || !acceptable.isValidBinding() || !this.isAcceptableMethod(tiebreakMethod, acceptable) || current.isBridge() && !next.isBridge() && tiebreakMethod.areParametersEqual(acceptable)) continue block5;
                    }
                    moreSpecific[i] = current;
                    ++count;
                }
            }
            if (count == 1) {
                for (int i = 0; i < visibleSize; ++i) {
                    if (moreSpecific[i] == null) continue;
                    MethodBinding candidate = this.inferInvocationType(invocationSite, visible[i], argumentTypes);
                    if (candidate != null) {
                        this.compilationUnitScope().recordTypeReferences(candidate.thrownExceptions);
                    }
                    return candidate;
                }
            } else if (count == 0) {
                return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
            }
        }
        if (receiverType != null) {
            receiverType = receiverType instanceof CaptureBinding ? receiverType : (ReferenceBinding)receiverType.erasure();
        }
        block8: for (int i = 0; i < visibleSize; ++i) {
            MethodBinding current = moreSpecific[i];
            if (current == null) continue;
            Object[] mostSpecificExceptions = null;
            MethodBinding original = current.original();
            boolean shouldIntersectExceptions = original.declaringClass.isAbstract() && original.thrownExceptions != Binding.NO_EXCEPTIONS;
            for (int j = 0; j < visibleSize; ++j) {
                int l;
                MethodBinding next = moreSpecific[j];
                if (next == null || i == j) continue;
                MethodBinding original2 = next.original();
                if (TypeBinding.equalsEquals(original.declaringClass, original2.declaringClass)) break block8;
                if (!original.isAbstract()) {
                    if (original2.isAbstract() || original2.isDefaultMethod() || (original2 = original.findOriginalInheritedMethod(original2)) != null && (!current.hasSubstitutedParameters() && original.typeVariables == Binding.NO_TYPE_VARIABLES || this.environment().methodVerifier().isParameterSubsignature(original, original2))) continue;
                    continue block8;
                }
                if (receiverType == null) continue;
                TypeBinding superType = receiverType.findSuperTypeOriginatingFrom(original.declaringClass.erasure());
                if (!TypeBinding.equalsEquals(original.declaringClass, superType) && superType instanceof ReferenceBinding) {
                    MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(original.selector, argumentTypes.length);
                    l = superMethods.length;
                    for (int m = 0; m < l; ++m) {
                        if (superMethods[m].original() != original) continue;
                        original = superMethods[m];
                        break;
                    }
                }
                if (!TypeBinding.equalsEquals(original2.declaringClass, superType = receiverType.findSuperTypeOriginatingFrom(original2.declaringClass.erasure())) && superType instanceof ReferenceBinding) {
                    MethodBinding[] superMethods = ((ReferenceBinding)superType).getMethods(original2.selector, argumentTypes.length);
                    l = superMethods.length;
                    for (int m = 0; m < l; ++m) {
                        if (superMethods[m].original() != original2) continue;
                        original2 = superMethods[m];
                        break;
                    }
                }
                if (original.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    original2 = original.computeSubstitutedMethod(original2, this.environment());
                }
                if (original2 == null || !original.areParameterErasuresEqual(original2) || TypeBinding.notEquals(original.returnType, original2.returnType) && (next.original().typeVariables == Binding.NO_TYPE_VARIABLES ? !current.returnType.isCompatibleWith(next.returnType) : original.returnType.erasure().findSuperTypeOriginatingFrom(original2.returnType.erasure()) == null)) continue block8;
                if (!shouldIntersectExceptions || !original2.declaringClass.isInterface() || current.thrownExceptions == next.thrownExceptions) continue;
                if (next.thrownExceptions == Binding.NO_EXCEPTIONS) {
                    mostSpecificExceptions = Binding.NO_EXCEPTIONS;
                    continue;
                }
                if (mostSpecificExceptions == null) {
                    mostSpecificExceptions = current.thrownExceptions;
                }
                int mostSpecificLength = mostSpecificExceptions.length;
                ReferenceBinding[] nextExceptions = this.getFilteredExceptions(next);
                int nextLength = nextExceptions.length;
                SimpleSet temp = new SimpleSet(mostSpecificLength);
                boolean changed = false;
                block12: for (int t = 0; t < mostSpecificLength; ++t) {
                    ReferenceBinding exception = mostSpecificExceptions[t];
                    for (int s = 0; s < nextLength; ++s) {
                        ReferenceBinding nextException = nextExceptions[s];
                        if (exception.isCompatibleWith(nextException)) {
                            temp.add(exception);
                            continue block12;
                        }
                        if (nextException.isCompatibleWith(exception)) {
                            temp.add(nextException);
                            changed = true;
                            continue block12;
                        }
                        changed = true;
                    }
                }
                if (!changed) continue;
                mostSpecificExceptions = temp.elementSize == 0 ? Binding.NO_EXCEPTIONS : new ReferenceBinding[temp.elementSize];
                temp.asArray(mostSpecificExceptions);
            }
            if (mostSpecificExceptions != null && mostSpecificExceptions != current.thrownExceptions) {
                return new MostSpecificExceptionMethodBinding(current, (ReferenceBinding[])mostSpecificExceptions);
            }
            return this.inferInvocationType(invocationSite, current, argumentTypes);
        }
        return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
    }

    private ReferenceBinding[] getFilteredExceptions(MethodBinding method) {
        ReferenceBinding[] allExceptions = method.thrownExceptions;
        int length = allExceptions.length;
        if (length < 2) {
            return allExceptions;
        }
        ReferenceBinding[] filteredExceptions = new ReferenceBinding[length];
        int count = 0;
        block0: for (int i = 0; i < length; ++i) {
            ReferenceBinding currentException = allExceptions[i];
            for (int j = 0; j < length; ++j) {
                if (i == j) continue;
                if (TypeBinding.equalsEquals(currentException, allExceptions[j])) {
                    if (i >= j) continue block0;
                    break;
                }
                if (currentException.isCompatibleWith(allExceptions[j])) continue block0;
            }
            filteredExceptions[count++] = currentException;
        }
        if (count != length) {
            ReferenceBinding[] tmp = new ReferenceBinding[count];
            System.arraycopy(filteredExceptions, 0, tmp, 0, count);
            return tmp;
        }
        return allExceptions;
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    public int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments) {
        return this.parameterCompatibilityLevel(method, arguments, false, false);
    }

    public int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments, boolean tiebreakingVarargsMethods, boolean tolerateInferenceVariables) {
        TypeBinding arg;
        TypeBinding[] parameters = method.parameters;
        int paramLength = parameters.length;
        int argLength = arguments.length;
        CompilerOptions compilerOptions = this.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L) {
            if (paramLength != argLength) {
                return -1;
            }
            for (int i = 0; i < argLength; ++i) {
                TypeBinding arg2 = arguments[i];
                TypeBinding param = parameters[i];
                if (!TypeBinding.notEquals(arg2, param) || arg2.isCompatibleWith(param.erasure(), this)) continue;
                return -1;
            }
            return 0;
        }
        if (tiebreakingVarargsMethods && CompilerOptions.tolerateIllegalAmbiguousVarargsInvocation && compilerOptions.complianceLevel < 0x330000L) {
            tiebreakingVarargsMethods = false;
        }
        int level = 0;
        int lastIndex = argLength;
        LookupEnvironment env = this.environment();
        if (method.isVarargs()) {
            TypeBinding param;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                param = parameters[lastIndex];
                TypeBinding arg3 = arguments[lastIndex];
                if (TypeBinding.notEquals(param, arg3) && (level = this.parameterCompatibilityLevel(arg3, param, env, tiebreakingVarargsMethods, tolerateInferenceVariables)) == -1) {
                    param = ((ArrayBinding)param).elementsType();
                    if (tiebreakingVarargsMethods) {
                        arg3 = ((ArrayBinding)arg3).elementsType();
                    }
                    if (this.parameterCompatibilityLevel(arg3, param, env, tiebreakingVarargsMethods, tolerateInferenceVariables) == -1) {
                        return -1;
                    }
                    level = 2;
                }
            } else {
                if (paramLength < argLength) {
                    param = ((ArrayBinding)parameters[lastIndex]).elementsType();
                    for (int i = lastIndex; i < argLength; ++i) {
                        TypeBinding typeBinding = arg = tiebreakingVarargsMethods && i == argLength - 1 ? ((ArrayBinding)arguments[i]).elementsType() : arguments[i];
                        if (!TypeBinding.notEquals(param, arg) || this.parameterCompatibilityLevel(arg, param, env, tiebreakingVarargsMethods, tolerateInferenceVariables) != -1) continue;
                        return -1;
                    }
                } else if (lastIndex != argLength) {
                    return -1;
                }
                level = 2;
            }
        } else if (paramLength != argLength) {
            return -1;
        }
        for (int i = 0; i < lastIndex; ++i) {
            TypeBinding param = parameters[i];
            TypeBinding typeBinding = arg = tiebreakingVarargsMethods && i == argLength - 1 ? ((ArrayBinding)arguments[i]).elementsType() : arguments[i];
            if (!TypeBinding.notEquals(arg, param)) continue;
            int newLevel = this.parameterCompatibilityLevel(arg, param, env, tiebreakingVarargsMethods, tolerateInferenceVariables);
            if (newLevel == -1) {
                return -1;
            }
            if (newLevel <= level) continue;
            level = newLevel;
        }
        return level;
    }

    public int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param) {
        TypeBinding convertedType;
        if (TypeBinding.equalsEquals(arg, param)) {
            return 0;
        }
        if (arg == null || param == null) {
            return -1;
        }
        if (arg.isCompatibleWith(param, this)) {
            return 0;
        }
        if ((arg.kind() == 65540 || arg.isBaseType() != param.isBaseType()) && (TypeBinding.equalsEquals(convertedType = this.environment().computeBoxingType(arg), param) || convertedType.isCompatibleWith(param, this))) {
            return 1;
        }
        return -1;
    }

    private int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param, LookupEnvironment env, boolean tieBreakingVarargsMethods, boolean tolerateInferenceVariables) {
        TypeBinding convertedType;
        if (arg == null || param == null) {
            return -1;
        }
        if (arg.isCompatibleWith(param, this)) {
            return 0;
        }
        if (tieBreakingVarargsMethods && (this.compilerOptions().complianceLevel >= 0x330000L || !CompilerOptions.tolerateIllegalAmbiguousVarargsInvocation)) {
            return -1;
        }
        if ((arg.kind() == 65540 || arg.isBaseType() != param.isBaseType()) && (TypeBinding.equalsEquals(convertedType = env.computeBoxingType(arg), param) || convertedType.isCompatibleWith(param, this))) {
            return 1;
        }
        if (!(!tolerateInferenceVariables || arg.isProperType(false) && param.isProperType(false))) {
            return 0;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    public ReferenceContext originalReferenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    ReferenceContext context = ((MethodScope)current).referenceContext;
                    if (context instanceof LambdaExpression) {
                        LambdaExpression expression = (LambdaExpression)context;
                        while (expression != expression.original) {
                            expression = expression.original;
                        }
                        return expression;
                    }
                    return context;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    public boolean deferCheck(Runnable check) {
        if (this.parent != null) {
            return this.parent.deferCheck(check);
        }
        return false;
    }

    public void deferBoundCheck(TypeReference typeRef) {
        if (this.kind == 3) {
            ClassScope classScope = (ClassScope)this;
            if (classScope.deferredBoundChecks == null) {
                classScope.deferredBoundChecks = new ArrayList(3);
                classScope.deferredBoundChecks.add(typeRef);
            } else if (!classScope.deferredBoundChecks.contains(typeRef)) {
                classScope.deferredBoundChecks.add(typeRef);
            }
        }
    }

    int startIndex() {
        return 0;
    }

    public MethodBinding getStaticFactory(ParameterizedTypeBinding allocationType, ReferenceBinding originalEnclosingType, TypeBinding[] argumentTypes, Invocation allocationSite) {
        ReferenceBinding genericType;
        int classTypeVariablesArity = 0;
        TypeVariableBinding[] classTypeVariables = Binding.NO_TYPE_VARIABLES;
        for (ReferenceBinding currentType = genericType = allocationType.genericType(); currentType != null; currentType = currentType.enclosingType()) {
            int length;
            TypeVariableBinding[] typeVariables = currentType.typeVariables();
            int n = length = typeVariables == null ? 0 : typeVariables.length;
            if (length > 0) {
                TypeVariableBinding[] typeVariableBindingArray = classTypeVariables;
                classTypeVariables = new TypeVariableBinding[classTypeVariablesArity + length];
                System.arraycopy(typeVariableBindingArray, 0, classTypeVariables, 0, classTypeVariablesArity);
                System.arraycopy(typeVariables, 0, classTypeVariables, classTypeVariablesArity, length);
                classTypeVariablesArity += length;
            }
            if (currentType.isStatic()) break;
        }
        MethodBinding[] methods = genericType.getMethods(TypeConstants.INIT, argumentTypes.length);
        MethodBinding[] staticFactories = new MethodBinding[methods.length];
        int sfi = 0;
        int length = methods.length;
        for (int i = 0; i < length; ++i) {
            int j;
            MethodBinding method = methods[i];
            if (!method.canBeSeenBy(allocationSite, this)) continue;
            int paramLength = method.parameters.length;
            boolean isVarArgs = method.isVarargs();
            if (argumentTypes.length != paramLength && (!isVarArgs || argumentTypes.length < paramLength - 1)) continue;
            TypeVariableBinding[] methodTypeVariables = method.typeVariables();
            int methodTypeVariablesArity = methodTypeVariables.length;
            int factoryArity = classTypeVariablesArity + methodTypeVariablesArity;
            LookupEnvironment environment = this.environment();
            SyntheticFactoryMethodBinding staticFactory = new SyntheticFactoryMethodBinding(method, environment, originalEnclosingType);
            staticFactory.typeVariables = new TypeVariableBinding[factoryArity];
            final SimpleLookupTable map = new SimpleLookupTable(factoryArity);
            String prime = "";
            Binding declaringElement = null;
            for (j = 0; j < classTypeVariablesArity; ++j) {
                TypeVariableBinding original = classTypeVariables[j];
                if (original.declaringElement != declaringElement) {
                    declaringElement = original.declaringElement;
                    prime = prime + "'";
                }
                staticFactory.typeVariables[j] = new TypeVariableBinding(CharOperation.concat(original.sourceName, prime.toCharArray()), staticFactory, j, environment);
                map.put(original, staticFactory.typeVariables[j]);
            }
            prime = prime + "'";
            j = classTypeVariablesArity;
            int k = 0;
            while (j < factoryArity) {
                staticFactory.typeVariables[j] = new TypeVariableBinding(CharOperation.concat(methodTypeVariables[k].sourceName, prime.toCharArray()), staticFactory, j, environment);
                map.put(methodTypeVariables[k], staticFactory.typeVariables[j]);
                ++j;
                ++k;
            }
            final Scope scope = this;
            Substitution substitution = new Substitution(){

                @Override
                public LookupEnvironment environment() {
                    return scope.environment();
                }

                @Override
                public boolean isRawSubstitution() {
                    return false;
                }

                @Override
                public TypeBinding substitute(TypeVariableBinding typeVariable) {
                    TypeBinding retVal = (TypeBinding)map.get(typeVariable);
                    return retVal == null ? typeVariable : (typeVariable.hasTypeAnnotations() ? this.environment().createAnnotatedType(retVal, typeVariable.getTypeAnnotations()) : retVal);
                }
            };
            block7: for (int j2 = 0; j2 < factoryArity; ++j2) {
                TypeVariableBinding originalVariable = j2 < classTypeVariablesArity ? classTypeVariables[j2] : methodTypeVariables[j2 - classTypeVariablesArity];
                TypeVariableBinding substitutedVariable = (TypeVariableBinding)map.get(originalVariable);
                TypeBinding substitutedSuperclass = Scope.substitute(substitution, originalVariable.superclass);
                ReferenceBinding[] substitutedInterfaces = Scope.substitute(substitution, originalVariable.superInterfaces);
                if (originalVariable.firstBound != null) {
                    TypeBinding firstBound = TypeBinding.equalsEquals(originalVariable.firstBound, originalVariable.superclass) ? substitutedSuperclass : substitutedInterfaces[0];
                    substitutedVariable.setFirstBound(firstBound);
                }
                switch (substitutedSuperclass.kind()) {
                    case 68: {
                        substitutedVariable.setSuperClass(environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null));
                        substitutedVariable.setSuperInterfaces(substitutedInterfaces);
                        continue block7;
                    }
                    default: {
                        if (substitutedSuperclass.isInterface()) {
                            substitutedVariable.setSuperClass(environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null));
                            int interfaceCount = substitutedInterfaces.length;
                            ReferenceBinding[] referenceBindingArray = substitutedInterfaces;
                            substitutedInterfaces = new ReferenceBinding[interfaceCount + 1];
                            System.arraycopy(referenceBindingArray, 0, substitutedInterfaces, 1, interfaceCount);
                            substitutedInterfaces[0] = (ReferenceBinding)substitutedSuperclass;
                            substitutedVariable.setSuperInterfaces(substitutedInterfaces);
                            continue block7;
                        }
                        substitutedVariable.setSuperClass((ReferenceBinding)substitutedSuperclass);
                        substitutedVariable.setSuperInterfaces(substitutedInterfaces);
                    }
                }
            }
            staticFactory.returnType = environment.createParameterizedType(genericType, Scope.substitute(substitution, genericType.typeVariables()), originalEnclosingType);
            staticFactory.parameters = Scope.substitute(substitution, method.parameters);
            staticFactory.thrownExceptions = Scope.substitute(substitution, method.thrownExceptions);
            if (staticFactory.thrownExceptions == null) {
                staticFactory.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
            staticFactories[sfi++] = new ParameterizedMethodBinding((ParameterizedTypeBinding)environment.convertToParameterizedType(staticFactory.declaringClass), staticFactory);
        }
        if (sfi == 0) {
            return null;
        }
        if (sfi != methods.length) {
            MethodBinding[] methodBindingArray = staticFactories;
            staticFactories = new MethodBinding[sfi];
            System.arraycopy(methodBindingArray, 0, staticFactories, 0, sfi);
        }
        MethodBinding[] compatible = new MethodBinding[sfi];
        int compatibleIndex = 0;
        for (int i = 0; i < sfi; ++i) {
            MethodBinding compatibleMethod = this.computeCompatibleMethod(staticFactories[i], argumentTypes, allocationSite, 1);
            if (compatibleMethod == null || !compatibleMethod.isValidBinding()) continue;
            compatible[compatibleIndex++] = compatibleMethod;
        }
        if (compatibleIndex == 0) {
            return null;
        }
        if (compatibleIndex == 1) {
            compatible[0] = this.inferInvocationType(allocationSite, compatible[0], argumentTypes);
        }
        return compatibleIndex == 1 ? compatible[0] : this.mostSpecificMethodBinding(compatible, compatibleIndex, argumentTypes, allocationSite, allocationType);
    }

    public boolean validateNullAnnotation(long tagBits, TypeReference typeRef, Annotation[] annotations) {
        TypeBinding type;
        long nullAnnotationTagBit = tagBits & 0x180000000000000L;
        if (nullAnnotationTagBit != 0L && (type = typeRef.resolvedType) != null && type.isBaseType()) {
            if (typeRef.resolvedType.id != 6 || this.compilerOptions().sourceLevel < 0x340000L) {
                this.problemReporter().illegalAnnotationForBaseType(typeRef, annotations, nullAnnotationTagBit);
            }
            return false;
        }
        return true;
    }

    public abstract boolean hasDefaultNullnessFor(int var1);

    public static BlockScope typeAnnotationsResolutionScope(Scope scope) {
        BlockScope resolutionScope = null;
        switch (scope.kind) {
            case 3: {
                resolutionScope = ((ClassScope)scope).referenceContext.staticInitializerScope;
                break;
            }
            case 1: 
            case 2: {
                resolutionScope = (BlockScope)scope;
            }
        }
        return resolutionScope;
    }

    public void tagAsAccessingEnclosingInstanceStateOf(ReferenceBinding enclosingType, boolean typeVariableAccess) {
        MethodBinding enclosingMethod;
        MethodScope methodScope = this.methodScope();
        if (methodScope != null && methodScope.referenceContext instanceof TypeDeclaration && !methodScope.enclosingReceiverType().isCompatibleWith(enclosingType)) {
            methodScope = methodScope.enclosingMethodScope();
        }
        MethodBinding methodBinding = enclosingMethod = enclosingType != null ? enclosingType.enclosingMethod() : null;
        while (methodScope != null) {
            TypeDeclaration type;
            ClassScope enclosingClassScope;
            while (methodScope != null && methodScope.referenceContext instanceof LambdaExpression) {
                LambdaExpression lambda = (LambdaExpression)methodScope.referenceContext;
                if (!typeVariableAccess) {
                    lambda.shouldCaptureInstance = true;
                }
                methodScope = methodScope.enclosingMethodScope();
            }
            if (methodScope == null) continue;
            if (methodScope.referenceContext instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)methodScope.referenceContext;
                if (methodDeclaration.binding == enclosingMethod) break;
                methodDeclaration.bits &= 0xFFFFFEFF;
            }
            if ((enclosingClassScope = methodScope.enclosingClassScope()) == null || (type = enclosingClassScope.referenceContext) == null || type.binding == null || enclosingType == null || type.binding.isCompatibleWith(enclosingType.original())) break;
            methodScope = enclosingClassScope.enclosingMethodScope();
        }
    }

    protected MethodBinding inferInvocationType(InvocationSite invocationSite, MethodBinding applicable, TypeBinding[] argumentTypes) {
        if (invocationSite instanceof Invocation) {
            Invocation invocation = (Invocation)invocationSite;
            if (applicable instanceof ParameterizedGenericMethodBinding) {
                ParameterizedGenericMethodBinding parameterizedMethod = (ParameterizedGenericMethodBinding)applicable;
                InferenceContext18 infCtx18 = invocation.getInferenceContext(parameterizedMethod);
                if (infCtx18 != null && !infCtx18.hasResultFor(invocation.invocationTargetType())) {
                    return infCtx18.inferInvocationType(invocation, argumentTypes, parameterizedMethod);
                }
            } else {
                ASTNode.resolvePolyExpressionArguments(invocation, applicable, argumentTypes, this);
            }
        } else if (invocationSite instanceof ReferenceExpression) {
            if (applicable instanceof ParameterizedGenericMethodBinding) {
                applicable = applicable.shallowOriginal();
            }
            if (applicable.typeVariables() != Binding.NO_TYPE_VARIABLES) {
                return ParameterizedGenericMethodBinding.computeCompatibleMethod(applicable, argumentTypes, this, invocationSite, 3);
            }
        }
        return applicable;
    }

    class MethodClashException
    extends RuntimeException {
        private static final long serialVersionUID = -7996779527641476028L;

        MethodClashException() {
        }
    }

    public static class Substitutor {
        public ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] originalTypes) {
            if (originalTypes == null) {
                return null;
            }
            ReferenceBinding[] substitutedTypes = originalTypes;
            int length = originalTypes.length;
            for (int i = 0; i < length; ++i) {
                ReferenceBinding originalType = originalTypes[i];
                TypeBinding substitutedType = this.substitute(substitution, originalType);
                if (!(substitutedType instanceof ReferenceBinding)) {
                    return null;
                }
                if (substitutedType != originalType) {
                    if (substitutedTypes == originalTypes) {
                        substitutedTypes = new ReferenceBinding[length];
                        System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                    }
                    substitutedTypes[i] = (ReferenceBinding)substitutedType;
                    continue;
                }
                if (substitutedTypes == originalTypes) continue;
                substitutedTypes[i] = originalType;
            }
            return substitutedTypes;
        }

        public TypeBinding substitute(Substitution substitution, TypeBinding originalType) {
            if (originalType == null) {
                return null;
            }
            switch (originalType.kind()) {
                case 4100: {
                    return substitution.substitute((TypeVariableBinding)originalType);
                }
                case 260: {
                    TypeBinding[] originalArguments;
                    ReferenceBinding originalEnclosing;
                    ParameterizedTypeBinding originalParameterizedType = (ParameterizedTypeBinding)originalType;
                    ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                    if (originalEnclosing != null && Substitutor.isMemberTypeOfRaw(originalType, substitutedEnclosing = (ReferenceBinding)this.substitute(substitution, originalEnclosing))) {
                        return originalParameterizedType.environment.createRawType(originalParameterizedType.genericType(), substitutedEnclosing, originalType.getTypeAnnotations());
                    }
                    TypeBinding[] substitutedArguments = originalArguments = originalParameterizedType.arguments;
                    if (originalArguments != null) {
                        if (substitution.isRawSubstitution()) {
                            return originalParameterizedType.environment.createRawType(originalParameterizedType.genericType(), substitutedEnclosing, originalType.getTypeAnnotations());
                        }
                        substitutedArguments = this.substitute(substitution, originalArguments);
                    }
                    if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) break;
                    return originalParameterizedType.environment.createParameterizedType(originalParameterizedType.genericType(), substitutedArguments, substitutedEnclosing, originalType.getTypeAnnotations());
                }
                case 68: {
                    ArrayBinding originalArrayType = (ArrayBinding)originalType;
                    TypeBinding originalLeafComponentType = originalArrayType.leafComponentType;
                    TypeBinding substitute = this.substitute(substitution, originalLeafComponentType);
                    if (substitute == originalLeafComponentType) break;
                    return originalArrayType.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalType.dimensions(), originalType.getTypeAnnotations());
                }
                case 516: 
                case 8196: {
                    WildcardBinding wildcard = (WildcardBinding)originalType;
                    if (wildcard.boundKind == 0) break;
                    TypeBinding originalBound = wildcard.bound;
                    TypeBinding substitutedBound = this.substitute(substitution, originalBound);
                    TypeBinding[] originalOtherBounds = wildcard.otherBounds;
                    TypeBinding[] substitutedOtherBounds = this.substitute(substitution, originalOtherBounds);
                    if (substitutedBound == originalBound && originalOtherBounds == substitutedOtherBounds) break;
                    if (originalOtherBounds != null) {
                        TypeBinding[] bounds = new TypeBinding[1 + substitutedOtherBounds.length];
                        bounds[0] = substitutedBound;
                        System.arraycopy(substitutedOtherBounds, 0, bounds, 1, substitutedOtherBounds.length);
                        TypeBinding[] glb = Scope.greaterLowerBound(bounds, null, substitution.environment());
                        if (glb != null && glb != bounds) {
                            substitutedBound = glb[0];
                            if (glb.length == 1) {
                                substitutedOtherBounds = null;
                            } else {
                                substitutedOtherBounds = new TypeBinding[glb.length - 1];
                                System.arraycopy(glb, 1, substitutedOtherBounds, 0, glb.length - 1);
                            }
                        }
                    }
                    return wildcard.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, substitutedOtherBounds, wildcard.boundKind, wildcard.getTypeAnnotations());
                }
                case 4: {
                    ReferenceBinding originalEnclosing;
                    if (!originalType.isMemberType()) break;
                    ReferenceBinding originalReferenceType = (ReferenceBinding)originalType;
                    ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                    if (originalEnclosing != null && Substitutor.isMemberTypeOfRaw(originalType, substitutedEnclosing = (ReferenceBinding)this.substitute(substitution, originalEnclosing))) {
                        return substitution.environment().createRawType(originalReferenceType, substitutedEnclosing, originalType.getTypeAnnotations());
                    }
                    if (substitutedEnclosing == originalEnclosing) break;
                    return substitution.isRawSubstitution() ? substitution.environment().createRawType(originalReferenceType, substitutedEnclosing, originalType.getTypeAnnotations()) : substitution.environment().createParameterizedType(originalReferenceType, null, substitutedEnclosing, originalType.getTypeAnnotations());
                }
                case 2052: {
                    ReferenceBinding originalEnclosing;
                    ReferenceBinding originalReferenceType = (ReferenceBinding)originalType;
                    ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                    if (originalEnclosing != null && Substitutor.isMemberTypeOfRaw(originalType, substitutedEnclosing = (ReferenceBinding)(originalType.isStatic() ? substitution.environment().convertToRawType(originalEnclosing, true) : (ReferenceBinding)this.substitute(substitution, originalEnclosing)))) {
                        return substitution.environment().createRawType(originalReferenceType, substitutedEnclosing, originalType.getTypeAnnotations());
                    }
                    if (substitution.isRawSubstitution()) {
                        return substitution.environment().createRawType(originalReferenceType, substitutedEnclosing, originalType.getTypeAnnotations());
                    }
                    TypeBinding[] originalArguments = originalReferenceType.typeVariables();
                    TypeBinding[] substitutedArguments = this.substitute(substitution, originalArguments);
                    return substitution.environment().createParameterizedType(originalReferenceType, substitutedArguments, substitutedEnclosing, originalType.getTypeAnnotations());
                }
            }
            return originalType;
        }

        private static boolean isMemberTypeOfRaw(TypeBinding originalType, ReferenceBinding substitutedEnclosing) {
            return substitutedEnclosing != null && substitutedEnclosing.isRawType() && originalType instanceof ReferenceBinding && !((ReferenceBinding)originalType).isStatic();
        }

        public TypeBinding[] substitute(Substitution substitution, TypeBinding[] originalTypes) {
            if (originalTypes == null) {
                return null;
            }
            TypeBinding[] substitutedTypes = originalTypes;
            int length = originalTypes.length;
            for (int i = 0; i < length; ++i) {
                TypeBinding originalType = originalTypes[i];
                TypeBinding substitutedParameter = this.substitute(substitution, originalType);
                if (substitutedParameter != originalType) {
                    if (substitutedTypes == originalTypes) {
                        substitutedTypes = new TypeBinding[length];
                        System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                    }
                    substitutedTypes[i] = substitutedParameter;
                    continue;
                }
                if (substitutedTypes == originalTypes) continue;
                substitutedTypes[i] = originalType;
            }
            return substitutedTypes;
        }
    }
}

