/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CGFunctionCallbacks;
import org.eclipse.swt.internal.carbon.CGPatternCallbacks;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public class Pattern
extends Resource {
    int jniRef;
    Image image;
    Color color1;
    Color color2;
    int alpha1;
    int alpha2;
    float x1;
    float y1;
    float x2;
    float y2;
    int shading;
    CGRect drawRect;

    public Pattern(Device device, Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        this.image = image;
        device.createPatternCallbacks();
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (color1 == null) {
            SWT.error(4);
        }
        if (color1.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color1 = color1;
        this.color2 = color2;
        this.alpha1 = alpha1;
        this.alpha2 = alpha2;
        device.createPatternCallbacks();
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        CGPoint start = new CGPoint();
        start.x = x1;
        start.y = y1;
        CGPoint end = new CGPoint();
        end.x = x2;
        end.y = y2;
        CGFunctionCallbacks fCallbacks = new CGFunctionCallbacks();
        fCallbacks.evaluate = device.axialShadingProc;
        int function = OS.CGFunctionCreate(this.jniRef, 1, new float[]{0.0f, 1.0f}, 4, new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f}, fCallbacks);
        if (function == 0) {
            SWT.error(2);
        }
        this.shading = OS.CGShadingCreateAxial(device.colorspace, start, end, function, true, true);
        OS.CGFunctionRelease(function);
        if (this.shading == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int axialShadingProc(int ref, int in, int out) {
        float[] buffer = new float[4];
        OS.memcpy(buffer, in, 4);
        float factor2 = buffer[0];
        float factor1 = 1.0f - factor2;
        float[] c1 = this.color1.handle;
        float[] c2 = this.color2.handle;
        float a1 = (float)(this.alpha1 & 0xFF) / 255.0f;
        float a2 = (float)(this.alpha2 & 0xFF) / 255.0f;
        buffer[0] = c2[0] * factor2 + c1[0] * factor1;
        buffer[1] = c2[1] * factor2 + c1[1] * factor1;
        buffer[2] = c2[2] * factor2 + c1[2] * factor1;
        buffer[3] = a2 * factor2 + a1 * factor1;
        OS.memcpy(out, buffer, buffer.length * 4);
        return 0;
    }

    int createPattern(int context) {
        float[] transform = new float[6];
        OS.CGContextGetCTM(context, transform);
        CGRect rect = new CGRect();
        if (this.image != null) {
            int imageHandle = this.image.handle;
            rect.width = OS.CGImageGetWidth(imageHandle);
            rect.height = OS.CGImageGetHeight(imageHandle);
        } else {
            rect.x = this.x1 - 0.5f;
            rect.y = this.y1 - 0.5f;
            rect.width = this.x2 - this.x1 + 1.0f;
            rect.height = this.y2 - this.y1 + 1.0f;
        }
        CGPatternCallbacks callbacks = new CGPatternCallbacks();
        callbacks.drawPattern = this.device.drawPatternProc;
        int pattern = OS.CGPatternCreate(this.jniRef, rect, transform, rect.width, rect.height, 0, 0, callbacks);
        if (pattern == 0) {
            SWT.error(2);
        }
        return pattern;
    }

    public void dispose() {
        if (this.jniRef == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        if (this.shading != 0) {
            OS.CGShadingRelease(this.shading);
        }
        this.shading = 0;
        this.jniRef = 0;
        this.image = null;
        this.color2 = null;
        this.color1 = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    int drawPatternProc(int ref, int context) {
        if (this.image != null) {
            if (this.image.isDisposed()) {
                return 0;
            }
            int imageHandle = this.image.handle;
            int imageWidth = OS.CGImageGetWidth(imageHandle);
            int imageHeight = OS.CGImageGetHeight(imageHandle);
            CGRect rect = new CGRect();
            rect.width = imageWidth;
            rect.height = imageHeight;
            OS.CGContextScaleCTM(context, 1.0f, -1.0f);
            if (this.drawRect != null && this.drawRect.x % (float)imageWidth + this.drawRect.width < (float)imageWidth && this.drawRect.y % (float)imageHeight + this.drawRect.height < (float)imageHeight) {
                rect.x = this.drawRect.x % (float)imageWidth;
                rect.y = this.drawRect.y % (float)imageHeight;
                rect.width = this.drawRect.width;
                rect.height = this.drawRect.height;
                if (OS.VERSION >= 4160) {
                    imageHandle = OS.CGImageCreateWithImageInRect(imageHandle, rect);
                } else {
                    int srcX = (int)this.drawRect.x;
                    int srcY = (int)this.drawRect.y;
                    int srcWidth = (int)this.drawRect.width;
                    int srcHeight = (int)this.drawRect.height;
                    int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
                    int bpp = OS.CGImageGetBitsPerPixel(imageHandle);
                    int bpr = OS.CGImageGetBytesPerRow(imageHandle);
                    int colorspace = OS.CGImageGetColorSpace(imageHandle);
                    int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
                    int data = this.image.data + srcY * bpr + srcX * 4;
                    int provider = OS.CGDataProviderCreateWithData(0, data, srcHeight * bpr, 0);
                    if (provider != 0) {
                        imageHandle = OS.CGImageCreate(srcWidth, srcHeight, bpc, bpp, bpr, colorspace, alphaInfo, provider, null, true, 0);
                        OS.CGDataProviderRelease(provider);
                    }
                }
            }
            OS.CGContextTranslateCTM(context, 0.0f, -(rect.height + 2.0f * rect.y));
            OS.CGContextDrawImage(context, rect, imageHandle);
            if (imageHandle != 0 && imageHandle != this.image.handle) {
                OS.CGImageRelease(imageHandle);
            }
        } else {
            OS.CGContextDrawShading(context, this.shading);
        }
        return 0;
    }

    public boolean isDisposed() {
        return this.jniRef == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.jniRef + "}";
    }
}

