/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ButtonRecord {
    public static final int BUTTON_HITTEST = 8;
    public static final int BUTTON_DOWN = 4;
    public static final int BUTTON_OVER = 2;
    public static final int BUTTON_UP = 1;
    protected int flags;
    protected int id;
    protected int layer;
    protected Matrix matrix;

    public int getCharId() {
        return this.id;
    }

    public int getLayer() {
        return this.layer;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isHitTest() {
        return (this.flags & 8) != 0;
    }

    public boolean isDown() {
        return (this.flags & 4) != 0;
    }

    public boolean isOver() {
        return (this.flags & 2) != 0;
    }

    public boolean isUp() {
        return (this.flags & 1) != 0;
    }

    public void setCharId(int n) {
        this.id = n;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public static Vector read(InStream inStream) throws IOException {
        Vector<ButtonRecord> vector = new Vector<ButtonRecord>();
        int n = 0;
        while ((n = inStream.readUI8()) != 0) {
            vector.addElement(new ButtonRecord(inStream, n));
        }
        return vector;
    }

    public static void write(OutStream outStream, Vector vector) throws IOException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ButtonRecord buttonRecord = (ButtonRecord)enumeration.nextElement();
            buttonRecord.write(outStream);
        }
        outStream.writeUI8(0);
    }

    public ButtonRecord(int n, int n2, Matrix matrix, int n3) {
        this.id = n;
        this.layer = n2;
        this.matrix = matrix;
        this.flags = n3;
    }

    protected ButtonRecord(InStream inStream, int n) throws IOException {
        this.flags = n;
        this.id = inStream.readUI16();
        this.layer = inStream.readUI16();
        this.matrix = new Matrix(inStream);
    }

    protected void write(OutStream outStream) throws IOException {
        outStream.writeUI8(this.flags);
        outStream.writeUI16(this.id);
        outStream.writeUI16(this.layer);
        this.matrix.write(outStream);
    }

    public String toString() {
        return "layer=" + this.layer + " id=" + this.id + " flags=" + Integer.toBinaryString(this.flags) + " " + this.matrix;
    }
}

