/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class InStream {
    protected InputStream in;
    protected long bytesRead = 0L;
    private static final int MAX_TRANSFER_BUFFER_SIZE = 10000;
    protected int bitBuf;
    protected int bitPos;

    public InStream(InputStream inputStream) {
        this.in = inputStream;
        this.synchBits();
    }

    public InStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray));
    }

    public void readCompressed() {
        this.in = new InflaterInputStream(this.in);
    }

    public void transfer(OutputStream outputStream, int n) throws IOException {
        int n2;
        int n3 = n < 10000 ? n : 10000;
        byte[] byArray = new byte[n3];
        while ((n2 = this.in.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public byte[] readStringBytes() throws IOException {
        this.synchBits();
        Vector<Byte> vector = new Vector<Byte>();
        byte[] byArray = new byte[1];
        int n = 0;
        while ((n = this.in.read(byArray)) == 1) {
            ++this.bytesRead;
            if (byArray[0] == 0) {
                byte[] byArray2 = new byte[vector.size()];
                int n2 = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    byArray2[n2++] = (Byte)enumeration.nextElement();
                }
                return byArray2;
            }
            vector.addElement(new Byte(byArray[0]));
        }
        throw new EOFException("Unterminated string - reached end of input before null char");
    }

    public String readString(String string) throws IOException {
        return new String(this.readStringBytes(), string);
    }

    public byte[] read() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = this.in.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (n > 0) {
            int n2;
            int n3;
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = this.in.read(byArray, n2, n - n2);
                if (n3 >= 0) continue;
                this.bytesRead += (long)n2;
                throw new EOFException("Unexpected end of input while reading a specified number of bytes");
            }
            this.bytesRead += (long)n2;
        }
        return byArray;
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > 0) {
            int n2;
            int n3;
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = this.in.read(byArray, n2, n - n2);
                if (n3 >= 0) continue;
                this.bytesRead += (long)n2;
                return n2;
            }
            this.bytesRead += (long)n2;
            return n2;
        }
        return 0;
    }

    public void synchBits() {
        this.bitBuf = 0;
        this.bitPos = 0;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long l) {
        this.bytesRead = l;
    }

    public void skipBytes(long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            int n = this.in.read();
            if (n >= 0) continue;
            throw new EOFException("Unexpected end of input");
        }
        this.bytesRead += l;
    }

    public long readUBits(int n) throws IOException {
        int n2;
        if (n == 0) {
            return 0L;
        }
        int n3 = n;
        long l = 0L;
        if (this.bitPos == 0) {
            this.bitBuf = this.in.read();
            this.bitPos = 8;
            ++this.bytesRead;
        }
        while ((n2 = n3 - this.bitPos) > 0) {
            l |= (long)(this.bitBuf << n2);
            n3 -= this.bitPos;
            this.bitBuf = this.in.read();
            this.bitPos = 8;
            ++this.bytesRead;
        }
        this.bitPos -= n3;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return l |= (long)(this.bitBuf >> -n2);
    }

    public int readUI8() throws IOException {
        this.synchBits();
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of input");
        }
        ++this.bytesRead;
        return n;
    }

    public int readUI16() throws IOException {
        this.synchBits();
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of input");
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("Unexpected end of input");
        }
        this.bytesRead += 2L;
        return n += n2 << 8;
    }

    public short readSI16() throws IOException {
        this.synchBits();
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of input");
        }
        byte[] byArray = new byte[1];
        int n2 = this.in.read(byArray);
        if (n2 < 1) {
            throw new EOFException("Unexpected end of input");
        }
        this.bytesRead += 2L;
        return (short)(byArray[0] * 256 + n);
    }

    public long readUI32() throws IOException {
        this.synchBits();
        long l = this.in.read();
        if (l < 0L) {
            throw new EOFException("Unexpected end of input");
        }
        long l2 = this.in.read();
        if (l2 < 0L) {
            throw new EOFException("Unexpected end of input");
        }
        l += l2 << 8;
        l2 = this.in.read();
        if (l2 < 0L) {
            throw new EOFException("Unexpected end of input");
        }
        l += l2 << 16;
        l2 = this.in.read();
        if (l2 < 0L) {
            throw new EOFException("Unexpected end of input");
        }
        this.bytesRead += 4L;
        return l += l2 << 24;
    }

    public int readSBits(int n) throws IOException {
        long l = this.readUBits(n);
        if ((l & 1L << n - 1) != 0L) {
            l |= -1L << n;
        }
        return (int)l;
    }

    public int readSI32() throws IOException {
        this.synchBits();
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of input");
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("Unexpected end of input");
        }
        int n3 = this.in.read();
        if (n3 < 0) {
            throw new EOFException("Unexpected end of input");
        }
        byte[] byArray = new byte[1];
        int n4 = this.in.read(byArray);
        if (n4 < 1) {
            throw new EOFException("Unexpected end of input");
        }
        this.bytesRead += 4L;
        return byArray[0] * 256 * 256 * 256 + n3 * 256 * 256 + n2 * 256 + n;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readSI32());
    }

    public double readDouble() throws IOException {
        byte[] byArray = this.read(8);
        byte[] byArray2 = new byte[]{byArray[3], byArray[2], byArray[1], byArray[0], byArray[7], byArray[6], byArray[5], byArray[4]};
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return new DataInputStream(byteArrayInputStream).readDouble();
    }

    public static int ubyteToInt(byte n) {
        boolean bl = n < 0;
        int n2 = n = (byte)(n & 0x7F);
        if (bl) {
            n2 += 128;
        }
        return n2;
    }

    public static int bytesToSigned(byte by, byte by2) {
        int n = InStream.ubyteToInt(by);
        int n2 = InStream.ubyteToInt(by2);
        int n3 = (n2 << 8) + n;
        if (n3 > Short.MAX_VALUE) {
            n3 -= 65536;
        }
        return n3;
    }
}

