# ----------------------------------------------------------------------------
# NOTE NOTE NOTE!
# This script is out of date.  We now require Ant support so that we can
# compile JSPs in hosted mode.  We need to modify this to include:
# 
# org.eclipse.jdt.core.JDTCompilerAdapter
# org.eclipse.jdt.internal.antadapter.*
#
# Also, it's worth noting that Eclipse now offers a "JDT Core Batch Compiler".
# We should look at using this standalone compiler as-is.  Example:
# http://download.eclipse.org/eclipse/downloads/drops/R-3.4.2-200902111700/index.php#JDTCORE
#
# Other things we have to do when updating JDT:
# - Update all overrides of CompilerImpl.process()
# - Update any shadowed JDT classes
# - Check to see if there are new JDT compiler options to tweak
# ----------------------------------------------------------------------------
#
# update-jdt.py
#
# This script is used to massage a JDT jar from Eclipse
# for inclusion in the GWT tools repository.
# It strips out files that are not needed and adds a version.txt
# file.
#
# Run it as:
#
# python update-jdt.py jarfile sourcefile

import re
import sys
import zipfile

print "This script is out of date, see note at top!"
print "(Remove these lines if you really know what you're doing)"
sys.exit(1)

# White listing
jarWhitelist = [
    "about.html",
    "org/eclipse/jdt/core/compiler",
    "org/eclipse/jdt/internal/compiler",
    "org/eclipse/jdt/internal/core/util"
]

def whitelistAllows(filename):
    for start in jarWhitelist:
        if filename.startswith(start):
            return True
    return False


# Parse arguments
if len(sys.argv) != 3:
    print "Usage: python update-jdt.py org.eclipse.jdt.core_N.N.N.v_NNN_RNNx.jar org.eclipse.jdt.core.source_N.N.N.v_NNN_RNNx.jar"
    sys.exit(1)

jdtjar = sys.argv[1]
srcjar = sys.argv[2]

print "JDT jar: " + jdtjar
print "source jar: " + srcjar


# extract versions from the names, and make sure they match
versionOfJarPattern = re.compile(r"org\.eclipse\.jdt\.core(\.source)?_(.*)\.jar")
def versionOfJar(jarname):
    match = versionOfJarPattern.match(jarname)
    if match == None:
        return ""
    else:
        return match.group(2)

version = versionOfJar(jdtjar)
srcversion = versionOfJar(srcjar)

if version == None or srcversion == None:
    print "Cannot determine the version number of these jars."
    sys.exit(2)

if version != srcversion:
    print "The version of the two jars is inconsistent (" + version1 + " vs. " + version2
    sys.exit(2)

print "long version: " + version

shortVersionPattern = re.compile(r"([0-9]+\.[0-9]+\.[0-9]+)\.v_[0-9]+_R[0-9]+x")
shortVersion = shortVersionPattern.match(version).group(1)

print "short version: " + shortVersion



# build jars for GWT
def filterjar(injarname, outjarname):
    print "writing " + outjarname + "..."

    outzip = zipfile.ZipFile(outjarname, mode='w')
    inzip = zipfile.ZipFile(injarname, mode='r')

    for info in inzip.infolist():
        if whitelistAllows(info.filename):
            data = inzip.read(info.filename)
            outinfo = zipfile.ZipInfo(filename=info.filename,
                                      date_time=info.date_time)
            outinfo.compress_type = zipfile.ZIP_DEFLATED
            outzip.writestr(outinfo, data)

    inzip.close()
    outzip.close()

jdtforgwt = "jdt-" + shortVersion + ".jar"
srcforgwt = "jdt-" + shortVersion + "-src.zip"

filterjar(jdtjar, jdtforgwt)
filterjar(srcjar, srcforgwt)


# add version.txt
jdtzip = zipfile.ZipFile(jdtforgwt, "a")
jdtzip.writestr(zipfile.ZipInfo(filename="org/eclipse/jdt/version.txt"),
                "version " + version + "\n")
jdtzip.close()

