package org.richfaces.realworld.domain;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.jboss.seam.annotations.Name;

@Entity
@Name("friendshipRequest")
@Table(name = "friendship_requests")
public class FriendshipRequest implements Serializable{

	private static final long serialVersionUID = 1218079203119021096L;

	@Id
	@GeneratedValue
	@Column(name = "REQUEST_ID")
	private Long id;
	
	@ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "USER_ID", nullable = false, updatable = false)
    @org.hibernate.annotations.ForeignKey(name = "FK_FROM_USERSFRIEND_ID")
	private User user;
	
	@ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "FRIEND_ID", nullable = false, updatable = false)
    @org.hibernate.annotations.ForeignKey(name = "FK_FROM_USERSFRIEND2_ID")
	private User friend;

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public User getFriend() {
		return friend;
	}

	public void setFriend(User friend) {
		this.friend = friend;
	}

	public Long getId() {
		return id;
	}
}
