package org.richfaces.realworld.service;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.User;

@Name("albumAction")
@Stateless
public class AlbumAction implements IAlbumAction {

	@In(value="entityManager")
	EntityManager em;
	
	@In @Out
	private User user;

	public void addAlbum(Album album) {
		if(album.getChangedName() != album.getName()){
			album.setName(album.getChangedName());
		}
		em.persist(album);
		user.addAlbum(album);
		em.flush();
	}
	
	public void deleteAlbum(Album album){
		user.removeAlbum(album);
		em.flush();
	}
	
	public void editAlbum(Album album){
		em.flush();
	}
}
