/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.fileupload;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
import org.richfaces.realworld.domain.Image;

@Name("avatarUpload")
@Scope(ScopeType.CONVERSATION)
public class AvatarUpload implements Serializable{
	
	private static final long serialVersionUID = -3653686566159143678L;
	
	private FileItem avatarItem;
	
	public void avatarListener(UploadEvent event){
	    		UploadItem item = event.getUploadItem();
	    	    FileItem file = new FileItem();
	    	    file.setLength(item.getData().length);
	    	    Image image = new Image();
	    	    image.setName(item.getFileName());
	    	    file.setImage(image);
	    	    file.setData(item.getData());
	    	    this.setAvatarItem(file);
	}
	
	public synchronized void paintAvatar(OutputStream stream, Object object) throws IOException {
		stream.write(this.getAvatarItem().getData());
	}

	public FileItem getAvatarItem() {
		return avatarItem;
	}

	public void setAvatarItem(FileItem avatarItem) {
		this.avatarItem = avatarItem;
	}
}
