/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.manager;

import java.util.Date;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Comment;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.fileupload.FileManager;
import org.richfaces.realworld.service.IImageAction;
import org.richfaces.realworld.tree.TreeAlbumItem;
import org.richfaces.realworld.tree.TreeImageItem;
import org.richfaces.realworld.tree.TreeRootItem;
import org.richfaces.realworld.util.RatingBinder;
import org.richfaces.realworld.util.SelectionHelper;

@Name("imageManager")
@Scope(ScopeType.CONVERSATION)
public class ImageManager {

	@In(create=true, required=true)
	private IImageAction imageAction;
	
	@In(create=true)
	FileManager fileManager;
	
	@In(create=true) @Out TreeRootItem treeRoot;
	
	@In(create=true) @Out
	private SelectionHelper selectionHelper;
	
	@In
	private User user;
	
	@In(create=true, required=true)
	private RatingBinder ratingBinder;
	
	public void deleteImage(Image image){
		int index = image.getAlbum().getIndex(image);
		String albumName = image.getAlbum().getName();
		String imagePath = image.getPath();
		TreeAlbumItem parent = treeRoot.getAlbums().get(image.getAlbum().getId());
		imageAction.deleteImage(image);
		parent.removeChild(image.getId());
		fileManager.deleteImage(fileManager.transformToServerPath(imagePath));
		if(selectionHelper.getSelectedAlbum().getImages().size() > index){
			selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(index));
		}else{
			selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(index-1));
		}
	}

	public void editImage(Image image){
		TreeAlbumItem parent = treeRoot.getAlbums().get(image.getAlbum().getId());
		boolean parentChanged = !parent.getAlbum().getName().equals(image.getAlbumName());
		
		if(parentChanged){
			parent.removeChild(image.getId());
			TreeAlbumItem albumItem = treeRoot.getAlbumByName(image.getAlbumName());
			TreeImageItem imageItem = new TreeImageItem(image.getId(),albumItem,image);
			albumItem.addChild(image.getId(), imageItem);
			String fileNameOld = fileManager.transformToServerPath(image.getPath());
			int lastIndexOf = image.getPath().lastIndexOf("/");
			String prevPathEnd = image.getPath().substring(lastIndexOf);
			String fileNameNew = user.getLogin() + fileManager.getFileSeparator() + image.getAlbumName() + fileManager.getFileSeparator() + prevPathEnd;
			String newPath = user.getLogin() + "/" + image.getAlbumName() + "/" + prevPathEnd;
			image.setPath(newPath);
			fileManager.renameImage(fileNameOld, fileNameNew);
			selectionHelper.setSelectedImage(imageItem.getImage());
			selectionHelper.setSelectedAlbum(albumItem.getAlbum());
		}else{
			TreeImageItem imageItem = (TreeImageItem)parent.getChild(image.getId());
			imageItem.setImage(image);
		}
		imageAction.editImage(image, parentChanged);
	}

	@Observer("addImage")
	public void addImage(Image image) {
		imageAction.addImage(image);
		TreeAlbumItem albumItem = treeRoot.getAlbumByName(image.getAlbumName());
		TreeImageItem imageItem = new TreeImageItem(image.getId(),albumItem,image);
		albumItem.addChild(image.getId(), imageItem);
		selectionHelper.setSelectedImage(imageItem.getImage());
		selectionHelper.setSelectedAlbum(albumItem.getAlbum());
	}
	

	public void editComment(Comment comment) {
		imageAction.editComment(comment);
	}

	public void addComment(Comment comment) {
		imageAction.addComment(comment);
	}
	
	public void addAutoComment(Image image) {
		Comment comment = new Comment();
		comment.setAuthor(user);
		comment.setDate(new Date());
		comment.setImage(image);
		comment.setMessage("+1");
		imageAction.addComment(comment);
	}
	
	public void vote(Image image){
		imageAction.vote(image, (Long)Long.valueOf(ratingBinder.getInputSlider().getValue().toString()));
	}
}
