/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.servlet;

import java.io.File;

public class FileHelper {

	private static final String FILE_SEPARATOR = "file.separator";
	private String uploadRoot;
	
	public String getUploadRoot() {
		return uploadRoot;
	}

	public void setUploadRoot(String uploadRoot) {
		this.uploadRoot = uploadRoot;
	}
	
	public FileHelper(String uploadRoot){
		this.setUploadRoot(uploadRoot);
	}
	
	public String getFileSeparator() {
		return System.getProperty(FILE_SEPARATOR);
	}

	public boolean isImagePresent(String fileName) {
		String fullPath = getAbsolutePath(fileName);
		File file = new File(fullPath);
		return file.exists() && !file.isDirectory();
	}
	
	public File getImage(String fileName){
		if(isImagePresent(fileName)){
			return new File(getAbsolutePath(fileName));
		}
		return null;
	}

	private String getAbsolutePath(String fileName) {
		return getUploadRoot() + fileName;
	}
	
}
