/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.tree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import org.ajax4jsf.context.AjaxContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Synchronized;
import org.jboss.seam.core.Events;
import org.richfaces.component.UIDatascroller;
import org.richfaces.component.UIDragSupport;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DropEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRowKey;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.fileupload.FileManager;
import org.richfaces.realworld.manager.ImageManager;
import org.richfaces.realworld.navigation.NavigationEnum;
import org.richfaces.realworld.util.SelectionHelper;

@Name("treeSelectionManager")
@Scope(ScopeType.CONVERSATION)
@Synchronized(timeout=200000)
public class TreeSelectionManager implements Serializable{

	private static final String DATASCROLLER_ID = "mainform:imageScroller";

	private static final String IMAGE_DATATABLE_ID = "mainform:mainImage";

	private static final String FIRST = "first";

	private static final String NEXT = "next";

	private static final String LAST = "last";
	
	private static final String UPDATE_MAIN_AREA_EVENT = "updateMainArea";

	private static final String PREVIOUS = "previous";

	private static final long serialVersionUID = -6072049677194472463L;
	
	private NavigationEnum mainArea;
	
	@In(required=false) @Out(required=false)
	private SelectionHelper selectionHelper;
	
	@In(create=true)
	FileManager fileManager;
	
	@In(required=false)
	ImageManager imageManager;

	private String nodeTitle;

	public void showFileUpload(TreeAlbumItem item){
		selectionHelper.setSelectedAlbum(item.getAlbum());
		if(item.isLeaf()){
			selectionHelper.setSelectedImage(null);
		}else{
			selectionHelper.setSelectedImage(((TreeImageItem)(item.getImages().get(0))).getImage());
		}
		this.setMainArea(NavigationEnum.FILE_UPLOAD);
	}
	
	@Observer("updateMainArea")
    public void updateMainArea(NavigationEnum mainArea) {
        this.setMainArea(mainArea);
    }

	public void scrollerListener(DataScrollerEvent event) {
		List<Image> images = selectionHelper.getSelectedAlbum().getImages();
		if (event.getNewScrolVal().equals(PREVIOUS)) {
			for(int index = 0 ; index < images.size(); index++){
				if(images.get(index) == selectionHelper.getSelectedImage()){
					selectionHelper.setSelectedImage(images.get(index - 1));
					selectionHelper.setSelectedImageIndex(index);
				}
			}
		} else if (event.getNewScrolVal().equals(LAST)) {
			selectionHelper.setSelectedImage(images.get(images.size() - 1));
			selectionHelper.setSelectedImageIndex(images.size());
		} else if (event.getNewScrolVal().equals(NEXT)) {
			for(int index = 0 ; index < images.size(); index++){
				if(images.get(index) == selectionHelper.getSelectedImage()){
					selectionHelper.setSelectedImage(images.get(index + 1));
						selectionHelper.setSelectedImageIndex(index + 2);
						return;
				}
			}
		} else if (event.getNewScrolVal().equals(FIRST)) {
			selectionHelper.setSelectedImage(images.get(0));
			selectionHelper.setSelectedImageIndex(1);
		}

	}
	
	public void dropListener(DropEvent dropEvent) {
		
		// resolve drag destination attributes
		UITreeNode destNode = (dropEvent.getSource() instanceof UITreeNode) ? (UITreeNode) dropEvent.getSource() : null;
		UITree destTree = destNode != null ? destNode.getUITree() : null;
		TreeRowKey dropNodeKey = (dropEvent.getDropValue() instanceof TreeRowKey) ? (TreeRowKey) dropEvent.getDropValue() : null;
		TreeNode droppedInNode = dropNodeKey != null ? destTree.getTreeNode(dropNodeKey) : null;
		
		// resolve drag source attributes
		UITreeNode srcNode = (dropEvent.getDraggableSource() instanceof UITreeNode) ? (UITreeNode) dropEvent.getDraggableSource() : null;
		UITree srcTree = srcNode != null ? srcNode.getUITree() : null;
		TreeRowKey dragNodeKey = (dropEvent.getDragValue() instanceof TreeRowKey) ? (TreeRowKey) dropEvent.getDragValue() : null;
		TreeNode draggedNode = dragNodeKey != null ? srcTree.getTreeNode(dragNodeKey) : null;
		if (dropEvent.getDraggableSource() instanceof UIDragSupport && srcTree == null && draggedNode == null && dropEvent.getDragValue() instanceof TreeNode) {	    
		    srcTree = destTree;
		    draggedNode = (TreeNode) dropEvent.getDragValue();
		    dragNodeKey = srcTree.getTreeNodeRowKey(draggedNode) instanceof TreeRowKey ? (TreeRowKey) srcTree.getTreeNodeRowKey(draggedNode) : null;
		}

		// Note: check if we dropped node on to itself or to item instead of
		// folder here
		if (droppedInNode != null && (droppedInNode.equals(draggedNode) || droppedInNode.getParent().getParent() != null || draggedNode.getParent().getParent() == null)) {
		    //Warning: Can't drop on itself or to pic itself! Also can't move folders
		    return;
		}

		if (dropNodeKey != null) {
		    // add destination node for rerender
		    destTree.addRequestKey(dropNodeKey);

		    Object state = null;
		    if (dragNodeKey != null) { // Drag from this or other tree
			TreeNode parentNode = draggedNode.getParent();
			// 1. remove node from tree
			state = srcTree.removeNode(dragNodeKey);
			// 2. add parent for rerender
			Object rowKey = srcTree.getTreeNodeRowKey(parentNode);
			srcTree.addRequestKey(rowKey);
			//TODO refactor this code
			if (dropEvent.getDraggableSource() instanceof UIDragSupport) {
			    // if node was gragged in it's parent place dragged node to
			    // the end of selected nodes in grid
			    if (droppedInNode.equals(parentNode)) {
			    }
			}
		    } else if (dropEvent.getDragValue() != null) { // Drag from some
								    // drag source
			draggedNode.setData(dropEvent.getDragValue().toString());
		    }

		    // generate new node id
		    Object id = getNewId(destTree.getTreeNode(dropNodeKey));
		    destTree.addNode(dropNodeKey, draggedNode, id, state);
		}

		AjaxContext ac = AjaxContext.getCurrentInstance();
		ac.addRenderedArea(IMAGE_DATATABLE_ID);
		Image draggedImage = ((TreeImageItem)draggedNode).getImage();
		draggedImage.setAlbumName(((TreeAlbumItem)droppedInNode).getAlbum().getName());
		imageManager.editImage(draggedImage);
		// Add destination tree to reRender
		try {
		    ac.addComponentToAjaxRender(destTree);
		} catch (Exception e) {
		    //System.err.print(e.getMessage());
		}
		
	    }
	
	private Object getNewId(TreeNode parentNode) {
		Map<Object, TreeNode> childs = new HashMap<Object, TreeNode>();
		Iterator<Map.Entry<Object, TreeNode>> iter = parentNode.getChildren();
		while (iter != null && iter.hasNext()) {
		    Map.Entry<Object, TreeNode> entry = iter.next();
		    childs.put(entry.getKey(), entry.getValue());
		}

		Integer index = 1;
		while (childs.containsKey(index)) {
		    index++;
		}
		return index;
	    }

	public Boolean adviseNodeSelected(UITree tree) {
		TreeRowKey treeRowKey = (TreeRowKey) tree.getRowKey();
		TreeNode treeNode = (TreeNode) tree.getRowData(treeRowKey);
		if (treeNode instanceof TreeAlbumItem) {
			TreeAlbumItem currentNode = (TreeAlbumItem) treeNode;
			return currentNode.getAlbum() == selectionHelper.getSelectedAlbum();
		} else if (treeNode instanceof TreeImageItem) {
			return ((TreeImageItem) treeNode).getImage() == selectionHelper.getSelectedImage();
		}
		return null;
	}

	public Boolean adviseNodeOpened(UITree tree) {
		TreeRowKey treeRowKey = (TreeRowKey) tree.getRowKey();
		TreeNode treeNode = (TreeNode) tree.getRowData(treeRowKey);
		if (treeNode instanceof TreeAlbumItem) {
			TreeAlbumItem currentNode = (TreeAlbumItem) treeNode;
			return currentNode.getAlbum() == selectionHelper.getSelectedAlbum();
		}
		return null;
	}

	public void processSelection(NodeSelectedEvent event) {
		try{
		HtmlTree tree = (HtmlTree) event.getComponent();
		if (tree.getRowData() instanceof TreeImageItem) {
			nodeTitle = ((TreeImageItem) (tree.getRowData())).getImage()
					.getName();
		} else if (tree.getRowData() instanceof TreeAlbumItem) {
			nodeTitle = ((TreeAlbumItem) (tree.getRowData())).getAlbum()
					.getName();
		}
		Events.instance().raiseEvent(UPDATE_MAIN_AREA_EVENT, NavigationEnum.IMAGE_PREVIEW);
		TreeNode<String> currentNode = tree.getModelTreeNode(tree.getRowKey());
		selectionHelper.setUserAlbumSelected(true);
		if(currentNode instanceof TreeImageItem){
				Image image = ((TreeImageItem)currentNode).getImage();
				selectionHelper.setSelectedImage(image);
				Album album = ((TreeAlbumItem)currentNode.getParent()).getAlbum();
				if(album != selectionHelper.getSelectedAlbum()){
					selectionHelper.setSelectedAlbum(album);
				}
				int index = album.getIndex(image);
				setDataScrollerIndex(index);
				return;
		}else if(currentNode instanceof TreeAlbumItem){
			TreeAlbumItem node = (TreeAlbumItem)currentNode;
			selectionHelper.setSelectedImage(null);
			setDataScrollerIndex(0);
			if (node.isLeaf()) {
				//selectionHelper.setSelectedImage(null);
				Album album = node.getAlbum();
				selectionHelper.setSelectedAlbum(album);
			}else{
				if(node.getAlbum() == selectionHelper.getSelectedAlbum()){
					return;
				}else{
					selectionHelper.setSelectedAlbum(node.getAlbum());
					//selectionHelper.setSelectedImage(node.getAlbum().getImages().get(0));
				}		
			}
		}
		}
		catch(Exception e){
			//Bla-bla-bla
		}
	}

	//public void updateScroller(ActionEvent event){
		//this.setDataScrollerIndex(selectionHelper.getSelectedImageIndex()- 1);
	//}
	
	private void setDataScrollerIndex(int index) {
		UIComponent component = FacesContext.getCurrentInstance().getViewRoot();
		UIDatascroller scroller = (UIDatascroller)component.findComponent(DATASCROLLER_ID);
		Map<String, Object> attributes = scroller.getDataTable().getAttributes();
		attributes.put(UIDatascroller.SCROLLER_STATE_ATTRIBUTE, index+1);
		selectionHelper.setSelectedImageIndex(index+1);
	}
	
	
	public void incrementSlideshowIndex() {
		if(null == selectionHelper.getSelectedAlbum()){
			//Events.instance().raiseEvent("addErrorEvent", new RealworldException("You have no albums and images"));
			return;
		}
		int index = selectionHelper.getSelectedAlbum().getIndex(selectionHelper.getSelectedImage());
		if(selectionHelper.getSelectedAlbum().getImages().size() == index +1){
			index = -1;
		}
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(index +1));
		UIComponent component = FacesContext.getCurrentInstance().getViewRoot();
		UIDatascroller scroller = (UIDatascroller)component.findComponent(DATASCROLLER_ID);
		Map<String, Object> attributes = scroller.getDataTable().getAttributes();
		attributes.put(UIDatascroller.SCROLLER_STATE_ATTRIBUTE, index+2);
		selectionHelper.setSelectedImageIndex(index+2);
	}

	public String getNodeTitle() {
		return nodeTitle;
	}

	public void setNodeTitle(String nodeTitle) {
		this.nodeTitle = nodeTitle;
	}

	public NavigationEnum getMainArea() {
		return mainArea;
	}

	public void setMainArea(NavigationEnum mainArea) {
		this.mainArea = mainArea;
	}
	
	public SelectItem[] getAvailableIndexOfImages(){
		SelectItem[] group = new SelectItem[selectionHelper.getSelectedAlbum().getImages().size()];
		for(int i = 0; i < selectionHelper.getSelectedAlbum().getImages().size(); i++){
			group[i] = new SelectItem(i+1);
		}
		return group;
	}
	
	@ErrorHandler
	public void updateSelectedItems(Image image){
		selectionHelper.setSelectedImage(image);
		Integer index = selectionHelper.getSelectedAlbum().getIndex(selectionHelper.getSelectedImage());
		setDataScrollerIndex(index);
	}
}
