/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
package org.ajax4jsf.bean;

import java.util.Date;
import java.util.EventListener;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;

import org.ajax4jsf.event.PushEventListener;

public class AjaxPushTestBean {

    private boolean enabled = false;

    private PushEventListener listener;

    private EventGenerator generator;

    private String content = "content";

    private final Object lock = new Object();

    /**
     * Gets value of content field.
     * 
     * @return value of content field
     */
    public String getContent() {
        return content;
    }

    /**
     * Set a new value for content field.
     * 
     * @param content
     *                a new value for content field
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * Gets value of eventsSent field.
     * 
     * @return value of eventsSent field
     */
    public int getEventsSent() {
        EventGenerator generator = getGenerator();
        return generator != null ? generator.getEventsSent() : 0;
    }

    public void addListener(EventListener listener) {
        synchronized (lock) {
            if (this.listener != listener) {
                this.listener = (PushEventListener) listener;
            }
        }
    }

    public void start() {
        synchronized (lock) {
            if (generator == null && listener != null) {
                generator = new EventGenerator(listener, 60000);
                Thread thread = new Thread(generator);
                thread.setDaemon(true);
                thread.start();
                setEnabled(true);
            }
        }
    }

    public void stop() {
        synchronized (lock) {
            if (generator != null) {
                generator.stop();
                setEnabled(false);
                generator = null;
            }
        }
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void restart() {
        stop();
        start();
    }

    private EventGenerator getGenerator() {
        return generator;
    }

    private static class EventGenerator implements Runnable {

        private final PushEventListener listener;

        private final long time;

        private AtomicInteger eventsSent = new AtomicInteger(0);

        private volatile boolean stopped;

        public EventGenerator(PushEventListener listener, long time) {
            this.listener = listener;
            this.time = time;
        }

        public void stop() {
            stopped = true;
            synchronized (this) {
                notify();
            }
        }

        public void run() {
            Date startDate = new Date();
            while (true) {
                try {
                    long left = System.currentTimeMillis() - startDate.getTime();
                    if (left >= time || stopped) {
                        break;
                    }
                    listener.onEvent(new EventObject(this));
                    eventsSent.incrementAndGet();
                    synchronized (this) {
                        wait(500);
                    }
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public int getEventsSent() {
            return eventsSent.get();
        }
    }

}
