/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.ajax4jsf.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.faces.model.SelectItem;

public class ComboBoxTestBean {

    private List<SelectItem> treeItems;
    private List<String> treeNames;

    public ComboBoxTestBean() {
        treeNames = Arrays.asList("Pine", "Birch", "Aspen", "Spruce", "Oak", "Maple", "Ash", "Lime");
        treeItems = new ArrayList<SelectItem>();
        for (String treeName : treeNames) {
            treeItems.add(new SelectItem(treeName, treeName));
        }
    }

    /**
     * Gets value of treeItems field.
     * @return value of treeItems field
     */
    public List<SelectItem> getTreeItems() {
        return treeItems;
    }

    /**
     * Gets value of treeNames field.
     * @return value of treeNames field
     */
    public List<String> getTreeNames() {
        return treeNames;
    }

}
