/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model;
import java.util.HashMap;
import java.util.Map;


/**
 * A SWF symbol dictionary
 * 
 * @author nick
 */
public class SWFDictionary {
	
	private Map symbols = new HashMap(); //Integer id -> SWFSymbol
	
	/**
	 * Get a symbol.
	 * @param id the symbol id
	 * @return null if the id does not exist
	 */
	public SWFSymbol getSymbol( int id ) {
		return (SWFSymbol) symbols.get( new Integer( id ));
	}
	
	/**
	 * Define a symbol.
	 * @param id the id
	 * @param symbol the symbol to define
	 */
	public void defineSymbol( int id, SWFSymbol symbol ) {
		symbols.put( new Integer( id ), symbol );
	}

	/**
	 * Remove a symbol and return it.
	 * @param id the id to remove
	 * @return null if no such symbol exists
	 */
	public SWFSymbol removeSymbol( int id ) {
		return (SWFSymbol) symbols.remove( new Integer( id ));
	}
}
