/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.ant.org.codehaus.plexus.interpolation.object;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.InterpolationException;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.Interpolator;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.object.ObjectInterpolationWarning;
import org.sonatype.aether.ant.org.codehaus.plexus.interpolation.object.ObjectInterpolator;

public class FieldBasedObjectInterpolator
implements ObjectInterpolator {
    public static final Set DEFAULT_BLACKLISTED_FIELD_NAMES;
    public static final Set DEFAULT_BLACKLISTED_PACKAGE_PREFIXES;
    private static final Map fieldsByClass;
    private static final Map fieldIsPrimitiveByClass;
    private Set blacklistedFieldNames;
    private Set blacklistedPackagePrefixes;
    private List warnings = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public static void clearCaches() {
        fieldsByClass.clear();
        fieldIsPrimitiveByClass.clear();
    }

    public FieldBasedObjectInterpolator() {
        this.blacklistedFieldNames = DEFAULT_BLACKLISTED_FIELD_NAMES;
        this.blacklistedPackagePrefixes = DEFAULT_BLACKLISTED_PACKAGE_PREFIXES;
    }

    public FieldBasedObjectInterpolator(Set blacklistedFieldNames, Set blacklistedPackagePrefixes) {
        this.blacklistedFieldNames = blacklistedFieldNames;
        this.blacklistedPackagePrefixes = blacklistedPackagePrefixes;
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public List getWarnings() {
        return new ArrayList(this.warnings);
    }

    public void interpolate(Object target, Interpolator interpolator) throws InterpolationException {
        this.interpolate(target, interpolator, new SimpleRecursionInterceptor());
    }

    public void interpolate(Object target, Interpolator interpolator, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        this.warnings.clear();
        InterpolateObjectAction action = new InterpolateObjectAction(target, interpolator, recursionInterceptor, this.blacklistedFieldNames, this.blacklistedPackagePrefixes, this.warnings);
        InterpolationException error = (InterpolationException)AccessController.doPrivileged(action);
        if (error != null) {
            throw error;
        }
    }

    static /* synthetic */ Map access$300() {
        return fieldsByClass;
    }

    static {
        fieldsByClass = new WeakHashMap();
        fieldIsPrimitiveByClass = new WeakHashMap();
        HashSet<String> blacklistedFields = new HashSet<String>();
        blacklistedFields.add("parent");
        DEFAULT_BLACKLISTED_FIELD_NAMES = Collections.unmodifiableSet(blacklistedFields);
        HashSet<String> blacklistedPackages = new HashSet<String>();
        blacklistedPackages.add("java");
        DEFAULT_BLACKLISTED_PACKAGE_PREFIXES = Collections.unmodifiableSet(blacklistedPackages);
    }

    private static final class InterpolationTarget {
        private Object value;
        private String path;

        private InterpolationTarget(Object value, String path) {
            this.value = value;
            this.path = path;
        }

        static /* synthetic */ String access$200(InterpolationTarget x0) {
            return x0.path;
        }
    }

    private static final class InterpolateObjectAction
    implements PrivilegedAction {
        private final LinkedList interpolationTargets;
        private final Interpolator interpolator;
        private final Set blacklistedFieldNames;
        private final String[] blacklistedPackagePrefixes;
        private final List warningCollector;
        private final RecursionInterceptor recursionInterceptor;

        public InterpolateObjectAction(Object target, Interpolator interpolator, RecursionInterceptor recursionInterceptor, Set blacklistedFieldNames, Set blacklistedPackagePrefixes, List warningCollector) {
            this.recursionInterceptor = recursionInterceptor;
            this.blacklistedFieldNames = blacklistedFieldNames;
            this.warningCollector = warningCollector;
            this.blacklistedPackagePrefixes = blacklistedPackagePrefixes.toArray(new String[0]);
            this.interpolationTargets = new LinkedList();
            this.interpolationTargets.add(new InterpolationTarget(target, ""));
            this.interpolator = interpolator;
        }

        public Object run() {
            while (!this.interpolationTargets.isEmpty()) {
                InterpolationTarget target = (InterpolationTarget)this.interpolationTargets.removeFirst();
                try {
                    this.traverseObjectWithParents(target.value.getClass(), target);
                }
                catch (InterpolationException e) {
                    return e;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private void traverseObjectWithParents(Class cls, InterpolationTarget target) throws InterpolationException {
            block26: {
                block25: {
                    obj = InterpolationTarget.access$100(target);
                    basePath = InterpolationTarget.access$200(target);
                    if (cls == null) {
                        return;
                    }
                    if (!cls.isArray()) break block25;
                    this.evaluateArray(obj, basePath);
                    break block26;
                }
                if (!this.isQualifiedForInterpolation(cls)) break block26;
                fields = (Field[])FieldBasedObjectInterpolator.access$300().get(cls);
                if (fields == null) {
                    fields = cls.getDeclaredFields();
                    FieldBasedObjectInterpolator.access$300().put(cls, fields);
                }
                for (i = 0; i < fields.length; ++i) {
                    type = fields[i].getType();
                    if (!this.isQualifiedForInterpolation(fields[i], type)) continue;
                    isAccessible = fields[i].isAccessible();
                    fields[i].setAccessible(true);
                    if ((FieldBasedObjectInterpolator.class$java$lang$String == null ? FieldBasedObjectInterpolator.class$("java.lang.String") : FieldBasedObjectInterpolator.class$java$lang$String) == type) {
                        value = (String)fields[i].get(obj);
                        if (value == null || (interpolated = this.interpolator.interpolate((String)value, this.recursionInterceptor)).equals(value)) continue;
                        fields[i].set(obj, interpolated);
                        continue;
                    }
                    if (!(FieldBasedObjectInterpolator.class$java$util$Collection == null ? FieldBasedObjectInterpolator.class$("java.util.Collection") : FieldBasedObjectInterpolator.class$java$util$Collection).isAssignableFrom(type)) ** GOTO lbl65
                    c = (Collection)fields[i].get(obj);
                    if (c == null || c.isEmpty()) continue;
                    originalValues = new ArrayList<E>(c);
                    try {
                        c.clear();
                    }
                    catch (UnsupportedOperationException e) {
                        this.warningCollector.add(new ObjectInterpolationWarning("Field is an unmodifiable collection. Skipping interpolation.", basePath + "." + fields[i].getName(), e));
                        fields[i].setAccessible(isAccessible);
                        continue;
                    }
                    try {
                        try {
                            it = originalValues.iterator();
                            while (it.hasNext()) {
                                value /* !! */  = it.next();
                                if (value /* !! */  != null) {
                                    if ((FieldBasedObjectInterpolator.class$java$lang$String == null ? FieldBasedObjectInterpolator.class$("java.lang.String") : FieldBasedObjectInterpolator.class$java$lang$String) == value /* !! */ .getClass()) {
                                        interpolated = this.interpolator.interpolate((String)value /* !! */ , this.recursionInterceptor);
                                        if (!interpolated.equals(value /* !! */ )) {
                                            c.add(interpolated);
                                            continue;
                                        }
                                        c.add(value /* !! */ );
                                        continue;
                                    }
                                    c.add(value /* !! */ );
                                    if (value /* !! */ .getClass().isArray()) {
                                        this.evaluateArray(value /* !! */ , basePath + "." + fields[i].getName());
                                        continue;
                                    }
                                    this.interpolationTargets.add(new InterpolationTarget(value /* !! */ , basePath + "." + fields[i].getName()));
                                    continue;
                                }
                                c.add(value /* !! */ );
                            }
                            continue;
lbl65:
                            // 1 sources

                            if ((FieldBasedObjectInterpolator.class$java$util$Map == null ? FieldBasedObjectInterpolator.class$("java.util.Map") : FieldBasedObjectInterpolator.class$java$util$Map).isAssignableFrom(type)) {
                                m = (Map)fields[i].get(obj);
                                if (m == null || m.isEmpty()) continue;
                                it = m.entrySet().iterator();
                                while (it.hasNext()) {
                                    entry = it.next();
                                    value /* !! */  = entry.getValue();
                                    if (value /* !! */  == null) continue;
                                    if ((FieldBasedObjectInterpolator.class$java$lang$String == null ? FieldBasedObjectInterpolator.class$("java.lang.String") : FieldBasedObjectInterpolator.class$java$lang$String) == value /* !! */ .getClass()) {
                                        interpolated = this.interpolator.interpolate((String)value /* !! */ , this.recursionInterceptor);
                                        if (interpolated.equals(value /* !! */ )) continue;
                                        try {
                                            entry.setValue(interpolated);
                                        }
                                        catch (UnsupportedOperationException e) {
                                            this.warningCollector.add(new ObjectInterpolationWarning("Field is an unmodifiable collection. Skipping interpolation.", basePath + "." + fields[i].getName(), e));
                                        }
                                        continue;
                                    }
                                    if (value /* !! */ .getClass().isArray()) {
                                        this.evaluateArray(value /* !! */ , basePath + "." + fields[i].getName());
                                        continue;
                                    }
                                    this.interpolationTargets.add(new InterpolationTarget(value /* !! */ , basePath + "." + fields[i].getName()));
                                }
                                continue;
                            }
                            value = fields[i].get(obj);
                            if (value == null) continue;
                            if (fields[i].getType().isArray()) {
                                this.evaluateArray(value, basePath + "." + fields[i].getName());
                                continue;
                            }
                            this.interpolationTargets.add(new InterpolationTarget(value, basePath + "." + fields[i].getName()));
                        }
                        catch (IllegalArgumentException e) {
                            this.warningCollector.add(new ObjectInterpolationWarning("Failed to interpolate field. Skipping.", basePath + "." + fields[i].getName(), e));
                        }
                        catch (IllegalAccessException e) {
                            this.warningCollector.add(new ObjectInterpolationWarning("Failed to interpolate field. Skipping.", basePath + "." + fields[i].getName(), e));
                        }
                        continue;
                    }
                    catch (Throwable var15_18) {
                        throw var15_18;
                    }
                    finally {
                        fields[i].setAccessible(isAccessible);
                    }
                }
                this.traverseObjectWithParents(cls.getSuperclass(), target);
            }
        }

        private boolean isQualifiedForInterpolation(Class cls) {
            String pkgName = cls.getPackage().getName();
            for (int i = 0; i < this.blacklistedPackagePrefixes.length; ++i) {
                String prefix = this.blacklistedPackagePrefixes[i];
                if (!pkgName.startsWith(prefix)) continue;
                return false;
            }
            return true;
        }

        private boolean isQualifiedForInterpolation(Field field, Class fieldType) {
            if (!fieldIsPrimitiveByClass.containsKey(fieldType)) {
                fieldIsPrimitiveByClass.put(fieldType, fieldType.isPrimitive());
            }
            if (((Boolean)fieldIsPrimitiveByClass.get(fieldType)).booleanValue()) {
                return false;
            }
            return !this.blacklistedFieldNames.contains(field.getName());
        }

        private void evaluateArray(Object target, String basePath) throws InterpolationException {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                if (value == null) continue;
                if ((class$java$lang$String == null ? FieldBasedObjectInterpolator.class$("java.lang.String") : class$java$lang$String) == value.getClass()) {
                    String interpolated = this.interpolator.interpolate((String)value, this.recursionInterceptor);
                    if (interpolated.equals(value)) continue;
                    Array.set(target, i, interpolated);
                    continue;
                }
                this.interpolationTargets.add(new InterpolationTarget(value, basePath + "[" + i + "]"));
            }
        }
    }
}

