/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.IAnnotationTransformer;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.ReporterConfig;
import org.testng.SuiteRunner;
import org.testng.TestNGCommandLineArgs;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.ClassHelper;
import org.testng.internal.IResultListener;
import org.testng.internal.Utils;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK14AnnotationFinder;
import org.testng.internal.version.VersionInfo;
import org.testng.log4testng.Logger;
import org.testng.remote.SuiteDispatcher;
import org.testng.remote.SuiteSlave;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.XMLReporter;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(TestNG.class);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SRC_SEPARATOR = ";";
    public static final String JDK_ANNOTATION_TYPE = AnnotationTypeEnum.JDK.getName();
    public static final String JAVADOC_ANNOTATION_TYPE = AnnotationTypeEnum.JAVADOC.getName();
    private static TestNG m_instance;
    protected List<XmlSuite> m_suites = new ArrayList<XmlSuite>();
    protected List<XmlSuite> m_cmdlineSuites;
    protected String m_outputDir = "test-output";
    protected String[] m_sourceDirs;
    private AnnotationTypeEnum m_defaultAnnotations = VersionInfo.getDefaultAnnotationType();
    protected IAnnotationFinder m_javadocAnnotationFinder;
    protected IAnnotationFinder m_jdkAnnotationFinder;
    protected String[] m_includedGroups;
    protected String[] m_excludedGroups;
    private Boolean m_isJUnit = Boolean.FALSE;
    protected boolean m_useDefaultListeners = true;
    protected ITestRunnerFactory m_testRunnerFactory;
    protected List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    protected List<ISuiteListener> m_suiteListeners = new ArrayList<ISuiteListener>();
    private List<IReporter> m_reporters = new ArrayList<IReporter>();
    public static final int HAS_FAILURE = 1;
    public static final int HAS_SKIPPED = 2;
    public static final int HAS_FSP = 4;
    public static final int HAS_NO_TEST = 8;
    protected int m_status;
    protected boolean m_hasTests = false;
    private String m_slavefileName = null;
    private String m_masterfileName = null;
    private int m_threadCount;
    private boolean m_useThreadCount;
    private String m_parallelMode;
    private boolean m_useParallelMode;
    private Class[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private Map<String, Integer> m_methodDescriptors = new HashMap<String, Integer>();
    private IObjectFactory m_objectFactory;
    private List<IInvokedMethodListener> m_invokedMethodListeners = new ArrayList<IInvokedMethodListener>();
    private int m_verbose = 1;
    private IAnnotationTransformer m_annotationTransformer = new DefaultAnnotationTransformer();
    private Boolean m_skipFailedInvocationCounts = false;
    private IMethodInterceptor m_methodInterceptor = null;

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public int getStatus() {
        return this.m_status;
    }

    protected void setStatus(int status) {
        this.m_status |= status;
    }

    public void setOutputDirectory(String outputdir) {
        if (null != outputdir && !"".equals(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    @Deprecated
    public void setTarget(String target) {
        LOGGER.warn("The usage of -target option is deprecated. Please use -annotations instead.");
        if (null == target) {
            return;
        }
        this.setAnnotations(target);
    }

    public void setAnnotations(String annotationType) {
        if (null != annotationType && !"".equals(annotationType)) {
            this.setAnnotations(AnnotationTypeEnum.valueOf(annotationType));
        }
    }

    private void setAnnotations(AnnotationTypeEnum annotationType) {
        if (null != annotationType) {
            this.m_defaultAnnotations = annotationType;
        }
    }

    public void setSourcePath(String sourcePaths) {
        LOGGER.debug("setSourcePath: \"" + sourcePaths + "\"");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-sourcedir-override.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading testng-sourcedir-override.properties", e);
            }
            sourcePaths = props.getProperty("sourcedir");
            LOGGER.debug("setSourcePath ignoring sourcepath parameter and using testng-sourcedir-override.properties: \"" + sourcePaths + "\"");
        }
        if (null == sourcePaths || "".equals(sourcePaths.trim())) {
            return;
        }
        this.m_sourceDirs = Utils.split(sourcePaths, SRC_SEPARATOR);
    }

    public void setTestJar(String jarPath) {
        if (null == jarPath || "".equals(jarPath)) {
            return;
        }
        File jarFile = new File(jarPath);
        try {
            URL jarfileUrl = new URL("jar", "", "file:" + jarFile.getAbsolutePath() + "!/");
            URLClassLoader jarLoader = new URLClassLoader(new URL[]{jarfileUrl});
            Thread.currentThread().setContextClassLoader(jarLoader);
            JarFile jf = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jf.entries();
            ArrayList<String> classes = new ArrayList<String>();
            boolean foundTestngXml = false;
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.getName().equals("testng.xml")) {
                    Parser parser = new Parser(jf.getInputStream(je));
                    this.m_suites.addAll(parser.parse());
                    foundTestngXml = true;
                    break;
                }
                if (!je.getName().endsWith(".class")) continue;
                int n = je.getName().length() - ".class".length();
                classes.add(je.getName().replace("/", ".").substring(0, n));
            }
            if (!foundTestngXml) {
                XmlSuite xmlSuite = new XmlSuite();
                xmlSuite.setVerbose(1);
                xmlSuite.setName("Jar suite");
                XmlTest xmlTest = new XmlTest(xmlSuite);
                ArrayList<XmlClass> xmlClasses = new ArrayList<XmlClass>();
                for (String cls : classes) {
                    XmlClass xmlClass = new XmlClass(cls);
                    xmlClasses.add(xmlClass);
                }
                xmlTest.setXmlClasses(xmlClasses);
                this.m_suites.add(xmlSuite);
            }
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            TestNG.exitWithError("Cannot use a threadCount parameter less than 1; 1 > " + threadCount);
        }
        this.m_threadCount = threadCount;
        this.m_useThreadCount = true;
    }

    public void setParallel(String parallel) {
        this.m_parallelMode = parallel;
        this.m_useParallelMode = true;
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuites = new ArrayList<XmlSuite>();
        this.m_cmdlineSuites.add(suite);
        this.m_suites.add(suite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_commandLineTestClasses = classes;
    }

    private IAnnotationFinder getAnnotationFinder() {
        return AnnotationTypeEnum.JDK == this.m_defaultAnnotations ? this.m_jdkAnnotationFinder : this.m_javadocAnnotationFinder;
    }

    private List<XmlSuite> createCommandLineSuites(Class[] classes) {
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        HashMap<String, XmlSuite> suites = new HashMap<String, XmlSuite>();
        IAnnotationFinder finder = this.getAnnotationFinder();
        for (int i = 0; i < classes.length; ++i) {
            XmlSuite xmlSuite;
            Class c = classes[i];
            ITestAnnotation test = (ITestAnnotation)finder.findAnnotation(c, ITestAnnotation.class);
            String suiteName = this.getDefaultSuiteName();
            String testName = this.getDefaultTestName();
            if (test != null) {
                String candidateTestName;
                String candidateSuiteName = test.getSuiteName();
                if (candidateSuiteName != null && !"".equals(candidateSuiteName)) {
                    suiteName = candidateSuiteName;
                }
                if ((candidateTestName = test.getTestName()) != null && !"".equals(candidateTestName)) {
                    testName = candidateTestName;
                }
            }
            if ((xmlSuite = (XmlSuite)suites.get(suiteName)) == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
            }
            List<XmlMethodSelector> selectors = xmlTest.getMethodSelectors();
            for (String name : this.m_methodDescriptors.keySet()) {
                XmlMethodSelector xms = new XmlMethodSelector();
                xms.setName(name);
                xms.setPriority(this.m_methodDescriptors.get(name));
                selectors.add(xms);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        return new ArrayList<XmlSuite>(suites.values());
    }

    public void addMethodSelector(String className, int priority) {
        this.m_methodDescriptors.put(className, priority);
    }

    public void setTestSuites(List<String> suites) {
        for (String suiteXmlPath : suites) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("suiteXmlPath: \"" + suiteXmlPath + "\"");
            }
            try {
                Collection<XmlSuite> allSuites = new Parser(suiteXmlPath).parse();
                for (XmlSuite s : allSuites) {
                    this.m_suites.add(s);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace(System.out);
            }
            catch (SAXException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = Utils.split(groups, ",");
    }

    public void setGroups(String groups) {
        this.m_includedGroups = Utils.split(groups, ",");
    }

    protected void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)ClassHelper.newInstance(testRunnerFactoryClass));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setObjectFactory(Class c) {
        this.m_objectFactory = (IObjectFactory)ClassHelper.newInstance(c);
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(ClassHelper.newInstance(cls));
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ITestNGListener)) {
            TestNG.exitWithError("Listener " + listener + " must be one of ITestListener, ISuiteListener, IReporter, " + " IAnnotationTransformer, IMethodInterceptor or IInvokedMethodListener");
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
            if (listener instanceof IReporter) {
                this.addListener((IReporter)listener);
            }
            if (listener instanceof IAnnotationTransformer) {
                this.setAnnotationTransformer((IAnnotationTransformer)listener);
            }
            if (listener instanceof IMethodInterceptor) {
                this.m_methodInterceptor = (IMethodInterceptor)listener;
            }
            if (listener instanceof IInvokedMethodListener) {
                this.addListener((IInvokedMethodListener)listener);
            }
        }
    }

    public void addListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(IReporter listener) {
        if (null != listener) {
            this.m_reporters.add(listener);
        }
    }

    public void addInvokedMethodListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public List<IReporter> getReporters() {
        return this.m_reporters;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<ISuiteListener> getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = verbose;
    }

    private void initializeCommandLineSuites() {
        if (null != this.m_commandLineTestClasses) {
            this.m_cmdlineSuites = this.createCommandLineSuites(this.m_commandLineTestClasses);
            for (XmlSuite s : this.m_cmdlineSuites) {
                this.m_suites.add(s);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite s : this.m_cmdlineSuites) {
            if (this.m_useThreadCount) {
                s.setThreadCount(this.m_threadCount);
            }
            if (!this.m_useParallelMode) continue;
            s.setParallel(this.m_parallelMode);
        }
    }

    private void initializeCommandLineSuitesGroups() {
        if (null != this.m_cmdlineSuites) {
            for (XmlSuite s : this.m_cmdlineSuites) {
                if (null != this.m_includedGroups && this.m_includedGroups.length > 0) {
                    s.getTests().get(0).setIncludedGroups(Arrays.asList(this.m_includedGroups));
                }
                if (null == this.m_excludedGroups || this.m_excludedGroups.length <= 0) continue;
                s.getTests().get(0).setExcludedGroups(Arrays.asList(this.m_excludedGroups));
            }
        }
    }

    private void initializeListeners() {
        this.m_testListeners.add(new ExitCodeListener(this));
        if (this.m_useDefaultListeners) {
            this.m_reporters.add(new SuiteHTMLReporter());
            this.m_reporters.add(new FailedReporter());
            this.m_reporters.add(new XMLReporter());
            this.m_reporters.add(new EmailableReporter());
        }
    }

    private void initializeAnnotationFinders() {
        this.m_javadocAnnotationFinder = new JDK14AnnotationFinder(this.getAnnotationTransformer());
        if (null != this.m_sourceDirs) {
            this.m_javadocAnnotationFinder.addSourceDirs(this.m_sourceDirs);
        }
        this.m_jdkAnnotationFinder = ClassHelper.createJdkAnnotationFinder(this.getAnnotationTransformer());
    }

    public void run() {
        this.initializeListeners();
        this.initializeAnnotationFinders();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        List<ISuite> suiteRunners = null;
        if (this.m_slavefileName != null) {
            SuiteSlave slave = new SuiteSlave(this.m_slavefileName, this);
            slave.waitForSuites();
        } else if (this.m_masterfileName == null) {
            suiteRunners = this.runSuitesLocally();
        } else {
            SuiteDispatcher dispatcher = new SuiteDispatcher(this.m_masterfileName);
            suiteRunners = dispatcher.dispatch(this.m_suites, this.getOutputDirectory(), this.m_javadocAnnotationFinder, this.m_jdkAnnotationFinder, this.getTestListeners());
        }
        if (null != suiteRunners) {
            this.generateReports(suiteRunners);
        }
        if (!this.m_hasTests) {
            this.setStatus(8);
            if (TestRunner.getVerbose() > 1) {
                System.err.println("[TestNG] No tests found. Nothing was run");
            }
        }
    }

    private void generateReports(List<ISuite> suiteRunners) {
        for (IReporter reporter : this.m_reporters) {
            try {
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
            }
            catch (Exception ex) {
                System.err.println("[TestNG] Reporter " + reporter + " failed");
                ex.printStackTrace(System.err);
            }
        }
    }

    public List<ISuite> runSuitesLocally() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        if (this.m_verbose > 0) {
            StringBuffer allFiles = new StringBuffer();
            for (XmlSuite s : this.m_suites) {
                allFiles.append("  ").append(s.getFileName() != null ? s.getFileName() : this.getDefaultSuiteName()).append('\n');
            }
            Utils.log("Parser", 0, "Running:\n" + allFiles.toString());
        }
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                xmlSuite.setDefaultAnnotations(this.m_defaultAnnotations.toString());
                if (null != this.m_isJUnit) {
                    xmlSuite.setJUnit(this.m_isJUnit);
                }
                for (String listenerName : xmlSuite.getListeners()) {
                    Class<?> listenerClass = ClassHelper.forName(listenerName);
                    Object listener = ClassHelper.newInstance(listenerClass);
                    this.addListener(listener);
                }
                if (null != this.m_skipFailedInvocationCounts) {
                    xmlSuite.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
                } else {
                    this.m_skipFailedInvocationCounts = xmlSuite.skipFailedInvocationCounts();
                }
                if (xmlSuite.getVerbose() == null) {
                    xmlSuite.setVerbose(this.m_verbose);
                }
                result.add(this.createAndRunSuiteRunners(xmlSuite));
            }
        } else {
            this.setStatus(8);
            System.err.println("[ERROR]: No test suite found.  Nothing to run");
        }
        return result;
    }

    protected SuiteRunner createAndRunSuiteRunners(XmlSuite xmlSuite) {
        SuiteRunner result = new SuiteRunner(xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, new IAnnotationFinder[]{this.m_javadocAnnotationFinder, this.m_jdkAnnotationFinder}, this.m_objectFactory, this.m_methodInterceptor, this.m_invokedMethodListeners);
        result.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        result.setTestListeners(this.m_testListeners);
        result.run();
        return result;
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        Map arguments = TestNG.checkConditions(TestNGCommandLineArgs.parseCommandLine(argv));
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        result.configure(arguments);
        try {
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                System.err.println("[ERROR]: " + ex.getMessage());
            }
            result.setStatus(1);
        }
        return result;
    }

    public void configure(Map cmdLineArgs) {
        List reporterConfigs;
        Class objectFactory;
        List listenerClasses;
        String defaultTestName;
        String defaultSuiteName;
        String threadCount;
        String useDefaultListeners;
        List testNgXml;
        Integer verbose = (Integer)cmdLineArgs.get("-log");
        if (null != verbose) {
            this.setVerbose(verbose);
        }
        this.setOutputDirectory((String)cmdLineArgs.get("-d"));
        this.setSourcePath((String)cmdLineArgs.get("-sourcedir"));
        this.setAnnotations((AnnotationTypeEnum)cmdLineArgs.get("-annotations"));
        List testClasses = (List)cmdLineArgs.get("-testclass");
        if (null != testClasses) {
            Class[] classes = testClasses.toArray(new Class[testClasses.size()]);
            this.setTestClasses(classes);
        }
        if (null != (testNgXml = (List)cmdLineArgs.get("testng.suite.definitions"))) {
            this.setTestSuites(testNgXml);
        }
        if (null != (useDefaultListeners = (String)cmdLineArgs.get("-usedefaultlisteners"))) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(useDefaultListeners));
        }
        this.setGroups((String)cmdLineArgs.get("-groups"));
        this.setExcludedGroups((String)cmdLineArgs.get("-excludegroups"));
        this.setTestJar((String)cmdLineArgs.get("-testjar"));
        this.setJUnit((Boolean)cmdLineArgs.get("-junit"));
        this.setMaster((String)cmdLineArgs.get("-master"));
        this.setSlave((String)cmdLineArgs.get("-slave"));
        this.setSkipFailedInvocationCounts((Boolean)cmdLineArgs.get("-skipfailedinvocationcounts"));
        String parallelMode = (String)cmdLineArgs.get("-parallel");
        if (parallelMode != null) {
            this.setParallel(parallelMode);
        }
        if ((threadCount = (String)cmdLineArgs.get("-threadcount")) != null) {
            this.setThreadCount(Integer.parseInt(threadCount));
        }
        if ((defaultSuiteName = (String)cmdLineArgs.get("-suitename")) != null) {
            this.setDefaultSuiteName(defaultSuiteName);
        }
        if ((defaultTestName = (String)cmdLineArgs.get("-testname")) != null) {
            this.setDefaultTestName(defaultTestName);
        }
        if (null != (listenerClasses = (List)cmdLineArgs.get("-listener"))) {
            this.setListenerClasses(listenerClasses);
        }
        if (null != (objectFactory = (Class)cmdLineArgs.get("-objectfactory"))) {
            this.setObjectFactory(objectFactory);
        }
        if ((reporterConfigs = (List)cmdLineArgs.get("-reporterslist")) != null) {
            for (ReporterConfig reporterConfig : reporterConfigs) {
                this.addReporter(reporterConfig);
            }
        }
    }

    private void setSkipFailedInvocationCounts(Boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    private void addReporter(ReporterConfig reporterConfig) {
        Object instance = reporterConfig.newReporterInstance();
        if (instance != null) {
            this.addListener(instance);
        } else {
            LOGGER.warn("Could not find reporte class : " + reporterConfig.getClassName());
        }
    }

    public void setMaster(String fileName) {
        this.m_masterfileName = fileName;
    }

    public void setSlave(String fileName) {
        this.m_slavefileName = fileName;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    @Deprecated
    public static void setTestNGVersion() {
        LOGGER.info("setTestNGVersion has been deprecated.");
    }

    public static boolean isJdk14() {
        return false;
    }

    protected static Map checkConditions(Map params) {
        List testClasses = (List)params.get("-testclass");
        List testNgXml = (List)params.get("testng.suite.definitions");
        Object testJar = params.get("-testjar");
        Object slave = params.get("-slave");
        if (testClasses == null && testNgXml == null && slave == null && testJar == null) {
            System.err.println("You need to specify at least one testng.xml or one class");
            TestNG.usage();
            System.exit(-1);
        }
        String groups = (String)params.get("-groups");
        String excludedGroups = (String)params.get("-excludegroups");
        if ((null != groups || null != excludedGroups) && null == testClasses) {
            throw new TestNGException("Groups option should be used with testclass option");
        }
        if (params.containsKey("-slave") && params.containsKey("-master")) {
            throw new TestNGException("-slave can't be combined with -master");
        }
        return params;
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    public static void usage() {
        TestNGCommandLineArgs.usage();
    }

    static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    public boolean getSkipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public void setAnnotationTransformer(IAnnotationTransformer t) {
        this.m_annotationTransformer = t;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String defaultSuiteName) {
        this.m_defaultSuiteName = defaultSuiteName;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.m_defaultTestName = defaultTestName;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    @Deprecated
    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    @Deprecated
    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    @Deprecated
    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptor = methodInterceptor;
    }

    public static class ExitCodeListener
    implements IResultListener {
        protected TestNG m_mainRunner;

        public ExitCodeListener() {
            this.m_mainRunner = m_instance;
        }

        public ExitCodeListener(TestNG runner) {
            this.m_mainRunner = runner;
        }

        public void onTestFailure(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(1);
        }

        public void onTestSkipped(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(2);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(4);
        }

        public void onTestSuccess(ITestResult result) {
            this.setHasRunTests();
        }

        public void onStart(ITestContext context) {
            this.setHasRunTests();
        }

        public void onFinish(ITestContext context) {
        }

        public void onTestStart(ITestResult result) {
            this.setHasRunTests();
        }

        private void setHasRunTests() {
            this.m_mainRunner.m_hasTests = true;
        }

        public void onConfigurationFailure(ITestResult itr) {
            this.m_mainRunner.setStatus(1);
        }

        public void onConfigurationSkip(ITestResult itr) {
            this.m_mainRunner.setStatus(2);
        }

        public void onConfigurationSuccess(ITestResult itr) {
        }
    }
}

