/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.BaseBlockCipherTest;
import org.bouncycastle.util.encoders.Hex;

public class AESTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "69c4e0d86a7b0430d8cdb78070b4c55a", "192", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "dda97ca4864cdfe06eaf70a0ec0d7191", "256", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "8ea2b7ca516745bfeafc49904b496089"};

    public AESTest() {
        super("AES");
    }

    private void test(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        try {
            cipher2.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("AES failed initialisation - " + exception.toString(), exception);
        }
        try {
            cipher.init(2, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("AES failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        try {
            for (int i = 0; i != byArray2.length / 2; ++i) {
                cipherOutputStream.write(byArray2[i]);
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            this.fail("AES failed encryption - " + iOException.toString(), iOException);
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("AES failed encryption - expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray2.length];
            for (int i = 0; i != byArray2.length / 2; ++i) {
                byArray4[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            this.fail("AES failed encryption - " + exception.toString(), exception);
        }
        if (!this.areEqual(byArray4, byArray2)) {
            this.fail("AES failed decryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
    }

    private void eaxTest() throws Exception {
        byte[] byArray = Hex.decode("233952DEE4D5ED5F9B9C6D6FF80FF478");
        byte[] byArray2 = Hex.decode("62EC67F9C3A4A407FCB2A8C49031A8B3");
        byte[] byArray3 = Hex.decode("68656c6c6f20776f726c642121");
        byte[] byArray4 = Hex.decode("2f9f76cb7659c70e4be11670a3e193ae1bc6b5762a");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray2));
        byte[] byArray5 = cipher.doFinal(byArray3);
        if (!this.areEqual(byArray5, byArray4)) {
            this.fail("ciphertext doesn't match in EAX");
        }
        cipher2.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
        byte[] byArray6 = cipher2.doFinal(byArray4);
        if (!this.areEqual(byArray6, byArray3)) {
            this.fail("plaintext doesn't match in EAX");
        }
        try {
            cipher = Cipher.getInstance("AES/EAX/PKCS5Padding", "BC");
            this.fail("bad padding missed in EAX");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    private void ccmTest() throws Exception {
        byte[] byArray = Hex.decode("404142434445464748494a4b4c4d4e4f");
        byte[] byArray2 = Hex.decode("10111213141516");
        byte[] byArray3 = Hex.decode("68656c6c6f20776f726c642121");
        byte[] byArray4 = Hex.decode("39264f148b54c456035de0a531c8344f46db12b388");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray2));
        byte[] byArray5 = cipher.doFinal(byArray3);
        if (!this.areEqual(byArray5, byArray4)) {
            this.fail("ciphertext doesn't match in CCM");
        }
        cipher2.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
        byte[] byArray6 = cipher2.doFinal(byArray4);
        if (!this.areEqual(byArray6, byArray3)) {
            this.fail("plaintext doesn't match in CCM");
        }
        try {
            cipher = Cipher.getInstance("AES/CCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in CCM");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 4) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
        }
        byte[] byArray = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] byArray2 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] byArray3 = Hex.decode("1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5");
        this.wrapTest(1, "AESWrap", byArray, byArray2, byArray3);
        String[] stringArray = new String[]{NISTObjectIdentifiers.id_aes128_ECB.getId(), NISTObjectIdentifiers.id_aes128_CBC.getId(), NISTObjectIdentifiers.id_aes128_OFB.getId(), NISTObjectIdentifiers.id_aes128_CFB.getId(), NISTObjectIdentifiers.id_aes192_ECB.getId(), NISTObjectIdentifiers.id_aes192_CBC.getId(), NISTObjectIdentifiers.id_aes192_OFB.getId(), NISTObjectIdentifiers.id_aes192_CFB.getId(), NISTObjectIdentifiers.id_aes256_ECB.getId(), NISTObjectIdentifiers.id_aes256_CBC.getId(), NISTObjectIdentifiers.id_aes256_OFB.getId(), NISTObjectIdentifiers.id_aes256_CFB.getId()};
        String[] stringArray2 = new String[]{"AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding"};
        this.oidTest(stringArray, stringArray2, 4);
        String[] stringArray3 = new String[]{NISTObjectIdentifiers.id_aes128_wrap.getId(), NISTObjectIdentifiers.id_aes192_wrap.getId(), NISTObjectIdentifiers.id_aes256_wrap.getId()};
        this.wrapOidTest(stringArray3, "AESWrap");
        this.eaxTest();
        this.ccmTest();
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        AESTest.runTest(new AESTest());
    }
}

