/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.AttributeCertificateHolder;
import org.bouncycastle.x509.AttributeCertificateIssuer;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificateGenerator;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class AttrCertTest
extends SimpleTest {
    private static final RSAPrivateCrtKeySpec RSA_PRIVATE_KEY_SPEC = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    static byte[] attrCert = Base64.decode("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");
    byte[] signCert = Base64.decode("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");
    static byte[] certWithBaseCertificateID = Base64.decode("MIIBqzCCARQCAQEwSKBGMD6kPDA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdAIEAVMVjqB6MHikdjB0MQswCQYDVQQGEwJBVTEoMCYGA1UEChMfVGhlIExlZ2lvbiBvZiB0aGUgQm91bmN5IENhc3RsZTEjMCEGA1UECxMaQm91bmN5IFByaW1hcnkgQ2VydGlmaWNhdGUxFjAUBgNVBAMTDUJvdW5jeSBDYXN0bGUwDQYJKoZIhvcNAQEFBQACBQKWRhnHMCIYDzIwMDUxMjEyMTIwMDQyWhgPMjAwNTEyMTkxMjAxMzJaMA8wDQYDVRhIMQaBBGVWSVAwDQYJKoZIhvcNAQEFBQADgYEAUAVin9StDaA+InxtXq/av6rUQLI9p1X6louBcj4kYJnxRvTrHpsrN3+i9Uq/uk5lRdAqmPFvcmSbuE3TRAsjrXON5uFiBBKZ1AouLqcr8nHbwcdwjJ9TyUNO9I4hfpSHUHHXMtBKgp4MOkhhX8xTGyWg3hp23d3GaUeg/IYlXBI=");
    byte[] holderCertWithBaseCertificateID = Base64.decode("MIIBwDCCASmgAwIBAgIEAVMVjjANBgkqhkiG9w0BAQUFADA6MQswCQYDVQQGEwJJVDEOMAwGA1UEChMFVU5JVE4xDDAKBgNVBAsTA0RJVDENMAsGA1UEAxMEcm9vdDAeFw0wNTExMTExMjAxMzJaFw0wNjA2MTYxMjAxMzJaMD4xCzAJBgNVBAYTAklUMQ4wDAYDVQQKEwVVTklUTjEMMAoGA1UECxMDRElUMREwDwYDVQQDEwhMdWNhQm9yejBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERoxUwEzARBglghkgBhvhCAQEEBAMCBDAwDQYJKoZIhvcNAQEFBQADgYEAsX50VPQQCWmHvPq9y9DeCpmS4szcpFAhpZyn6gYRwY9CRZVtmZKH8713XhkGDWcIEMcG0u3oTz3tdKgPU5uyIPrDEWr6w8ClUj4x5aVz5c2223+dVY7KES//JSB2bE/KCIchN3kAioQ4K8O3e0OL6oDVjsqKGw5bfahgKuSIk/Q=");

    public String getName() {
        return "AttrCertTest";
    }

    private void testCertWithBaseCertificateID() throws Exception {
        X509V2AttributeCertificate x509V2AttributeCertificate = new X509V2AttributeCertificate(certWithBaseCertificateID);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID));
        AttributeCertificateHolder attributeCertificateHolder = x509V2AttributeCertificate.getHolder();
        if (attributeCertificateHolder.getEntityNames() != null) {
            this.fail("entity names set when none expected");
        }
        if (!attributeCertificateHolder.getSerialNumber().equals(x509Certificate.getSerialNumber())) {
            this.fail("holder serial number doesn't match");
        }
        if (!((Object)attributeCertificateHolder.getIssuer()[0]).equals(x509Certificate.getIssuerX500Principal())) {
            this.fail("holder issuer doesn't match");
        }
        if (!attributeCertificateHolder.match(x509Certificate)) {
            this.fail("holder not matching holder certificate");
        }
        if (!attributeCertificateHolder.equals(attributeCertificateHolder.clone())) {
            this.fail("holder clone test failed");
        }
        if (!x509V2AttributeCertificate.getIssuer().equals(x509V2AttributeCertificate.getIssuer().clone())) {
            this.fail("issuer clone test failed");
        }
    }

    private void equalityAndHashCodeTest(X509AttributeCertificate x509AttributeCertificate, byte[] byArray) throws IOException {
        X509V2AttributeCertificate x509V2AttributeCertificate;
        if (!x509AttributeCertificate.equals(x509AttributeCertificate)) {
            this.fail("same certificate not equal");
        }
        if (!x509AttributeCertificate.getHolder().equals(x509AttributeCertificate.getHolder())) {
            this.fail("same holder not equal");
        }
        if (!x509AttributeCertificate.getIssuer().equals(x509AttributeCertificate.getIssuer())) {
            this.fail("same issuer not equal");
        }
        if (x509AttributeCertificate.getHolder().equals(x509AttributeCertificate.getIssuer())) {
            this.fail("wrong holder equal");
        }
        if (x509AttributeCertificate.getIssuer().equals(x509AttributeCertificate.getHolder())) {
            this.fail("wrong issuer equal");
        }
        if ((x509V2AttributeCertificate = new X509V2AttributeCertificate(byArray)).getHolder().hashCode() != x509AttributeCertificate.getHolder().hashCode()) {
            this.fail("holder hashCode test failed");
        }
        if (!x509V2AttributeCertificate.getHolder().equals(x509AttributeCertificate.getHolder())) {
            this.fail("holder equals test failed");
        }
        if (x509V2AttributeCertificate.getIssuer().hashCode() != x509AttributeCertificate.getIssuer().hashCode()) {
            this.fail("issuer hashCode test failed");
        }
        if (!x509V2AttributeCertificate.getIssuer().equals(x509AttributeCertificate.getIssuer())) {
            this.fail("issuer equals test failed");
        }
    }

    private void testGenerateWithCert() throws Exception {
        X509Certificate x509Certificate;
        ASN1Encodable[] aSN1EncodableArray;
        GeneralName generalName;
        X509Attribute x509Attribute;
        X509Attribute[] x509AttributeArray;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.signCert));
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(RSA_PRIVATE_KEY_SPEC);
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        X509V2AttributeCertificateGenerator x509V2AttributeCertificateGenerator = new X509V2AttributeCertificateGenerator();
        GeneralName generalName2 = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName2);
        X509Attribute x509Attribute2 = new X509Attribute("2.5.24.72", new DERSequence(aSN1EncodableVector));
        x509V2AttributeCertificateGenerator.addAttribute(x509Attribute2);
        x509V2AttributeCertificateGenerator.setHolder(new AttributeCertificateHolder(x509Certificate2));
        x509V2AttributeCertificateGenerator.setIssuer(new AttributeCertificateIssuer(new X509Principal("cn=test")));
        x509V2AttributeCertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V2AttributeCertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V2AttributeCertificateGenerator.setSerialNumber(BigInteger.ONE);
        x509V2AttributeCertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509AttributeCertificate x509AttributeCertificate = x509V2AttributeCertificateGenerator.generate(privateKey, "BC");
        x509AttributeCertificate.checkValidity();
        x509AttributeCertificate.verify(publicKey, "BC");
        AttributeCertificateHolder attributeCertificateHolder = x509AttributeCertificate.getHolder();
        if (attributeCertificateHolder.getEntityNames() != null) {
            this.fail("entity names set when none expected");
        }
        if (!attributeCertificateHolder.getSerialNumber().equals(x509Certificate2.getSerialNumber())) {
            this.fail("holder serial number doesn't match");
        }
        if (!((Object)attributeCertificateHolder.getIssuer()[0]).equals(x509Certificate2.getIssuerX500Principal())) {
            this.fail("holder issuer doesn't match");
        }
        if (!attributeCertificateHolder.match(x509Certificate2)) {
            this.fail("generated holder not matching holder certificate");
        }
        if ((x509AttributeArray = x509AttributeCertificate.getAttributes("2.5.24.72")) == null) {
            this.fail("attributes related to 2.5.24.72 not found");
        }
        if (!(x509Attribute = x509AttributeArray[0]).getOID().equals("2.5.24.72")) {
            this.fail("attribute oid mismatch");
        }
        if ((generalName = GeneralNames.getInstance((aSN1EncodableArray = x509Attribute.getValues())[0]).getNames()[0]).getTagNo() != 1) {
            this.fail("wrong general name type found in role");
        }
        if (!((DERString)((Object)generalName.getName())).getString().equals("DAU123456789")) {
            this.fail("wrong general name value found in role");
        }
        if (attributeCertificateHolder.match(x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID)))) {
            this.fail("generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(x509AttributeCertificate, x509AttributeCertificate.getEncoded());
    }

    private void testGenerateWithPrincipal() throws Exception {
        X509Certificate x509Certificate;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.signCert));
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(RSA_PRIVATE_KEY_SPEC);
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        X509V2AttributeCertificateGenerator x509V2AttributeCertificateGenerator = new X509V2AttributeCertificateGenerator();
        GeneralName generalName = new GeneralName(1, "DAU123456789");
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName);
        X509Attribute x509Attribute = new X509Attribute("2.5.24.72", new DERSequence(aSN1EncodableVector));
        x509V2AttributeCertificateGenerator.addAttribute(x509Attribute);
        x509V2AttributeCertificateGenerator.setHolder(new AttributeCertificateHolder(x509Certificate2.getSubjectX500Principal()));
        x509V2AttributeCertificateGenerator.setIssuer(new AttributeCertificateIssuer(new X509Principal("cn=test")));
        x509V2AttributeCertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V2AttributeCertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V2AttributeCertificateGenerator.setSerialNumber(BigInteger.ONE);
        x509V2AttributeCertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509AttributeCertificate x509AttributeCertificate = x509V2AttributeCertificateGenerator.generate(privateKey, "BC");
        x509AttributeCertificate.checkValidity();
        x509AttributeCertificate.verify(publicKey, "BC");
        AttributeCertificateHolder attributeCertificateHolder = x509AttributeCertificate.getHolder();
        if (attributeCertificateHolder.getEntityNames() == null) {
            this.fail("entity names not set when expected");
        }
        if (attributeCertificateHolder.getSerialNumber() != null) {
            this.fail("holder serial number found when none expected");
        }
        if (attributeCertificateHolder.getIssuer() != null) {
            this.fail("holder issuer found when none expected");
        }
        if (!attributeCertificateHolder.match(x509Certificate2)) {
            this.fail("generated holder not matching holder certificate");
        }
        if (attributeCertificateHolder.match(x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.holderCertWithBaseCertificateID)))) {
            this.fail("principal generated holder matching wrong certificate");
        }
        this.equalityAndHashCodeTest(x509AttributeCertificate, x509AttributeCertificate.getEncoded());
    }

    public void performTest() throws Exception {
        byte[] byArray;
        ASN1Object aSN1Object;
        X509Attribute[] x509AttributeArray;
        X509AttributeCertificate x509AttributeCertificate = new X509V2AttributeCertificate(attrCert);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.signCert));
        x509AttributeCertificate.verify(x509Certificate.getPublicKey(), "BC");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        CertStore certStore = CertStore.getInstance("Collection", collectionCertStoreParameters);
        Collection<? extends Certificate> collection = certStore.getCertificates(x509AttributeCertificate.getIssuer());
        if (collection.size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("sCert not found by issuer");
        }
        if ((x509AttributeArray = x509AttributeCertificate.getAttributes("1.3.6.1.4.1.6760.8.1.1")) == null || x509AttributeArray.length != 1) {
            this.fail("attribute not found");
        }
        x509AttributeCertificate = new X509V2AttributeCertificate(x509AttributeCertificate.getEncoded());
        x509AttributeCertificate.verify(x509Certificate.getPublicKey(), "BC");
        X509V2AttributeCertificate x509V2AttributeCertificate = new X509V2AttributeCertificate(new ByteArrayInputStream(x509AttributeCertificate.getEncoded()));
        if (!x509AttributeCertificate.getNotAfter().equals(x509V2AttributeCertificate.getNotAfter())) {
            this.fail("failed date comparison");
        }
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = RSA_PRIVATE_KEY_SPEC;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        X509V2AttributeCertificateGenerator x509V2AttributeCertificateGenerator = new X509V2AttributeCertificateGenerator();
        x509V2AttributeCertificateGenerator.addAttribute(x509AttributeArray[0]);
        x509V2AttributeCertificateGenerator.setHolder(x509AttributeCertificate.getHolder());
        x509V2AttributeCertificateGenerator.setIssuer(x509AttributeCertificate.getIssuer());
        x509V2AttributeCertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V2AttributeCertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V2AttributeCertificateGenerator.setSerialNumber(x509AttributeCertificate.getSerialNumber());
        x509V2AttributeCertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        x509AttributeCertificate = x509V2AttributeCertificateGenerator.generate(privateKey, "BC");
        x509AttributeCertificate.checkValidity();
        x509AttributeCertificate.verify(publicKey, "BC");
        collection = certStore.getCertificates(x509AttributeCertificate.getIssuer());
        if (collection.size() != 1 || !collection.contains(x509Certificate)) {
            this.fail("sCert not found by issuer");
        }
        if ((x509AttributeArray = x509AttributeCertificate.getAttributes("1.3.6.1.4.1.6760.8.1.1")) == null || x509AttributeArray.length != 1) {
            this.fail("attribute not found");
        }
        x509AttributeCertificate = new X509V2AttributeCertificate(x509AttributeCertificate.getEncoded());
        x509AttributeCertificate.verify(publicKey, "BC");
        AttributeCertificateIssuer attributeCertificateIssuer = x509AttributeCertificate.getIssuer();
        Principal[] principalArray = attributeCertificateIssuer.getPrincipals();
        AttributeCertificateHolder attributeCertificateHolder = x509AttributeCertificate.getHolder();
        if (attributeCertificateHolder.getEntityNames() == null) {
            this.fail("entity names not set");
        }
        if (attributeCertificateHolder.getSerialNumber() != null) {
            this.fail("holder serial number set when none expected");
        }
        if (attributeCertificateHolder.getIssuer() != null) {
            this.fail("holder issuer set when none expected");
        }
        if (!((Object)(principalArray = attributeCertificateHolder.getEntityNames())[0]).toString().equals("C=US, O=vt, OU=Class 2, OU=Virginia Tech User, CN=Markus Lorch (mlorch), EMAILADDRESS=mlorch@vt.edu")) {
            this.fail("principal[0] for entity names don't match");
        }
        if (x509AttributeCertificate.hasUnsupportedCriticalExtension()) {
            this.fail("unsupported extensions found with no extensions");
        }
        x509V2AttributeCertificateGenerator.addExtension("1.1", true, new DEROctetString(new byte[10]));
        x509V2AttributeCertificateGenerator.addExtension("2.2", false, new DEROctetString(new byte[20]));
        x509AttributeCertificate = x509V2AttributeCertificateGenerator.generate(privateKey, "BC");
        Set<String> set = x509AttributeCertificate.getCriticalExtensionOIDs();
        if (set.size() != 1 || !set.contains("1.1")) {
            this.fail("critical extension test failed");
        }
        if ((set = x509AttributeCertificate.getNonCriticalExtensionOIDs()).size() != 1 || !set.contains("2.2")) {
            this.fail("non-critical extension test failed");
        }
        if (!x509AttributeCertificate.hasUnsupportedCriticalExtension()) {
            this.fail("unsupported extensions not found");
        }
        if (!((ASN1Encodable)(aSN1Object = X509ExtensionUtil.fromExtensionValue(byArray = x509AttributeCertificate.getExtensionValue("1.1")))).equals(new DEROctetString(new byte[10]))) {
            this.fail("wrong extension value found for 1.1");
        }
        this.testCertWithBaseCertificateID();
        this.testGenerateWithCert();
        this.testGenerateWithPrincipal();
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        AttrCertTest.runTest(new AttrCertTest());
    }
}

