/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.test.SimpleTest;

public class NamedCurveTest
extends SimpleTest {
    private static Hashtable CURVE_NAMES = new Hashtable();
    private static Hashtable CURVE_ALIASES = new Hashtable();

    public void testCurve(String string) throws Exception {
        ECNamedCurveSpec eCNamedCurveSpec;
        byte[] byArray;
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        ECPrivateKey eCPrivateKey;
        X509EncodedKeySpec x509EncodedKeySpec;
        ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
        if (eCGenParameterSpec == null) {
            this.fail("no curve for " + string + " found.");
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize(eCGenParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDHC", "BC");
        keyAgreement.init(keyPair.getPrivate());
        KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
        KeyAgreement keyAgreement2 = KeyAgreement.getInstance("ECDHC", "BC");
        keyAgreement2.init(keyPair2.getPrivate());
        keyAgreement.doPhase(keyPair2.getPublic(), true);
        keyAgreement2.doPhase(keyPair.getPublic(), true);
        BigInteger bigInteger = new BigInteger(keyAgreement.generateSecret());
        BigInteger bigInteger2 = new BigInteger(keyAgreement2.generateSecret());
        if (!bigInteger.equals(bigInteger2)) {
            this.fail("2-way test failed");
        }
        byte[] byArray2 = keyPair.getPublic().getEncoded();
        KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "BC");
        ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray2));
        if (!eCPublicKey.getW().equals(((ECPublicKey)keyPair.getPublic()).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(eCPublicKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray = keyPair.getPrivate().getEncoded()))).getS().equals(((ECPrivateKey)keyPair.getPrivate()).getS())) {
            this.fail("private key encoding (S test) failed");
        }
        if (!(eCPrivateKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("private key encoding not named curve");
        }
        if (!(eCNamedCurveSpec = (ECNamedCurveSpec)eCPrivateKey.getParams()).getName().equals(string) && !eCNamedCurveSpec.getName().equals(CURVE_NAMES.get(string))) {
            this.fail("private key encoding wrong named curve. Expected: " + CURVE_NAMES.get(string) + " got " + eCNamedCurveSpec.getName());
        }
    }

    public void testECDSA(String string) throws Exception {
        ECNamedCurveSpec eCNamedCurveSpec;
        byte[] byArray;
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        ECPrivateKey eCPrivateKey;
        X509EncodedKeySpec x509EncodedKeySpec;
        ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
        if (eCGenParameterSpec == null) {
            this.fail("no curve for " + string + " found.");
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyPairGenerator.initialize(eCGenParameterSpec, new SecureRandom());
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail(string + " verification failed");
        }
        byte[] byArray4 = publicKey.getEncoded();
        KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "BC");
        ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray4));
        if (!eCPublicKey.getW().equals(((ECPublicKey)publicKey).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(eCPublicKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray = privateKey.getEncoded()))).getS().equals(((ECPrivateKey)privateKey).getS())) {
            this.fail("private key encoding (S test) failed");
        }
        if (!(eCPrivateKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("private key encoding not named curve");
        }
        if (!(eCNamedCurveSpec = (ECNamedCurveSpec)eCPrivateKey.getParams()).getName().equalsIgnoreCase(string) && !eCNamedCurveSpec.getName().equalsIgnoreCase((String)CURVE_ALIASES.get(string))) {
            this.fail("private key encoding wrong named curve. Expected: " + string + " got " + eCNamedCurveSpec.getName());
        }
    }

    public void testECGOST(String string) throws Exception {
        ECNamedCurveSpec eCNamedCurveSpec;
        byte[] byArray;
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        ECPrivateKey eCPrivateKey;
        X509EncodedKeySpec x509EncodedKeySpec;
        ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
        if (eCGenParameterSpec == null) {
            this.fail("no curve for " + string + " found.");
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        keyPairGenerator.initialize(eCGenParameterSpec, new SecureRandom());
        Signature signature = Signature.getInstance("ECGOST3410", "BC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail(string + " verification failed");
        }
        byte[] byArray4 = publicKey.getEncoded();
        KeyFactory keyFactory = KeyFactory.getInstance("ECGOST3410", "BC");
        ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray4));
        if (!eCPublicKey.getW().equals(((ECPublicKey)publicKey).getW())) {
            this.fail("public key encoding (Q test) failed");
        }
        if (!(eCPublicKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("public key encoding not named curve");
        }
        if (!(eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray = privateKey.getEncoded()))).getS().equals(((ECPrivateKey)privateKey).getS())) {
            this.fail("GOST private key encoding (S test) failed");
        }
        if (!(eCPrivateKey.getParams() instanceof ECNamedCurveSpec)) {
            this.fail("GOST private key encoding not named curve");
        }
        if (!(eCNamedCurveSpec = (ECNamedCurveSpec)eCPrivateKey.getParams()).getName().equalsIgnoreCase(string) && !eCNamedCurveSpec.getName().equalsIgnoreCase((String)CURVE_ALIASES.get(string))) {
            this.fail("GOST private key encoding wrong named curve. Expected: " + string + " got " + eCNamedCurveSpec.getName());
        }
    }

    public String getName() {
        return "NamedCurve";
    }

    public void performTest() throws Exception {
        this.testCurve("prime192v1");
        this.testCurve("sect571r1");
        this.testCurve("secp224r1");
        this.testCurve("B-409");
        this.testCurve("P-521");
        this.testCurve("brainpoolp160r1");
        Enumeration enumeration = X962NamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            this.testECDSA((String)enumeration.nextElement());
        }
        enumeration = SECNamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            this.testECDSA((String)enumeration.nextElement());
        }
        enumeration = TeleTrusTNamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            this.testECDSA((String)enumeration.nextElement());
        }
        enumeration = ECGOST3410NamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            this.testECGOST((String)enumeration.nextElement());
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        NamedCurveTest.runTest(new NamedCurveTest());
    }

    static {
        CURVE_NAMES.put("prime192v1", "prime192v1");
        CURVE_NAMES.put("sect571r1", "sect571r1");
        CURVE_NAMES.put("secp224r1", "secp224r1");
        CURVE_NAMES.put("B-409", SECNamedCurves.getName(NISTNamedCurves.getOID("B-409")));
        CURVE_NAMES.put("P-521", SECNamedCurves.getName(NISTNamedCurves.getOID("P-521")));
        CURVE_NAMES.put("brainpoolp160r1", "brainpoolp160r1");
        CURVE_ALIASES.put("secp192r1", "prime192v1");
        CURVE_ALIASES.put("secp256r1", "prime256v1");
    }
}

