
package org.jgroups;

import org.jgroups.util.Streamable;
import org.jgroups.util.UUID;

import java.io.Externalizable;

/**
 * Address identifies cluster member. For example, whenever a unicast message is sent in a cluster
 * an Address of a cluster member message recipient needs to be specified. Similarly a cluster
 * member can use Address to check its own identity, request a state from a particular member and so
 * on. Addresses are mostly generated by the bottom-most (transport) layers (e.g. UDP, TCP,
 * LOOPBACK).
 * 
 * @author Bela Ban
 * @since 2.0
 * @see PhysicalAddress
 * @see UUID
 */
public interface Address extends Streamable, Comparable<Address>, Externalizable {
    // flags used for marshalling
    public static final byte NULL       = 1 << 0;
    public static final byte UUID_ADDR  = 1 << 1;
    public static final byte IP_ADDR    = 1 << 2;


    /** Returns serialized size of this address */
    int size();
}
