/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class DSATest
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});

    public void testCompat() throws Exception {
        Signature signature = Signature.getInstance("DSA", "SUN");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "SUN");
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        keyPairGenerator.initialize(512, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("DSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("SUN -> BC verification failed");
        }
        signature.initSign(privateKey);
        signature.update(byArray);
        byArray2 = signature.sign();
        signature = Signature.getInstance("DSA", "SUN");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("BC -> SUN verification failed");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("DSA", "BC");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        DSAPublicKey dSAPublicKey = (DSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        this.checkPublic(dSAPublicKey, publicKey);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        this.checkPrivateKey(dSAPrivateKey, privateKey);
        keyFactory = KeyFactory.getInstance("DSA", "SUN");
        x509EncodedKeySpec = new X509EncodedKeySpec(dSAPublicKey.getEncoded());
        publicKey = (DSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        this.checkPublic(dSAPublicKey, publicKey);
        pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(dSAPrivateKey.getEncoded());
        privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        this.checkPrivateKey(dSAPrivateKey, privateKey);
    }

    private void checkPublic(DSAPublicKey dSAPublicKey, PublicKey publicKey) {
        if (!dSAPublicKey.getY().equals(((DSAPublicKey)publicKey).getY())) {
            this.fail("public number not decoded properly");
        }
        if (!dSAPublicKey.getParams().getG().equals(((DSAPublicKey)publicKey).getParams().getG())) {
            this.fail("public generator not decoded properly");
        }
        if (!dSAPublicKey.getParams().getP().equals(((DSAPublicKey)publicKey).getParams().getP())) {
            this.fail("public p value not decoded properly");
        }
        if (!dSAPublicKey.getParams().getQ().equals(((DSAPublicKey)publicKey).getParams().getQ())) {
            this.fail("public q value not decoded properly");
        }
    }

    private void checkPrivateKey(DSAPrivateKey dSAPrivateKey, PrivateKey privateKey) {
        if (!dSAPrivateKey.getX().equals(((DSAPrivateKey)privateKey).getX())) {
            this.fail("private number not decoded properly");
        }
        if (!dSAPrivateKey.getParams().getG().equals(((DSAPrivateKey)privateKey).getParams().getG())) {
            this.fail("private generator not decoded properly");
        }
        if (!dSAPrivateKey.getParams().getP().equals(((DSAPrivateKey)privateKey).getParams().getP())) {
            this.fail("private p value not decoded properly");
        }
        if (!dSAPrivateKey.getParams().getQ().equals(((DSAPrivateKey)privateKey).getParams().getQ())) {
            this.fail("private q value not decoded properly");
        }
    }

    private Object serializeDeserialize(Object object) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return objectInputStream.readObject();
    }

    private void testECDSA239bitPrime() throws Exception {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger bigInteger2 = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, ((ECCurve)fp).decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(((ECCurve)fp).decodePoint(Hex.decode("025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCParameterSpec);
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        signature.initSign(privateKey, fixedSecureRandom);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!bigInteger.equals((bigIntegerArray = this.derDecode(byArray3))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
    }

    private void testECDSA239bitBinary() throws Exception {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger("21596333210419611985018340039034612628818151486841789642455876922391552");
        BigInteger bigInteger2 = new BigInteger("197030374000731686738334997654997227052849804072198819102649413465737174");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("171278725565216523967285789236956265265265235675811949404040041670216363"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        ECCurve.F2m f2m = new ECCurve.F2m(239, 36, new BigInteger("32010857077C5431123A46B808906756F543423E8D27877578125778AC76", 16), new BigInteger("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(f2m, ((ECCurve)f2m).decodePoint(Hex.decode("0457927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305")), new BigInteger("220855883097298041197912187592864814557886993776713230936715041207411783"), BigInteger.valueOf(4L));
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("145642755521911534651321230007534120304391871461646461466464667494947990"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(((ECCurve)f2m).decodePoint(Hex.decode("045894609CCECF9A92533F630DE713A958E96C97CCB8F5ABB5A688A238DEED6DC2D9D0C94EBFB7D526BA6A61764175B99CB6011E2047F9F067293F57F5")), eCParameterSpec);
        Signature signature = Signature.getInstance("ECDSA", "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.initSign(privateKey, fixedSecureRandom);
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("239 Bit EC verification failed");
        }
        if (!bigInteger.equals((bigIntegerArray = this.derDecode(byArray3))[0])) {
            this.fail("r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail("s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
    }

    private void testECDSA239bitBinary(String string, DERObjectIdentifier dERObjectIdentifier) throws Exception {
        BigInteger bigInteger = new BigInteger("21596333210419611985018340039034612628818151486841789642455876922391552");
        BigInteger bigInteger2 = new BigInteger("197030374000731686738334997654997227052849804072198819102649413465737174");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("171278725565216523967285789236956265265265235675811949404040041670216363"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        ECCurve.F2m f2m = new ECCurve.F2m(239, 36, new BigInteger("32010857077C5431123A46B808906756F543423E8D27877578125778AC76", 16), new BigInteger("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(f2m, ((ECCurve)f2m).decodePoint(Hex.decode("0457927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305")), new BigInteger("220855883097298041197912187592864814557886993776713230936715041207411783"), BigInteger.valueOf(4L));
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("145642755521911534651321230007534120304391871461646461466464667494947990"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(((ECCurve)f2m).decodePoint(Hex.decode("045894609CCECF9A92533F630DE713A958E96C97CCB8F5ABB5A688A238DEED6DC2D9D0C94EBFB7D526BA6A61764175B99CB6011E2047F9F067293F57F5")), eCParameterSpec);
        Signature signature = Signature.getInstance(string, "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.initSign(privateKey, fixedSecureRandom);
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature = Signature.getInstance(dERObjectIdentifier.getId(), "BC");
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("239 Bit EC RIPEMD160 verification failed");
        }
    }

    private void testGeneration() throws Exception {
        Signature signature = Signature.getInstance("DSA", "BC");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        try {
            keyPairGenerator.initialize(513, new SecureRandom());
            this.fail("illegal parameter 513 check failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            keyPairGenerator.initialize(510, new SecureRandom());
            this.fail("illegal parameter 510 check failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            keyPairGenerator.initialize(1025, new SecureRandom());
            this.fail("illegal parameter 1025 check failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        keyPairGenerator.initialize(512, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("DSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("DSA verification failed");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)this.serializeDeserialize(publicKey);
        this.checkPublic(dSAPublicKey, publicKey);
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)this.serializeDeserialize(privateKey);
        this.checkPrivateKey(dSAPrivateKey, privateKey);
        signature = Signature.getInstance("ECDSA", "BC");
        keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve eCCurve = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(eCCurve, eCCurve.decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        keyPair = keyPairGenerator.generateKeyPair();
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byArray2 = signature.sign();
        signature = Signature.getInstance("ECDSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("ECDSA verification failed");
        }
        signature = Signature.getInstance("ECDSA", "BC");
        keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        eCCurve = new ECCurve.F2m(239, 36, new BigInteger("32010857077C5431123A46B808906756F543423E8D27877578125778AC76", 16), new BigInteger("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16", 16));
        eCParameterSpec = new ECParameterSpec(eCCurve, eCCurve.decodePoint(Hex.decode("0457927098FA932E7C0A96D3FD5B706EF7E5F5C156E16B7E7C86038552E91D61D8EE5077C33FECF6F1A16B268DE469C3C7744EA9A971649FC7A9616305")), new BigInteger("220855883097298041197912187592864814557886993776713230936715041207411783"), BigInteger.valueOf(4L));
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        keyPair = keyPairGenerator.generateKeyPair();
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byArray2 = signature.sign();
        signature = Signature.getInstance("ECDSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("ECDSA verification failed");
        }
    }

    private void testParameters() throws Exception {
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "BC");
        algorithmParameterGenerator.init(512, this.random);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        byte[] byArray = algorithmParameters.getEncoded();
        AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("DSA", "BC");
        algorithmParameters2.init(byArray);
        byte[] byArray2 = algorithmParameters2.getEncoded();
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("encode/decode parameters failed");
        }
        DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        keyPairGenerator.initialize(dSAParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Signature signature = Signature.getInstance("DSA", "BC");
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        signature.initSign(privateKey);
        signature.update(byArray3);
        byte[] byArray4 = signature.sign();
        signature = Signature.getInstance("DSA", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray3);
        if (!signature.verify(byArray4)) {
            this.fail("DSA verification failed");
        }
    }

    public void performTest() throws Exception {
        this.testCompat();
        this.testECDSA239bitPrime();
        this.testECDSA239bitBinary();
        this.testECDSA239bitBinary("RIPEMD160withECDSA", TeleTrusTObjectIdentifiers.ecSignWithRipemd160);
        this.testECDSA239bitBinary("SHA1withECDSA", TeleTrusTObjectIdentifiers.ecSignWithSha1);
        this.testECDSA239bitBinary("SHA224withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        this.testECDSA239bitBinary("SHA256withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        this.testECDSA239bitBinary("SHA384withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        this.testECDSA239bitBinary("SHA512withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        this.testGeneration();
        this.testParameters();
    }

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        BigInteger[] bigIntegerArray = new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }

    public String getName() {
        return "DSA/ECDSA";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        DSATest.runTest(new DSATest());
    }
}

