/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GOST28147Test
extends SimpleTest {
    static String[] cipherTests = new String[]{"256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d6520666f7220616c6c20", "281630d0d5770030068c252d841e84149ccc1912052dbc02", "256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d65208a920c6ed1a804f5", "88e543dfc04dc4f764fa7b624741cec07de49b007bf36065"};

    public String getName() {
        return "GOST28147";
    }

    public void testECB(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "GOST28147");
        Cipher cipher = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
        cipher2.init(1, secretKeySpec);
        cipher.init(2, secretKeySpec);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        for (int i = 0; i != byArray2.length / 2; ++i) {
            cipherOutputStream.write(byArray2[i]);
        }
        cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        cipherOutputStream.close();
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("GOST28147 failed encryption - expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
        byArray4 = new byte[byArray2.length];
        for (int i = 0; i != byArray2.length / 2; ++i) {
            byArray4[i] = (byte)dataInputStream.read();
        }
        dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        if (!this.areEqual(byArray4, byArray2)) {
            this.fail("GOST28147 failed decryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
    }

    public void testCFB(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "GOST28147");
        Cipher cipher = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
        byte[] byArray4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        cipher2.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray4));
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray4));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        for (int i = 0; i != byArray2.length / 2; ++i) {
            cipherOutputStream.write(byArray2[i]);
        }
        cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        cipherOutputStream.close();
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("GOST28147 failed encryption - expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray5)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray5);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
        byArray5 = new byte[byArray2.length];
        for (int i = 0; i != byArray2.length / 2; ++i) {
            byArray5[i] = (byte)dataInputStream.read();
        }
        dataInputStream.readFully(byArray5, byArray2.length / 2, byArray5.length - byArray2.length / 2);
        if (!this.areEqual(byArray5, byArray2)) {
            this.fail("GOST28147 failed decryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray5)));
        }
    }

    private void oidTest() {
        String[] stringArray = new String[]{CryptoProObjectIdentifiers.gostR28147_cbc.getId()};
        String[] stringArray2 = new String[]{"GOST28147/CBC/PKCS7Padding"};
        try {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[8]);
            for (int i = 0; i != stringArray.length; ++i) {
                Cipher cipher = Cipher.getInstance(stringArray[i], "BC");
                Cipher cipher2 = Cipher.getInstance(stringArray2[i], "BC");
                KeyGenerator keyGenerator = KeyGenerator.getInstance(stringArray[i], "BC");
                SecretKey secretKey = keyGenerator.generateKey();
                cipher.init(1, (Key)secretKey, ivParameterSpec);
                cipher2.init(2, (Key)secretKey, ivParameterSpec);
                byte[] byArray2 = cipher2.doFinal(cipher.doFinal(byArray));
                if (this.areEqual(byArray, byArray2)) continue;
                this.fail("failed OID test");
            }
        }
        catch (Exception exception) {
            this.fail("failed exception " + exception.toString(), exception);
        }
    }

    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 8) {
            this.testECB(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
            this.testCFB(Integer.parseInt(cipherTests[i + 4]), Hex.decode(cipherTests[i + 4 + 1]), Hex.decode(cipherTests[i + 4 + 2]), Hex.decode(cipherTests[i + 4 + 3]));
            this.oidTest();
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        GOST28147Test.runTest(new GOST28147Test());
    }
}

