/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class GOST3410Test
extends SimpleTest {
    private void ecGOST3410Test() throws Exception {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = new BigInteger("29700980915817952874371204983938256990422752107994319651632687982059210933395");
        BigInteger bigInteger2 = new BigInteger("46959264877825372965922731380059061821746083849389763294914877353246631700866");
        byte[] byArray = BigIntegers.asUnsignedByteArray(new BigInteger("53854137677348463731403841147996619241504003434302020712960838528893196233395"));
        FixedSecureRandom fixedSecureRandom = new FixedSecureRandom(byArray);
        BigInteger bigInteger3 = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
        ECCurve.Fp fp = new ECCurve.Fp(bigInteger3, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp(bigInteger3, new BigInteger("2")), new ECFieldElement.Fp(bigInteger3, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("55441196065363246126355624130324183196576709222340016572108097750006097525544"), eCParameterSpec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint.Fp(fp, new ECFieldElement.Fp(bigInteger3, new BigInteger("57520216126176808443631405023338071176630104906313632182896741342206604859403")), new ECFieldElement.Fp(bigInteger3, new BigInteger("17614944419213781543809391949654080031942662045363639260709847859438286763994"))), eCParameterSpec);
        Signature signature = Signature.getInstance("ECGOST3410", "BC");
        KeyFactory keyFactory = KeyFactory.getInstance("ECGOST3410", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        signature.initSign(privateKey, fixedSecureRandom);
        byte[] byArray2 = new byte[]{97, 98, 99};
        signature.update(byArray2);
        byte[] byArray3 = signature.sign();
        signature.initVerify(publicKey);
        signature.update(byArray2);
        if (!signature.verify(byArray3)) {
            this.fail("ECGOST3410 verification failed");
        }
        if (!bigInteger.equals((bigIntegerArray = this.decode(byArray3))[0])) {
            this.fail(": r component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
        }
        if (!bigInteger2.equals(bigIntegerArray[1])) {
            this.fail(": s component wrong." + System.getProperty("line.separator") + " expecting: " + bigInteger2 + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
        }
    }

    private void generationTest() throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        GOST3410PrivateKey gOST3410PrivateKey;
        X509EncodedKeySpec x509EncodedKeySpec;
        KeyFactory keyFactory;
        GOST3410PublicKey gOST3410PublicKey;
        Signature signature = Signature.getInstance("GOST3410", "BC");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        GOST3410ParameterSpec gOST3410ParameterSpec = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId());
        keyPairGenerator.initialize(gOST3410ParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("GOST3410", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("GOST3410 verification failed");
        }
        signature = Signature.getInstance("GOST3410", "BC");
        keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
        keyPair = keyPairGenerator.generateKeyPair();
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byArray2 = signature.sign();
        signature = Signature.getInstance("GOST3410", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("GOST3410 verification failed");
        }
        if (!(gOST3410PublicKey = (GOST3410PublicKey)(keyFactory = KeyFactory.getInstance("GOST3410", "BC")).generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded()))).getY().equals(((GOST3410PublicKey)publicKey).getY())) {
            this.fail("public number not decoded properly");
        }
        if (!(gOST3410PrivateKey = (GOST3410PrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded()))).getX().equals(((GOST3410PrivateKey)privateKey).getX())) {
            this.fail("private number not decoded properly");
        }
        signature = Signature.getInstance("ECGOST3410", "BC");
        keyPairGenerator = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
        ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
        ECParameterSpec eCParameterSpec = new ECParameterSpec(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp(bigInteger, new BigInteger("2")), new ECFieldElement.Fp(bigInteger, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
        keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
        keyPair = keyPairGenerator.generateKeyPair();
        privateKey = keyPair.getPrivate();
        publicKey = keyPair.getPublic();
        signature.initSign(privateKey);
        signature.update(byArray);
        byArray2 = signature.sign();
        signature = Signature.getInstance("ECGOST3410", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("ECGOST3410 verification failed");
        }
    }

    private void parametersTest() throws Exception {
        GOST3410ParameterSpec gOST3410ParameterSpec = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_B.getId());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
        keyPairGenerator.initialize(gOST3410ParameterSpec, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Signature signature = Signature.getInstance("GOST3410", "BC");
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature = Signature.getInstance("GOST3410", "BC");
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("GOST3410 verification failed");
        }
    }

    private BigInteger[] decode(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        System.arraycopy(byArray, 0, byArray3, 0, 32);
        System.arraycopy(byArray, 32, byArray2, 0, 32);
        BigInteger[] bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray2), new BigInteger(1, byArray3)};
        return bigIntegerArray;
    }

    public String getName() {
        return "GOST3410/ECGOST3410";
    }

    public void performTest() throws Exception {
        this.ecGOST3410Test();
        this.generationTest();
        this.parametersTest();
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        GOST3410Test.runTest(new GOST3410Test());
    }
}

