#!/bin/bash

while test $# -gt 0; do
    case "$1" in
            -h|--help)
                    echo "This creates JDG depdency information for building Brew repository"
                    echo " "
                    echo "if no arguments specified - assume infinispan project to build and current directory is packaging"
                    echo " "
                    echo "options:"
                    echo "-h, --help                Show brief help"
                    echo "--projects                Comma separated list of projects to be built, like jdg,camel"
                    exit 1
                    ;;
            --projects*)
                    IFS=',' read -a PROJECTS <<< "$2"
                    printf -- '%s\n' "${PROJECTS[@]}"
                    shift
                    ;;
            *)
                    shift
                    ;;
    esac
done

# Solves sorting issues
LANG=C
DIR=`dirname $0`
BASEDIR=`readlink -f "$DIR"`
OUTPUT=`pwd`/target/dependency-report

rm -rf $OUTPUT
mkdir -p $OUTPUT

if [ -z $PROJECTS ]; then
    PROJECTS=("infinispan")
fi

IT_REGEX="^integrationtests.*"

cat src/main/resources/artifacts/jboss-eap*.txt | sort | uniq > $OUTPUT/eap-artifacts.txt
cat src/main/resources/artifacts/fuse-*.txt | sort | uniq > $OUTPUT/fuse-artifacts.txt

for PROJECT in ${PROJECTS[@]}; do
    echo "Processing $PROJECT"
    pushd ../$PROJECT > /dev/null
    MODULES=`xsltproc $BASEDIR/module-list.xslt pom.xml`
    xsltproc $BASEDIR/extract-gav.xslt pom.xml > $OUTPUT/module-$PROJECT.txt
    for MODULE in $MODULES; do
                if [[ $MODULE =~ $IT_REGEX ]]; then
                    continue
                fi
        echo "  Processing $MODULE"
        DEPS=`echo $MODULE|tr / -`
        xsltproc $BASEDIR/extract-gav.xslt $MODULE/pom.xml > $OUTPUT/module-$PROJECT-$DEPS.txt
        mvn -s "$BASEDIR/maven-settings.xml" org.apache.maven.plugins:maven-dependency-plugin:2.8:list -DincludeParents=true -pl $MODULE | cut -c 11- | grep -v "^Some problems" | sort >> $OUTPUT/module-$PROJECT-$DEPS.txt
    done

    cat $OUTPUT/module-$PROJECT-* | sort | uniq > $OUTPUT/all-$PROJECT-unsorted.txt
    cat $OUTPUT/all-$PROJECT-unsorted.txt | cut -d: -f 1,2,4 | sort > $OUTPUT/all-$PROJECT-artifacts-sorted.txt

    while read IN; do
        GAV=(${IN//:/ })
        echo -n ${GAV[0]} |tr . / >> $OUTPUT/all-$PROJECT-artifact-paths-unsorted.txt
        echo /${GAV[1]}/${GAV[2]} >> $OUTPUT/all-$PROJECT-artifact-paths-unsorted.txt
    done < $OUTPUT/all-$PROJECT-artifacts-sorted.txt

    cat $OUTPUT/all-$PROJECT-artifact-paths-unsorted.txt | sort | uniq > $OUTPUT/all-$PROJECT-artifact-paths-sorted.txt

    if [ "$PROJECT" == "camel" ]; then
        echo "Filtering $PROJECT artifacts agains Fuse"
        comm -1 -3 $OUTPUT/fuse-artifacts.txt $OUTPUT/all-$PROJECT-artifact-paths-sorted.txt | grep -E '[0-9]+.[0-9]+-[0-9]+|redhat[-.]' > $OUTPUT/final-$PROJECT-artifacts.txt
    else
        echo "Filtering $PROJECT artifacts agains EAP"
        comm -1 -3 $OUTPUT/eap-artifacts.txt $OUTPUT/all-$PROJECT-artifact-paths-sorted.txt | grep -E '[0-9]+.[0-9]+-[0-9]+|redhat[-.]' > $OUTPUT/final-$PROJECT-artifacts.txt
    fi

    popd > /dev/null
done

cat $OUTPUT/final-*-artifacts.txt | sort | uniq > $OUTPUT/jdg-artifacts.txt
