package org.infinispan.expiration.impl;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertNull;

import java.util.concurrent.TimeUnit;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups = "functional", testName = "expiration.impl.ExpirationRepeatableReadFunctionalTest")
public class ExpirationRepeatableReadFunctionalTest extends SingleCacheManagerTest {

   protected final int SIZE = 10;
   protected ControlledTimeService timeService = new ControlledTimeService(0);

   protected EmbeddedCacheManager createCacheManager() throws Exception {
      ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
      builder.clustering().cacheMode(CacheMode.DIST_SYNC);
      builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
      builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true);
      builder.versioning().enabled(true).scheme(VersioningScheme.SIMPLE);

      EmbeddedCacheManager cm = createCacheManager(builder);
      TestingUtil.replaceComponent(cm, TimeService.class, timeService, true);
      cache = cm.getCache();
      return cm;
   }

   protected EmbeddedCacheManager createCacheManager(ConfigurationBuilder builder) {
      return TestCacheManagerFactory.createClusteredCacheManager(builder);
   }

   public void testSimpleWrite() throws SystemException, NotSupportedException, HeuristicRollbackException, HeuristicMixedException, RollbackException {
      TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
      tm.begin();
      try {
         assertNull(cache.get("key-" + 2));
         for (int i = 0; i < SIZE; i++) {
            cache.put("key-" + i, "value-" + i, 1, TimeUnit.MILLISECONDS);
         }
      } finally {
         tm.commit();
      }

      for (int i = 0; i < SIZE; i++) {
         assertEquals(1, cache.getAdvancedCache().getCacheEntry("key-" + i).getLifespan());
      }

      timeService.advance(2);

      for (int i = 0; i < SIZE; i++) {
         assertNull("Entry wasn't null for " + i, cache.get("key-" + i));
      }
   }
}
