package org.infinispan.query.remote;

import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.protostream.BaseMarshaller;

import javax.management.ObjectName;

/**
 * A clustered repository of protobuf definition files. All protobuf types and their marshallers must be registered with
 * this repository before being used.
 *
 * @author anistor@redhat.com
 * @since 8.0
 */
@Scope(Scopes.GLOBAL)
public interface ProtobufMetadataManager extends ProtobufMetadataManagerMBean {

   ObjectName getObjectName();

   void setObjectName(ObjectName objectName);

   void registerMarshaller(BaseMarshaller<?> marshaller);

   /**
    * This method is deprecated. Use one of the alternative methods from {@link org.infinispan.query.remote.client.ProtobufMetadataManagerMBean}:
    * {@link org.infinispan.query.remote.client.ProtobufMetadataManagerMBean#registerProtofile(String name, String
    * contents)} or {@link org.infinispan.query.remote.client.ProtobufMetadataManagerMBean#registerProtofiles(String[]
    * name, String[] contents)}.
    */
   @Deprecated
   void registerProtofiles(String... classPathResources) throws Exception;
}
